/*
 * Copyright (C) 2004-2013 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package handlers.admincommandhandlers;

import java.util.StringTokenizer;

import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.handler.AdminCommandHandler;
import com.l2jserver.gameserver.handler.IAdminCommandHandler;
import com.l2jserver.gameserver.instancemanager.RaidBossSpawnManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.util.Util;

/**
 * @author UnAfraid (.js)
 * @author JOJO (.java)
 */
public class AdminScan implements IAdminCommandHandler
{
	public static void main(String[] args)
	{
		AdminCommandHandler.getInstance().registerHandler(new AdminScan());
	}
	
	@Override // Override useAdminCommand() method.
	public boolean useAdminCommand(String command, L2PcInstance player)
	{
		StringTokenizer st = new StringTokenizer(command, " ");
		if (st.hasMoreTokens())
		{
			String cmd = st.nextToken();
			if (cmd.equals("admin_scan"))
			{
				int radius = 500;
				if (st.hasMoreTokens())
				{
					String token = st.nextToken();
					if (Util.isDigit(token))
					{
						radius = Integer.parseInt(token);
					}
				}
				
				NpcHtmlMessage html = new NpcHtmlMessage(0);
				html.setFile(player.getHtmlPrefix(), "data/html/admin/scan.htm");
				StringBuilder sb = new StringBuilder();
				for (L2Object o : player.getKnownList().getKnownObjects().values())
				{
					if (o instanceof L2Npc && Util.checkIfInRange(radius, player, o, true))
					{
						L2Npc character = (L2Npc) o;
						sb.append("<tr>");
						sb.append("<td width=54>" + character.getNpcId() + "</td>");
						sb.append("<td width=54>" + character.getName() + "</td>");
						sb.append("<td width=54>" + Math.round(Util.calculateDistance(player, character, false)) + "</td>");
						sb.append("<td width=54><a action=\"bypass -h admin_deleteNpcByObjectId " + character.getObjectId() + " " + radius + "\"><font color=LEVEL>Delete</font></a></td>");
						sb.append("<td width=54><a action=\"bypass -h admin_move_to " + character.getX() + " " + character.getY() + " " + character.getZ() + "\"><font color=LEVEL>Go to</font></a></td>");
						sb.append("</tr>");
					}
				}
				html.replace("%radius%", radius);
				html.replace("%data%", sb.toString());
				player.sendPacket(html);
			}
			else if (cmd.equals("admin_deleteNpcByObjectId") && st.hasMoreTokens())
			{
				String token = st.nextToken();
				if (Util.isDigit(token))
				{
					int objectId = Integer.parseInt(token);
					L2Object o = player.getKnownList().getKnownObjects().get(objectId);
					if (o instanceof L2Npc)
					{
						L2Npc character = (L2Npc) o;
						character.deleteMe();
						L2Spawn spawn = character.getSpawn();
						if (spawn != null)
						{
							spawn.stopRespawn();
							
							if (RaidBossSpawnManager.getInstance().isDefined(spawn.getNpcid()))
							{
								RaidBossSpawnManager.getInstance().deleteSpawn(spawn, true);
							}
							else
							{
								SpawnTable.getInstance().deleteSpawn(spawn, true);
							}
						}
						player.sendMessage(character.getName() + " have been deleted.");
						String radius = st.hasMoreTokens() ? " " + st.nextToken() : "";
						useAdminCommand("admin_scan" + radius, player);
					}
				}
			}
		}
		return true;
	}
	
	@Override // Override getAdminCommandList() method.
	public String[] getAdminCommandList()
	{
		return new String[]{ "admin_scan", "admin_deleteNpcByObjectId" };
	}
}