package test;

import jp.sf.l2j.troja.FastIntObjectMap;
import jp.sf.l2j.troja.IntObjectMap;

public class TestEmptyMap {
	private static class Items {
		private IntObjectMap<String> m = FastIntObjectMap.emptyMap();

		String getItem(int key) {
			return m.get(key);
		}

		String putItem(int key, String val) {
			if (m == FastIntObjectMap.EMPTY_MAP)
				m = new FastIntObjectMap<String>();
			return m.put(key, val);
		}

		int size() {
			return m.size();
		}

		IntObjectMap<String> getItems() {
			return m;
		}
	}

	public static void main(String[] args) {
		Items items = new Items();

		System.out.println(items.size());
	//	items.get().putItem(9, "999");	// UnsupportedOperationException: Unmodifiable map
		items.putItem(3, "003");
		items.putItem(1, "001");
		System.out.println(items.getItem(1));
		items.putItem(2, "002");
		for (String s : items.getItems().values())
			System.out.print("[" + s + "]");
		System.out.println();
	}
}
