﻿## Active Perl 5.8.8

use utf8;
use warnings;
use strict;
use Encode;
binmode STDOUT, ':encoding(cp932)'; $|=1;

my $DEBUG = 0;

&start('./');

exit 0;

sub start {
	my ($subDir) = @_;

	opendir DIR,$subDir  or die $!;
	my @files = readdir DIR;
	closedir DIR;

	foreach my $fileName (@files) {
		next if $fileName =~ m/^\./;
		next if $fileName =~ m/ /;

		my $filePath = $subDir.$fileName;
		if (-d $filePath) {
			&start($filePath.'/');

		} elsif ($fileName =~ m!\.html?$!) {
			open FILE, '<:utf8', $filePath  or die "'$filePath' $!";
			read FILE, my $htm, -s FILE;
			my $mtime = (stat FILE)[9];
			close FILE;

			my $original = $htm;
			$_           = $htm;
#----------------------------------------------------------------------------
s{\Q>Priest of Dawn:\E}{>黎明の司祭:};
s{\Q>Dawn Priest:\E}{>黎明の司祭:};
s{\Q>Dusk Priestess:\E}{>黄昏の司祭:};

s{\Q[ The initialization period is in effect. ]\E}{「現在、準備期間中」};	#〓仮〓
s{\Q>The competition period has begun. Any player who hasn't participated in the Seven Signs may do so now.<\E}
 {>「現在、競争期間中。まだセブン サインに参加していない方は、今すぐ参加可能」<};
s{\Q>[ The competition period is in progress. Players who haven't participate in the Seven Signs can take part now. ]\E}
 {「現在、競争期間中。まだセブン サインに参加していない方は、今すぐ参加可能」};
s{\Q[Scores are being calculated. The seal validation period will begin soon.]}
 {「現在、点数集計中。まもなく封印有効期間開始」};
s{\Q[The scores are being calculated. The seal validation period will begin soon.]}
 {「現在、点数集計中。まもなく封印有効期間開始」};
s{\Q[ The seal validation period is in effect. ]\E}{「現在、封印の有効期間中」}i;
s{\Q[ The seal validation period is underway. ]\E}{「現在、封印の有効期間中」}i;

s{\Q[ Guide of Seven Signs ]\E}{「セブン サイン情報」};
s{\Q[ Seven Signs Information ]\E}{「セブン サイン情報」};
s{\Q[Seven Signs Announcement]\E}{「セブン サイン情報」};

s{\Q>"What is the Seven Signs?"<\E}{>セブン サインとは？<};
s{\Q>What is the Seven Signs?<\E}{>セブン サインとは？<};

s{\Q>Purchase Record of the Seven Signs.<\E}{>7つの封印の実録を購入する<};
s{\Q>"How do I participate in the Seven Signs?"<\E}{>セブン サインへの参加方法は？<};

s{\Q>"What is the Collection of Seal Stones?"<\E}{>封印石の収集とは？<};
s{\Q>Progress Period of the Seven Signs.<\E}{>セブン サインの進行周期<};
s{\Q>Determination of Seven Signs Victory and Defeat.<\E}{>セブン サインの勝敗決定<};
s{\Q>Benefits of Seven Signs Victory.<\E}{>セブン サインの勝利報賞<};
s{\Q>Seven Signs and Control of the Seals.<\E}{>セブン サインと封印の支配<};
s{\Q>Seven Signs and Control of Seals.<\E}{>セブン サインと封印の支配<};
s{\Q>What are necropolises and catacombs?<\E}{>ネクロポリス、カタコムとは？<};

s{\Q[What is Seal Stone Collection?]\E}{「封印石の収集とは？」};
s{\Q[Time Period of the Seven Signs]\E}{「セブン サインの進行周期」};
s{\Q[Winning the Seven Signs]\E}{「セブン サインの勝利報賞」};
s{\Q[Benefits of Seven Signs Victory]\E}{「セブン サインと封印の支配」};
s{\Q[The Seven Signs and Control of the Seals]\E}{「セブン サインと封印の支配」};
s{\Q[Necropolises]\E}{[ネクロポリス]};
s{\Q[Catacomb]\E}{[カタコム]};

s{\Q[ Participate in the Seven Signs ]\E}{「セブン サインに参加する」};
s{\Q>Participate in Seven Signs.<\E}{>セブン サインに参加する<};

s{\Q[ Purchase the Record of the Seven Seals ]\E}{「7つの封印の実録を購入する」};
s{\Q[ Purchase the Record of Seven Seals ]\E}{「7つの封印の実録を購入する」};
s{\Q>"I want to buy the Record of Seven Seals."<\E}{>7つの封印の実録を購入する<};

s{\Q[ Festival of Darkness ]\E}{「闇の祭典」};
s{\Q>"What is the Festival of Darkness?"<\E}{>闇の祭典とは？<};
s{\Q>"I want to participate in the Festival of Darkness."<\E}{>闇の祭典に参加する<};
s{\Q>I wish to participate in the Festival of Darkness<\E}{>闇の祭典に参加する<};

s{\Q[What is the Festival of Darkness?]\E}{「闇の祭典とは？」};
s{\Q>"I wish to go to the Oracle of Dawn."<\E}{>黎明の神託所に移動する<};
s{\Q>"I wish to go to the Oracle of Dusk."<\E}{>黄昏の神託所に移動する<};

s{\Q[ Benefits of Victory ]\E}{「勝利の特典」};
s{\Q>Receive bonuses for gathering seal stones<\E}{>封印石の収集に対する報賞を受ける<};
s{\Q>Teleport to nearby hunting grounds<\E}{>近くのネクロポリスまたはカタコムへテレポートする<};
s{\Q>Purchase consumable items<\E}{>消耗品を購入する<};
s{\Q>Exchange seal stones for ancient adena<\E}{>封印石を古代のアデナに交換する<};

s{\Q>Go Back.<\E}{>戻る<}i;
s{\Q>Back.<\E}{>戻る<}i;
s{\Q>Back<\E}{>戻る<}i;
#----------------------------------------------------------------------------
			$htm = $_;

			if ($htm ne $original) {
				print $filePath,"\n";
				my $output = $filePath;
				   $output = $filePath.'.text' if $DEBUG;
				open FILE, '>:utf8', $output  or die "'$output' $!";
#				$htm = "\x{feff}".$htm unless $htm =~ m/^\x{feff}/;  #BOM
				print FILE $htm;
				close FILE;
				utime $mtime,$mtime,$output;
			}
		}
	}
}
