/*
 * Copyright (C) 2005-2008 L2J_JP / 2008-2013 L2J-SFJP
 * 
 * This file is part of L2J Server.
 * 
 * L2J Server is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J Server is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.l2jserver.gameserver.model.actor.instance;

import static com.l2jserver.gameserver.ai.CtrlIntention.AI_INTENTION_ACTIVE;
import static com.l2jserver.gameserver.ai.CtrlIntention.AI_INTENTION_ATTACK;

import com.l2jserver.gameserver.ai.L2AttackableAI;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;

/**
 * @author JOJO
 * |i CxgAXCJ CxgpX^[B
 * E҂lێB
 * EUł邪AĂȂB
 */
public class L2ChronoMonsterInstance extends L2MonsterInstance
{
	public L2ChronoMonsterInstance(int objectId, L2NpcTemplate template)
	{
		super(objectId, template);
		setAI(new L2ChronoAI(new AIAccessor()));
	}
	
	public class AIAccessor extends L2Character.AIAccessor
	{
		@Override
		public void detachAI()
		{}
	}
	
	@Override
	public L2Character getMostHated()
	{
		return null;
	}
	
	@Override
	public void onSpawn()
	{
		super.onSpawn();
		setShowSummonAnimation(false);
	}
	
	/* package com.l2jserver.gameserver.ai; */
	class L2ChronoAI extends L2AttackableAI
	{
		public L2ChronoAI(L2Character.AIAccessor accessor)
		{
			super(accessor);
		}
		
		/**
		 * Manage AI thinking actions of a L2Attackable.<BR><BR>
		 */
		@Override
		protected void onEvtThink()
		{
			// Check if the actor can't use skills and if a thinking action isn't already in progress
			if (/*_thinking ||*/ _actor.isAllSkillsDisabled())
				return;
			
			// Manage AI thinks of a L2Attackable
		/**	if (getIntention() == AI_INTENTION_ACTIVE)
				thinkActive();
			else **/ if (getIntention() == AI_INTENTION_ATTACK)
				setIntention(AI_INTENTION_ACTIVE);
			//	thinkAttack();
		}
	}
}