﻿<?php
/**
 * Account object file
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @version $Id: Account.php 23 2005-06-08 19:20:39Z madest $
 * @package AccountManager
 * @filesource
 */

/**
 * Account object definition
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @version $Id: Account.php 23 2005-06-08 19:20:39Z madest $
 * @package AccountManager
 */
class Account extends AccountManager
{	
	/**
	 * @var string - login name
	 */
	var $login;
	/**
	 * @var string - login password
	 */	
	var $password;
	/**
	 * @var string - time when account was last active
	 */	
	var $lastactive;
	/**
	 * @var int(3) - access level min -100, max 100
	 */	
	var $access_level;
	
	/**
	 * @var string - encrypted password
	 */
	var $encrypted;
	
	/**
	 * @var int - character count for that account
	 */
	var $char_count;
	
	/**
	 * Create object and set values
	 */
	function account($login, $password="")
	{		
		$this->AccountManager();
		
		$this->login = $login;
		$this->password = $password;
		
		if($this->password!="")
		{
			$this->encrypted = $this->l2j_encrypt($this->password);
		} else {
			$this->encrypted = "";
		}
	}
	
	/**
	 * Get account data - false means that account with that name and password does not exist
	 * @return bool
	 */
	function get()
	{ 		
		$q = mysql_query("SELECT * FROM accounts WHERE login = '{$this->login}'");				
		$r = mysql_fetch_array($q);
		
		$this->char_count = $this->get_charcount();
		$this->lastactive = date ($this->config->manager['dateformat'], $r['lastactive']/1000 );
		//$this->lastactive = $r['lastactive'];
		
		$this->access_level = $r['accessLevel'] ;	//[JOJO]
		if(mysql_numrows($q) > 0)
		{
			return true;
		}else{
			return false;
		}			
	}
	
	/**
	 * Check if password is OK
	 * @return bool
	 */
	function auth()
	{
		if($this->password != "")
		{
			if($q = mysql_query("SELECT * FROM accounts WHERE login = '{$this->login}' AND password = '{$this->encrypted}'"))
			{
				$r = mysql_fetch_array($q);
				if(mysql_numrows($q) > 0)
				{
					$this->lastactive = date ($this->config->manager['dateformat'], $r['lastactive']/1000 );
					$this->access_level = $r['accessLevel'] ;	//[JOJO]
					return true;
				}else{
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;			
		}	
	}
	
	/**
	 * Check if account is banned or not (access level beeing below 0)
	 * @return bool
	 */
	function is_banned()
	{
		if($this->auth() == true)
		{
			$this->get();
			if($this->access_level >= 0)
			{
				return false;
			} else {
				return true;
			}
		} else {
			return true;
		}
	}
	
	/**
	 * Check if that login is awailable
	 * @param string
	 * @return bool
	 */
	function is_free($login)
	{
		if($q = mysql_query("SELECT * FROM accounts WHERE login='{$login}'"))
		{
			if(!mysql_numrows($q) > 0)
			{
				return true;
			}else{
				return false;
			}
		} else {
			return false;
		}
	}
	
	/**
	 * Create account
	 * @return bool
	 */
	function create()
	{
		if( $this->is_free($this->login) == true )
		{
			if($this->password!="")
			{
				$this->lastactive = time()*1000;
				mysql_query("INSERT INTO accounts(login, password, lastactive, accessLevel) VALUES('{$this->login}' , '{$this->encrypted}', '{$this->lastactive}', '{$this->access_level}')");
				
				     //echo "INSERT INTO accounts(login, password, lastactive, accessLevel) VALUES('{$this->login}' , '{$this->encrypted}', '{$this->lastactive}', '{$this->access_level}')";
				return true;
			} else {
				return false;
			}
		}else{
			return false;
		}
	}
	
	/**
	 * Set password
	 * @param string	 
	 */
	function set_password($new_pass)
	{
		$new_encrypt = $this->l2j_encrypt($new_pass);
		mysql_query("UPDATE accounts SET password = '{$new_encrypt}' WHERE login = '{$this->login}' AND password = '{$this->encrypted}'");		
	}
	
	/**
	 * Set access level
	 * @param string
	 * @return bool
	 */
	function set_access($new_access)
	{
		if($_POST['access'] <= 999 && $_POST['access'] >= -999)
		{
			mysql_query("UPDATE accounts SET accessLevel = '{$new_access}' WHERE login = '{$this->login}'");
			return  true;
		} else {
			return  false;
		}
	}
	
	/**
	 * Encrypt password
	 * @param string
	 * @return string
	 */
	function l2j_encrypt($password) 
	{
		return base64_encode(pack("H*", sha1(utf8_encode($password))));
	}
	
	/**
	 * Delete account and characters created with this account
	 * and returns true if deletion done
	 * @return bool
	 */
	function delete()
	{
		if ($this->get())
		{
			$q = mysql_query("SELECT * FROM characters WHERE account_name = '{$this->login}'");
			while($r = mysql_fetch_array($q))
			{
				$character = new character($r['charId']);
				$character->delete();
			}
			mysql_query("DELETE FROM accounts WHERE login = '{$this->login}'");	
			return true;
		} else {
			return false;
		}				
	}
	
	/**
	 * Does created account have ACM admin premissions
	 * @return bool
	 */
	function is_admin()
	{
		$conf = new InitConfig();
		$x = false;
		
		// New way
		if($this->config->manager['level_based'] == true)
		{
			$this->get();
			if($this->access_level == $this->config->manager['admin_level'])
			{
				$x = true;
			} else {
				$x = false;
			}
		}
		
		// Old way
		if(isset($this->config->login))
		{
			foreach ($this->config->login as $key => $var)
			{
				if($this->login == $var['login'])
				{				
					$x = true;
				}
			}
		}
		return $x;		
	}
	
	/**
	 * Does created account have ACM admin premission to delete accounts and characters
	 * @return bool
	 */
	function can_delete()
	{
		$conf = new InitConfig();
		$x = false;
		
		// New way for admin premission
		if($this->config->manager['level_based'] == true)
		{
			if($this->config->admin['can_delete'] == true && $this->is_admin() == true)
			{
				$x = true;
			}						
		}
		
		// Old way for admin premission
		if( isset($this->config->login) )
		{
			for($i=0; $i < sizeof($this->config->login); $i++)
			{
				if( $this->login == $this->config->login[$i]['login'])
				{
					if($this->config->login[$i]['allow_delete'] == true)
					{
						$x = true;
					} else {
						$x = false;
					}
				}
			}
		}
		return $x;	
	}
	
	/**
	 * Checks if character with that charId belongs to this account or not
	 * @return bool
	 */
	function is_yourchar($charId)
	{
		$q = mysql_query("SELECT * FROM characters WHERE account_name = '{$this->login}' AND charId='{$charId}'");				
		$r = mysql_fetch_array($q);

		if(mysql_numrows($q) > 0)
		{
			return true;
		}else{
			return false;
		}
	}
	
	/**
	 * Gets character count for this account
	 * @return int
	 */
	function get_charcount()
	{
		$chars = mysql_fetch_array(mysql_query("SELECT COUNT(charId) as charCount FROM characters WHERE account_name='{$this->login}'"));
		return $chars['charCount'];
	}	
}
?>