/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javax.realtime.MemoryArea;
import javolution.context.AllocatorContext;
import javolution.context.ConcurrentException;
import javolution.context.ConcurrentThread;
import javolution.context.Context;
import javolution.context.LocalContext;
import javolution.context.ObjectFactory;
import javolution.lang.Configurable;
import javolution.lang.MathLib;
import javolution.lang.Reflection;

public abstract class ConcurrentContext
extends Context {
    public static final Configurable<Class<? extends ConcurrentContext>> DEFAULT = new Configurable<Class>(Default.access$000());
    public static final Configurable<Integer> MAXIMUM_CONCURRENCY = new Configurable(new Integer(ConcurrentContext.availableProcessors() - 1)){

        @Override
        protected void notifyChange() {
            CONCURRENCY.setDefault(this.get());
        }
    };
    private static final LocalContext.Reference CONCURRENCY = new LocalContext.Reference<Integer>(MAXIMUM_CONCURRENCY.get());

    private static int availableProcessors() {
        Reflection.Method method = Reflection.getMethod("java.lang.Runtime.availableProcessors()");
        if (method != null) {
            Integer n = (Integer)method.invoke(Runtime.getRuntime());
            return n;
        }
        return 1;
    }

    protected ConcurrentContext() {
    }

    public static ConcurrentContext enter() {
        return Context.enter(DEFAULT.get());
    }

    public static ConcurrentContext exit() {
        return (ConcurrentContext)Context.exit();
    }

    public static void setConcurrency(int n) {
        n = MathLib.max(0, n);
        n = MathLib.min(MAXIMUM_CONCURRENCY.get(), n);
        CONCURRENCY.set(new Integer(n));
    }

    public static int getConcurrency() {
        return (Integer)CONCURRENCY.get();
    }

    public static void execute(Runnable runnable) {
        ConcurrentContext concurrentContext = (ConcurrentContext)Context.getCurrent();
        concurrentContext.executeAction(runnable);
    }

    protected abstract void executeAction(Runnable var1);

    static {
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new Default();
            }
        }, Default.CLASS);
    }

    static final class Default
    extends ConcurrentContext {
        private static final Class CLASS = new Default().getClass();
        private static ConcurrentThread[] _Executors = new ConcurrentThread[0];
        private static final Runnable CREATE_EXECUTORS = new Runnable(){

            @Override
            public synchronized void run() {
                int n = MAXIMUM_CONCURRENCY.get();
                int n2 = _Executors.length;
                if (n2 >= n) {
                    return;
                }
                ConcurrentThread[] concurrentThreadArray = new ConcurrentThread[n];
                System.arraycopy(_Executors, 0, concurrentThreadArray, 0, n2);
                for (int i = n2; i < n; ++i) {
                    concurrentThreadArray[i] = new ConcurrentThread();
                    concurrentThreadArray[i].start();
                }
                Default.access$202(concurrentThreadArray);
            }
        };
        private int _concurrency;
        private Throwable _error;
        private int _initiated;
        private int _completed;

        Default() {
        }

        @Override
        protected void enterAction() {
            this._error = null;
            this._initiated = 0;
            this._completed = 0;
            this._concurrency = ConcurrentContext.getConcurrency();
            if (this._concurrency > _Executors.length) {
                MemoryArea.getMemoryArea(_Executors).executeInArea(CREATE_EXECUTORS);
            }
        }

        @Override
        protected void executeAction(Runnable runnable) {
            int n = this._concurrency;
            while (--n >= 0) {
                if (!_Executors[n].execute(runnable, this)) continue;
                ++this._initiated;
                return;
            }
            runnable.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void exitAction() {
            Default default_ = this;
            synchronized (default_) {
                while (this._initiated != this._completed) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new ConcurrentException(interruptedException);
                    }
                }
            }
            if (this._error != null) {
                if (this._error instanceof RuntimeException) {
                    throw (RuntimeException)this._error;
                }
                if (this._error instanceof Error) {
                    throw (Error)this._error;
                }
                throw new ConcurrentException(this._error);
            }
        }

        void started() {
            Context.setCurrent(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void completed() {
            Default default_ = this;
            synchronized (default_) {
                ++this._completed;
                this.notify();
            }
            AllocatorContext.getCurrent().deactivate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void error(Throwable throwable) {
            Default default_ = this;
            synchronized (default_) {
                if (this._error == null) {
                    this._error = throwable;
                }
            }
        }

        static /* synthetic */ ConcurrentThread[] access$202(ConcurrentThread[] concurrentThreadArray) {
            _Executors = concurrentThreadArray;
            return concurrentThreadArray;
        }
    }
}

