/*
 * Decompiled with CFR 0.152.
 */
package javolution.text;

import java.io.IOException;
import java.io.Writer;
import javax.realtime.MemoryArea;
import javolution.JavolutionError;
import javolution.context.ObjectFactory;
import javolution.io.UTF8StreamWriter;
import javolution.lang.MathLib;
import javolution.lang.Realtime;
import javolution.lang.ValueType;
import javolution.text.CharSet;
import javolution.text.TextBuilder;
import javolution.util.FastComparator;
import javolution.util.FastMap;
import javolution.xml.XMLSerializable;

public final class Text
implements CharSequence,
Comparable,
XMLSerializable,
ValueType,
Realtime {
    private static final int BLOCK_SIZE = 32;
    private static final int BLOCK_MASK = -32;
    private static final FastMap INTERN_INSTANCES = new FastMap().setKeyComparator(FastComparator.LEXICAL);
    private static final ThreadLocal TEXT_BUILDER = new ThreadLocal(){

        protected Object initialValue() {
            return new TextBuilder();
        }
    };
    public static final Text EMPTY = Text.intern("");
    private final char[] _data;
    private int _count;
    private Text _head;
    private Text _tail;
    private static final Text TRUE = Text.intern("true");
    private static final Text FALSE = Text.intern("false");
    private static final UTF8StreamWriter SYSTEM_OUT_WRITER = new UTF8StreamWriter().setOutput(System.out);
    private static final ObjectFactory PRIMITIVE_FACTORY = new ObjectFactory(){

        public Object create() {
            return new Text(true);
        }
    };
    private static final ObjectFactory COMPOSITE_FACTORY = new ObjectFactory(){

        public Object create() {
            return new Text(false);
        }
    };

    private Text(boolean bl) {
        this._data = bl ? new char[32] : null;
    }

    public Text(String string) {
        this(string.length() <= 32);
        this._count = string.length();
        if (this._data != null) {
            string.getChars(0, this._count, this._data, 0);
        } else {
            int n = this._count + 32 >> 1 & 0xFFFFFFE0;
            this._head = new Text(string.substring(0, n));
            this._tail = new Text(string.substring(n, this._count));
        }
    }

    public static Text valueOf(Object object) {
        if (object instanceof Realtime) {
            return ((Realtime)object).toText();
        }
        if (object instanceof Number) {
            return Text.valueOfNumber(object);
        }
        return Text.valueOf(String.valueOf(object));
    }

    private static Text valueOf(String string) {
        return Text.valueOf(string, 0, string.length());
    }

    private static Text valueOf(String string, int n, int n2) {
        int n3 = n2 - n;
        if (n3 <= 32) {
            Text text = Text.newPrimitive(n3);
            string.getChars(n, n2, text._data, 0);
            return text;
        }
        int n4 = n3 + 32 >> 1 & 0xFFFFFFE0;
        return Text.newComposite(Text.valueOf(string, n, n + n4), Text.valueOf(string, n + n4, n2));
    }

    private static Text valueOfNumber(Object object) {
        if (object instanceof Integer) {
            return Text.valueOf((Integer)object);
        }
        if (object instanceof Long) {
            return Text.valueOf((Long)object);
        }
        if (object instanceof Float) {
            return Text.valueOf(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return Text.valueOf((Double)object);
        }
        return Text.valueOf(String.valueOf(object));
    }

    public static Text valueOf(char[] cArray) {
        return Text.valueOf(cArray, 0, cArray.length);
    }

    public static Text valueOf(char[] cArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 <= 32) {
            Text text = Text.newPrimitive(n2);
            System.arraycopy(cArray, n, text._data, 0, n2);
            return text;
        }
        int n3 = n2 + 32 >> 1 & 0xFFFFFFE0;
        return Text.newComposite(Text.valueOf(cArray, n, n3), Text.valueOf(cArray, n + n3, n2 - n3));
    }

    static Text valueOf(TextBuilder textBuilder, int n, int n2) {
        int n3 = n2 - n;
        if (n3 <= 32) {
            Text text = Text.newPrimitive(n3);
            textBuilder.getChars(n, n2, text._data, 0);
            return text;
        }
        int n4 = n3 + 32 >> 1 & 0xFFFFFFE0;
        return Text.newComposite(Text.valueOf(textBuilder, n, n + n4), Text.valueOf(textBuilder, n + n4, n2));
    }

    public static Text valueOf(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static Text valueOf(char c) {
        Text text = Text.newPrimitive(1);
        text._data[0] = c;
        return text;
    }

    public static Text valueOf(int n) {
        TextBuilder textBuilder = (TextBuilder)TEXT_BUILDER.get();
        textBuilder.clear().append(n);
        return textBuilder.toText();
    }

    public static Text valueOf(int n, int n2) {
        TextBuilder textBuilder = (TextBuilder)TEXT_BUILDER.get();
        textBuilder.clear().append(n, n2);
        return textBuilder.toText();
    }

    public static Text valueOf(long l) {
        TextBuilder textBuilder = (TextBuilder)TEXT_BUILDER.get();
        textBuilder.clear().append(l);
        return textBuilder.toText();
    }

    public static Text valueOf(long l, int n) {
        TextBuilder textBuilder = (TextBuilder)TEXT_BUILDER.get();
        textBuilder.clear().append(l, n);
        return textBuilder.toText();
    }

    public static Text valueOf(float f) {
        TextBuilder textBuilder = (TextBuilder)TEXT_BUILDER.get();
        textBuilder.clear().append(f);
        return textBuilder.toText();
    }

    public static Text valueOf(double d) {
        TextBuilder textBuilder = (TextBuilder)TEXT_BUILDER.get();
        textBuilder.clear().append(d);
        return textBuilder.toText();
    }

    public static Text valueOf(double d, int n, boolean bl, boolean bl2) {
        TextBuilder textBuilder = (TextBuilder)TEXT_BUILDER.get();
        textBuilder.clear().append(d, n, bl, bl2);
        return textBuilder.toText();
    }

    @Override
    public int length() {
        return this._count;
    }

    public Text plus(Object object) {
        return this.concat(Text.valueOf(object));
    }

    public Text concat(Text text) {
        int n = this._count + text._count;
        if (n <= 32) {
            Text text2 = Text.newPrimitive(n);
            this.getChars(0, this._count, text2._data, 0);
            text.getChars(0, text._count, text2._data, this._count);
            return text2;
        }
        Text text3 = this;
        Text text4 = text;
        if (text3._count << 1 < text4._count && text4._data == null) {
            if (text4._head._count > text4._tail._count) {
                text4 = text4.rightRotation();
            }
            text3 = text3.concat(text4._head);
            text4 = text4._tail;
        } else if (text4._count << 1 < text3._count && text3._data == null) {
            if (text3._tail._count > text3._head._count) {
                text3 = text3.leftRotation();
            }
            text4 = text3._tail.concat(text4);
            text3 = text3._head;
        }
        return Text.newComposite(text3, text4);
    }

    private Text rightRotation() {
        Text text = this._head;
        if (text._data != null) {
            return this;
        }
        Text text2 = text._head;
        Text text3 = text._tail;
        Text text4 = this._tail;
        return Text.newComposite(text2, Text.newComposite(text3, text4));
    }

    private Text leftRotation() {
        Text text = this._tail;
        if (text._data != null) {
            return this;
        }
        Text text2 = text._head;
        Text text3 = text._tail;
        Text text4 = this._head;
        return Text.newComposite(Text.newComposite(text4, text2), text3);
    }

    public Text subtext(int n) {
        return this.subtext(n, this.length());
    }

    public Text insert(int n, Text text) {
        return this.subtext(0, n).concat(text).concat(this.subtext(n));
    }

    public Text delete(int n, int n2) {
        if (n > n2) {
            throw new IndexOutOfBoundsException();
        }
        return this.subtext(0, n).concat(this.subtext(n2));
    }

    public Text replace(CharSequence charSequence, CharSequence charSequence2) {
        int n = this.indexOf(charSequence);
        return n < 0 ? this : this.subtext(0, n).concat(Text.valueOf(charSequence2)).concat(this.subtext(n + charSequence.length()).replace(charSequence, charSequence2));
    }

    public Text replace(CharSet charSet, CharSequence charSequence) {
        int n = this.indexOfAny(charSet);
        return n < 0 ? this : this.subtext(0, n).concat(Text.valueOf(charSequence)).concat(this.subtext(n + 1).replace(charSet, charSequence));
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.subtext(n, n2);
    }

    public int indexOf(CharSequence charSequence) {
        return this.indexOf(charSequence, 0);
    }

    public int indexOf(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = Math.max(0, n);
        int n4 = this._count - n2;
        if (n2 == 0) {
            return n3 > n4 ? -1 : n3;
        }
        char c = charSequence.charAt(0);
        int n5 = this.indexOf(c, n3);
        while (n5 >= 0 && n5 <= n4) {
            boolean bl = true;
            for (int i = 1; i < n2; ++i) {
                if (this.charAt(n5 + i) == charSequence.charAt(i)) continue;
                bl = false;
                break;
            }
            if (bl) {
                return n5;
            }
            ++n5;
            n5 = this.indexOf(c, n5);
        }
        return -1;
    }

    public int lastIndexOf(CharSequence charSequence) {
        return this.lastIndexOf(charSequence, this._count);
    }

    public int lastIndexOf(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = Math.min(n, this._count - n2);
        if (n2 == 0) {
            return 0 > n3 ? -1 : n3;
        }
        char c = charSequence.charAt(0);
        int n4 = this.lastIndexOf(c, n3);
        while (n4 >= 0) {
            boolean bl = true;
            for (int i = 1; i < n2; ++i) {
                if (this.charAt(n4 + i) == charSequence.charAt(i)) continue;
                bl = false;
                break;
            }
            if (bl) {
                return n4;
            }
            --n4;
            n4 = this.lastIndexOf(c, n4);
        }
        return -1;
    }

    public boolean startsWith(CharSequence charSequence) {
        return this.startsWith(charSequence, 0);
    }

    public boolean endsWith(CharSequence charSequence) {
        return this.startsWith(charSequence, this.length() - charSequence.length());
    }

    public boolean startsWith(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        if (n >= 0 && n <= this.length() - n2) {
            int n3 = 0;
            int n4 = n;
            while (n3 < n2) {
                if (charSequence.charAt(n3++) == this.charAt(n4++)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Text trim() {
        int n;
        int n2 = this.length() - 1;
        for (n = 0; n <= n2 && this.charAt(n) <= ' '; ++n) {
        }
        while (n2 >= n && this.charAt(n2) <= ' ') {
            --n2;
        }
        return this.subtext(n, n2 + 1);
    }

    public static Text intern(CharSequence charSequence) {
        Text text = (Text)INTERN_INSTANCES.get(charSequence);
        return text != null ? text : Text.internImpl(((Object)charSequence).toString());
    }

    public static Text intern(String string) {
        Text text = (Text)INTERN_INSTANCES.get(string);
        return text != null ? text : Text.internImpl(string);
    }

    private static synchronized Text internImpl(final String string) {
        if (!INTERN_INSTANCES.containsKey(string)) {
            MemoryArea.getMemoryArea(INTERN_INSTANCES).executeInArea(new Runnable(){

                @Override
                public void run() {
                    Text text = new Text(string);
                    INTERN_INSTANCES.put(text, text);
                }
            });
        }
        return (Text)INTERN_INSTANCES.get(string);
    }

    public boolean contentEquals(CharSequence charSequence) {
        if (charSequence.length() != this._count) {
            return false;
        }
        int n = 0;
        while (n < this._count) {
            if (this.charAt(n) == charSequence.charAt(n++)) continue;
            return false;
        }
        return true;
    }

    public boolean contentEqualsIgnoreCase(CharSequence charSequence) {
        if (this._count != charSequence.length()) {
            return false;
        }
        int n = 0;
        while (n < this._count) {
            char c;
            char c2 = this.charAt(n);
            if (c2 == (c = charSequence.charAt(n++)) || (c2 = Character.toUpperCase(c2)) == (c = Character.toUpperCase(c)) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Text)) {
            return false;
        }
        Text text = (Text)object;
        if (this._count != text._count) {
            return false;
        }
        int n = 0;
        while (n < this._count) {
            if (this.charAt(n) == text.charAt(n++)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.length();
        int n3 = 0;
        while (n3 < n2) {
            n = 31 * n + this.charAt(n3++);
        }
        return n;
    }

    public int compareTo(Object object) {
        return FastComparator.LEXICAL.compare(this, (CharSequence)object);
    }

    @Override
    public Text toText() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() {
        try {
            UTF8StreamWriter uTF8StreamWriter = SYSTEM_OUT_WRITER;
            synchronized (uTF8StreamWriter) {
                this.print(SYSTEM_OUT_WRITER);
                SYSTEM_OUT_WRITER.flush();
            }
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println() {
        try {
            UTF8StreamWriter uTF8StreamWriter = SYSTEM_OUT_WRITER;
            synchronized (uTF8StreamWriter) {
                this.println(SYSTEM_OUT_WRITER);
                SYSTEM_OUT_WRITER.flush();
            }
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public void print(Writer writer) throws IOException {
        if (this._data != null) {
            writer.write(this._data, 0, this._count);
        } else {
            this._head.print(writer);
            this._tail.print(writer);
        }
    }

    public void println(Writer writer) throws IOException {
        this.print(writer);
        writer.write(10);
    }

    public Text toLowerCase() {
        if (this._data == null) {
            return Text.newComposite(this._head.toLowerCase(), this._tail.toLowerCase());
        }
        Text text = Text.newPrimitive(this._count);
        int n = 0;
        while (n < this._count) {
            text._data[n] = Character.toLowerCase(this._data[n++]);
        }
        return text;
    }

    public Text toUpperCase() {
        if (this._data == null) {
            return Text.newComposite(this._head.toUpperCase(), this._tail.toUpperCase());
        }
        Text text = Text.newPrimitive(this._count);
        int n = 0;
        while (n < this._count) {
            text._data[n] = Character.toUpperCase(this._data[n++]);
        }
        return text;
    }

    public int depth() {
        if (this._data != null) {
            return 0;
        }
        return MathLib.max(this._head.depth(), this._tail.depth()) + 1;
    }

    @Override
    public char charAt(int n) {
        if (n >= this._count) {
            throw new IndexOutOfBoundsException();
        }
        return this._data != null ? this._data[n] : (n < this._head._count ? this._head.charAt(n) : this._tail.charAt(n - this._head._count));
    }

    public int indexOf(char c, int n) {
        int n2;
        if (this._data != null) {
            for (int i = MathLib.max(n, 0); i < this._count; ++i) {
                if (this._data[i] != c) continue;
                return i;
            }
            return -1;
        }
        int n3 = this._head._count;
        if (n < n3 && (n2 = this._head.indexOf(c, n)) >= 0) {
            return n2;
        }
        n2 = this._tail.indexOf(c, n - n3);
        return n2 >= 0 ? n2 + n3 : -1;
    }

    public int lastIndexOf(char c, int n) {
        int n2;
        if (this._data != null) {
            for (int i = MathLib.min(n, this._count - 1); i >= 0; --i) {
                if (this._data[i] != c) continue;
                return i;
            }
            return -1;
        }
        int n3 = this._head._count;
        if (n >= n3 && (n2 = this._tail.lastIndexOf(c, n - n3)) >= 0) {
            return n2 + n3;
        }
        return this._head.lastIndexOf(c, n);
    }

    public Text subtext(int n, int n2) {
        if (this._data != null) {
            if (n < 0 || n > n2 || n2 > this._count) {
                throw new IndexOutOfBoundsException();
            }
            if (n == 0 && n2 == this._count) {
                return this;
            }
            if (n == n2) {
                return EMPTY;
            }
            int n3 = n2 - n;
            Text text = Text.newPrimitive(n3);
            System.arraycopy(this._data, n, text._data, 0, n3);
            return text;
        }
        int n4 = this._head._count;
        if (n2 <= n4) {
            return this._head.subtext(n, n2);
        }
        if (n >= n4) {
            return this._tail.subtext(n - n4, n2 - n4);
        }
        if (n == 0 && n2 == this._count) {
            return this;
        }
        return this._head.subtext(n, n4).concat(this._tail.subtext(0, n2 - n4));
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (this._data != null) {
            if (n < 0 || n2 > this._count || n > n2) {
                throw new IndexOutOfBoundsException();
            }
            System.arraycopy(this._data, n, cArray, n3, n2 - n);
        } else {
            int n4 = this._head._count;
            if (n2 <= n4) {
                this._head.getChars(n, n2, cArray, n3);
            } else if (n >= n4) {
                this._tail.getChars(n - n4, n2 - n4, cArray, n3);
            } else {
                this._head.getChars(n, n4, cArray, n3);
                this._tail.getChars(0, n2 - n4, cArray, n3 + n4 - n);
            }
        }
    }

    @Override
    public String toString() {
        if (this._data != null) {
            return new String(this._data, 0, this._count);
        }
        char[] cArray = new char[this._count];
        this.getChars(0, this._count, cArray, 0);
        return new String(cArray, 0, this._count);
    }

    @Override
    public Text copy() {
        if (this._data != null) {
            Text text = Text.newPrimitive(this._count);
            System.arraycopy(this._data, 0, text._data, 0, this._count);
            return text;
        }
        return Text.newComposite(this._head.copy(), this._tail.copy());
    }

    public static Text valueOf(char c, int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n <= 32) {
            Text text = Text.newPrimitive(n);
            int n2 = 0;
            while (n2 < n) {
                text._data[n2++] = c;
            }
            return text;
        }
        int n3 = n >> 1;
        return Text.newComposite(Text.valueOf(c, n3), Text.valueOf(c, n - n3));
    }

    public boolean isBlank() {
        return this.isBlank(0, this.length());
    }

    public boolean isBlank(int n, int n2) {
        while (n < n2) {
            if (this.charAt(n) > ' ') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Text trimStart() {
        int n;
        int n2 = this.length() - 1;
        for (n = 0; n <= n2 && this.charAt(n) <= ' '; ++n) {
        }
        return this.subtext(n, n2 + 1);
    }

    public Text trimEnd() {
        int n;
        int n2 = 0;
        for (n = this.length() - 1; n >= n2 && this.charAt(n) <= ' '; --n) {
        }
        return this.subtext(n2, n + 1);
    }

    public Text padLeft(int n) {
        return this.padLeft(n, ' ');
    }

    public Text padLeft(int n, char c) {
        int n2 = n <= this.length() ? 0 : n - this.length();
        return this.insert(0, Text.valueOf(c, n2));
    }

    public Text padRight(int n) {
        return this.padRight(n, ' ');
    }

    public Text padRight(int n, char c) {
        int n2 = n <= this.length() ? 0 : n - this.length();
        return this.concat(Text.valueOf(c, n2));
    }

    public int indexOfAny(CharSet charSet) {
        return this.indexOfAny(charSet, 0, this.length());
    }

    public int indexOfAny(CharSet charSet, int n) {
        return this.indexOfAny(charSet, n, this.length() - n);
    }

    public int indexOfAny(CharSet charSet, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (!charSet.contains(this.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOfAny(CharSet charSet) {
        return this.lastIndexOfAny(charSet, 0, this.length());
    }

    public int lastIndexOfAny(CharSet charSet, int n) {
        return this.lastIndexOfAny(charSet, n, this.length() - n);
    }

    public int lastIndexOfAny(CharSet charSet, int n, int n2) {
        int n3 = n + n2;
        while (--n3 >= n) {
            if (!charSet.contains(this.charAt(n3))) continue;
            return n3;
        }
        return -1;
    }

    private static Text newPrimitive(int n) {
        Text text = (Text)PRIMITIVE_FACTORY.object();
        text._count = n;
        return text;
    }

    private static Text newComposite(Text text, Text text2) {
        Text text3 = (Text)COMPOSITE_FACTORY.object();
        text3._count = text._count + text2._count;
        text3._head = text;
        text3._tail = text2;
        return text3;
    }
}

