/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.io.ObjectStreamException;
import javax.realtime.MemoryArea;
import javolution.lang.Configurable;
import javolution.lang.Immutable;
import javolution.util.FastCollection;
import javolution.xml.XMLSerializable;

public final class Index
extends Number
implements Comparable<Index>,
FastCollection.Record,
Immutable,
XMLSerializable {
    public static final Configurable<Integer> INITIAL_FIRST = new Configurable(new Integer(-1)){

        @Override
        protected void notifyChange() {
            Index.valueOf(INITIAL_FIRST.get());
        }
    };
    public static final Configurable<Integer> INITIAL_LAST = new Configurable(new Integer(16)){

        @Override
        protected void notifyChange() {
            Index.valueOf(INITIAL_LAST.get());
        }
    };
    public static final Index ZERO = new Index(0);
    private static Index[] PositiveIndices = new Index[16];
    private static int PositiveIndicesLength;
    private static Index[] NegativeIndices;
    private static final MemoryArea IMMORTAL_MEMORY;
    private static int NegativeIndicesLength;
    private final int _value;
    private static final Runnable AUGMENT_POSITIVE;
    private static final Runnable AUGMENT_NEGATIVE;
    private static final int INCREASE_AMOUNT = 16;
    static volatile boolean NoReordering;
    private static final long serialVersionUID = 1L;

    private Index(int n) {
        this._value = n;
    }

    public static void setMinimumRange(int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        Index.valueOf(n);
        Index.valueOf(n2);
    }

    public static Index valueOf(int n) {
        return n >= 0 ? (n < PositiveIndicesLength ? PositiveIndices[n] : Index.createPositive(n)) : Index.valueOfNegative(-n);
    }

    private static Index valueOfNegative(int n) {
        return n < NegativeIndicesLength ? NegativeIndices[n] : Index.createNegative(n);
    }

    private static synchronized Index createPositive(int n) {
        if (n < PositiveIndicesLength) {
            return PositiveIndices[n];
        }
        while (n >= PositiveIndicesLength) {
            IMMORTAL_MEMORY.executeInArea(AUGMENT_POSITIVE);
        }
        return PositiveIndices[n];
    }

    private static synchronized Index createNegative(int n) {
        if (n < NegativeIndicesLength) {
            return NegativeIndices[n];
        }
        while (n >= NegativeIndicesLength) {
            IMMORTAL_MEMORY.executeInArea(AUGMENT_NEGATIVE);
        }
        return NegativeIndices[n];
    }

    @Override
    public final int intValue() {
        return this._value;
    }

    @Override
    public final long longValue() {
        return this.intValue();
    }

    @Override
    public final float floatValue() {
        return this.intValue();
    }

    @Override
    public final double doubleValue() {
        return this.intValue();
    }

    public final String toString() {
        return String.valueOf(this._value);
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final int hashCode() {
        return this._value;
    }

    protected final Object readResolve() throws ObjectStreamException {
        return Index.valueOf(this._value);
    }

    @Override
    public int compareTo(Index index) {
        return this._value - index._value;
    }

    @Override
    public final FastCollection.Record getNext() {
        return Index.valueOf(this._value + 1);
    }

    @Override
    public final FastCollection.Record getPrevious() {
        return Index.valueOf(this._value - 1);
    }

    static /* synthetic */ Index[] access$202(Index[] indexArray) {
        PositiveIndices = indexArray;
        return indexArray;
    }

    static /* synthetic */ Index[] access$402(Index[] indexArray) {
        NegativeIndices = indexArray;
        return indexArray;
    }

    static {
        Index.PositiveIndices[0] = ZERO;
        PositiveIndicesLength = 1;
        NegativeIndices = new Index[16];
        Index.NegativeIndices[0] = ZERO;
        IMMORTAL_MEMORY = MemoryArea.getMemoryArea(new Object());
        NegativeIndicesLength = 1;
        AUGMENT_POSITIVE = new Runnable(){

            @Override
            public void run() {
                int n = PositiveIndicesLength + 16;
                for (int i = PositiveIndicesLength; i < n; ++i) {
                    Index index = new Index(i);
                    if (PositiveIndices.length <= i) {
                        Index[] indexArray = new Index[PositiveIndices.length * 2];
                        System.arraycopy(PositiveIndices, 0, indexArray, 0, PositiveIndices.length);
                        Index.access$202(indexArray);
                    }
                    PositiveIndices[i] = index;
                }
                NoReordering = true;
                PositiveIndicesLength += 16;
            }
        };
        AUGMENT_NEGATIVE = new Runnable(){

            @Override
            public void run() {
                int n = NegativeIndicesLength + 16;
                for (int i = NegativeIndicesLength; i < n; ++i) {
                    Index index = new Index(-i);
                    if (NegativeIndices.length <= i) {
                        Index[] indexArray = new Index[NegativeIndices.length * 2];
                        System.arraycopy(NegativeIndices, 0, indexArray, 0, NegativeIndices.length);
                        Index.access$402(indexArray);
                    }
                    NegativeIndices[i] = index;
                }
                NoReordering = true;
                NegativeIndicesLength += 16;
            }
        };
        Index.valueOf(INITIAL_FIRST.get());
        Index.valueOf(INITIAL_LAST.get());
    }
}

