/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml.stream;

import java.util.Iterator;
import javax.realtime.MemoryArea;
import javolution.lang.Reusable;
import javolution.text.CharArray;
import javolution.util.FastList;
import javolution.xml.stream.NamespaceContext;

final class NamespacesImpl
implements Reusable,
NamespaceContext {
    static final int NBR_PREDEFINED_NAMESPACES = 3;
    final CharArray _nullNsURI = new CharArray("");
    final CharArray _defaultNsPrefix = new CharArray("");
    final CharArray _xml = new CharArray("xml");
    final CharArray _xmlURI = new CharArray("http://www.w3.org/XML/1998/namespace");
    final CharArray _xmlns = new CharArray("xmlns");
    final CharArray _xmlnsURI = new CharArray("http://www.w3.org/2000/xmlns/");
    private int _nesting = 0;
    CharArray[] _prefixes = new CharArray[16];
    CharArray[] _namespaces = new CharArray[this._prefixes.length];
    boolean[] _prefixesWritten = new boolean[this._prefixes.length];
    int[] _namespacesCount = new int[16];
    CharArray _defaultNamespace = this._nullNsURI;
    int _defaultNamespaceIndex;
    private CharArray[] _prefixesTmp = new CharArray[this._prefixes.length];
    private CharArray[] _namespacesTmp = new CharArray[this._prefixes.length];

    public NamespacesImpl() {
        this._prefixes[0] = this._defaultNsPrefix;
        this._namespaces[0] = this._nullNsURI;
        this._prefixes[1] = this._xml;
        this._namespaces[1] = this._xmlURI;
        this._prefixes[2] = this._xmlns;
        this._namespaces[2] = this._xmlnsURI;
        this._namespacesCount[0] = 3;
    }

    @Override
    public CharArray getNamespaceURI(CharSequence charSequence) {
        if (charSequence == null) {
            throw new IllegalArgumentException("null prefix not allowed");
        }
        return this.getNamespaceURINullAllowed(charSequence);
    }

    CharArray getNamespaceURINullAllowed(CharSequence charSequence) {
        int n;
        if (charSequence == null || charSequence.length() == 0) {
            return this._defaultNamespace;
        }
        int n2 = n = this._namespacesCount[this._nesting];
        while (--n2 >= 0) {
            if (!this._prefixes[n2].equals((Object)charSequence)) continue;
            return this._namespaces[n2];
        }
        return null;
    }

    @Override
    public CharArray getPrefix(CharSequence charSequence) {
        if (charSequence == null) {
            throw new IllegalArgumentException("null namespace URI not allowed");
        }
        return this._defaultNamespace.equals((Object)charSequence) ? this._defaultNsPrefix : this.getPrefix(charSequence, this._namespacesCount[this._nesting]);
    }

    CharArray getPrefix(CharSequence charSequence, int n) {
        int n2 = n;
        while (--n2 >= 0) {
            CharArray charArray = this._prefixes[n2];
            CharArray charArray2 = this._namespaces[n2];
            if (!charArray2.equals((Object)charSequence)) continue;
            boolean bl = false;
            for (int i = n2 + 1; i < n; ++i) {
                if (!charArray.equals(this._prefixes[i])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return charArray;
        }
        return null;
    }

    @Override
    public Iterator getPrefixes(CharSequence charSequence) {
        FastList<CharArray> fastList = new FastList<CharArray>();
        int n = this._namespacesCount[this._nesting];
        while (--n >= 0) {
            if (!this._namespaces[n].equals((Object)charSequence)) continue;
            fastList.add(this._prefixes[n]);
        }
        return fastList.iterator();
    }

    void setPrefix(CharArray charArray, CharArray charArray2) {
        int n = this._namespacesCount[this._nesting];
        this._prefixes[n] = charArray;
        this._namespaces[n] = charArray2;
        if (charArray.length() == 0) {
            this._defaultNamespaceIndex = n;
            this._defaultNamespace = charArray2;
        }
        int n2 = this._nesting;
        this._namespacesCount[n2] = this._namespacesCount[n2] + 1;
        if (this._namespacesCount[n2] >= this._prefixes.length) {
            this.resizePrefixStack();
        }
    }

    void setPrefix(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        int n;
        final int n2 = this._namespacesCount[this._nesting];
        this._prefixesWritten[n2] = bl;
        final int n3 = charSequence.length();
        CharArray charArray = this._prefixesTmp[n2];
        if (charArray == null || charArray.array().length < n3) {
            MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

                @Override
                public void run() {
                    ((NamespacesImpl)NamespacesImpl.this)._prefixesTmp[n2] = new CharArray().setArray(new char[n3 + 32], 0, 0);
                }
            });
            charArray = this._prefixesTmp[n2];
        }
        for (n = 0; n < n3; ++n) {
            charArray.array()[n] = charSequence.charAt(n);
        }
        charArray.setArray(charArray.array(), 0, n3);
        n = charSequence2.length();
        CharArray charArray2 = this._namespacesTmp[n2];
        if (charArray2 == null || charArray2.array().length < n) {
            MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

                @Override
                public void run() {
                    ((NamespacesImpl)NamespacesImpl.this)._namespacesTmp[n2] = new CharArray().setArray(new char[n + 32], 0, 0);
                }
            });
            charArray2 = this._namespacesTmp[n2];
        }
        for (int i = 0; i < n; ++i) {
            charArray2.array()[i] = charSequence2.charAt(i);
        }
        charArray2.setArray(charArray2.array(), 0, n);
        this.setPrefix(charArray, charArray2);
    }

    void pop() {
        if (this._namespacesCount[--this._nesting] <= this._defaultNamespaceIndex) {
            this.searchDefaultNamespace();
        }
    }

    private void searchDefaultNamespace() {
        int n;
        int n2 = n = this._namespacesCount[this._nesting];
        while (--n2 >= 0) {
            if (this._prefixes[n2].length() != 0) continue;
            this._defaultNamespaceIndex = n2;
            return;
        }
        throw new Error("Cannot find default namespace");
    }

    void push() {
        ++this._nesting;
        if (this._nesting >= this._namespacesCount.length) {
            this.resizeNamespacesCount();
        }
        this._namespacesCount[this._nesting] = this._namespacesCount[this._nesting - 1];
    }

    @Override
    public void reset() {
        this._defaultNamespace = this._nullNsURI;
        this._defaultNamespaceIndex = 0;
        this._namespacesCount[0] = 3;
        this._nesting = 0;
    }

    private void resizeNamespacesCount() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            @Override
            public void run() {
                int n = NamespacesImpl.this._namespacesCount.length;
                int n2 = n * 2;
                int[] nArray = new int[n2];
                System.arraycopy(NamespacesImpl.this._namespacesCount, 0, nArray, 0, n);
                NamespacesImpl.this._namespacesCount = nArray;
            }
        });
    }

    private void resizePrefixStack() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            @Override
            public void run() {
                int n = NamespacesImpl.this._prefixes.length;
                int n2 = n * 2;
                CharArray[] charArrayArray = new CharArray[n2];
                System.arraycopy(NamespacesImpl.this._prefixes, 0, charArrayArray, 0, n);
                NamespacesImpl.this._prefixes = charArrayArray;
                CharArray[] charArrayArray2 = new CharArray[n2];
                System.arraycopy(NamespacesImpl.this._namespaces, 0, charArrayArray2, 0, n);
                NamespacesImpl.this._namespaces = charArrayArray2;
                boolean[] blArray = new boolean[n2];
                System.arraycopy(NamespacesImpl.this._prefixesWritten, 0, blArray, 0, n);
                NamespacesImpl.this._prefixesWritten = blArray;
                CharArray[] charArrayArray3 = new CharArray[n2];
                System.arraycopy(NamespacesImpl.this._prefixesTmp, 0, charArrayArray3, 0, n);
                NamespacesImpl.access$002(NamespacesImpl.this, charArrayArray3);
                CharArray[] charArrayArray4 = new CharArray[n2];
                System.arraycopy(NamespacesImpl.this._namespacesTmp, 0, charArrayArray4, 0, n);
                NamespacesImpl.access$102(NamespacesImpl.this, charArrayArray4);
            }
        });
    }

    static /* synthetic */ CharArray[] access$002(NamespacesImpl namespacesImpl, CharArray[] charArrayArray) {
        namespacesImpl._prefixesTmp = charArrayArray;
        return charArrayArray;
    }

    static /* synthetic */ CharArray[] access$102(NamespacesImpl namespacesImpl, CharArray[] charArrayArray) {
        namespacesImpl._namespacesTmp = charArrayArray;
        return charArrayArray;
    }
}

