/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml.stream;

import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import javolution.context.ObjectFactory;
import javolution.lang.Configurable;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLStreamReader;
import javolution.xml.stream.XMLStreamReaderImpl;

public abstract class XMLInputFactory {
    public static final Configurable<Class<? extends XMLInputFactory>> DEFAULT = new Configurable<Class>(Default.CLASS);
    public static final String IS_COALESCING = "javolution.xml.stream.isCoalescing";
    public static final String ENTITIES = "javolution.xml.stream.entities";
    private static ObjectFactory XML_READER_FACTORY = new ObjectFactory(){

        protected Object create() {
            return new XMLStreamReaderImpl();
        }

        protected void cleanup(Object object) {
            ((XMLStreamReaderImpl)object).reset();
        }
    };

    protected XMLInputFactory() {
    }

    public static XMLInputFactory newInstance() {
        Class<? extends XMLInputFactory> clazz = DEFAULT.get();
        return ObjectFactory.getInstance(clazz).object();
    }

    public abstract XMLStreamReader createXMLStreamReader(Reader var1) throws XMLStreamException;

    public abstract XMLStreamReader createXMLStreamReader(InputStream var1) throws XMLStreamException;

    public abstract XMLStreamReader createXMLStreamReader(InputStream var1, String var2) throws XMLStreamException;

    public abstract void setProperty(String var1, Object var2) throws IllegalArgumentException;

    public abstract Object getProperty(String var1) throws IllegalArgumentException;

    public abstract boolean isPropertySupported(String var1);

    static {
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new Default();
            }
        }, Default.CLASS);
    }

    private static final class Default
    extends XMLInputFactory {
        static final Class CLASS = new Default().getClass();
        Map _entities = null;

        private Default() {
        }

        @Override
        public XMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
            XMLStreamReaderImpl xMLStreamReaderImpl = this.newReader();
            xMLStreamReaderImpl.setInput(reader);
            return xMLStreamReaderImpl;
        }

        @Override
        public XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
            XMLStreamReaderImpl xMLStreamReaderImpl = this.newReader();
            xMLStreamReaderImpl.setInput(inputStream);
            return xMLStreamReaderImpl;
        }

        @Override
        public XMLStreamReader createXMLStreamReader(InputStream inputStream, String string) throws XMLStreamException {
            XMLStreamReaderImpl xMLStreamReaderImpl = this.newReader();
            xMLStreamReaderImpl.setInput(inputStream, string);
            return xMLStreamReaderImpl;
        }

        @Override
        public void setProperty(String string, Object object) throws IllegalArgumentException {
            if (!string.equals(XMLInputFactory.IS_COALESCING)) {
                if (string.equals(XMLInputFactory.ENTITIES)) {
                    this._entities = (Map)object;
                } else {
                    throw new IllegalArgumentException("Property: " + string + " not supported");
                }
            }
        }

        @Override
        public Object getProperty(String string) throws IllegalArgumentException {
            if (string.equals(XMLInputFactory.IS_COALESCING)) {
                return new Boolean(true);
            }
            if (string.equals(XMLInputFactory.ENTITIES)) {
                return this._entities;
            }
            throw new IllegalArgumentException("Property: " + string + " not supported");
        }

        @Override
        public boolean isPropertySupported(String string) {
            return string.equals(XMLInputFactory.IS_COALESCING) || string.equals(XMLInputFactory.ENTITIES);
        }

        private XMLStreamReaderImpl newReader() {
            XMLStreamReaderImpl xMLStreamReaderImpl = (XMLStreamReaderImpl)XML_READER_FACTORY.object();
            if (this._entities != null) {
                xMLStreamReaderImpl.setEntities(this._entities);
            }
            xMLStreamReaderImpl._objectFactory = XML_READER_FACTORY;
            return xMLStreamReaderImpl;
        }
    }
}

