/*
 * Decompiled with CFR 0.152.
 */
package org.mmocore.util.collections.concurrent;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemiConcurrentLinkedList<E>
implements Iterable<E> {
    private volatile Node<E> _start = new Node();
    private volatile Node<E> _end = new Node();
    private int _size;

    public SemiConcurrentLinkedList() {
        this.clear();
    }

    public void addLast(E elem) {
        Node<E> oldEndNode = this._end;
        ((Node)oldEndNode)._value = elem;
        Node<Object> newEndNode = new Node<Object>(oldEndNode, null, null);
        oldEndNode.setNext(newEndNode);
        this._end = newEndNode;
        ++this._size;
    }

    public void remove(Node<E> node) {
        Node<E> previous = node.getPrevious();
        Node<E> next = node.getNext();
        previous.setNext(next);
        next.setPrevious(previous);
        --this._size;
    }

    public int size() {
        return this._size;
    }

    public final boolean isEmpty() {
        return this._size == 0;
    }

    public void clear() {
        this._start.setNext(this._end);
        this._end.setPrevious(this._start);
    }

    public Node<E> getStart() {
        return this._start;
    }

    public Node<E> getEnd() {
        return this._end;
    }

    @Override
    public Iterator<E> iterator() {
        return new SemiConcurrentIterator(this._start);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Node<T> {
        private Node<T> _previous;
        private Node<T> _next;
        private T _value;

        protected Node() {
        }

        protected Node(T value) {
            this._value = value;
        }

        protected Node(Node<T> previous, Node<T> next, T value) {
            this._previous = previous;
            this._next = next;
            this._value = value;
        }

        public Node<T> getNext() {
            return this._next;
        }

        protected void setNext(Node<T> node) {
            this._next = node;
        }

        public Node<T> getPrevious() {
            return this._previous;
        }

        protected void setPrevious(Node<T> node) {
            this._previous = node;
        }

        public T getValue() {
            return this._value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SemiConcurrentIterator
    implements Iterator<E> {
        private Node<E> _current;

        protected SemiConcurrentIterator(Node<E> start) {
            this._current = start;
        }

        @Override
        public boolean hasNext() {
            return this._current.getNext() != SemiConcurrentLinkedList.this._end;
        }

        @Override
        public E next() {
            this._current = this._current.getNext();
            if (this._current == SemiConcurrentLinkedList.this._end) {
                throw new NoSuchElementException();
            }
            return this._current.getValue();
        }

        @Override
        public void remove() {
            SemiConcurrentLinkedList.this.remove(this._current);
            this._current = this._current.getPrevious();
        }
    }
}

