/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * http://www.gnu.org/copyleft/gpl.html
 */
package net.sf.l2j.gameserver.communitybbs.Manager;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Logger;

import javolution.text.TextBuilder;

import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.actor.instance.L2PcInstance;
import net.sf.l2j.gameserver.network.serverpackets.ShowBoard;

/**
 * @author  TSL
 */
public class FriendListManager extends BaseBBSManager
{
	private static Logger _log = Logger.getLogger(FriendListManager.class.getName());
	private static FriendListManager _instance = new FriendListManager();
	
	/**
	 * @return
	 */
	public static FriendListManager getInstance()
	{
		return _instance;
	}
	
	/* (non-Javadoc)
	 * @see net.sf.l2j.gameserver.communitybbs.Manager.BaseBBSManager#parsecmd(java.lang.String, net.sf.l2j.gameserver.model.actor.instance.L2PcInstance)
	 */
	@Override
	public void parsecmd(String command, L2PcInstance activeChar)
	{
		if (activeChar == null) return;
		
		if(command.startsWith("_friendlist"))
		{
			showFriendList(activeChar);
		}
		else
		{
			ShowBoard sb = new ShowBoard("<html><body><br><br><center> the command: "+command+" is not implemented yet</center><br><br></body></html>","101");
			activeChar.sendPacket(sb);
			activeChar.sendPacket(new ShowBoard(null,"102"));
			activeChar.sendPacket(new ShowBoard(null,"103"));
		}
	}

	/**
	 * @param activeChar
	 */
	private void showFriendList(L2PcInstance activeChar)
	{
        TextBuilder html = new TextBuilder("<html><body><br><br>");
		html.append("<TABLE border=0 width=610><TR><TD width=10></TD><TD width=600 align=left>");
		html.append("<a action=\"bypass _bbshome\"> &$377; </a>&nbsp;>&nbsp;<A action=\"bypass _friendlist\">&$904;</A>");
		html.append("</TD></TR>");
		html.append("</TABLE>");
		html.append("<CENTER>");
		html.append("<IMG src=\"L2UI.squareblank\" width=\"1\" height=\"10\">");
		html.append("&$997;");
		html.append("<IMG src=\"L2UI.squaregray\" width=\"610\" height=\"1\"><BR>");
		html.append("<TABLE border=0 cellspacing=0 cellpadding=0 width=610>");
		html.append("<TR>");
		html.append("<TD fixWIDTH=5></td>");
		html.append("<TD fixWIDTH=600>");
		
		java.sql.Connection con = null;
		try
		{
			con = L2DatabaseFactory.getInstance().getConnection();
			PreparedStatement statement = con.prepareStatement("SELECT friend_name FROM character_friends WHERE charId=? ORDER BY friend_name");
			statement.setInt(1, activeChar.getObjectId());
			ResultSet rset = statement.executeQuery();
			while (rset.next())
			{
				String friendName = rset.getString("friend_name");
				L2PcInstance friend = L2World.getInstance().getPlayer(friendName);
				html.append("<A action=\"bypass _bbscustom;msgnew;private;"+friendName+"\">"+friendName+"</A> (" + ((friend != null) ? "&$1006;":"&$1007;") +") &nbsp;");
			}
			rset.close();
			statement.close();
		}
		catch (Exception e) {
			_log.warning("Error in friendlist : " + e);
		}
		finally	{
			try {con.close();} catch (Exception e) {}
		}
		
		html.append("</TD>");
		html.append("<TD fixWIDTH=5></td>");
		html.append("</TR>");
		html.append("</TABLE>");
		html.append("</CENTER>");
		html.append("</body>");
		html.append("</html>");
		separateAndSend(html.toString(), activeChar);
	}

	/* (non-Javadoc)
	 * @see net.sf.l2j.gameserver.communitybbs.Manager.BaseBBSManager#parsewrite(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, net.sf.l2j.gameserver.model.actor.instance.L2PcInstance)
	 */
	@Override
	public void parsewrite(String ar1, String ar2, String ar3, String ar4, String ar5, L2PcInstance activeChar)
	{
		
	}
}