/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package net.sf.l2j.gameserver.handler.skillhandlers;

import java.util.logging.Level;

import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.datatables.MapRegionTable;
import net.sf.l2j.gameserver.handler.ISkillHandler;
import net.sf.l2j.gameserver.instancemanager.CustomZoneManager;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.model.actor.instance.L2MonsterInstance;
import net.sf.l2j.gameserver.model.actor.instance.L2PcInstance;
import net.sf.l2j.gameserver.model.entity.TvTEvent;
import net.sf.l2j.gameserver.network.SystemMessageId;
import net.sf.l2j.gameserver.network.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.network.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.templates.skills.L2SkillType;
import net.sf.l2j.util.Rnd;

public class Recall implements ISkillHandler
{
	private static final L2SkillType[] SKILL_IDS =
	{
		L2SkillType.RECALL
	};
	
	/**
	 * 
	 * @see net.sf.l2j.gameserver.handler.ISkillHandler#useSkill(net.sf.l2j.gameserver.model.L2Character, net.sf.l2j.gameserver.model.L2Skill, net.sf.l2j.gameserver.model.L2Object[])
	 */
	public void useSkill(L2Character activeChar, L2Skill skill, L2Object[] targets)
	{
		// [L2J_JP ADD SANDMAN]
		// <!--- Zaken skills - teleport PC --> or <!--- Zaken skills - teleport -->
		if (skill.getId() == 4216 || skill.getId() == 4217 || skill.getId() == 4222)
        {
//XXX: p~\Bscript/ai/individual/Zaken.java ŏuԈړ𐧌䂵Ă̂ŁB
System.out.println("__BASENAME__:__LINE__: UP uԈړ");
net.sf.l2j.custom.CallTree.print(); System.exit(1);
			this.doZakenTeleport(targets);
			activeChar.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
			if (activeChar instanceof L2MonsterInstance)
				((L2MonsterInstance) activeChar).clearAggroList();
			return;
		}
        
		if (activeChar instanceof L2PcInstance)
		{
			// Thanks nbd
			if (!TvTEvent.onEscapeUse(((L2PcInstance) activeChar).getObjectId()))
			{
				((L2PcInstance) activeChar).sendPacket(ActionFailed.STATIC_PACKET);
				return;
			}
			
			if (((L2PcInstance) activeChar).isInOlympiadMode())
			{
				((L2PcInstance) activeChar).sendPacket(new SystemMessage(SystemMessageId.THIS_ITEM_IS_NOT_AVAILABLE_FOR_THE_OLYMPIAD_EVENT));
				return;
			}
		}
		
		try
		{
			for (L2Character target: (L2Character[]) targets)
			{
				if (target instanceof L2PcInstance)
				{
					L2PcInstance targetChar = (L2PcInstance) target;
					
					// [L2J_JP ADD][JOJO]
					if (CustomZoneManager.getInstance().isInsideNoEscapeZone(targetChar))
					{
						targetChar.sendMessage("You can not escape from here.");
						targetChar.sendPacket(ActionFailed.STATIC_PACKET);
						break;
					}
					
					// Check to see if the current player target is in a festival.
					if (targetChar.isFestivalParticipant())
					{
						targetChar.sendMessage("You may not use an escape skill in a festival.");
						continue;
					}
					
					// Check to see if player is in jail
					if (targetChar.isInJail())
					{
						targetChar.sendMessage("You can not escape from jail.");
						continue;
					}
					
					// Check to see if player is in a duel
					if (targetChar.isInDuel())
					{
						targetChar.sendMessage("You cannot use escape skills during a duel.");
						continue;
					}
				}
				target.setInstanceId(0);
				
				target.teleToLocation(MapRegionTable.TeleportWhereType.Town);
			}
		}
		catch (Exception e)
		{
			_log.log(Level.SEVERE, "", e);
		}
	}
	
	/**
	 * 
	 * @see net.sf.l2j.gameserver.handler.ISkillHandler#getSkillIds()
	 */
	public L2SkillType[] getSkillIds()
	{
		return SKILL_IDS;
	}
    
	// [L2J_JP ADD SANDMAN]
	@Deprecated
	protected void doZakenTeleport(L2Object[] targets)
	{
//XXX: p~\Bscript/ai/individual/Zaken.java ŏuԈړ𐧌䂵Ă̂ŁB
net.sf.l2j.custom.CallTree.print(); System.exit(1);
//		final int loc[][] =
//		{
//			// 1F
//			{54228,220136,-3496},
//			{56315,220127,-3496},
//			{56285,218078,-3496},
//			{54238,218066,-3496},
//			{55259,219107,-3496},
//			// 2F
//			{56295,218078,-3224},
//			{56283,220133,-3224},
//			{54241,220127,-3224},
//			{54238,218077,-3224},
//			{55268,219090,-3224},
//			// 3F
//			{56284,218078,-2952},
//			//{56288,220120,-2952},	// ̍
//			{54252,220135,-2952},
//			{54244,218095,-2952},
//			{55270,219086,-2952}
//		};
//		
//    	int rndLoc = 0;
//		int rndX = 0;
//		int rndY = 0;
//		
//        try
//		{
//			for (int index = 0; index < targets.length; index++)
//			{
//				if (!(targets[index] instanceof L2Character))
//					continue;
//				
//				L2Character target = (L2Character) targets[index];
//				
//				target.abortAttack();
//				
//				rndLoc = Rnd.get(14);
//				rndX = Rnd.get(-400, 400);
//				rndY = Rnd.get(-400, 400);
//				
//				target.teleToLocation(loc[rndLoc][0] + rndX, loc[rndLoc][1]
//				        + rndY, loc[rndLoc][2]);
//			}
//		}
//		catch (Throwable e)
//		{
//			if (Config.DEBUG)
//				e.printStackTrace();
//		}
	}
}