﻿## Active Perl 5.8.8

# L2J_JP用 「テレホーダイ」
# admin 用のテレポートメニューを、一般プレイヤー用に変換する.
#  入力：gameserver/data/html/admin/tele/*.htm
#  出力：gameserver/data/html/teleporter/*.htm、teleport.sql
# ※ L2J_JP と datapack を合体したあとに行うこと.

use utf8;
use strict;
use warnings;
#use Encode;
use File::Basename;
use File::Path;

binmode STDOUT, ':encoding(cp932)';
#sub   FS {Encode::encode('cp932',shift)}
#sub UTF8 {Encode::decode('cp932',shift)}

#-my $lang_suffix = '.ja';

my $adminDir = '../../gameserver/data/html/admin/'; # L2J_JP + datapack_development
my $telepDir = '../../gameserver/data/html/teleporter/'; # htm保存先
my $sqlPath = 'teleports.sql';

my $startId = 29001;

my @excludes = (
	  'tele/j/boss.htm'
	, 'tele/j/castles.htm'
	, 'tele/j/goodies.htm'
	, 'tele/j/toi.htm'
#	, 'tele/locations/hellbound.htm'
	, 'tele/raid/raid_special.htm'
	, 'tele/raid.htm'
 );
my @done;

my $id = $startId;
my $SQL = '';

&start('teleports.htm', 0);

open FILE, '>:utf8', $sqlPath  or die "'$sqlPath' $!";
print FILE "\x{FEFF}"; #BOM
print FILE "SET NAMES UTF8;\n";
print FILE "DELETE FROM teleport WHERE id BETWEEN $startId AND $id;\n";
print FILE $SQL;
close FILE;
exit 0;

########################################################################
#
sub start($$) {
	my ($fileName,$nest) = @_;
	return if grep /^\Q$fileName\E$/,@done;
	push @done,$fileName;
	my $adminPath = $adminDir.$fileName;
	my $telepPath = $telepDir.$fileName;

	print '| 'x$nest,'+- ',$fileName,"\n";

	open FILE, '<:utf8', $adminPath  or die "'$adminPath' $!";
	read FILE, my $htm, -s FILE;
	close FILE;

#-	##! language
#-	my $lang_path = $telepPath.$lang_suffix;
#-	  if (-e $lang_path) {$_ = $htm; do $lang_path; $htm = $_}
#-	$lang_path = $adminPath.$lang_suffix;
#-	  if (-e $lang_path) {$_ = $htm; do $lang_path; $htm = $_}

	##! language
	$htm =~ s!value="Main"!value="メイン"!;
	$htm =~ s!value="Back"!value="戻る"!;
	$htm =~ s!="?sek.cbui94"?!=L2UI_ct1.button_df!g;
	$htm =~ s!="?sek.cbui92"?!=L2UI_ct1.button_df!g;

	##- delete "Bookmark"
	$htm =~ s!<a action="bypass -h admin_bookmark show">.*</body></html>!</body></html>!s;
	##- delete "Move to given Coords: X Y Z"
	$htm =~ s!<button value="More" action="bypass -h admin_tele".*?</body></html>!</body></html>!s;

	##- exclude
	# htm ファイル名による除外
	{
		foreach my $pattern (@excludes) {
			$htm =~ s!<a action="bypass -h admin_help \Q$pattern\E">(?:<.*?>|).+?(?:</.*?>|)</a>!!;
		}
	}

	##- exclude
	# 「：入口」以外を除外
	{
		my @a;
		while ($htm =~ m!<a action="bypass -h admin_move_to .*?">(?:<.*?>|)(.+?)：入口(?:</.*?>|)</a>!g) {
			push @a,$1;
		}
		foreach my $pattern (@a)
			{ $htm =~ s/>\Q$pattern\E：入口</>$pattern\f</g }
		foreach my $pattern (@a)
			{ $htm =~ s!<a action="bypass -h admin_move_to .*?">(?:<.*?>|)\Q$pattern\E：.*?(?:</.*?>|)</a>!!g }
		$htm =~ s/\f/：入口/g;
	}

	##- exclude area
	$htm =~ s!<a action="bypass -h admin_move_to .*?">.*?モンスター レース.*?</a>!!g;
	$htm =~ s!<a action="bypass -h admin_move_to .*?">.*?メルケニスの部屋.*?</a>!!g;
	$htm =~ s!<a action="bypass -h admin_move_to .*?">.*?祖先マルタンクスの部屋.*?</a>!!g;
	$htm =~ s!<a action="bypass -h admin_move_to .*?">.*?フリンテッサの部屋.*?</a>!!g;
	$htm =~ s!<a action="bypass -h admin_move_to .*?">.*?ナヒルの部屋.*?</a>!!g;
	$htm =~ s!<a action="bypass -h admin_move_to .*?">.*?バイウムの部屋.*?</a>!!g;
	$htm =~ s!<a action="bypass -h admin_move_to .*?">.*?アンタラスの棲処.*?</a>!!g;
	$htm =~ s!<a action="bypass -h admin_move_to .*?">.*?ヴァラカスの棲処.*?</a>!!g;
	$htm =~ s!<a action="bypass -h admin_move_to .*?">.*?最後の皇帝の墓.*?</a>!!g;
	$htm =~ s!<a action="bypass -h admin_move_to .*?">.*?最深部.*?</a>!!g;

	##- exclude BossZone
#	$htm =~ s!<a action="bypass -h admin_move_to .*?">(?:<.*?>|)(?:Core|コア)\s*(?:<.*?>|)</a>!!g;
#	$htm =~ s!<a action="bypass -h admin_move_to .*?">(?:<.*?>|)(?:Zaken|ザケン)\s*(?:<.*?>|)</a>!!g;
#	$htm =~ s!<a action="bypass -h admin_move_to .*?">(?:<.*?>|)(?:Baium|バイウム)\s*(?:<.*?>|)</a>!!g;
#	$htm =~ s!<a action="bypass -h admin_move_to .*?">(?:<.*?>|)(?:Antharas|アンタラス)\s*(?:<.*?>|)</a>!!g;
#	$htm =~ s!<a action="bypass -h admin_move_to .*?">(?:<.*?>|)(?:Valakas|ヴァラカス)\s*(?:<.*?>|)</a>!!g;
#	$htm =~ s!<a action="bypass -h admin_move_to .*?">.*?(?:最後の皇帝の墓|フリンテッサ)\s*(?:<.*?>|)</a>!!g;
#	$htm =~ s!<a action="bypass -h admin_move_to .*?">(?:<.*?>|)(?:Sailren|サイレン)\s*(?:<.*?>|)</a>!!g;
#	$htm =~ s!<a action="bypass -h admin_move_to .*?">(?:<.*?>|)(?:Anakim|アナキム)\s*(?:<.*?>|)</a>!!g;
#	$htm =~ s!<a action="bypass -h admin_move_to .*?">(?:<.*?>|)(?:Lilith|リリス)\s*(?:<.*?>|)</a>!!g;
#	$htm =~ s!<a action="bypass -h admin_move_to .*?">(?:<.*?>|)(?:Van Halter|ヴァン ホルター)\s*(?:<.*?>|)</a>!!g;
#	$htm =~ s!<a action="bypass -h admin_move_to .*?">(?:<.*?>|)(?:Shadow of Halisha|霊廟の支配者 ハリシャ シャドー)\s*(?:<.*?>|)</a>!!g;

	##! link
	$htm =~ s!"bypass -h admin_admin"!"bypass -h npc_%objectId%_Chat 0"!g;
	$htm =~ s!"bypass -h admin_show_moves"!"bypass -h npc_%objectId%_Link teleporter/teleports.htm"!g;
	$htm =~ s!"bypass -h admin_help teleports.htm"!"bypass -h npc_%objectId%_Link teleporter/teleports.htm"!;
#-	$htm =~ s!"bypass -h admin_help tele/boss.htm"!"bypass -h admin_help tele/raid.htm"!;	# JP --> English

	##- <a action="bypass -h admin_move_to -84202 244520 -3730"><font color="LEVEL">話せる島の村</font></a>
	##+ <a action="bypass -h npc_%objectId%_goto 9001" msg="811;話せる島の村"><font color="LEVEL">話せる島の村</font></a>
	my $tmp = '';
	while ($htm =~ s!<a action="bypass -h admin_move_to (-?\d+) (-?\d+) (-?\d+) *">(<.*?>|)(.+?)(<.*?>|)</a>!<a action="bypass -h npc_%objectId%_goto $id" msg="811;$5">$4$5$6</a>!) {
		my ($x,$y,$z,undef,$name,undef) = ($1,$2,$3,$4,$5,$6);
		$name =~ s!'!''!g;
		$tmp .= ",($id,$x,$y,$z,'$name')\n";
		++$id;
	}
	if ($tmp ne '') {
		$tmp =~ s/^,/ /s;
		$tmp =~ s/\n$/;\n/s;
		$SQL .= '-- '.$fileName."\n"
			. "INSERT INTO teleport (id,loc_x,loc_y,loc_z,Description) VALUES\n"
			. $tmp;
	}

	##- <a action="bypass -h admin_help tele/towns.htm">
	##+ <a action="bypass -h npc_%objectId%_Link teleporter/tele/towns.htm">
	while ($htm =~ s!"bypass -h admin_help (tele/.*?\.htm)"!"bypass -h npc_%objectId%_Link teleporter/$1"!) {
		&start($1, $nest+1);
	}

	# 整形
	1 while $htm =~ s!<br1>\s*<br1>!<br1>!gs;
	1 while $htm =~ s!<br1>(\s*<br>)!$1!g;
	1 while $htm =~ s!> +</!>\t</!g;
	$htm =~ s!\n\n+!\n!gs;

	die "[$1] Can't convert " if $htm =~ m/^(.*admin.*)$/m;	# DEBUG
#-	die "[$&] Can't convert " if $htm =~ m/^.*admin.*$/m;	# DEBUG

	my ($basename, $subdir, $ext) = fileparse($telepPath, ('\.htm'));
	unless (-d $subdir) {
		mkpath $subdir;
		print "mkdir $subdir\n";
	}
	open FILE, '>:utf8', $telepPath  or die "'$telepPath' $!";
	print FILE $htm;
	close FILE;
}
