-- -------------------------
-- Table structure for armor
-- -------------------------
DROP TABLE IF EXISTS `armor`;
CREATE TABLE IF NOT EXISTS `armor` (
  `item_id` int(11) NOT NULL default '0',
  `name` varchar(80) default NULL,
  `bodypart` varchar(15) NOT NULL default '',
  `crystallizable` varchar(5) NOT NULL default '',
  `armor_type` varchar(5) NOT NULL default '',
  `weight` int(5) NOT NULL default '0',
  `material` varchar(15) NOT NULL default '',
  `crystal_type` varchar(4) NOT NULL default '',
  `avoid_modify` int(1) NOT NULL default '0',
  `duration` int(3) NOT NULL default '0',
  `p_def` int(3) NOT NULL default '0',
  `m_def` int(2) NOT NULL default '0',
  `mp_bonus` int(3) NOT NULL default '0',
  `price` int(11) NOT NULL default '0',
  `crystal_count` int(4) default NULL,
  `sellable` varchar(5) default NULL,
  `dropable` varchar(5) NOT NULL default 'true',
  `destroyable` varchar(5) NOT NULL default 'true',
  `tradeable` varchar(5) NOT NULL default 'true',
  `skill` varchar(70) default '0-0;',
  PRIMARY KEY (`item_id`)
) DEFAULT CHARSET=utf8;
-- -----------------------
-- Records for table armor
-- -----------------------

INSERT INTO armor VALUES
(21,'Shirt','chest','false','light',4830,'cloth','none',0,-1,36,0,0,147,0,'true','true','true','true','0-0;'),
(22,'Leather Shirt','chest','false','light',4830,'leather','none',0,-1,43,0,0,2430,0,'true','true','true','true','0-0;'),
(23,'Wooden Breastplate','chest','false','light',4820,'wood','none',0,-1,47,0,0,7960,0,'true','true','true','true','0-0;'),
(24,'Bone Breastplate','chest','false','light',4770,'bone','none',0,-1,50,0,0,15600,0,'true','true','true','true','0-0;'),
(25,'Piece Bone Breastplate','chest','false','heavy',8970,'bone','none',0,-1,62,0,0,24480,0,'true','true','true','true','0-0;'),
(26,'Bronze Breastplate','chest','false','heavy',8920,'bronze','none',0,-1,68,0,0,37820,0,'true','true','true','true','0-0;'),
(27,'Hard Leather Shirt','chest','false','light',4720,'leather','none',0,-1,53,0,0,28400,0,'true','true','true','true','0-0;'),
(28,'Pants','legs','false','light',1740,'cloth','none',0,-1,22,0,0,92,0,'true','true','true','true','0-0;'),
(29,'Leather Pants','legs','false','light',1730,'leather','none',0,-1,27,0,0,1520,0,'true','true','true','true','0-0;'),
(30,'Hard Leather Pants','legs','false','light',1700,'leather','none',0,-1,29,0,0,4970,0,'true','true','true','true','0-0;'),
(31,'Bone Gaiters','legs','false','light',1680,'bone','none',0,-1,32,0,0,9770,0,'true','true','true','true','0-0;'),
(32,'Piece Bone Gaiters','legs','false','heavy',4020,'bone','none',0,-1,39,0,0,15300,0,'true','true','true','true','0-0;'),
(33,'Hard Leather Gaiters','legs','false','light',1610,'leather','none',0,-1,33,0,0,17700,0,'true','true','true','true','0-0;'),
(34,'Bronze Gaiters','legs','false','heavy',3960,'bronze','none',0,-1,43,0,0,23600,0,'true','true','true','true','0-0;'),
(35,'Cloth Shoes','feet','false','none',1320,'cloth','none',0,-1,9,0,0,37,0,'true','true','true','true','0-0;'),
(36,'Leather Sandals','feet','false','none',1320,'leather','none',0,-1,9,0,0,37,0,'true','true','true','true','0-0;'),
(37,'Leather Shoes','feet','false','none',1320,'leather','none',0,-1,13,0,0,2650,0,'true','true','true','true','0-0;'),
(38,'Low Boots','feet','false','none',1320,'leather','none',0,-1,15,0,0,5210,0,'true','true','true','true','0-0;'),
(39,'Boots','feet','false','none',1310,'cloth','none',0,-1,17,0,0,9500,0,'true','true','true','true','0-0;'),
(40,'Leather Boots','feet','true','none',1300,'leather','d',0,-1,19,0,0,16100,30,'true','true','true','true','0-0;'),
(41,'Cloth Cap','head','false','none',660,'cloth','none',0,-1,13,0,0,55,0,'true','true','true','true','0-0;'),
(42,'Leather Cap','head','false','none',660,'leather','none',0,-1,16,0,0,911,0,'true','true','true','true','0-0;'),
(43,'Wooden Helmet','head','false','none',660,'wood','none',0,-1,19,0,0,3980,0,'true','true','true','true','0-0;'),
(44,'Leather Helmet','head','false','none',650,'leather','none',0,-1,23,0,0,7820,0,'true','true','true','true','0-0;'),
(45,'Bone Helmet','head','true','none',640,'bone','d',0,-1,29,0,0,24100,44,'true','true','true','true','0-0;'),
(46,'Bronze Helmet','head','true','none',630,'bronze','d',0,-1,33,0,0,38400,71,'true','true','true','true','0-0;'),
(47,'Helmet','head','true','none',640,'fine_steel','d',0,-1,37,0,0,58600,108,'true','true','true','true','0-0;'),
(48,'Short Gloves','gloves','false','none',660,'cloth','none',0,-1,9,0,0,37,0,'true','true','true','true','0-0;'),
(49,'Gloves','gloves','false','none',660,'cloth','none',0,-1,13,0,0,2650,0,'true','true','true','true','0-0;'),
(50,'Leather Gloves','gloves','false','none',650,'leather','none',0,-1,15,0,0,5210,0,'true','true','true','true','0-0;'),
(51,'Bracer','gloves','false','none',650,'leather','none',0,-1,17,0,0,9500,0,'true','true','true','true','0-0;'),
(52,'Vesper Dual Sword','underwear','false','none',260,'cloth','none',0,-1,2,0,0,37,0,'true','true','true','true','0-0;'),
(53,'Cotton Cloak','underwear','false','none',250,'cloth','none',0,-1,3,0,0,607,0,'true','true','true','true','0-0;'),
(54,'Silk Cloak','underwear','false','none',250,'cloth','none',0,-1,4,0,0,2650,0,'true','true','true','true','0-0;'),
(55,'Cotton Undergarment','underwear','false','none',170,'cotton','none',0,-1,4,0,0,18,0,'true','true','true','true','0-0;'),
(56,'Wool Undergarment','underwear','false','none',170,'wood','none',0,-1,5,0,0,304,0,'true','true','true','true','0-0;'),
(58,'Mithril Breastplate','chest','true','heavy',8670,'mithril','d',0,-1,95,0,0,141100,260,'true','true','true','true','0-0;'),
(59,'Mithril Gaiters','legs','true','heavy',3830,'mithril','d',0,-1,61,0,0,97600,180,'true','true','true','true','0-0;'),
(60,'Composite Armor','fullarmor','true','heavy',10980,'fine_steel','c',0,-1,224,0,0,1227000,491,'true','true','true','true','0-0;'),
(61,'Mithril Plate Gloves','gloves','true','none',630,'mithril','d',0,-1,29,0,0,75200,137,'true','true','true','true','0-0;'),
(62,'Mithril Boots','feet','true','none',1230,'leather','c',0,-1,32,0,0,97100,39,'true','true','true','true','0-0;'),
(63,'Gauntlets','gloves','true','none',640,'cloth','d',0,-1,24,0,0,39100,71,'true','true','true','true','0-0;'),
(64,'Composite Boots','feet','true','none',1220,'fine_steel','c',0,-1,36,0,0,188800,76,'true','true','true','true','0-0;'),
(112,'Apprentice\'s Earring','rear,lear','false','none',150,'silver','none',0,-1,0,11,0,49,0,'true','true','true','true','0-0;'),
(113,'Mystic\'s Earring','rear,lear','false','none',150,'silver','none',0,-1,0,13,0,811,0,'true','true','true','true','0-0;'),
(114,'Earring of Strength','rear,lear','false','none',150,'gold','none',0,-1,0,16,0,3510,0,'true','true','true','true','0-0;'),
(115,'Earring of Wisdom','rear,lear','false','none',150,'gold','none',0,-1,0,16,0,3510,0,'true','true','true','true','0-0;'),
(116,'Magic Ring','rfinger,lfinger','false','none',150,'gold','none',0,-1,0,7,0,33,0,'true','true','true','true','0-0;'),
(117,'Ring of Mana','rfinger,lfinger','true','none',150,'silver','b',0,-1,0,34,0,404000,54,'true','true','true','true','0-0;'),
(118,'Necklace of Magic','neck','false','none',150,'silver','none',0,-1,0,15,0,66,0,'true','true','true','true','0-0;'),
(119,'Necklace of Binding','neck','true','none',150,'adamantaite','c',0,-1,0,64,0,434399,174,'true','true','true','true','0-0;'),
(347,'Ring Mail Breastplate','chest','true','heavy',8820,'steel','d',0,-1,77,0,0,83500,119,'true','true','true','true','0-0;'),
(348,'Scale Mail','chest','true','heavy',8720,'steel','d',0,-1,87,0,0,102500,189,'true','true','true','true','0-0;'),
(349,'Compound Scale Mail','chest','true','heavy',8620,'fine_steel','d',0,-1,95,0,0,141100,260,'true','true','true','true','0-0;'),
(350,'Dwarven Scale Mail','chest','true','heavy',8540,'fine_steel','d',0,-1,95,0,0,141100,260,'true','true','true','true','0-0;'),
(351,'Blast Plate','chest','true','heavy',8420,'fine_steel','d',0,-1,97,0,0,203000,288,'true','true','true','true','0-0;'),
(352,'Brigandine Tunic','chest','true','heavy',8320,'fine_steel','d',0,-1,103,0,0,229700,424,'true','true','true','true','0-0;'),
(353,'Half Plate Armor','chest','true','heavy',8220,'fine_steel','d',0,-1,111,0,0,300800,555,'true','true','true','true','0-0;'),
(354,'Chain Mail Shirt','chest','true','heavy',8120,'fine_steel','c',0,-1,120,0,0,388600,155,'true','true','true','true','0-0;'),
(355,'Dwarven Chain Mail Shirt','chest','true','heavy',8070,'fine_steel','c',0,-1,129,0,0,495500,198,'true','true','true','true','0-0;'),
(356,'Full Plate Armor','fullarmor','true','heavy',10480,'fine_steel','c',0,-1,239,0,0,1788000,715,'true','true','true','true','0-0;'),
(357,'Zubei\'s Breastplate','chest','true','heavy',7970,'mithril','b',0,-1,157,0,0,2080000,213,'true','true','true','true','0-0;'),
(358,'Blue Wolf Breastplate','chest','true','heavy',7820,'oriharukon','b',0,-1,166,0,0,3220000,330,'true','true','true','true','0-0;'),
(359,'Shining Dragon Armor','fullarmor','true','heavy',6400,'mithril','b',0,-1,301,0,0,6770000,903,'true','true','true','true','0-0;'),
(360,'Armor of Victory','chest','true','heavy',3360,'oriharukon','b',0,-1,175,0,0,3220000,429,'true','true','true','true','0-0;'),
(361,'Breastplate of Valor','chest','true','heavy',3360,'blood_steel','b',0,-1,185,0,0,4630000,617,'true','true','true','true','0-0;'),
(362,'Glorious Armor','fullarmor','true','heavy',6720,'fine_steel','b',0,-1,284,0,0,4710000,628,'true','true','true','true','0-0;'),
(363,'Red Flame Armor','fullarmor','true','heavy',6400,'blood_steel','b',0,-1,301,0,0,6770000,903,'true','true','true','true','0-0;'),
(364,'Elven Crystal Breastplate','chest','true','heavy',2400,'crystal','b',0,-1,175,0,0,3220000,429,'true','true','true','true','0-0;'),
(365,'Dark Crystal Breastplate','chest','true','heavy',7700,'crystal','a',0,-1,171,0,0,4630000,285,'true','true','true','true','0-0;'),
(366,'Implosion Armor','fullarmor','true','heavy',6080,'damascus','b',0,-1,284,0,0,4710000,628,'true','true','true','true','0-0;'),
(367,'Dark Dragon Armor','fullarmor','true','heavy',5760,'damascus','b',0,-1,301,0,0,6770000,903,'true','true','true','true','0-0;'),
(368,'Elven Vagian Armor','fullarmor','true','heavy',2400,'mithril','b',0,-1,284,0,0,4710000,628,'true','true','true','true','0-0;'),
(369,'Dark Vagian Armor','fullarmor','true','heavy',2400,'mithril','b',0,-1,301,0,0,6770000,903,'true','true','true','true','0-0;'),
(370,'Complete Set of Plate Armor','fullarmor','true','heavy',6400,'fine_steel','b',0,-1,284,0,0,4710000,628,'true','true','true','true','0-0;'),
(371,'Hell Plate','fullarmor','true','heavy',6400,'blood_steel','b',0,-1,301,0,0,6770000,903,'true','true','true','true','0-0;'),
(372,'Art of Plate','fullarmor','true','heavy',6720,'chrysolite','b',0,-1,284,0,0,4710000,628,'true','true','true','true','0-0;'),
(373,'Masterpiece Armor','fullarmor','true','heavy',5600,'oriharukon','b',0,-1,301,0,0,6770000,903,'true','true','true','true','0-0;'),
(374,'Armor of Nightmare','fullarmor','true','heavy',9580,'blood_steel','a',0,-1,293,0,0,10300000,704,'true','true','true','true','0-0;'),
(375,'Dragon Scale Mail','chest','true','heavy',7620,'scale_of_dragon','s',0,-1,198,0,0,10500000,525,'false','false','true','false','0-0;'),
(376,'Iron Plate Gaiters','legs','true','heavy',3820,'steel','d',0,-1,48,0,0,40100,74,'true','true','true','true','0-0;'),
(377,'Scale Gaiters','legs','true','heavy',3860,'fine_steel','d',0,-1,54,0,0,64100,118,'true','true','true','true','0-0;'),
(378,'Compound Scale Gaiters','legs','true','heavy',3770,'fine_steel','d',0,-1,61,0,0,97600,180,'true','true','true','true','0-0;'),
(379,'Dwarven Scale Gaiters','legs','true','heavy',3840,'fine_steel','d',0,-1,61,0,0,97600,180,'true','true','true','true','0-0;'),
(380,'Plate Gaiters','legs','true','heavy',3770,'fine_steel','d',0,-1,70,0,0,188000,347,'true','true','true','true','0-0;'),
(381,'Chain Gaiters','legs','true','heavy',3680,'fine_steel','c',0,-1,75,0,0,242900,97,'true','true','true','true','0-0;'),
(382,'Dwarven Chain Gaiters','legs','true','heavy',3620,'fine_steel','c',0,-1,80,0,0,309700,124,'true','true','true','true','0-0;'),
(383,'Zubei\'s Gaiters','legs','true','heavy',3570,'mithril','b',0,-1,98,0,0,1300000,133,'true','true','true','true','0-0;'),
(384,'Wolf Gaiters','legs','true','heavy',2560,'oriharukon','b',0,-1,109,0,0,2010000,206,'true','true','true','true','0-0;'),
(385,'Gaiters of Victory','legs','true','heavy',2240,'oriharukon','b',0,-1,109,0,0,2010000,268,'true','true','true','true','0-0;'),
(386,'Gaiters of Valor','legs','true','heavy',2240,'blood_steel','b',0,-1,116,0,0,2890000,385,'true','true','true','true','0-0;'),
(387,'Elven Crystal Gaiters','legs','true','heavy',2240,'crystal','b',0,-1,109,0,0,2010000,268,'true','true','true','true','0-0;'),
(388,'Dark Crystal Gaiters','legs','true','heavy',3320,'crystal','a',0,-1,107,0,0,2890000,178,'true','true','true','true','0-0;'),
(389,'Dragon Scale Gaiters','legs','true','heavy',3260,'scale_of_dragon','s',0,-1,122,0,0,5980000,299,'false','false','true','false','0-0;'),
(390,'Cotton Shirt','chest','false','light',4770,'cloth','none',0,-1,50,0,0,15600,0,'true','true','true','true','0-0;'),
(391,'Puma Skin Shirt','chest','true','light',4700,'leather','d',0,-1,58,0,0,48200,89,'true','true','true','true','0-0;'),
(392,'Lion Skin Shirt','chest','true','light',4580,'leather','d',0,-1,65,0,0,76900,142,'true','true','true','true','0-0;'),
(393,'Mithril Banded Mail','chest','true','light',4570,'mithril','d',0,-1,73,0,0,117000,216,'true','true','true','true','0-0;'),
(394,'Reinforced Leather Shirt','chest','true','light',4570,'leather','d',0,-1,73,0,0,117000,216,'true','true','true','true','0-0;'),
(395,'Manticore Skin Shirt','chest','true','light',4520,'leather','d',0,-1,77,0,0,172000,318,'true','true','true','true','0-0;'),
(396,'Salamander Skin Mail','fullarmor','true','light',6100,'leather','d',0,-1,136,0,0,366600,677,'true','true','true','true','0-0;'),
(397,'Mithril Shirt','chest','true','light',4470,'mithril','c',0,-1,90,0,0,291000,116,'true','true','true','true','0-0;'),
(398,'Plated Leather','chest','true','light',4450,'leather','c',0,-1,94,0,0,343000,137,'true','true','true','true','0-0;'),
(399,'Rind Leather Armor','chest','true','light',4420,'leather','c',0,-1,97,0,0,372000,149,'true','true','true','true','0-0;'),
(400,'Theca Leather Armor','chest','true','light',4370,'leather','c',0,-1,106,0,0,635000,254,'true','true','true','true','0-0;'),
(401,'Drake Leather Armor','fullarmor','true','light',5800,'leather','c',0,-1,179,0,0,1341000,536,'true','true','true','true','0-0;'),
(402,'Chain Mail of Silence','fullarmor','true','light',3200,'damascus','b',0,-1,213,0,0,3530000,471,'true','true','true','true','0-0;'),
(403,'Gust Chain Mail','fullarmor','true','light',2720,'blood_steel','b',0,-1,225,0,0,5080000,677,'true','true','true','true','0-0;'),
(404,'Prairie Leather Armor','chest','true','light',8000,'leather','b',0,-1,131,0,0,2410000,321,'true','true','true','true','0-0;'),
(405,'Leather Armor of The Underworld','chest','true','light',8000,'leather','b',0,-1,139,0,0,3470000,463,'true','true','true','true','0-0;'),
(406,'Leather Suit of Concentration','fullarmor','true','light',2400,'leather','b',0,-1,213,0,0,3530000,471,'true','true','true','true','0-0;'),
(407,'Ace\'s Leather Armor','fullarmor','true','light',2400,'leather','b',0,-1,225,0,0,5080000,677,'true','true','true','true','0-0;'),
(408,'Guardian\'s Leather Armor','chest','true','light',8000,'leather','b',0,-1,131,0,0,2410000,321,'true','true','true','true','0-0;'),
(409,'Marksman\'s Leather Armor','chest','true','light',4300,'leather','b',0,-1,139,0,0,3470000,463,'true','true','true','true','0-0;'),
(410,'Unicorn Leather Armor','fullarmor','true','light',1280,'leather','a',0,-1,238,0,0,7730000,618,'true','true','true','true','0-0;'),
(411,'Dragon Leather Armor','fullarmor','true','light',4950,'leather','s',0,-1,237,0,0,10500000,525,'false','false','true','false','0-0;'),
(412,'Cotton Pants','legs','false','light',1630,'cloth','none',0,-1,32,0,0,9770,0,'true','true','true','true','0-0;'),
(413,'Puma Skin Gaiters','legs','true','light',1600,'leather','d',0,-1,36,0,0,30100,56,'true','true','true','true','0-0;'),
(414,'Lion Skin Gaiters','legs','true','light',1570,'leather','d',0,-1,41,0,0,48000,89,'true','true','true','true','0-0;'),
(415,'Mithril Banded Gaiters','legs','true','light',1580,'mithril','d',0,-1,46,0,0,73200,135,'true','true','true','true','0-0;'),
(416,'Reinforced Leather Gaiters','legs','true','light',1570,'leather','d',0,-1,46,0,0,73200,135,'true','true','true','true','0-0;'),
(417,'Manticore Skin Gaiters','legs','true','light',1550,'leather','d',0,-1,48,0,0,107700,199,'true','true','true','true','0-0;'),
(418,'Plated Leather Gaiters','legs','true','light',1560,'leather','c',0,-1,59,0,0,214500,86,'true','true','true','true','0-0;'),
(419,'Rind Leather Gaiters','legs','true','light',1550,'leather','c',0,-1,60,0,0,232300,93,'true','true','true','true','0-0;'),
(420,'Theca Leather Gaiters','legs','true','light',1530,'leather','c',0,-1,66,0,0,396700,159,'true','true','true','true','0-0;'),
(421,'Prairie Leather Gaiters','legs','true','light',4800,'leather','b',0,-1,82,0,0,1510000,201,'true','true','true','true','0-0;'),
(422,'Gaiters of The Underworld','legs','true','light',4800,'leather','b',0,-1,87,0,0,2170000,289,'true','true','true','true','0-0;'),
(423,'Guardian\'s Leather Gaiters','legs','true','light',4800,'leather','b',0,-1,82,0,0,1510000,201,'true','true','true','true','0-0;'),
(424,'Marksman\'s Leather Gaiters','legs','true','light',1490,'leather','b',0,-1,87,0,0,2170000,289,'true','true','true','true','0-0;'),
(425,'Apprentice\'s Tunic','chest','false','magic',2150,'cloth','none',0,-1,17,0,19,26,0,'false','false','true','false','0-0;'),
(426,'Tunic','chest','false','magic',2150,'cloth','none',0,-1,18,0,24,147,0,'true','true','true','true','0-0;'),
(427,'Cotton Robe','fullarmor','false','magic',2750,'cotton','none',0,-1,35,0,61,3550,0,'true','true','true','true','0-0;'),
(428,'Feriotic Tunic','chest','false','magic',2140,'cloth','none',0,-1,21,0,38,2430,0,'true','true','true','true','0-0;'),
(429,'Leather Tunic','chest','false','magic',2110,'leather','none',0,-1,25,0,52,7960,0,'true','true','true','true','0-0;'),
(430,'Robe of Devotion','fullarmor','false','magic',2650,'cloth','none',0,-1,49,0,109,29700,0,'true','true','true','true','0-0;'),
(431,'Robe of Magic','fullarmor','false','magic',2600,'cloth','none',0,-1,56,0,140,53900,0,'true','true','true','true','0-0;'),
(432,'Cursed Tunic','chest','true','magic',2090,'cloth','d',0,-1,39,0,106,48200,89,'true','true','true','true','0-0;'),
(433,'Elven Tunic','chest','true','magic',2080,'cloth','d',0,-1,43,0,126,76900,142,'true','true','true','true','0-0;'),
(434,'White Tunic','chest','true','magic',2040,'cloth','d',0,-1,43,0,126,76900,142,'true','true','true','true','0-0;'),
(435,'Mystic\'s Tunic','chest','true','magic',2030,'cloth','d',0,-1,43,0,126,76900,142,'true','true','true','true','0-0;'),
(436,'Tunic of Knowledge','chest','true','magic',2020,'cloth','d',0,-1,49,0,147,117000,216,'true','true','true','true','0-0;'),
(437,'Mithril Tunic','chest','true','magic',2010,'mithril','d',0,-1,52,0,169,172000,318,'true','true','true','true','0-0;'),
(438,'Sage\'s Rag','fullarmor','true','magic',2580,'cloth','d',0,-1,90,0,320,366600,677,'true','true','true','true','0-0;'),
(439,'Karmian Tunic','chest','true','magic',1980,'cloth','c',0,-1,60,0,225,291000,116,'true','true','true','true','0-0;'),
(440,'Robe of Seal','fullarmor','true','magic',2500,'cloth','c',0,-1,105,0,413,603900,242,'true','true','true','true','0-0;'),
(441,'Demon\'s Tunic','chest','true','magic',1990,'cloth','c',0,-1,69,0,284,566000,226,'true','true','true','true','0-0;'),
(442,'Divine Tunic','chest','true','magic',1980,'cloth','c',0,-1,74,0,314,825000,330,'true','true','true','true','0-0;'),
(443,'Tunic of Mana','chest','true','magic',2000,'cloth','b',0,-1,87,0,377,2410000,321,'true','true','true','true','0-0;'),
(444,'Sage\'s Robe','fullarmor','true','magic',1600,'cloth','b',0,-1,150,0,665,5080000,677,'true','true','true','true','0-0;'),
(445,'Paradia Tunic','chest','true','magic',1990,'cloth','b',0,-1,87,0,377,2410000,321,'true','true','true','true','0-0;'),
(446,'Inferno Tunic','chest','true','magic',1880,'cloth','b',0,-1,92,0,409,3470000,463,'true','true','true','true','0-0;'),
(447,'Tunic of Solar Eclipse','chest','true','magic',1960,'cloth','b',0,-1,87,0,377,2410000,321,'true','true','true','true','0-0;'),
(448,'Robe of Black Ore','fullarmor','true','magic',1600,'cloth','b',0,-1,150,0,665,5080000,677,'true','true','true','true','0-0;'),
(449,'Tunic of Summoning','chest','true','magic',1950,'cloth','b',0,-1,87,0,377,2410000,321,'true','true','true','true','0-0;'),
(450,'Otherworldly Robe','fullarmor','true','magic',1600,'cloth','b',0,-1,150,0,665,5080000,677,'true','true','true','true','0-0;'),
(451,'Elemental Tunic','chest','true','magic',1970,'cloth','b',0,-1,87,0,377,2410000,321,'true','true','true','true','0-0;'),
(452,'Tunic of Phantom','chest','true','magic',1890,'cloth','b',0,-1,92,0,409,3470000,463,'true','true','true','true','0-0;'),
(453,'Tunic of Grace','chest','true','magic',1930,'cloth','b',0,-1,87,0,377,2410000,321,'true','true','true','true','0-0;'),
(454,'Robe of Holy Spirit','fullarmor','true','magic',1600,'cloth','b',0,-1,150,0,665,5080000,677,'true','true','true','true','0-0;'),
(455,'Phoenix Tunic','chest','true','magic',1950,'cloth','b',0,-1,87,0,377,2410000,321,'true','true','true','true','0-0;'),
(456,'Cerberus Tunic','chest','true','magic',1870,'cloth','b',0,-1,92,0,409,3470000,463,'true','true','true','true','0-0;'),
(457,'Tunic of Aid','chest','true','magic',1910,'cloth','b',0,-1,87,0,377,2410000,321,'true','true','true','true','0-0;'),
(458,'Robe of Blessing','fullarmor','true','magic',1600,'cloth','b',0,-1,150,0,665,5080000,677,'true','true','true','true','0-0;'),
(459,'Dasparion\'s Robe','fullarmor','true','magic',1200,'cloth','a',0,-1,158,0,718,7730000,618,'true','true','true','true','0-0;'),
(460,'The Robe','fullarmor','true','magic',2300,'cloth','s',0,-1,158,0,773,10500000,525,'false','false','true','false','0-0;'),
(461,'Apprentice\'s Stockings','legs','false','magic',1100,'cloth','none',0,-1,10,0,10,6,0,'false','false','true','false','0-0;'),
(462,'Stockings','legs','false','magic',1080,'cloth','none',0,-1,11,0,15,92,0,'true','true','true','true','0-0;'),
(463,'Feriotic Stockings','legs','false','magic',1070,'cloth','none',0,-1,13,0,23,1520,0,'true','true','true','true','0-0;'),
(464,'Leather Stockings','legs','false','magic',1020,'leather','none',0,-1,16,0,33,4970,0,'true','true','true','true','0-0;'),
(465,'Cursed Stockings','legs','true','magic',1020,'cloth','d',0,-1,24,0,66,30100,56,'true','true','true','true','0-0;'),
(466,'Elven Stockings','legs','true','magic',1010,'cloth','d',0,-1,27,0,79,48000,89,'true','true','true','true','0-0;'),
(467,'Dark Stockings','legs','true','magic',1000,'cloth','d',0,-1,27,0,79,48000,89,'true','true','true','true','0-0;'),
(468,'Mystic\'s Stockings','legs','true','magic',990,'cloth','d',0,-1,27,0,79,48000,89,'true','true','true','true','0-0;'),
(469,'Stockings of Knowledge','legs','true','magic',1000,'cloth','d',0,-1,30,0,92,73200,135,'true','true','true','true','0-0;'),
(470,'Mithril Stockings','legs','true','magic',980,'mithril','d',0,-1,32,0,105,107700,199,'true','true','true','true','0-0;'),
(471,'Karmian Stockings','legs','true','magic',970,'cloth','c',0,-1,37,0,141,182100,73,'true','true','true','true','0-0;'),
(472,'Demon\'s Stockings','legs','true','magic',980,'cloth','c',0,-1,43,0,177,354000,142,'true','true','true','true','0-0;'),
(473,'Divine Stockings','legs','true','magic',960,'cloth','c',0,-1,46,0,196,515800,206,'true','true','true','true','0-0;'),
(474,'Stockings of Mana','legs','true','magic',2400,'cloth','b',0,-1,55,0,236,1510000,201,'true','true','true','true','0-0;'),
(475,'Paradia Stockings','legs','true','magic',1600,'cloth','b',0,-1,55,0,236,1510000,201,'true','true','true','true','0-0;'),
(476,'Inferno Stockings','legs','true','magic',1600,'cloth','b',0,-1,58,0,256,2170000,289,'true','true','true','true','0-0;'),
(477,'Stockings of Solar Eclipse','legs','true','magic',2400,'cloth','b',0,-1,55,0,236,1510000,201,'true','true','true','true','0-0;'),
(478,'Stockings of Summoning','legs','true','magic',2400,'cloth','b',0,-1,55,0,236,1510000,201,'true','true','true','true','0-0;'),
(479,'Elemental Stockings','legs','true','magic',1600,'cloth','b',0,-1,55,0,236,1510000,201,'true','true','true','true','0-0;'),
(480,'Stockings of Phantom','legs','true','magic',1600,'cloth','b',0,-1,58,0,256,2170000,289,'true','true','true','true','0-0;'),
(481,'Stockings of Grace','legs','true','magic',2400,'cloth','b',0,-1,55,0,236,1510000,201,'true','true','true','true','0-0;'),
(482,'Phoenix Stockings','legs','true','magic',2400,'cloth','b',0,-1,55,0,236,1510000,201,'true','true','true','true','0-0;'),
(483,'Cerberus Stockings','legs','true','magic',6400,'cloth','b',0,-1,58,0,256,2170000,289,'true','true','true','true','0-0;'),
(484,'Stockings of Aid','legs','true','magic',2400,'cloth','b',0,-1,55,0,236,1510000,201,'true','true','true','true','0-0;'),
(485,'Tattoo of Power','underwear','false','none',4200,'dyestuff','none',0,-1,53,0,0,36900,0,'true','true','true','true','0-0;'),
(486,'Tattoo of Fire','underwear','true','none',4050,'dyestuff','d',0,-1,73,0,0,152000,276,'true','true','true','true','0-0;'),
(487,'Tattoo of Resolve','underwear','true','none',4000,'dyestuff','d',0,-1,73,0,0,152000,276,'true','true','true','true','0-0;'),
(488,'Tattoo of Flame','underwear','true','none',800,'dyestuff','b',0,-1,139,0,0,3470000,463,'true','true','true','true','0-0;'),
(489,'Tattoo of Bravery','underwear','true','none',4100,'dyestuff','c',0,-1,110,0,0,1070000,428,'true','true','true','true','0-0;'),
(490,'Tattoo of Blood','underwear','true','none',3800,'dyestuff','a',0,-1,132,0,0,3470000,278,'true','true','true','true','0-0;'),
(491,'Tattoo of Absolute','underwear','true','none',800,'dyestuff','a',0,-1,146,0,0,5280000,422,'true','true','true','true','0-0;'),
(492,'Tattoo of Soul','underwear','true','none',4150,'dyestuff','d',0,-1,65,0,0,99900,182,'true','true','true','true','0-0;'),
(493,'Tattoo of Avadon','underwear','true','none',4000,'dyestuff','b',0,-1,117,0,0,1560000,208,'true','true','true','true','0-0;'),
(494,'Tattoo of Doom','underwear','true','none',4100,'dyestuff','b',0,-1,125,0,0,2410000,321,'true','true','true','true','0-0;'),
(495,'Tattoo of Pledge','underwear','true','none',4000,'dyestuff','b',0,-1,124,0,0,1560000,208,'true','true','true','true','0-0;'),
(496,'Tattoo of Divine','underwear','true','none',4100,'dyestuff','b',0,-1,131,0,0,2410000,321,'true','true','true','true','0-0;'),
(497,'Chain Helmet','head','true','none',620,'fine_steel','c',0,-1,45,0,0,147000,59,'true','true','true','true','0-0;'),
(498,'Steel Plate Helmet','head','true','none',610,'fine_steel','c',0,-1,49,0,0,206000,82,'true','true','true','true','0-0;'),
(499,'Mithril Helmet','head','true','none',240,'mithril','c',0,-1,58,0,0,536000,214,'true','true','true','true','0-0;'),
(500,'Great Helmet','head','true','none',610,'fine_steel','c',0,-1,51,0,0,185800,74,'true','true','true','true','0-0;'),
(501,'Armet','head','true','none',580,'chrysolite','b',0,-1,62,0,0,1030000,137,'true','true','true','true','0-0;'),
(502,'Close Helmet','head','true','none',570,'oriharukon','a',0,-1,64,0,0,1560000,125,'true','true','true','true','0-0;'),
(503,'Zubei\'s Helmet','head','true','none',590,'mithril','b',0,-1,62,0,0,778000,80,'true','true','true','true','0-0;'),
(504,'Dragon Helmet','head','true','none',550,'bone','s',0,-1,77,0,0,3590000,180,'false','false','true','false','0-0;'),
(505,'Wolf Helmet','head','true','none',580,'oriharukon','b',0,-1,66,0,0,1210000,124,'true','true','true','true','0-0;'),
(506,'Shining Dragon Helmet','head','true','none',880,'mithril','b',0,-1,67,0,0,1740000,232,'true','true','true','true','0-0;'),
(507,'Helmet of Victory','head','true','none',640,'oriharukon','b',0,-1,66,0,0,1210000,161,'true','true','true','true','0-0;'),
(508,'Helmet of Valor','head','true','none',720,'blood_steel','b',0,-1,67,0,0,1740000,232,'true','true','true','true','0-0;'),
(509,'Glorious Helmet','head','true','none',800,'fine_steel','a',0,-1,65,0,0,2040000,163,'true','true','true','true','0-0;'),
(510,'Red Flame Helmet','head','true','none',960,'blood_steel','a',0,-1,71,0,0,2640000,211,'true','true','true','true','0-0;'),
(511,'Elven Crystal Helmet','head','true','none',580,'crystal','b',0,-1,66,0,0,1210000,161,'true','true','true','true','0-0;'),
(512,'Dark Crystal Helmet','head','true','none',570,'crystal','a',0,-1,69,0,0,1740000,107,'true','true','true','true','0-0;'),
(513,'Implosion Helmet','head','true','none',480,'damascus','b',0,-1,66,0,0,1210000,161,'true','true','true','true','0-0;'),
(514,'Dark Dragon Helmet','head','true','none',400,'damascus','b',0,-1,67,0,0,1740000,232,'true','true','true','true','0-0;'),
(515,'Elven Vagian Helm','head','true','none',560,'mithril','a',0,-1,65,0,0,2040000,163,'true','true','true','true','0-0;'),
(516,'Dark Vagian Helm','head','true','none',560,'mithril','a',0,-1,71,0,0,2640000,211,'true','true','true','true','0-0;'),
(517,'Composite Helmet','head','true','none',610,'fine_steel','c',0,-1,54,0,0,283200,113,'true','true','true','true','0-0;'),
(518,'Hell Helm','head','true','none',320,'blood_steel','a',0,-1,71,0,0,2640000,211,'true','true','true','true','0-0;'),
(519,'Art of Helmet','head','true','none',400,'chrysolite','b',0,-1,66,0,0,1210000,161,'true','true','true','true','0-0;'),
(520,'Masterpiece Helm','head','true','none',400,'oriharukon','a',0,-1,71,0,0,2640000,211,'true','true','true','true','0-0;'),
(521,'Helmet of Silence','head','true','none',320,'damascus','b',0,-1,66,0,0,1210000,161,'true','true','true','true','0-0;'),
(522,'Gust Helmet','head','true','none',570,'blood_steel','b',0,-1,67,0,0,1740000,232,'true','true','true','true','0-0;'),
(523,'Prairie Helmet','head','true','none',480,'leather','b',0,-1,66,0,0,1210000,161,'true','true','true','true','0-0;'),
(524,'Helm of The Underworld','head','true','none',320,'damascus','b',0,-1,67,0,0,1740000,232,'true','true','true','true','0-0;'),
(525,'Helmet of Concentration','head','true','none',320,'oriharukon','b',0,-1,66,0,0,1210000,161,'true','true','true','true','0-0;'),
(526,'Ace\'s Helmet','head','true','none',320,'oriharukon','b',0,-1,67,0,0,1740000,232,'true','true','true','true','0-0;'),
(527,'Guardian\'s Helmet','head','true','none',240,'mithril','b',0,-1,66,0,0,1210000,161,'true','true','true','true','0-0;'),
(528,'Marksman Helmet','head','true','none',240,'leather','b',0,-1,67,0,0,1740000,232,'true','true','true','true','0-0;'),
(529,'Cap of Mana','head','true','none',320,'cloth','c',0,-1,58,0,0,536000,214,'true','true','true','true','0-0;'),
(530,'Sage\'s Cap','head','true','none',320,'cloth','b',0,-1,62,0,0,778000,104,'true','true','true','true','0-0;'),
(531,'Paradia Hood','head','true','none',320,'cloth','c',0,-1,58,0,0,536000,214,'true','true','true','true','0-0;'),
(532,'Inferno Hood','head','true','none',320,'cloth','b',0,-1,62,0,0,778000,104,'true','true','true','true','0-0;'),
(533,'Hood of Solar Eclipse','head','true','none',320,'cloth','c',0,-1,58,0,0,536000,214,'true','true','true','true','0-0;'),
(534,'Hood of Black Ore','head','true','none',320,'cloth','b',0,-1,62,0,0,778000,104,'true','true','true','true','0-0;'),
(535,'Hood of Summoning','head','true','none',320,'cloth','c',0,-1,58,0,0,536000,214,'true','true','true','true','0-0;'),
(536,'Otherworldly Hood','head','true','none',320,'cloth','b',0,-1,62,0,0,778000,104,'true','true','true','true','0-0;'),
(537,'Elemental Hood','head','true','none',320,'cloth','c',0,-1,58,0,0,536000,214,'true','true','true','true','0-0;'),
(538,'Hood of Phantom','head','true','none',320,'cloth','b',0,-1,62,0,0,778000,104,'true','true','true','true','0-0;'),
(539,'Hood of Grace','head','true','none',320,'cloth','c',0,-1,58,0,0,536000,214,'true','true','true','true','0-0;'),
(540,'Hood of Holy Spirit','head','true','none',320,'cloth','b',0,-1,62,0,0,778000,104,'true','true','true','true','0-0;'),
(541,'Phoenix Hood','head','true','none',590,'cloth','c',0,-1,58,0,0,536000,214,'true','true','true','true','0-0;'),
(542,'Cerberus Hood','head','true','none',320,'cloth','b',0,-1,62,0,0,778000,104,'true','true','true','true','0-0;'),
(543,'Hood of Aid','head','true','none',320,'cloth','c',0,-1,58,0,0,536000,214,'true','true','true','true','0-0;'),
(544,'Hood of Blessing','head','true','none',320,'cloth','b',0,-1,62,0,0,778000,104,'true','true','true','true','0-0;'),
(545,'Flame Helm','head','true','none',400,'cloth','c',0,-1,58,0,0,536000,214,'true','true','true','true','0-0;'),
(546,'Helm of Bravery','head','true','none',400,'cloth','b',0,-1,62,0,0,778000,104,'true','true','true','true','0-0;'),
(547,'Tallum Helm','head','true','none',570,'cloth','a',0,-1,69,0,0,1740000,107,'true','true','true','true','0-0;'),
(548,'Absolute Helm','head','true','none',400,'cloth','b',0,-1,62,0,0,778000,104,'true','true','true','true','0-0;'),
(549,'Helm of Avadon','head','true','none',400,'cloth','c',0,-1,58,0,0,536000,214,'true','true','true','true','0-0;'),
(550,'Helm of Doom','head','true','none',400,'cloth','b',0,-1,62,0,0,778000,124,'true','true','true','true','0-0;'),
(551,'Helmet of Pledge','head','true','none',400,'chrysolite','c',0,-1,58,0,0,536000,214,'true','true','true','true','0-0;'),
(552,'Divine Helm','head','true','none',400,'cloth','b',0,-1,62,0,0,778000,104,'true','true','true','true','0-0;'),
(553,'Iron Boots','feet','true','none',1280,'fine_steel','d',0,-1,24,0,0,39100,71,'true','true','true','true','0-0;'),
(554,'Zubei\'s Boots','feet','true','none',1180,'mithril','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(555,'Dragon Boots','feet','true','none',1110,'leather','a',0,-1,48,0,0,1760000,141,'false','false','true','false','0-0;'),
(556,'Wolf Boots','feet','true','none',1180,'oriharukon','b',0,-1,41,0,0,519000,83,'true','true','true','true','0-0;'),
(557,'Shining Dragon Boots','feet','true','none',1150,'mithril','b',0,-1,44,0,0,804000,107,'true','true','true','true','0-0;'),
(558,'Boots of Victory','feet','true','none',1180,'oriharukon','b',0,-1,41,0,0,519000,69,'true','true','true','true','0-0;'),
(559,'Boots of Valor','feet','true','none',1150,'blood_steel','b',0,-1,44,0,0,804000,107,'true','true','true','true','0-0;'),
(560,'Glorious Boots','feet','true','none',1180,'fine_steel','b',0,-1,41,0,0,519000,69,'true','true','true','true','0-0;'),
(561,'Red Flame Boots','feet','true','none',1120,'blood_steel','a',0,-1,45,0,0,1160000,93,'true','true','true','true','0-0;'),
(562,'Elven Crystal Boots','feet','true','none',1180,'crystal','b',0,-1,41,0,0,519000,69,'true','true','true','true','0-0;'),
(563,'Dark Crystal Boots','feet','true','none',1110,'crystal','a',0,-1,45,0,0,1160000,71,'true','true','true','true','0-0;'),
(564,'Implosion Boots','feet','true','none',1150,'damascus','b',0,-1,44,0,0,804000,107,'true','true','true','true','0-0;'),
(565,'Dark Dragon Boots','feet','true','none',1130,'damascus','b',0,-1,44,0,0,804000,107,'true','true','true','true','0-0;'),
(566,'Elven Vagian Boots','feet','true','none',1150,'mithril','b',0,-1,41,0,0,519000,69,'true','true','true','true','0-0;'),
(567,'Dark Vagian Boots','feet','true','none',1130,'mithril','b',0,-1,44,0,0,804000,107,'true','true','true','true','0-0;'),
(568,'Composite Boots','feet','true','none',200,'fine_steel','b',0,-1,41,0,0,519000,69,'true','true','true','true','0-0;'),
(569,'Hell Boots','feet','true','none',1130,'blood_steel','b',0,-1,44,0,0,804000,107,'true','true','true','true','0-0;'),
(570,'Art of Boots','feet','true','none',1150,'chrysolite','b',0,-1,41,0,0,519000,69,'true','true','true','true','0-0;'),
(571,'Masterpiece Boots','feet','true','none',1130,'oriharukon','b',0,-1,44,0,0,804000,107,'true','true','true','true','0-0;'),
(572,'Boots of Silence','feet','true','none',1190,'damascus','b',0,-1,41,0,0,519000,69,'true','true','true','true','0-0;'),
(573,'Gust Boots','feet','true','none',1120,'blood_steel','a',0,-1,45,0,0,1160000,93,'true','true','true','true','0-0;'),
(574,'Prairie Boots','feet','true','none',1140,'leather','b',0,-1,41,0,0,519000,69,'true','true','true','true','0-0;'),
(575,'Boots of The Underworld','feet','true','none',1110,'leather','a',0,-1,45,0,0,1160000,93,'true','true','true','true','0-0;'),
(576,'Boots of Concentration','feet','true','none',1170,'oriharukon','b',0,-1,41,0,0,519000,69,'true','true','true','true','0-0;'),
(577,'Ace\'s Boots','feet','true','none',1150,'oriharukon','b',0,-1,44,0,0,804000,107,'true','true','true','true','0-0;'),
(578,'Guardian\'s Boots','feet','true','none',1180,'mithril','b',0,-1,41,0,0,519000,69,'true','true','true','true','0-0;'),
(579,'Marksman Boots','feet','true','none',1150,'leather','b',0,-1,44,0,0,804000,107,'true','true','true','true','0-0;'),
(580,'Boots of Mana','feet','true','none',1180,'leather','b',0,-1,41,0,0,519000,69,'true','true','true','true','0-0;'),
(581,'Sage\'s Boots','feet','true','none',1150,'leather','b',0,-1,44,0,0,804000,107,'true','true','true','true','0-0;'),
(582,'Paradia Boots','feet','true','none',1140,'chrysolite','b',0,-1,44,0,0,804000,107,'true','true','true','true','0-0;'),
(583,'Majestic Boots','feet','true','none',1110,'blood_steel','a',0,-1,48,0,0,1760000,108,'true','true','true','true','0-0;'),
(584,'Boots of Solar Eclipse','feet','true','none',1180,'blood_steel','b',0,-1,41,0,0,519000,69,'true','true','true','true','0-0;'),
(585,'Boots of Black Ore','feet','true','none',1200,'damascus','b',0,-1,44,0,0,804000,107,'true','true','true','true','0-0;'),
(586,'Boots of Summoning','feet','true','none',1170,'leather','b',0,-1,41,0,0,519000,69,'true','true','true','true','0-0;'),
(587,'Otherworldly Boots','feet','true','none',1200,'adamantaite','b',0,-1,44,0,0,804000,107,'true','true','true','true','0-0;'),
(588,'Elemental Boots','feet','true','none',1130,'mithril','b',0,-1,44,0,0,804000,107,'true','true','true','true','0-0;'),
(589,'Boots of Phantom','feet','true','none',1120,'oriharukon','a',0,-1,48,0,0,1760000,141,'true','true','true','true','0-0;'),
(590,'Boots of Grace','feet','true','none',1130,'mithril','b',0,-1,44,0,0,804000,107,'true','true','true','true','0-0;'),
(591,'Boots of Holy Spirit','feet','true','none',1200,'chrysolite','b',0,-1,44,0,0,804000,107,'true','true','true','true','0-0;'),
(592,'Phoenix Boots','feet','true','none',1120,'blood_steel','a',0,-1,45,0,0,1160000,93,'true','true','true','true','0-0;'),
(593,'Cerberus Boots','feet','true','none',1120,'damascus','a',0,-1,48,0,0,1760000,141,'true','true','true','true','0-0;'),
(594,'Boots of Aid','feet','true','none',1200,'leather','b',0,-1,41,0,0,519000,69,'true','true','true','true','0-0;'),
(595,'Boots of Blessing','feet','true','none',1160,'adamantaite','b',0,-1,41,0,0,519000,69,'true','true','true','true','0-0;'),
(596,'Flame Boots','feet','true','none',1020,'blood_steel','b',0,-1,45,0,0,1160000,155,'true','true','true','true','0-0;'),
(597,'Boots of Bravery','feet','true','none',1050,'chrysolite','b',0,-1,45,0,0,1160000,155,'true','true','true','true','0-0;'),
(598,'Blood Boots','feet','true','none',1130,'blood_steel','a',0,-1,45,0,0,1160000,93,'true','true','true','true','0-0;'),
(599,'Absolute Boots','feet','true','none',1130,'mithril','b',0,-1,45,0,0,1160000,155,'true','true','true','true','0-0;'),
(600,'Avadon Boots','feet','true','none',1170,'damascus','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(601,'Boots of Doom','feet','true','none',1130,'mithril','b',0,-1,83,0,0,804000,107,'true','true','true','true','0-0;'),
(602,'Boots of Pledge','feet','true','none',1130,'chrysolite','b',0,-1,45,0,0,1160000,155,'true','true','true','true','0-0;'),
(603,'Divine Boots','feet','true','none',1200,'adamantaite','c',0,-1,39,0,0,358000,143,'true','true','true','true','0-0;'),
(604,'Crafted Leather Gloves','gloves','true','none',650,'leather','d',0,-1,19,0,0,16100,30,'true','true','true','true','0-0;'),
(605,'Leather Gauntlets','gloves','true','none',640,'leather','d',0,-1,22,0,0,25600,47,'true','true','true','true','0-0;'),
(606,'Rip Gauntlets','gloves','true','none',630,'leather','d',0,-1,27,0,0,57400,106,'true','true','true','true','0-0;'),
(607,'Ogre Power Gauntlets','gloves','true','none',620,'fine_steel','d',0,-1,29,0,0,75200,139,'true','true','true','true','0-0;'),
(608,'Mithril Gauntlets','gloves','true','none',600,'mithril','c',0,-1,36,0,0,188800,76,'true','true','true','true','0-0;'),
(609,'Gauntlets of Ghost','gloves','true','none',1920,'blood_steel','c',0,-1,39,0,0,358000,143,'true','true','true','true','0-0;'),
(610,'Saint Knight\'s Gauntlets','gloves','true','none',6400,'oriharukon','b',0,-1,41,0,0,519000,69,'true','true','true','true','0-0;'),
(611,'Soul Leech Gauntlets','gloves','true','none',4800,'blood_steel','b',0,-1,44,0,0,804000,107,'true','true','true','true','0-0;'),
(612,'Zubei\'s Gauntlets','gloves','true','none',590,'mithril','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(613,'Sand Dragon Gloves','gloves','true','none',3200,'damascus','a',0,-1,48,0,0,1760000,141,'true','true','true','true','0-0;'),
(614,'Knight\'s Cloak','underwear','true','none',240,'cloth','d',0,-1,7,0,0,20900,38,'true','true','true','true','0-0;'),
(615,'Cobweb Cloak','underwear','true','none',240,'cobweb','d',0,-1,8,0,0,33300,61,'true','true','true','true','0-0;'),
(616,'Cloak of Magic','underwear','true','none',240,'cloth','d',0,-1,11,0,0,74700,136,'true','true','true','true','0-0;'),
(617,'Mithril Cloak','underwear','true','none',240,'mithril','d',0,-1,11,0,0,97800,178,'true','true','true','true','0-0;'),
(618,'Cloak of Self Protection','underwear','true','none',240,'cloth','c',0,-1,13,0,0,161000,64,'true','true','true','true','0-0;'),
(619,'Ancient Cloak','underwear','true','none',230,'cloth','c',0,-1,15,0,0,245000,98,'true','true','true','true','0-0;'),
(620,'Cloak of Protection','underwear','true','none',230,'cloth','c',0,-1,16,0,0,358000,143,'true','true','true','true','0-0;'),
(621,'Cloak of Hell','underwear','true','none',220,'cloth','b',0,-1,18,0,0,804000,107,'true','true','true','true','0-0;'),
(622,'Holy Spirit\'s Cloak','underwear','true','none',220,'cloth','a',0,-1,18,0,0,1160000,93,'true','true','true','true','0-0;'),
(623,'Divine Cloak','underwear','true','none',220,'cloth','a',0,-1,19,0,0,1760000,141,'true','true','true','true','0-0;'),
(624,'Cloak of Invisibility','underwear','false','none',260,'cloth','none',0,-1,2,0,0,37,0,'true','false','true','true','0-0;'),
(675,'Silk Yarn Undergarment Set','underwear','false','none',170,'cloth','none',0,-1,6,0,0,1330,0,'true','true','true','true','0-0;'),
(676,'Pure White Undergarment Set','underwear','false','none',160,'cloth','none',0,-1,9,0,0,6150,0,'true','true','true','true','0-0;'),
(677,'One-Piece Swimsuit','underwear','true','none',150,'cloth','d',0,-1,10,0,0,10400,19,'true','true','true','true','0-0;'),
(678,'Bikini Set','underwear','true','none',150,'cloth','d',0,-1,11,0,0,16700,30,'true','true','true','true','0-0;'),
(679,'Cursed Undergarment Set','underwear','true','none',150,'cloth','d',0,-1,12,0,0,25400,46,'true','true','true','true','0-0;'),
(680,'Mithril Undergarment Set','underwear','true','none',140,'mithril','c',0,-1,16,0,0,63100,25,'true','true','true','true','0-0;'),
(681,'Fascination Undergarment Set','underwear','true','none',140,'cloth','c',0,-1,17,0,0,80500,32,'true','true','true','true','0-0;'),
(682,'Demon\'s Undergarment Set','underwear','true','none',140,'cloth','c',0,-1,19,0,0,179000,72,'true','true','true','true','0-0;'),
(683,'Holy Undergarment Set','underwear','true','none',140,'cloth','b',0,-1,22,0,0,402000,54,'true','true','true','true','0-0;'),
(684,'Underwear of Rule','underwear','true','none',140,'cloth','a',0,-1,24,0,0,880000,70,'true','true','true','true','0-0;'),
(685,'Crystal Swimsuit Set','underwear','true','none',130,'crystal','s',0,-1,26,0,0,1310000,66,'true','true','true','true','0-0;'),
(845,'Cat\'s Eye Earring','rear,lear','false','none',150,'silver','none',0,-1,0,19,0,6840,0,'true','true','true','true','0-0;'),
(846,'Coral Earring','rear,lear','false','none',150,'silver','none',0,-1,0,21,0,12300,0,'true','true','true','true','0-0;'),
(847,'Red Crescent Earring','rear,lear','true','none',150,'silver','d',0,-1,0,24,0,20700,38,'true','true','true','true','0-0;'),
(848,'Enchanted Earring','rear,lear','true','none',150,'silver','d',0,-1,0,27,0,32800,61,'true','true','true','true','0-0;'),
(849,'Tiger\'s Eye Earring','rear,lear','true','none',150,'silver','d',0,-1,0,30,0,49400,91,'true','true','true','true','0-0;'),
(850,'Elven Earring','rear,lear','true','none',150,'silver','d',0,-1,0,34,0,71900,133,'true','true','true','true','0-0;'),
(851,'Omen Beast\'s Eye Earring','rear,lear','true','none',150,'silver','d',0,-1,0,36,0,93300,172,'true','true','true','true','0-0;'),
(852,'Moonstone Earring','rear,lear','true','none',150,'silver','c',0,-1,0,39,0,119299,48,'true','true','true','true','0-0;'),
(853,'Earring of Protection','rear,lear','true','none',150,'silver','c',0,-1,0,42,0,150500,60,'true','true','true','true','0-0;'),
(854,'Earring of Binding','rear,lear','true','none',150,'silver','c',0,-1,0,45,0,226599,91,'true','true','true','true','0-0;'),
(855,'Nassen\'s Earring','rear,lear','true','none',150,'silver','c',0,-1,0,48,0,325800,130,'true','true','true','true','0-0;'),
(856,'Adamantite Earring','rear,lear','true','none',150,'silver','b',0,-1,0,51,0,606000,62,'true','true','true','true','0-0;'),
(857,'Blessed Earring','rear,lear','true','none',150,'silver','c',0,-1,0,48,0,424000,170,'true','true','true','true','0-0;'),
(858,'Tateossian Earring','rear,lear','true','none',150,'silver','s',0,-1,0,71,31,4440000,157,'true','true','true','true','0-0;'),
(859,'Earring of Mana','rear,lear','true','none',150,'silver','b',0,-1,0,51,0,606000,81,'true','true','true','true','0-0;'),
(860,'Sage\'s Earring','rear,lear','true','none',150,'silver','b',0,-1,0,54,0,924000,123,'true','true','true','true','0-0;'),
(861,'Paradia Earring','rear,lear','true','none',150,'silver','b',0,-1,0,54,0,924000,123,'true','true','true','true','0-0;'),
(862,'Majestic Earring','rear,lear','true','none',150,'silver','a',0,-1,0,63,25,2590000,120,'true','true','true','true','0-0;'),
(863,'Earring of Solar Eclipse','rear,lear','true','none',150,'silver','b',0,-1,0,51,0,606000,81,'true','true','true','true','0-0;'),
(864,'Earring of Black Ore','rear,lear','true','none',150,'silver','b',0,-1,0,54,0,924000,95,'true','true','true','true','0-0;'),
(865,'Earring of Summoning','rear,lear','true','none',150,'silver','b',0,-1,0,51,0,606000,81,'true','true','true','true','0-0;'),
(866,'Otherworldly Earring','rear,lear','true','none',150,'silver','b',0,-1,0,54,0,924000,123,'true','true','true','true','0-0;'),
(867,'Elemental Earring','rear,lear','true','none',150,'silver','b',0,-1,0,54,0,924000,123,'true','true','true','true','0-0;'),
(868,'Earring of Phantom','rear,lear','true','none',150,'silver','a',0,-1,0,60,0,1950000,156,'true','true','true','true','0-0;'),
(869,'Earring of Grace','rear,lear','true','none',150,'silver','b',0,-1,0,51,0,606000,81,'true','true','true','true','0-0;'),
(870,'Earring of Holy Spirit','rear,lear','true','none',150,'silver','b',0,-1,0,54,0,924000,123,'true','true','true','true','0-0;'),
(871,'Phoenix Earring','rear,lear','true','none',150,'silver','a',0,-1,0,60,20,1950000,80,'true','true','true','true','0-0;'),
(872,'Cerberus Earring','rear,lear','true','none',150,'silver','a',0,-1,0,60,0,1950000,156,'true','true','true','true','0-0;'),
(873,'Earring of Aid','rear,lear','true','none',150,'silver','b',0,-1,0,51,0,606000,81,'true','true','true','true','0-0;'),
(874,'Earring of Blessing','rear,lear','true','none',150,'silver','b',0,-1,0,51,0,606000,81,'true','true','true','true','0-0;'),
(875,'Ring of Knowledge','rfinger,lfinger','false','none',150,'gold','none',0,-1,0,9,0,540,0,'true','true','true','true','0-0;'),
(876,'Ring of Anguish','rfinger,lfinger','false','none',150,'gold','none',0,-1,0,11,0,2340,0,'true','true','true','true','0-0;'),
(877,'Ring of Wisdom','rfinger,lfinger','false','none',150,'gold','none',0,-1,0,12,0,4560,0,'true','true','true','true','0-0;'),
(878,'Blue Coral Ring','rfinger,lfinger','false','none',150,'gold','none',0,-1,0,14,0,8200,0,'true','true','true','true','0-0;'),
(879,'Enchanted Ring','rfinger,lfinger','true','none',150,'gold','d',0,-1,0,18,0,21800,40,'true','true','true','true','0-0;'),
(880,'Black Pearl Ring','rfinger,lfinger','true','none',150,'gold','d',0,-1,0,20,0,33000,61,'true','true','true','true','0-0;'),
(881,'Elven Ring','rfinger,lfinger','true','none',150,'gold','d',0,-1,0,22,0,47900,88,'true','true','true','true','0-0;'),
(882,'Mithril Ring','rfinger,lfinger','true','none',150,'gold','d',0,-1,0,24,0,62200,115,'true','true','true','true','0-0;'),
(883,'Aquastone Ring','rfinger,lfinger','true','none',150,'gold','c',0,-1,0,26,0,79500,32,'true','true','true','true','0-0;'),
(884,'Ring of Protection','rfinger,lfinger','true','none',150,'gold','c',0,-1,0,28,0,100299,40,'true','true','true','true','0-0;'),
(885,'Ring of Ages','rfinger,lfinger','true','none',150,'gold','c',0,-1,0,30,0,151100,60,'true','true','true','true','0-0;'),
(886,'Ring of Binding','rfinger,lfinger','true','none',150,'gold','c',0,-1,0,32,0,217199,87,'true','true','true','true','0-0;'),
(887,'Adamantite Ring','rfinger,lfinger','true','none',150,'gold','b',0,-1,0,34,0,404000,41,'true','true','true','true','0-0;'),
(888,'Blessed Ring','rfinger,lfinger','true','none',150,'gold','c',0,-1,0,32,0,282000,113,'true','true','true','true','0-0;'),
(889,'Tateossian Ring','rfinger,lfinger','true','none',150,'gold','s',0,-1,0,48,21,2960000,105,'true','true','true','true','0-0;'),
(890,'Ring of Devotion','rfinger,lfinger','true','none',150,'gold','d',0,-1,0,16,0,13800,25,'true','true','true','true','0-0;'),
(891,'Sage\'s Ring','rfinger,lfinger','true','none',150,'gold','b',0,-1,0,36,0,616000,82,'true','true','true','true','0-0;'),
(892,'Paradia Ring','rfinger,lfinger','true','none',150,'gold','b',0,-1,0,36,0,616000,82,'true','true','true','true','0-0;'),
(893,'Majestic Ring','rfinger,lfinger','true','none',150,'gold','a',0,-1,0,42,17,1730000,80,'true','true','true','true','0-0;'),
(894,'Ring of Solar Eclipse','rfinger,lfinger','true','none',150,'gold','b',0,-1,0,34,0,404000,54,'true','true','true','true','0-0;'),
(895,'Ring of Black Ore','rfinger,lfinger','true','none',150,'gold','b',0,-1,0,36,0,616000,63,'true','true','true','true','0-0;'),
(896,'Ring of Summoning','rfinger,lfinger','true','none',150,'gold','b',0,-1,0,34,0,404000,54,'true','true','true','true','0-0;'),
(897,'Otherworldly Ring','rfinger,lfinger','true','none',150,'gold','b',0,-1,0,36,0,616000,82,'true','true','true','true','0-0;'),
(898,'Elemental Ring','rfinger,lfinger','true','none',150,'gold','b',0,-1,0,36,0,616000,82,'true','true','true','true','0-0;'),
(899,'Ring of Phantom','rfinger,lfinger','true','none',150,'gold','a',0,-1,0,40,0,1300000,104,'true','true','true','true','0-0;'),
(900,'Ring of Grace','rfinger,lfinger','true','none',150,'gold','b',0,-1,0,34,0,404000,54,'true','true','true','true','0-0;'),
(901,'Ring of Holy Spirit','rfinger,lfinger','true','none',150,'gold','b',0,-1,0,36,0,616000,82,'true','true','true','true','0-0;'),
(902,'Phoenix Ring','rfinger,lfinger','true','none',150,'gold','a',0,-1,0,40,13,1300000,54,'true','true','true','true','0-0;'),
(903,'Cerberus Ring','rfinger,lfinger','true','none',150,'gold','a',0,-1,0,40,0,1300000,104,'true','true','true','true','0-0;'),
(904,'Ring of Aid','rfinger,lfinger','true','none',150,'gold','b',0,-1,0,34,0,404000,54,'true','true','true','true','0-0;'),
(905,'Ring of Blessing','rfinger,lfinger','true','none',150,'gold','b',0,-1,0,34,0,404000,54,'true','true','true','true','0-0;'),
(906,'Necklace of Knowledge','neck','false','none',150,'silver','none',0,-1,0,18,0,1080,0,'true','true','true','true','0-0;'),
(907,'Necklace of Anguish','neck','false','none',150,'silver','none',0,-1,0,21,0,4680,0,'true','true','true','true','0-0;'),
(908,'Necklace of Wisdom','neck','false','none',150,'silver','none',0,-1,0,25,0,9120,0,'true','true','true','true','0-0;'),
(909,'Blue Diamond Necklace','neck','false','none',150,'silver','none',0,-1,0,28,0,16400,0,'true','true','true','true','0-0;'),
(910,'Necklace of Devotion','neck','true','none',150,'silver','d',0,-1,0,32,0,27600,51,'true','true','true','true','0-0;'),
(911,'Enchanted Necklace','neck','true','none',150,'silver','d',0,-1,0,36,0,43700,81,'true','true','true','true','0-0;'),
(912,'Near Forest Necklace','neck','true','none',150,'silver','d',0,-1,0,40,0,65900,122,'true','true','true','true','0-0;'),
(913,'Elven Necklace','neck','true','none',150,'silver','d',0,-1,0,45,0,95800,177,'true','true','true','true','0-0;'),
(914,'Necklace of Darkness','neck','true','none',150,'silver','d',0,-1,0,48,0,124400,230,'true','true','true','true','0-0;'),
(915,'Aquastone Necklace','neck','true','none',150,'silver','c',0,-1,0,52,0,159000,64,'true','true','true','true','0-0;'),
(916,'Necklace of Protection','neck','true','none',150,'silver','c',0,-1,0,56,0,200599,80,'true','true','true','true','0-0;'),
(917,'Necklace of Mermaid','neck','true','none',150,'silver','c',0,-1,0,60,0,302100,121,'true','true','true','true','0-0;'),
(918,'Adamantite Necklace','neck','true','none',150,'silver','b',0,-1,0,68,0,808000,83,'true','true','true','true','0-0;'),
(919,'Blessed Necklace','neck','true','none',150,'silver','c',0,-1,0,64,0,565000,226,'true','true','true','true','0-0;'),
(920,'Tateossian Necklace','neck','true','none',150,'silver','s',0,-1,0,95,42,5920000,209,'true','true','true','true','0-0;'),
(921,'Necklace of Mana','neck','true','none',150,'silver','b',0,-1,0,68,0,808000,108,'true','true','true','true','0-0;'),
(922,'Sage\'s Necklace','neck','true','none',150,'silver','b',0,-1,0,72,0,1230000,164,'true','true','true','true','0-0;'),
(923,'Paradia Necklace','neck','true','none',150,'silver','b',0,-1,0,72,0,1230000,164,'true','true','true','true','0-0;'),
(924,'Majestic Necklace','neck','true','none',150,'silver','a',0,-1,0,85,33,3450000,160,'true','true','true','true','0-0;'),
(925,'Necklace of Solar Eclipse','neck','true','none',150,'silver','b',0,-1,0,68,0,808000,108,'true','true','true','true','0-0;'),
(926,'Necklace of Black Ore','neck','true','none',150,'silver','b',0,-1,0,72,0,1230000,126,'true','true','true','true','0-0;'),
(927,'Necklace of Summoning','neck','true','none',150,'silver','b',0,-1,0,68,0,808000,108,'true','true','true','true','0-0;'),
(928,'Otherworldly Necklace','neck','true','none',150,'silver','b',0,-1,0,72,0,1230000,164,'true','true','true','true','0-0;'),
(929,'Elemental Necklace','neck','true','none',150,'silver','b',0,-1,0,72,0,1230000,164,'true','true','true','true','0-0;'),
(930,'Necklace of Phantom','neck','true','none',150,'silver','a',0,-1,0,80,0,2600000,208,'true','true','true','true','0-0;'),
(931,'Necklace of Grace','neck','true','none',150,'silver','b',0,-1,0,68,0,808000,108,'true','true','true','true','0-0;'),
(932,'Necklace of Holy Spirit','neck','true','none',150,'silver','b',0,-1,0,72,0,1230000,164,'true','true','true','true','0-0;'),
(933,'Phoenix Necklace','neck','true','none',150,'silver','a',0,-1,0,80,26,2600000,107,'true','true','true','true','0-0;'),
(934,'Cerberus Necklace','neck','true','none',150,'silver','a',0,-1,0,80,0,2600000,208,'true','true','true','true','0-0;'),
(935,'Necklace of Aid','neck','true','none',150,'silver','b',0,-1,0,68,0,808000,108,'true','true','true','true','0-0;'),
(936,'Necklace of Blessing','neck','true','none',150,'silver','b',0,-1,0,68,0,808000,108,'true','true','true','true','0-0;'),
(990,'Mandragora Essence','gloves','false','none',60,'cloth','none',0,-1,9,0,0,37,0,'true','true','true','true','0-0;'),
(991,'Royen\'s Key','gloves','false','none',60,'cloth','none',0,-1,9,0,0,37,0,'true','true','true','true','0-0;'),
(992,'Shilen\'s 1st Mark','gloves','false','none',60,'cloth','none',0,-1,9,0,0,37,0,'true','true','true','true','0-0;'),
(993,'Shilen\'s 2nd Mark','gloves','false','none',60,'cloth','none',0,-1,9,0,0,37,0,'true','true','true','true','0-0;'),
(994,'Eye of Abyss','gloves','false','none',60,'cloth','none',0,-1,9,0,0,37,0,'true','true','true','true','0-0;'),
(995,'Wanted Poster','gloves','false','none',60,'cloth','none',0,-1,9,0,0,37,0,'true','true','true','true','0-0;'),
(996,'Alex\'s Dagger','gloves','false','none',60,'cloth','none',0,-1,9,0,0,37,0,'true','true','true','true','0-0;'),
(997,'Pinter\'s Bill','gloves','false','none',60,'cloth','none',0,-1,9,0,0,37,0,'true','true','true','true','0-0;'),
(998,'Book of Aklantoth - Part 1','gloves','false','none',60,'cloth','none',0,-1,9,0,0,37,0,'true','true','true','true','0-0;'),
(999,'Book of Aklantoth - Part 2','gloves','false','none',60,'cloth','none',0,-1,9,0,0,37,0,'true','true','true','true','0-0;'),
(1000,'Book of Aklantoth - Part 3','gloves','false','none',60,'cloth','none',0,-1,9,0,0,37,0,'true','true','true','true','0-0;'),
(1100,'Cotton Tunic','chest','false','magic',2120,'cloth','none',0,-1,21,0,38,2430,0,'true','true','true','true','0-0;'),
(1101,'Tunic of Devotion','chest','false','magic',2090,'cloth','none',0,-1,30,0,67,15600,0,'true','true','true','true','0-0;'),
(1102,'Tunic of Magic','chest','false','magic',2080,'cloth','none',0,-1,34,0,86,28400,0,'true','true','true','true','0-0;'),
(1103,'Cotton Stockings','legs','false','magic',1060,'cloth','none',0,-1,13,0,23,1520,0,'true','true','true','true','0-0;'),
(1104,'Stockings of Devotion','legs','false','magic',1040,'cloth','none',0,-1,19,0,42,9770,0,'true','true','true','true','0-0;'),
(1105,'Stockings of Magic','legs','false','magic',1030,'cloth','none',0,-1,21,0,54,17700,0,'true','true','true','true','0-0;'),
(1119,'Short Leather Gloves','gloves','false','none',660,'leather','none',0,-1,11,0,0,607,0,'true','true','true','true','0-0;'),
(1120,'Pa\'agrian Hand','gloves','true','none',1600,'leather','c',0,-1,34,0,0,161000,64,'true','true','true','true','0-0;'),
(1121,'Apprentice\'s Shoes','feet','false','none',1320,'leather','none',0,-1,8,0,0,7,0,'true','true','true','true','0-0;'),
(1122,'Cotton Shoes','feet','false','none',1320,'leather','none',0,-1,11,0,0,607,0,'true','true','true','true','0-0;'),
(1123,'Blue Buckskin Boots','feet','true','none',1300,'leather','d',0,-1,22,0,0,25600,47,'true','true','true','true','0-0;'),
(1124,'Boots of Power','feet','true','none',1250,'leather','d',0,-1,27,0,0,57400,106,'true','true','true','true','0-0;'),
(1125,'Assault Boots','feet','true','none',1240,'leather','d',0,-1,29,0,0,75200,139,'true','true','true','true','0-0;'),
(1126,'Crimson Boots','feet','true','none',1210,'leather','c',0,-1,34,0,0,123900,50,'true','true','true','true','0-0;'),
(1127,'Forgotten Boots','feet','true','none',4000,'leather','c',0,-1,36,0,0,245000,98,'true','true','true','true','0-0;'),
(1128,'Adamantite Boots','feet','true','none',4000,'adamantaite','c',0,-1,39,0,0,358000,143,'true','true','true','true','0-0;'),
(1129,'Crude Leather Shoes','feet','false','none',1320,'leather','none',0,-1,11,0,0,607,0,'true','true','true','true','0-0;'),
(1146,'Squire\'s Shirt','chest','false','light',3301,'cloth','none',0,-1,33,0,0,26,0,'false','false','true','false','0-0;'),
(1147,'Squire\'s Pants','legs','false','light',1750,'cloth','none',0,-1,20,0,0,6,0,'false','false','true','false','0-0;'),
(1148,'Hard Leather Helmet','head','false','none',640,'leather','none',0,-1,26,0,0,14200,0,'true','true','true','true','0-0;'),
(1149,'Shining Circlet','head','true','none',600,'steel','c',0,-1,54,0,0,283200,113,'true','true','true','true','0-0;'),
(1308,'Compound Scale Mail','chest','false','heavy',1400,'fine_steel','none',0,-1,51,0,0,247000,0,'false','true','true','false','0-0;'),
(1309,'Mithril Breastplate','chest','false','heavy',1000,'mithril','none',0,-1,51,0,0,247000,0,'false','true','true','false','0-0;'),
(1310,'Tunic of Magic','chest','false','magic',150,'cloth','none',0,-1,51,0,96,48500,0,'false','true','true','false','0-0;'),
(1311,'Puma Skin Shirt','chest','false','light',300,'leather','none',0,-1,51,0,0,99900,0,'false','true','true','false','0-0;'),
(1312,'White Tunic','chest','false','magic',150,'cloth','none',0,-1,51,0,142,138000,0,'false','true','true','false','0-0;'),
(1313,'Compound Scale Gaiters','legs','false','heavy',1000,'fine_steel','none',0,-1,32,0,0,170000,0,'false','true','true','false','0-0;'),
(1314,'Mithril Gaiters','legs','false','heavy',600,'mithril','none',0,-1,32,0,0,170000,0,'false','true','true','false','0-0;'),
(1315,'Stockings of Magic','legs','false','magic',150,'cloth','none',0,-1,32,0,60,30300,0,'false','true','true','false','0-0;'),
(1316,'Puma Skin Gaiters','legs','false','light',400,'leather','none',0,-1,32,0,0,55800,0,'false','true','true','false','0-0;'),
(1317,'Dark Stockings','legs','false','magic',150,'cloth','none',0,-1,32,0,79,62500,0,'false','true','true','false','0-0;'),
(1318,'Gloves','gloves','false','none',80,'cloth','none',0,-1,14,0,0,3270,0,'false','true','true','false','0-0;'),
(1319,'Leather Gloves','gloves','false','none',100,'leather','none',0,-1,14,0,0,7950,0,'false','true','true','false','0-0;'),
(1320,'Crafted Leather Gloves','gloves','false','none',100,'leather','none',0,-1,14,0,0,29800,0,'false','true','true','false','0-0;'),
(1321,'Rip Gauntlets','gloves','false','none',150,'leather','none',0,-1,14,0,0,97800,0,'false','true','true','false','0-0;'),
(1322,'Bracer','gloves','false','none',80,'leather','none',0,-1,14,0,0,16200,0,'false','true','true','false','0-0;'),
(1323,'Leather Shoes','feet','false','none',120,'leather','none',0,-1,14,0,0,3270,0,'false','true','true','false','0-0;'),
(1324,'Low Boots','feet','false','none',150,'leather','none',0,-1,14,0,0,7950,0,'false','true','true','false','0-0;'),
(1325,'Leather Boots','feet','false','none',250,'leather','none',0,-1,14,0,0,29800,0,'false','true','true','false','0-0;'),
(1326,'Iron Boots','feet','false','none',300,'fine_steel','none',0,-1,14,0,0,74700,0,'false','true','true','false','0-0;'),
(1327,'Boots','feet','false','none',200,'cloth','none',0,-1,14,0,0,16200,0,'false','true','true','false','0-0;'),
(1506,'Necklace of Courage','neck','false','none',150,'silver','none',0,-1,0,15,0,66,0,'true','true','true','true','0-0;'),
(1507,'Necklace of Valor','neck','false','none',150,'silver','none',0,-1,0,21,0,4680,0,'true','true','true','true','0-0;'),
(1508,'Ring of Raccoon','rfinger,lfinger','false','none',150,'gold','none',0,-1,0,11,0,2340,0,'true','true','true','true','0-0;'),
(1509,'Ring of Firefly','rfinger,lfinger','false','none',150,'gold','none',0,-1,0,11,0,2340,0,'true','true','true','true','0-0;'),
(2376,'Avadon Breastplate','chest','true','heavy',7920,'leather','b',0,-1,157,0,0,2080000,213,'true','true','true','true','0-0;'),
(2377,'Mithril Scale Gaiters','legs','true','heavy',3870,'leather','d',0,-1,64,0,0,143600,265,'true','true','true','true','0-0;'),
(2378,'Brigandine Gaiters','legs','true','heavy',3820,'leather','d',0,-1,64,0,0,143600,265,'true','true','true','true','0-0;'),
(2379,'Avadon Gaiters','legs','true','heavy',3520,'leather','b',0,-1,98,0,0,1300000,133,'true','true','true','true','0-0;'),
(2380,'Blue Wolf Gaiters','legs','true','heavy',3370,'leather','b',0,-1,104,0,0,2010000,206,'true','true','true','true','0-0;'),
(2381,'Doom Plate Armor','fullarmor','true','heavy',9980,'leather','b',0,-1,270,0,0,4710000,536,'true','true','true','true','0-0;'),
(2382,'Tallum Plate Armor','fullarmor','true','heavy',9780,'leather','a',0,-1,278,0,0,6770000,463,'true','true','true','true','0-0;'),
(2383,'Majestic Plate Armor','fullarmor','true','heavy',9200,'leather','a',0,-1,293,0,0,10300000,704,'true','true','true','true','0-0;'),
(2384,'Zubei\'s Leather Shirt','chest','true','light',4330,'leather','b',0,-1,117,0,0,1560000,160,'true','true','true','true','0-0;'),
(2385,'Dark Crystal Leather Armor','chest','true','light',4300,'leather','a',0,-1,128,0,0,3470000,214,'true','true','true','true','0-0;'),
(2386,'Wooden Gaiters','legs','false','light',1670,'leather','none',0,-1,29,0,0,4970,0,'true','true','true','true','0-0;'),
(2387,'Tempered Mithril Gaiters','legs','true','light',1530,'leather','c',0,-1,56,0,0,182100,73,'true','true','true','true','0-0;'),
(2388,'Zubei\'s Leather Gaiters','legs','true','light',1480,'leather','b',0,-1,73,0,0,973000,100,'true','true','true','true','0-0;'),
(2389,'Dark Crystal Leggings','legs','true','light',1480,'leather','a',0,-1,80,0,0,2170000,134,'true','true','true','true','0-0;'),
(2390,'Avadon Leather Armor','fullarmor','true','light',5600,'leather','b',0,-1,191,0,0,2280000,259,'true','true','true','true','0-0;'),
(2391,'Blue Wolf Leather Armor','fullarmor','true','light',5500,'leather','b',0,-1,202,0,0,3530000,402,'true','true','true','true','0-0;'),
(2392,'Leather Armor of Doom','fullarmor','true','light',5500,'leather','b',0,-1,202,0,0,3530000,402,'true','true','true','true','0-0;'),
(2393,'Tallum Leather Armor','fullarmor','true','light',5400,'leather','a',0,-1,209,0,0,5080000,347,'true','true','true','true','0-0;'),
(2394,'Nightmarish Leather Armor','fullarmor','true','light',5300,'leather','a',0,-1,220,0,0,7730000,528,'true','true','true','true','0-0;'),
(2395,'Majestic Leather Armor','fullarmor','true','light',5350,'leather','a',0,-1,220,0,0,7730000,528,'true','true','true','true','0-0;'),
(2396,'Elven Mithril Tunic','chest','true','magic',720,'leather','d',0,-1,54,0,169,224000,407,'true','true','true','true','0-0;'),
(2397,'Tunic of Zubei','chest','true','magic',1960,'leather','b',0,-1,78,0,345,1560000,160,'true','true','true','true','0-0;'),
(2398,'Blue Wolf Tunic','chest','true','magic',1920,'leather','b',0,-1,83,0,377,2410000,248,'true','true','true','true','0-0;'),
(2399,'Tunic of Doom','chest','true','magic',1900,'leather','b',0,-1,83,0,377,2410000,248,'true','true','true','true','0-0;'),
(2400,'Tallum Tunic','chest','true','magic',1860,'leather','a',0,-1,86,0,409,3470000,214,'true','true','true','true','0-0;'),
(2401,'Elven Mithril Stockings','legs','true','magic',2400,'leather','d',0,-1,34,0,105,140000,255,'true','true','true','true','0-0;'),
(2402,'Stockings of Zubei','legs','true','magic',940,'leather','b',0,-1,49,0,216,973000,100,'true','true','true','true','0-0;'),
(2403,'Blue Wolf Stockings','legs','true','magic',920,'leather','b',0,-1,52,0,236,1510000,155,'true','true','true','true','0-0;'),
(2404,'Stockings of Doom','legs','true','magic',910,'leather','b',0,-1,52,0,236,1510000,155,'true','true','true','true','0-0;'),
(2405,'Tallum Stockings','legs','true','magic',920,'leather','a',0,-1,53,0,256,2170000,134,'true','true','true','true','0-0;'),
(2406,'Avadon Robe','fullarmor','true','magic',2540,'leather','b',0,-1,127,0,561,2280000,259,'true','true','true','true','0-0;'),
(2407,'Dark Crystal Robe','fullarmor','true','magic',2450,'leather','a',0,-1,139,0,665,5080000,347,'true','true','true','true','0-0;'),
(2408,'Nightmare Robe','fullarmor','true','magic',2300,'leather','a',0,-1,147,0,718,7730000,528,'true','true','true','true','0-0;'),
(2409,'Majestic Robe','fullarmor','true','magic',2330,'leather','a',0,-1,147,0,718,7730000,528,'true','true','true','true','0-0;'),
(2410,'Nightmarish Tattoo','underwear','true','none',3600,'leather','a',0,-1,139,0,0,5280000,422,'true','true','true','true','0-0;'),
(2411,'Brigandine Helmet','head','true','none',630,'leather','d',0,-1,41,0,0,86100,159,'true','true','true','true','0-0;'),
(2412,'Plate Helmet','head','true','none',630,'leather','d',0,-1,44,0,0,112800,205,'true','true','true','true','0-0;'),
(2413,'Chain Hood','head','true','none',620,'leather','c',0,-1,47,0,0,145700,58,'true','true','true','true','0-0;'),
(2414,'Full Plate Helmet','head','true','none',600,'leather','c',0,-1,58,0,0,412600,165,'true','true','true','true','0-0;'),
(2415,'Avadon Circlet','head','true','none',590,'leather','b',0,-1,62,0,0,778000,80,'true','true','true','true','0-0;'),
(2416,'Blue Wolf Helmet','head','true','none',580,'leather','b',0,-1,66,0,0,1210000,124,'true','true','true','true','0-0;'),
(2417,'Doom Helmet','head','true','none',580,'leather','b',0,-1,66,0,0,1210000,124,'true','true','true','true','0-0;'),
(2418,'Helm of Nightmare','head','true','none',560,'leather','a',0,-1,73,0,0,2640000,163,'true','true','true','true','0-0;'),
(2419,'Majestic Circlet','head','true','none',550,'leather','a',0,-1,73,0,0,2640000,163,'true','true','true','true','0-0;'),
(2420,'Dragon Headgear','head','true','none',540,'leather','s',0,-1,77,0,0,3590000,180,'true','true','true','true','0-0;'),
(2421,'The Hood','head','true','none',540,'leather','s',0,-1,77,0,0,3590000,180,'true','true','true','true','0-0;'),
(2422,'Reinforced Leather Boots','feet','true','none',1280,'leather','d',0,-1,24,0,0,39100,72,'true','true','true','true','0-0;'),
(2423,'Boots of Knowledge','feet','true','none',1270,'leather','d',0,-1,24,0,0,39100,72,'true','true','true','true','0-0;'),
(2424,'Manticore Skin Boots','feet','true','none',1260,'leather','d',0,-1,27,0,0,57400,106,'true','true','true','true','0-0;'),
(2425,'Brigandine Boots','feet','true','none',1250,'leather','d',0,-1,27,0,0,57400,106,'true','true','true','true','0-0;'),
(2426,'Elven Mithril Boots','feet','true','none',1250,'leather','d',0,-1,27,0,0,57400,106,'true','true','true','true','0-0;'),
(2427,'Salamander Skin Boots','feet','true','none',1230,'leather','d',0,-1,29,0,0,75200,139,'true','true','true','true','0-0;'),
(2428,'Plate Boots','feet','true','none',1240,'leather','d',0,-1,29,0,0,75200,139,'true','true','true','true','0-0;'),
(2429,'Chain Boots','feet','true','none',1220,'leather','c',0,-1,32,0,0,97100,39,'true','true','true','true','0-0;'),
(2430,'Karmian Boots','feet','true','none',1230,'leather','c',0,-1,32,0,0,97100,39,'true','true','true','true','0-0;'),
(2431,'Plated Leather Boots','feet','true','none',1220,'leather','c',0,-1,32,0,0,97100,39,'true','true','true','true','0-0;'),
(2432,'Dwarven Chain Boots','feet','true','none',1210,'leather','c',0,-1,32,0,0,97100,39,'true','true','true','true','0-0;'),
(2433,'Boots of Seal','feet','true','none',1220,'leather','c',0,-1,32,0,0,97100,39,'true','true','true','true','0-0;'),
(2434,'Rind Leather Boots','feet','true','none',1220,'leather','c',0,-1,34,0,0,123900,50,'true','true','true','true','0-0;'),
(2435,'Demon\'s Boots','feet','true','none',1220,'leather','c',0,-1,36,0,0,188800,76,'true','true','true','true','0-0;'),
(2436,'Theca Leather Boots','feet','true','none',1210,'leather','c',0,-1,37,0,0,211600,85,'true','true','true','true','0-0;'),
(2437,'Drake Leather Boots','feet','true','none',1210,'leather','c',0,-1,39,0,0,275100,110,'true','true','true','true','0-0;'),
(2438,'Full Plate Boots','feet','true','none',1200,'leather','c',0,-1,39,0,0,275100,110,'true','true','true','true','0-0;'),
(2439,'Blue Wolf Boots','feet','true','none',1130,'leather','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(2440,'Boots of Nightmare','feet','true','none',1110,'leather','a',0,-1,48,0,0,1760000,108,'true','true','true','true','0-0;'),
(2441,'Dark Legion Boots','feet','true','none',1120,'leather','a',0,-1,48,0,0,1760000,141,'true','true','true','true','0-0;'),
(2442,'Dasparion\'s Boots','feet','true','none',1100,'leather','a',0,-1,48,0,0,1760000,141,'true','true','true','true','0-0;'),
(2443,'Dragon Leather Boots','feet','true','none',1100,'leather','s',0,-1,51,0,0,2390000,120,'true','true','true','true','0-0;'),
(2444,'The Boots','feet','true','none',1100,'leather','s',0,-1,51,0,0,2390000,120,'true','true','true','true','0-0;'),
(2445,'Dragon Scale Boots','feet','true','none',1100,'leather','a',0,-1,48,0,0,1760000,141,'true','true','true','true','0-0;'),
(2446,'Reinforced Leather Gloves','gloves','true','none',640,'leather','d',0,-1,24,0,0,39100,72,'true','true','true','true','0-0;'),
(2447,'Gloves of Knowledge','gloves','true','none',640,'leather','d',0,-1,24,0,0,39100,72,'true','true','true','true','0-0;'),
(2448,'Manticore Skin Gloves','gloves','true','none',630,'leather','d',0,-1,27,0,0,57400,106,'true','true','true','true','0-0;'),
(2449,'Brigandine Gauntlets','gloves','true','none',630,'leather','d',0,-1,27,0,0,57400,106,'true','true','true','true','0-0;'),
(2450,'Mithril Gloves','gloves','true','none',640,'leather','d',0,-1,27,0,0,57400,106,'true','true','true','true','0-0;'),
(2451,'Sage\'s Worn Gloves','gloves','true','none',630,'leather','d',0,-1,29,0,0,75200,139,'true','true','true','true','0-0;'),
(2452,'Reinforced Mithril Gloves','gloves','true','none',620,'leather','c',0,-1,32,0,0,97100,39,'true','true','true','true','0-0;'),
(2453,'Chain Gloves','gloves','true','none',620,'leather','c',0,-1,32,0,0,97100,39,'true','true','true','true','0-0;'),
(2454,'Karmian Gloves','gloves','true','none',620,'leather','c',0,-1,32,0,0,97100,39,'true','true','true','true','0-0;'),
(2455,'Plated Leather Gloves','gloves','true','none',610,'leather','c',0,-1,33,0,0,114400,46,'true','true','true','true','0-0;'),
(2456,'Dwarven Chain Gloves','gloves','true','none',600,'leather','c',0,-1,34,0,0,123900,50,'true','true','true','true','0-0;'),
(2457,'Gloves of Seal','gloves','true','none',620,'leather','c',0,-1,34,0,0,123900,50,'true','true','true','true','0-0;'),
(2458,'Rind Leather Gloves','gloves','true','none',600,'leather','c',0,-1,34,0,0,123900,50,'true','true','true','true','0-0;'),
(2459,'Demon\'s Gloves','gloves','true','none',610,'leather','c',0,-1,36,0,0,188800,76,'true','true','true','true','0-0;'),
(2460,'Theca Leather Gloves','gloves','true','none',600,'leather','c',0,-1,37,0,0,211600,85,'true','true','true','true','0-0;'),
(2461,'Drake Leather Gloves','gloves','true','none',600,'leather','c',0,-1,39,0,0,275100,110,'true','true','true','true','0-0;'),
(2462,'Full Plate Gauntlets','gloves','true','none',600,'leather','c',0,-1,39,0,0,275100,110,'true','true','true','true','0-0;'),
(2463,'Divine Gloves','gloves','true','none',610,'leather','c',0,-1,39,0,0,275100,110,'true','true','true','true','0-0;'),
(2464,'Avadon Gloves','gloves','true','none',590,'leather','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(2465,'Chain Gloves of Silence','gloves','true','none',590,'leather','b',0,-1,41,0,0,519000,69,'true','true','true','true','0-0;'),
(2466,'Guardian\'s Gloves','gloves','true','none',590,'leather','b',0,-1,41,0,0,519000,69,'true','true','true','true','0-0;'),
(2467,'Gloves of Blessing','gloves','true','none',590,'leather','b',0,-1,41,0,0,519000,69,'true','true','true','true','0-0;'),
(2468,'Blessed Gloves','gloves','true','none',600,'leather','c',0,-1,39,0,0,358000,143,'true','true','true','true','0-0;'),
(2469,'Gloves of The Underworld','gloves','true','none',580,'leather','a',0,-1,45,0,0,1160000,93,'true','true','true','true','0-0;'),
(2470,'Gloves of Phantom','gloves','true','none',560,'leather','a',0,-1,48,0,0,1760000,141,'true','true','true','true','0-0;'),
(2471,'Dark Legion Gloves','gloves','true','none',560,'leather','a',0,-1,48,0,0,1760000,141,'true','true','true','true','0-0;'),
(2472,'Dark Crystal Gloves','gloves','true','none',580,'leather','a',0,-1,45,0,0,1160000,71,'true','true','true','true','0-0;'),
(2473,'The Gloves','gloves','true','none',540,'leather','s',0,-1,51,0,0,2390000,120,'true','true','true','true','0-0;'),
(2474,'Dasparion\'s Gloves','gloves','true','none',550,'leather','a',0,-1,48,0,0,1760000,141,'true','true','true','true','0-0;'),
(2475,'Doom Gloves','gloves','true','none',580,'leather','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(2476,'Dragon Gauntlets','gloves','true','none',540,'leather','s',0,-1,52,0,0,2610000,131,'true','true','true','true','0-0;'),
(2477,'Dragon Leather Gloves','gloves','true','none',540,'leather','s',0,-1,51,0,0,2390000,120,'true','true','true','true','0-0;'),
(2478,'Tallum Gloves','gloves','true','none',580,'leather','a',0,-1,45,0,0,1160000,71,'true','true','true','true','0-0;'),
(2479,'Gauntlets of Nightmare','gloves','true','none',550,'leather','a',0,-1,48,0,0,1760000,108,'true','true','true','true','0-0;'),
(2480,'Elemental Gloves','gloves','true','none',580,'leather','b',0,-1,44,0,0,804000,107,'true','true','true','true','0-0;'),
(2481,'Gloves of Grace','gloves','true','none',580,'leather','b',0,-1,44,0,0,804000,107,'true','true','true','true','0-0;'),
(2482,'Majestic Gauntlets','gloves','true','none',540,'leather','a',0,-1,48,0,0,1760000,108,'true','true','true','true','0-0;'),
(2483,'Gust Bracer','gloves','true','none',580,'leather','a',0,-1,45,0,0,1160000,93,'true','true','true','true','0-0;'),
(2484,'Cerberus Gloves','gloves','true','none',540,'leather','a',0,-1,48,0,0,1760000,141,'true','true','true','true','0-0;'),
(2485,'Implosion Gauntlets','gloves','true','none',580,'leather','b',0,-1,44,0,0,804000,107,'true','true','true','true','0-0;'),
(2486,'Paradia Gloves','gloves','true','none',580,'leather','b',0,-1,44,0,0,804000,107,'true','true','true','true','0-0;'),
(2487,'Blue Wolf Gloves','gloves','true','none',590,'leather','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(2488,'Phoenix Gloves','gloves','true','none',570,'leather','a',0,-1,45,0,0,1160000,93,'true','true','true','true','0-0;'),
(2489,'Gloves of Black Ore','gloves','true','none',570,'leather','a',0,-1,45,0,0,1160000,93,'true','true','true','true','0-0;'),
(2490,'Cloak of Silence','underwear','false','none',250,'leather','none',0,-1,5,0,0,6770,0,'true','true','true','true','0-0;'),
(2491,'Golden Yarn Cloak','underwear','false','none',250,'leather','none',0,-1,5,0,0,12300,0,'true','true','true','true','0-0;'),
(2492,'Shadow Cloak','underwear','true','none',240,'leather','c',0,-1,12,0,0,126000,50,'true','true','true','true','0-0;'),
(2506,'Wolf\'s Leather Armor','wolf','false','pet',160,'leather','none',0,-1,9,14,0,6630,0,'true','true','true','true','0-0;'),
(3891,'Wolf\'s Hide Armor','wolf','false','pet',160,'leather','none',0,-1,13,16,0,16900,0,'true','true','true','true','0-0;'),
(3892,'Wolf\'s Hard Leather Mail','wolf','false','pet',160,'leather','none',0,-1,16,18,0,30766,0,'true','true','true','true','0-0;'),
(3893,'Wolf\'s Wooden Armor','wolf','false','pet',160,'leather','none',0,-1,19,20,0,52216,0,'true','true','true','true','0-0;'),
(3894,'Wolf\'s Ring Mail','wolf','false','pet',160,'leather','none',0,-1,22,23,0,83308,0,'true','true','true','true','0-0;'),
(3895,'Wolf\'s Bone Armor','wolf','false','pet',160,'leather','none',0,-1,26,26,0,126750,0,'true','true','true','true','0-0;'),
(3896,'Wolf\'s Scale Male','wolf','false','pet',160,'leather','none',0,-1,30,29,0,186333,0,'true','true','true','true','0-0;'),
(3897,'Wof\'s Bronze Armor','wolf','false','pet',160,'leather','none',0,-1,33,31,0,260000,0,'true','true','true','true','0-0;'),
(3898,'Wolf\'s Plate Mail','wolf','false','pet',160,'leather','none',0,-1,37,33,0,330000,0,'true','true','true','true','0-0;'),
(3899,'Wolf\'s Steel Armor','wolf','false','pet',160,'leather','none',0,-1,40,36,0,420000,0,'true','true','true','true','0-0;'),
(3900,'Wolf\'s Luxury Plate','wolf','false','pet',160,'leather','none',0,-1,43,38,0,640000,0,'true','true','true','true','0-0;'),
(3901,'Wolf\'s Mithril Armor','wolf','false','pet',160,'leather','none',0,-1,47,41,0,940000,0,'true','true','true','true','0-0;'),
(3912,'Hatchling\'s Soft Leather','hatchling','false','pet',160,'leather','none',0,-1,26,26,0,200000,0,'true','true','true','true','0-0;'),
(3913,'Hatchling\'s Scale Mail','hatchling','false','pet',160,'leather','none',0,-1,29,29,0,186333,0,'true','true','true','true','0-0;'),
(3914,'Hatchling\'s Brigandine','hatchling','false','pet',160,'leather','none',0,-1,31,31,0,244833,0,'true','true','true','true','0-0;'),
(3915,'Hatchling\'s Bronze Coat','hatchling','false','pet',160,'leather','none',0,-1,33,33,0,315250,0,'true','true','true','true','0-0;'),
(3916,'Hatchling\'s Steel Coat','hatchling','false','pet',160,'leather','none',0,-1,36,36,0,403000,0,'true','true','true','true','0-0;'),
(3917,'Hatchling\'s Shadowplate','hatchling','false','pet',160,'leather','none',0,-1,38,38,0,1100000,0,'true','true','true','true','0-0;'),
(3918,'Hatchling\'s Mithril Coat','hatchling','false','pet',160,'leather','none',0,-1,41,41,0,1600000,0,'true','true','true','true','0-0;'),
(4224,'Dream Armor','chest','true','heavy',8920,'bronze','none',0,-1,68,0,0,49200,0,'true','true','true','true','0-0;'),
(4225,'Dream Stockings','legs','true','heavy',3960,'bronze','none',0,-1,43,0,0,30700,0,'true','true','true','true','0-0;'),
(4226,'Dream Gloves','gloves','true','none',650,'leather','none',0,-1,17,0,0,12300,0,'true','true','true','true','0-0;'),
(4227,'Dream Boots','feet','true','none',1310,'cloth','none',0,-1,17,0,0,12300,0,'true','true','true','true','0-0;'),
(4228,'Ubiquitous Armor','chest','true','heavy',8920,'bronze','none',0,-1,68,0,0,49200,0,'true','true','true','true','0-0;'),
(4229,'Ubiquitous Stockings','legs','true','heavy',3960,'bronze','none',0,-1,43,0,0,30700,0,'true','true','true','true','0-0;'),
(4230,'Ubiquitous Gloves','gloves','true','none',650,'leather','none',0,-1,17,0,0,12300,0,'true','true','true','true','0-0;'),
(4231,'Ubiquitous Boots','feet','true','none',1310,'cloth','none',0,-1,17,0,0,12300,0,'true','true','true','true','0-0;'),
(4234,'Hatchling\'s Level 65 Armor','hatchling','false','pet',160,'leather','none',0,-1,50,50,0,5628000,0,'true','true','true','true','0-0;'),
(4235,'Hatchling\'s Level 75 Armor','hatchling','false','pet',160,'leather','none',0,-1,58,58,0,19073000,0,'true','true','true','true','0-0;'),
(4236,'Gara Item','chest','false','light',160,'leather','none',0,-1,58,58,0,19073000,0,'true','true','true','true','0-0;'),
(5170,'Mithril Panzer Coat','strider','false','pet',160,'leather','none',0,-1,41,41,0,893750,0,'true','true','true','true','0-0;'),
(5171,'Brigadine Panzer Coat','strider','false','pet',160,'leather','none',0,-1,44,44,0,1296750,0,'true','true','true','true','0-0;'),
(5172,'Draconic Panzer Coat','strider','false','pet',160,'leather','none',0,-1,46,46,0,2011750,0,'true','true','true','true','0-0;'),
(5173,'Blood Panzer Coat','strider','false','pet',160,'leather','none',0,-1,49,49,0,2893583,0,'true','true','true','true','0-0;'),
(5174,'Ophidian Panzer Coat','strider','false','pet',160,'leather','none',0,-1,52,52,0,4402666,0,'true','true','true','true','0-0;'),
(5175,'Inferno Panzer Coat','strider','false','pet',160,'leather','none',0,-1,54,54,0,6032000,0,'true','true','true','true','0-0;'),
(5182,'Hatchling\'s Gorgon Coat','hatchling','false','pet',160,'leather','none',0,-1,44,44,0,1296750,0,'true','true','true','true','0-0;'),
(5183,'Hatchling\'s Ophidian Plate','hatchling','false','pet',160,'leather','none',0,-1,46,46,0,2011750,0,'true','true','true','true','0-0;'),
(5184,'Hatchling\'s Crimson Plate','hatchling','false','pet',160,'leather','none',0,-1,49,49,0,2893583,0,'true','true','true','true','0-0;'),
(5185,'Hatchling\'s Draconic Plate','hatchling','false','pet',160,'leather','none',0,-1,52,52,0,4402666,0,'true','true','true','true','0-0;'),
(5186,'Hatchling\'s Inferno Plate','hatchling','false','pet',160,'leather','none',0,-1,54,54,0,6032000,0,'true','true','true','true','0-0;'),
(5216,'Wolf Level 75 Armor','wolf','false','pet',160,'leather','none',0,-1,71,58,0,938705,0,'true','true','true','true','0-0;'),
(5287,'Sealed Dark Crystal breastplate','chest','true','heavy',7700,'crystal','a',0,-1,171,0,0,4630000,285,'true','true','true','true','0-0;'),
(5288,'Sealed Dark Crystal Gaiters','legs','true','heavy',3320,'crystal','a',0,-1,107,0,0,2890000,178,'true','true','true','true','0-0;'),
(5289,'Sealed Dark Crystal Helmet','head','true','none',570,'crystal','a',0,-1,69,0,0,1740000,107,'true','true','true','true','0-0;'),
(5290,'Sealed Dark Crystal Gloves','gloves','true','none',580,'leather','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(5291,'Sealed Dark Crystal Boots','feet','true','none',1110,'crystal','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(5293,'Sealed Tallum Plate Armor','fullarmor','true','heavy',9780,'leather','a',0,-1,278,0,0,6770000,463,'true','true','true','true','0-0;'),
(5294,'Sealed Tallum Helmet','head','true','none',570,'cloth','a',0,-1,69,0,0,1740000,107,'true','true','true','true','0-0;'),
(5295,'Sealed Tallum Gloves','gloves','true','none',580,'leather','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(5296,'Sealed Tallum Boots','feet','true','none',1130,'blood_steel','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(5297,'Sealed Dark Crystal Leather Armor','chest','true','light',4300,'leather','a',0,-1,128,0,0,3470000,214,'true','true','true','true','0-0;'),
(5298,'Sealed Dark Crystal Leggings','legs','true','light',1480,'leather','a',0,-1,80,0,0,2170000,134,'true','true','true','true','0-0;'),
(5299,'Sealed Gloves of The Underworld','gloves','true','none',580,'leather','a',0,-1,45,0,0,1070000,86,'true','true','true','true','0-0;'),
(5300,'Sealed Boots of The Underworld','feet','true','none',1110,'leather','a',0,-1,45,0,0,1070000,86,'true','true','true','true','0-0;'),
(5301,'Sealed Tallum Leather Armor','fullarmor','true','light',5400,'leather','a',0,-1,209,0,0,5080000,347,'true','true','true','true','0-0;'),
(5302,'Sealed Gust Bracer','gloves','true','none',580,'leather','a',0,-1,45,0,0,1070000,86,'true','true','true','true','0-0;'),
(5303,'Sealed Gust Boots','feet','true','none',1120,'blood_steel','a',0,-1,45,0,0,1070000,86,'true','true','true','true','0-0;'),
(5304,'Sealed Tallum Tunic','chest','true','magic',1860,'leather','a',0,-1,86,0,409,3470000,214,'true','true','true','true','0-0;'),
(5305,'Sealed Tallum Stockings','legs','true','magic',920,'leather','a',0,-1,53,0,256,2170000,134,'true','true','true','true','0-0;'),
(5306,'Sealed Gloves of Black Ore','gloves','true','none',570,'leather','a',0,-1,45,0,0,1070000,86,'true','true','true','true','0-0;'),
(5307,'Sealed Red Flame Boots','feet','true','none',1120,'blood_steel','a',0,-1,45,0,0,1070000,86,'true','true','true','true','0-0;'),
(5308,'Sealed Dark Crystal Robe','fullarmor','true','magic',2450,'leather','a',0,-1,139,0,665,5080000,347,'true','true','true','true','0-0;'),
(5309,'Sealed Phoenix Gloves','gloves','true','none',570,'leather','a',0,-1,45,0,0,1070000,86,'true','true','true','true','0-0;'),
(5310,'Sealed Phoenix Boots','feet','true','none',1120,'blood_steel','a',0,-1,45,0,0,1070000,86,'true','true','true','true','0-0;'),
(5311,'Sealed Armor of Nightmare','fullarmor','true','heavy',9580,'blood_steel','a',0,-1,293,0,0,10300000,704,'true','true','true','true','0-0;'),
(5312,'Sealed Helm of Nightmare','head','true','none',560,'leather','a',0,-1,73,0,0,2640000,163,'true','true','true','true','0-0;'),
(5313,'Sealed Gauntlets of Nightmare','gloves','true','none',550,'leather','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(5314,'Sealed Boots of Nightmare','feet','true','none',1110,'leather','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(5316,'Sealed Majestic Plate Armor','fullarmor','true','heavy',9200,'leather','a',0,-1,293,0,0,10300000,704,'true','true','true','true','0-0;'),
(5317,'Sealed Majestic Circlet','head','true','none',550,'leather','a',0,-1,73,0,0,2640000,163,'true','true','true','true','0-0;'),
(5318,'Sealed Majestic Gauntlets','gloves','true','none',540,'leather','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(5319,'Sealed Majestic Boots','feet','true','none',1110,'blood_steel','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(5320,'Sealed Leather Armor of Nightmare','fullarmor','true','light',5300,'leather','a',0,-1,220,0,0,7730000,528,'true','true','true','true','0-0;'),
(5321,'Sealed Dark Legion Gloves','gloves','true','none',560,'leather','a',0,-1,48,0,0,1630000,130,'true','true','true','true','0-0;'),
(5322,'Sealed Dark Legion Boots','feet','true','none',1120,'leather','a',0,-1,48,0,0,1630000,130,'true','true','true','true','0-0;'),
(5323,'Sealed Majestic Leather Armor','fullarmor','true','light',5350,'leather','a',0,-1,220,0,0,7730000,528,'true','true','true','true','0-0;'),
(5324,'Sealed Gloves of Phantom','gloves','true','none',560,'leather','a',0,-1,48,0,0,1630000,130,'true','true','true','true','0-0;'),
(5325,'Sealed Boots of Phantom','feet','true','none',1120,'oriharukon','a',0,-1,48,0,0,1630000,130,'true','true','true','true','0-0;'),
(5326,'Sealed Nightmare Robe','fullarmor','true','magic',2300,'leather','a',0,-1,147,0,718,7730000,528,'true','true','true','true','0-0;'),
(5327,'Sealed Cerberus Gloves','gloves','true','none',540,'leather','a',0,-1,48,0,0,1630000,130,'true','true','true','true','0-0;'),
(5328,'Sealed Cerberus Boots','feet','true','none',1120,'damascus','a',0,-1,48,0,0,1630000,130,'true','true','true','true','0-0;'),
(5329,'Sealed Majestic Robe','fullarmor','true','magic',2330,'leather','a',0,-1,147,0,718,7730000,528,'true','true','true','true','0-0;'),
(5330,'Sealed Dasparion\'s Gloves','gloves','true','none',550,'leather','a',0,-1,48,0,0,1630000,130,'true','true','true','true','0-0;'),
(5331,'Sealed Dasparion\'s Boots','feet','true','none',1100,'leather','a',0,-1,48,0,0,1630000,130,'true','true','true','true','0-0;'),
(5576,'Sound Test Boots','feet','false','none',50,'cloth','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(5590,'Squeaking Shoes','feet','false','none',50,'cloth','none',0,-1,0,0,0,350000,0,'true','true','true','true','0-0;'),
(5709,'Sealed Zubei\'s Gauntlets','gloves','true','none',590,'mithril','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(5710,'Zubei\'s Gauntlets - Heavy Armor','gloves','true','none',590,'mithril','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(5711,'Zubei\'s Gauntlets - Light Armor','gloves','true','none',590,'mithril','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(5712,'Zubei\'s Gauntlets - Robe','gloves','true','none',590,'mithril','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(5713,'Sealed Avadon Gloves','gloves','true','none',590,'mithril','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(5714,'Avadon Gloves - Heavy Armor','gloves','true','none',590,'mithril','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(5715,'Avadon Gloves - Light Armor','gloves','true','none',590,'mithril','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(5716,'Avadon Gloves - Robe','gloves','true','none',590,'mithril','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(5717,'Sealed Blue Wolf Gloves','gloves','true','none',590,'leather','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(5718,'Blue Wolf Gloves - Heavy Armor','gloves','true','none',590,'leather','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(5719,'Blue Wolf Gloves - Light Armor','gloves','true','none',590,'leather','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(5720,'Blue Wolf Gloves - Robe','gloves','true','none',590,'leather','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(5721,'Sealed Doom Gloves','gloves','true','none',580,'leather','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(5722,'Doom Gloves - Heavy Armor','gloves','true','none',580,'leather','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(5723,'Doom Gloves - Light Armor','gloves','true','none',580,'leather','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(5724,'Doom Gloves - Robe','gloves','true','none',580,'leather','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(5725,'Sealed Zubei\'s Boots','feet','true','none',1180,'mithril','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(5726,'Zubei\'s Boots - Heavy Armor','feet','true','none',1180,'mithril','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(5727,'Zubei\'s Boots - Light Armor','feet','true','none',1180,'mithril','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(5728,'Zubei\'s Boots - Robe','feet','true','none',1180,'mithril','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(5729,'Sealed Avadon Boots','feet','true','none',1180,'mithril','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(5730,'Avadon Boots - Heavy Armor','feet','true','none',1180,'mithril','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(5731,'Avadon Boots - Light Armor','feet','true','none',1180,'mithril','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(5732,'Avadon Boots - Robe','feet','true','none',1180,'mithril','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(5733,'Sealed Blue Wolf Boots','feet','true','none',1130,'leather','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(5734,'Blue Wolf Boots - Heavy Armor','feet','true','none',1130,'leather','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(5735,'Blue Wolf Boots - Light Armor','feet','true','none',1130,'leather','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(5736,'Blue Wolf Boots - Robe','feet','true','none',1130,'leather','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(5737,'Sealed Boots of Doom','feet','true','none',1130,'mithril','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(5738,'Doom Boots - Heavy Armor','feet','true','none',1130,'mithril','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(5739,'Doom Boots - Light Armor','feet','true','none',1130,'mithril','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(5740,'Doom Boots - Robe','feet','true','none',1130,'mithril','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(5765,'Dark Crystal Gloves - Heavy Armor','gloves','true','none',580,'leather','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(5766,'Dark Crystal Gloves - Light Armor','gloves','true','none',580,'leather','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(5767,'Dark Crystal Gloves - Robe','gloves','true','none',580,'leather','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(5768,'Tallum Gloves - Heavy Armor','gloves','true','none',580,'leather','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(5769,'Tallum Gloves - Light Armor','gloves','true','none',580,'leather','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(5770,'Tallum Gloves - Robe','gloves','true','none',580,'leather','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(5771,'Gauntlets of Nightmare - Heavy Armor','gloves','true','none',550,'leather','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(5772,'Gauntlets of Nightmare - Light Armor','gloves','true','none',550,'leather','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(5773,'Gauntlets of Nightmare - Robe','gloves','true','none',550,'leather','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(5774,'Majestic Gauntlets - Heavy Armor','gloves','true','none',540,'leather','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(5775,'Majestic Gauntlets - Light Armor','gloves','true','none',540,'leather','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(5776,'Majestic Gauntlets - Robe','gloves','true','none',540,'leather','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(5777,'Dark Crystal Boots - Heavy Armor','feet','true','none',1110,'crystal','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(5778,'Dark Crystal Boots - Light Armor','feet','true','none',1110,'crystal','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(5779,'Dark Crystal Boots - Robe','feet','true','none',1110,'crystal','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(5780,'Tallum Boots - Heavy Armor','feet','true','none',1130,'blood_steel','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(5781,'Tallum Boots - Light Armor','feet','true','none',1130,'blood_steel','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(5782,'Tallum Boots - Robe','feet','true','none',1130,'blood_steel','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(5783,'Boots of Nightmare - Heavy Armor','feet','true','none',1110,'leather','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(5784,'Boots of Nightmare - Light Armor','feet','true','none',1110,'leather','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(5785,'Boots of Nightmare - Robe','feet','true','none',1110,'leather','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(5786,'Majestic Boots - Heavy Armor','feet','true','none',1110,'blood_steel','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(5787,'Majestic Boots - Light Armor','feet','true','none',1110,'blood_steel','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(5788,'Majestic Boots - Robe','feet','true','none',1110,'blood_steel','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(5808,'Party Mask','face','false','none',10,'wood','none',0,-1,0,0,0,500000,0,'true','true','true','true','0-0;'),
(6323,'Sealed Phoenix Necklace','neck','true','none',150,'silver','a',0,-1,0,76,0,1740000,107,'true','true','true','true','0-0;'),
(6324,'Sealed Phoenix Earring','rear,lear','true','none',150,'silver','a',0,-1,0,57,0,1310000,80,'true','true','true','true','0-0;'),
(6325,'Sealed Phoenix Ring','rfinger,lfinger','true','none',150,'gold','a',0,-1,0,38,0,871000,54,'true','true','true','true','0-0;'),
(6326,'Sealed Majestic Necklace','neck','true','none',150,'silver','a',0,-1,0,80,0,2600000,160,'true','true','true','true','0-0;'),
(6327,'Sealed Majestic Earring','rear,lear','true','none',150,'silver','a',0,-1,0,60,0,1950000,120,'true','true','true','true','0-0;'),
(6328,'Sealed Majestic Ring','rfinger,lfinger','true','none',150,'silver','a',0,-1,0,40,0,1300000,80,'true','true','true','true','0-0;'),
(6373,'Imperial Crusader Breastplate','chest','true','heavy',7620,'scale_of_dragon','s',0,-1,205,0,0,14300000,613,'true','true','true','true','0-0;'),
(6374,'Imperial Crusader Gaiters','legs','true','heavy',3260,'scale_of_dragon','s',0,-1,128,0,0,8960000,383,'true','true','true','true','0-0;'),
(6375,'Imperial Crusader Gauntlets','gloves','true','none',540,'leather','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(6376,'Imperial Crusader Boots','feet','true','none',1110,'leather','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(6378,'Imperial Crusader Helmet','head','true','none',550,'bone','s',0,-1,83,0,0,5370000,230,'true','true','true','true','0-0;'),
(6379,'Draconic Leather Armor','fullarmor','true','light',4950,'leather','s',0,-1,249,0,0,17400000,748,'true','true','true','true','0-0;'),
(6380,'Draconic Leather Gloves','gloves','true','none',540,'leather','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(6381,'Draconic Leather Boots','feet','true','none',1110,'leather','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(6382,'Draconic Leather Helmet','head','true','none',550,'bone','s',0,-1,83,0,0,5370000,230,'true','true','true','true','0-0;'),
(6383,'Major Arcana Robe','fullarmor','true','magic',2300,'cloth','s',0,-1,166,0,866,17400000,748,'true','true','true','true','0-0;'),
(6384,'Major Arcana Gloves','gloves','true','none',540,'leather','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(6385,'Major Arcana Boots','feet','true','none',1110,'leather','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(6386,'Major Arcana Circlet','head','true','none',550,'bone','s',0,-1,83,0,0,5370000,230,'true','true','true','true','0-0;'),
(6394,'Red Party Mask','face','false','none',10,'wood','none',0,-1,0,0,0,500000,0,'true','true','true','true','0-0;'),
(6408,'Formal Wear','fullarmor','false','none',1000,'cloth','none',0,-1,0,0,0,5000000,0,'true','true','true','true','0-0;'),
(6656,'Earring of Antharas','rear,lear','true','none',150,'gold','s',0,-1,0,71,31,3700000,178,'true','true','true','true','3558-1;'),
(6657,'Necklace of Valakas','neck','true','none',150,'gold','s',0,-1,0,95,42,4940000,237,'true','true','true','true','3557-1;'),
(6658,'Ring of Baium','rfinger,lfinger','true','none',150,'gold','s',0,-1,0,48,21,1730000,83,'true','true','true','true','3561-1;'),
(6659,'Zaken\'s Earring','rear,lear','true','none',150,'gold','s',0,-1,0,71,31,2590000,124,'true','true','true','true','3559-1;'),
(6660,'Ring of Queen Ant','rfinger,lfinger','true','none',150,'gold','b',0,-1,0,48,21,616000,82,'true','true','true','true','3562-1;'),
(6661,'Earring of Orfen','rear,lear','true','none',150,'gold','a',0,-1,0,71,31,1300000,104,'true','true','true','true','3560-1;'),
(6662,'Ring of Core','rfinger,lfinger','true','none',150,'gold','a',0,-1,0,48,21,870000,69,'true','true','true','true','3563-1;'),
(6674,'Sealed Imperial Crusader Breastplate','chest','true','heavy',7620,'scale_of_dragon','s',0,-1,193,0,0,14300000,613,'true','true','true','true','0-0;'),
(6675,'Sealed Imperial Crusader Gaiters','legs','true','heavy',3260,'scale_of_dragon','s',0,-1,121,0,0,8960000,383,'true','true','true','true','0-0;'),
(6676,'Sealed Imperial Crusader Gauntlet','gloves','true','none',540,'leather','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(6677,'Sealed Imperial Crusader Boots','feet','true','none',1110,'leather','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(6679,'Sealed Imperial Crusader Helmet','head','true','none',550,'bone','s',0,-1,83,0,0,5370000,230,'true','true','true','true','0-0;'),
(6680,'Sealed Draconic Leather Armor','fullarmor','true','light',4950,'leather','s',0,-1,236,0,0,17400000,748,'true','true','true','true','0-0;'),
(6681,'Sealed Draconic Leather Glove','gloves','true','none',540,'leather','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(6682,'Sealed Draconic Leather Boots','feet','true','none',1110,'leather','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(6683,'Sealed Draconic Leather Helmet','head','true','none',550,'bone','s',0,-1,83,0,0,5370000,230,'true','true','true','true','0-0;'),
(6684,'Sealed Major Arcana Robe','fullarmor','true','magic',2300,'cloth','s',0,-1,157,0,866,17400000,748,'true','true','true','true','0-0;'),
(6685,'Sealed Major Arcana Glove','gloves','true','none',540,'leather','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(6686,'Sealed Major Arcana Boots','feet','true','none',1110,'leather','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(6687,'Sealed Major Arcana Circlet','head','true','none',550,'bone','s',0,-1,83,0,0,5370000,230,'true','true','true','true','0-0;'),
(6724,'Sealed Tateossian Earring','rear,lear','true','none',150,'silver','s',0,-1,0,68,0,3700000,157,'true','true','true','true','0-0;'),
(6725,'Sealed Tateossian Ring','rfinger,lfinger','true','none',150,'gold','s',0,-1,0,46,0,2470000,105,'true','true','true','true','0-0;'),
(6726,'Sealed Tateossian Necklace','neck','true','none',150,'silver','s',0,-1,0,91,0,4940000,209,'true','true','true','true','0-0;'),
(6834,'Circlet of Innadril','face','false','none',10,'wood','none',0,-1,0,0,0,500000,0,'false','false','false','false','3633-1;'),
(6835,'Circlet of Dion','face','false','none',10,'wood','none',0,-1,0,0,0,500000,0,'false','false','false','false','3633-1;'),
(6836,'Circlet of Goddard','face','false','none',10,'wood','none',0,-1,0,0,0,500000,0,'false','false','false','false','3633-2;'),
(6837,'Circlet of Oren','face','false','none',10,'wood','none',0,-1,0,0,0,500000,0,'false','false','false','false','3633-1;'),
(6838,'Circlet of Gludio','face','false','none',10,'wood','none',0,-1,0,0,0,500000,0,'false','false','false','false','3633-1;'),
(6839,'Circlet of Giran','face','false','none',10,'wood','none',0,-1,0,0,0,500000,0,'false','false','false','false','3633-1;'),
(6840,'Circlet of Aden','face','false','none',10,'wood','none',0,-1,0,0,0,500000,0,'false','false','false','false','3633-2;'),
(6841,'The Lord\'s Crown','face','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','false','false','3633-1;'),
(6842,'Wings of Destiny Circlet','face','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(6843,'Cat Ear','hair','false','none',10,'wood','none',0,-1,0,0,0,500000,0,'true','true','true','true','0-0;'),
(6844,'Lady\'s Hair Pin','hair','false','none',10,'wood','none',0,-1,0,0,0,500000,0,'true','true','true','true','0-0;'),
(6845,'Pirate\'s Eye Patch','face','false','none',10,'wood','none',0,-1,0,0,0,500000,0,'true','true','true','true','0-0;'),
(6846,'Monocle','face','false','none',10,'wood','none',0,-1,0,0,0,500000,0,'true','true','true','true','0-0;'),
(7059,'Golden Festival Mask','face','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(7060,'Tateossian Hairband','face','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','false','true','true','0-0;'),
(7680,'Raccoon Ears','hair','false','none',10,'wood','none',0,-1,0,0,0,500000,0,'true','true','true','true','0-0;'),
(7681,'Outlaw\'s Eyepatch','face','false','none',10,'wood','none',0,-1,0,0,0,500000,0,'true','true','true','true','0-0;'),
(7682,'Maiden\'s Hairpin','hair','false','none',10,'wood','none',0,-1,0,0,0,500000,0,'true','true','true','true','0-0;'),
(7683,'Rabbit Ears','hair','false','none',10,'wood','none',0,-1,0,0,0,500000,0,'true','true','true','true','0-0;'),
(7694,'Noblesse Tiara','face','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(7695,'Forget-me-not Hairpin','hair','false','none',10,'wood','none',0,-1,0,0,0,500000,0,'true','true','true','true','0-0;'),
(7696,'Daisy Hairpin','hair','false','none',10,'wood','none',0,-1,0,0,0,500000,0,'true','true','true','true','0-0;'),
(7836,'Santa\'s Hat','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','false','true','true','0-0;'),
(7837,'Sayha\'s White Mask','face','false','none',10,'steel','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(7839,'Gran Kain\'s Black Mask','face','false','none',10,'steel','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(7840,'Rabbit Ears (Event)','hair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(7841,'Racoon Ears (Event)','hair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(7842,'Cat Ears (Event)','hair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(7843,'Pirate\'s Eyepatch (Event)','face','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(7844,'Monocle (Event)','face','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(7845,'Outlaw\'s Eyepatch (Event)','face','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(7846,'Lady\'s Hairpin (Event)','hair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(7847,'Noblewoman\'s Hairpin (Event)','hair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(7848,'Forget-me-not Hairpin (Event)','hair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(7849,'Daisy Hairpin (Event)','hair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(7850,'Clan Oath Helm','head','true','none',640,'fine_steel','d',0,-1,37,0,0,76200,108,'true','true','true','true','0-0;'),
(7851,'Clan Oath Armor','fullarmor','true','heavy',9870,'fine_steel','d',0,-1,158,0,0,330000,469,'true','true','true','true','0-0;'),
(7852,'Clan Oath Gauntlets - Heavy Armor','gloves','true','none',640,'fine_steel','d',0,-1,24,0,0,50800,72,'true','true','true','true','0-0;'),
(7853,'Clan Oath Sabaton - Heavy Armor','feet','true','none',1280,'fine_steel','d',0,-1,24,0,0,50800,72,'true','true','true','true','0-0;'),
(7854,'Clan Oath Brigandine','fullarmor','true','light',5400,'leather','d',0,-1,119,0,0,247000,352,'true','true','true','true','0-0;'),
(7855,'Clan Oath Leather Gloves - Light Armor','gloves','true','none',640,'leather','d',0,-1,24,0,0,50800,72,'true','true','true','true','0-0;'),
(7856,'Clan Oath Boots - Light Armor','feet','true','none',1280,'leather','d',0,-1,24,0,0,50800,72,'true','true','true','true','0-0;'),
(7857,'Clan Oath Aketon','fullarmor','true','magic',2450,'cloth','d',0,-1,79,0,239,247000,357,'true','true','true','true','0-0;'),
(7858,'Clan Oath Padded Gloves - Robe','gloves','true','none',640,'cloth','d',0,-1,24,0,0,50800,72,'true','true','true','true','0-0;'),
(7859,'Clan Oath Sandals - Robe','feet','true','none',1280,'cloth','d',0,-1,24,0,0,50800,72,'true','true','true','true','0-0;'),
(7860,'Apella Helm','head','true','none',570,'fine_steel','a',0,-1,69,0,0,1340000,107,'true','true','true','true','0-0;'),
(7861,'Apella Plate Armor','fullarmor','true','heavy',9780,'leather','a',0,-1,278,0,0,6770000,463,'true','true','true','true','0-0;'),
(7862,'Apella Gauntlet - Heavy Armor','gloves','true','none',580,'leather','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(7863,'Apella Solleret - Heavy Armor','feet','true','none',1130,'blood_steel','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(7864,'Apella Brigandine','fullarmor','true','light',5400,'leather','a',0,-1,209,0,0,5080000,347,'true','true','true','true','0-0;'),
(7865,'Apella Leather Gloves - Light Armor','gloves','true','none',580,'leather','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(7866,'Apella Boots - Light Armor','feet','true','none',1130,'blood_steel','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(7867,'Apella Doublet','fullarmor','true','magic',2450,'leather','a',0,-1,139,0,665,4340000,347,'true','true','true','true','0-0;'),
(7868,'Apella Silk Gloves - Robe','gloves','true','none',580,'leather','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(7869,'Apella Sandals - Robe','feet','true','none',1130,'blood_steel','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(7870,'Sealed Apella Helm','head','true','none',570,'cloth','a',0,-1,69,0,0,1340000,107,'true','true','true','true','0-0;'),
(7871,'Sealed Apella Plate Armor','fullarmor','true','heavy',9780,'leather','a',0,-1,278,0,0,6770000,463,'true','true','true','true','0-0;'),
(7872,'Sealed Apella Gauntlet','gloves','true','none',580,'leather','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(7873,'Sealed Apella Solleret','feet','true','none',1130,'blood_steel','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(7874,'Sealed Apella Brigandine','fullarmor','true','light',5400,'leather','a',0,-1,209,0,0,5080000,347,'true','true','true','true','0-0;'),
(7875,'Sealed Apella Leather Gloves','gloves','true','none',580,'leather','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(7876,'Sealed Apella Boots','feet','true','none',1130,'blood_steel','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(7877,'Sealed Apella Doublet','fullarmor','true','magic',2450,'leather','a',0,-1,139,0,665,4340000,347,'true','true','true','true','0-0;'),
(7878,'Sealed Apella Silk Gloves','gloves','true','none',580,'leather','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(7879,'Sealed Apella Sandals','feet','true','none',1130,'blood_steel','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(8177,'Raid Challenger\'s Circlet','face','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8178,'Raid Adventurer\'s Circlet','face','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8179,'Raid Master\'s Circlet','face','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8180,'Circlet of Ice Fairy Sirra','face','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8181,'Academy Circlet','face','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','false','false','0-0;'),
(8182,'Circlet of Rune','face','false','none',10,'wood','none',0,-1,0,0,0,500000,0,'false','false','false','false','3633-2;'),
(8183,'Circlet of Schuttgart','face','false','none',10,'wood','none',0,-1,0,0,0,500000,0,'false','false','false','false','3633-2;'),
(8184,'Party Hat','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8185,'Feathered Hat','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8186,'Artisan\'s Goggles','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8187,'Demon Horns','hair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8188,'Little Angel Wings','hair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8189,'Fairy Antennae','hair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8191,'Frintezza\'s Necklace','neck','true','none',150,'gold','a',0,-1,0,95,42,3450000,230,'true','true','true','true','3604-1;'),
(8541,'Little Harness','babypet','false','pet',160,'leather','none',0,-1,10,25,0,216666,0,'true','true','true','true','0-0;'),
(8552,'Mask of Spirits','face','false','none',10,'paper','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8557,'Blue Party Hat','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8558,'Eva\'s Mark (Event)','face','false','none',10,'steel','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(8559,'Diadem','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8560,'Teddy Bear Hat','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8561,'Piggy Hat','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8562,'Jester Hat','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8563,'Wizard Hat','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8564,'Dapper Cap','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8565,'Romantic Chapeau','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8566,'Iron Circlet','face','false','none',10,'steel','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(8567,'Valakas Slayer Circlet','face','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8568,'Antharas Slayer Circlet','face','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8569,'Half Face Mask','face','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8660,'Demon Horns','hair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8661,'Mask of Spirits','face','false','none',10,'paper','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8662,'Fairy Antennae (Event)','hair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(8910,'Black Feather Mask (Event)','dhair','false','none',10,'steel','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(8911,'Black Half-Mask (Event)','face','false','none',10,'steel','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8912,'Single Stem Flower','hair','false','none',10,'steel','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8913,'Butterfly Hairpin','hair','false','none',10,'steel','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8914,'Luxurious Gold Circlet','dhair','false','none',10,'steel','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8915,'Luxurious Silver Circlet','dhair','false','none',10,'steel','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8916,'Eye Patch','face','false','none',10,'steel','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8917,'Goddess Circlet','dhair','false','none',10,'steel','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8918,'Leather Cap','dhair','false','none',10,'steel','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8919,'First Mate\'s Hat','dhair','false','none',10,'steel','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(8920,'Angel Halo','dhair','false','none',10,'steel','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8921,'Demon Circlet','dhair','false','none',10,'steel','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8922,'Pirate Hat','dhair','false','none',10,'steel','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8923,'Scar','face','false','none',10,'steel','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8936,'Santa\'s Antlers','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8947,'L2 Day: Rabbit Ears','hair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8948,'L2 Day: Little Angel Wings','hair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8949,'L2 Day: Fairy Antennae','hair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8950,'L2 Day: Feathered Hat','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(8951,'L2 Day: Artisan\'s Goggles','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9030,'Shadow Item: Bronze Breastplate','chest','false','heavy',2973,'bronze','none',0,600,68,0,0,0,0,'false','false','true','false','0-0;'),
(9031,'Shadow Item: Bronze Gaiters','legs','false','heavy',1320,'bronze','none',0,600,43,0,0,0,0,'false','false','true','false','0-0;'),
(9032,'Shadow Item: Hard Leather Shirt','chest','false','light',1573,'leather','none',0,600,53,0,0,0,0,'false','false','true','false','0-0;'),
(9033,'Shadow Item: Hard Leather Gaiters','legs','false','light',537,'leather','none',0,600,33,0,0,0,0,'false','false','true','false','0-0;'),
(9034,'Shadow Item: Tunic of Magic','chest','false','magic',693,'cloth','none',0,600,34,0,86,0,0,'false','false','true','false','0-0;'),
(9035,'Shadow Item: Stockings of Magic','legs','false','magic',343,'cloth','none',0,600,21,0,54,0,0,'false','false','true','false','0-0;'),
(9037,'Shadow Item: Hard Leather Helmet','head','false','none',213,'leather','none',0,600,26,0,0,0,0,'false','false','true','false','0-0;'),
(9038,'Shadow Item: Boots','feet','false','none',437,'cloth','none',0,600,17,0,0,0,0,'false','false','true','false','0-0;'),
(9039,'Shadow Item: Bracer','gloves','false','none',217,'leather','none',0,600,17,0,0,0,0,'false','false','true','false','0-0;'),
(9040,'Shadow Item: Mithril Breastplate','chest','false','heavy',2890,'mithril','d',0,600,95,0,0,0,0,'false','false','true','false','0-0;'),
(9041,'Shadow Item: Mithril Gaiters','legs','false','heavy',1277,'mithril','d',0,600,61,0,0,0,0,'false','false','true','false','0-0;'),
(9042,'Shadow Item: Gauntlet','gloves','false','none',213,'cloth','d',0,600,24,0,0,0,0,'false','false','true','false','0-0;'),
(9043,'Shadow Item: Iron Boots','feet','false','none',427,'fine_steel','d',0,600,24,0,0,0,0,'false','false','true','false','0-0;'),
(9045,'Shadow Item: Reinforced Leather Shirt','chest','false','light',1523,'leather','d',0,600,73,0,0,0,0,'false','false','true','false','0-0;'),
(9046,'Shadow Item: Reinforced Leather Gaiters','legs','false','light',523,'leather','d',0,600,46,0,0,0,0,'false','false','true','false','0-0;'),
(9047,'Shadow Item: Reinforced Leather Gloves','gloves','false','none',213,'leather','d',0,600,24,0,0,0,0,'false','false','true','false','0-0;'),
(9048,'Shadow Item: Reinforced Leather Boots','feet','false','none',427,'leather','d',0,600,24,0,0,0,0,'false','false','true','false','0-0;'),
(9049,'Shadow Item: Tunic of Knowledge','chest','false','magic',673,'cloth','d',0,600,49,0,147,0,0,'false','false','true','false','0-0;'),
(9050,'Shadow Item: Stockings of Knowledge','legs','false','magic',333,'cloth','d',0,600,30,0,92,0,0,'false','false','true','false','0-0;'),
(9051,'Shadow Item: Gloves of Knowledge','gloves','false','none',213,'leather','d',0,600,24,0,0,0,0,'false','false','true','false','0-0;'),
(9052,'Shadow Item: Boots of Knowledge','feet','false','none',423,'leather','d',0,600,24,0,0,0,0,'false','false','true','false','0-0;'),
(9053,'Shadow Item: Helmet','head','false','none',213,'fine_steel','d',0,600,37,0,0,0,0,'false','false','true','false','0-0;'),
(9054,'Shadow Item: Composite Armor','fullarmor','false','heavy',3660,'fine_steel','c',0,600,224,0,0,0,0,'false','false','true','false','0-0;'),
(9055,'Shadow Item: Composite Boots','feet','false','none',407,'fine_steel','c',0,600,36,0,0,0,0,'false','false','true','false','0-0;'),
(9057,'Shadow Item: Composite Helmet','head','false','none',203,'fine_steel','c',0,600,54,0,0,0,0,'false','false','true','false','0-0;'),
(9058,'Shadow Item: Theca Leather Armor','chest','false','light',1457,'leather','c',0,600,106,0,0,0,0,'false','false','true','false','0-0;'),
(9059,'Shadow Item: Theca Leather Gaiters','legs','false','light',510,'leather','c',0,600,66,0,0,0,0,'false','false','true','false','0-0;'),
(9060,'Shadow Item: Theca Leather Boots','feet','false','none',403,'leather','c',0,600,37,0,0,0,0,'false','false','true','false','0-0;'),
(9061,'Shadow Item: Theca Leather Gloves','gloves','false','none',200,'leather','c',0,600,37,0,0,0,0,'false','false','true','false','0-0;'),
(9062,'Shadow Item: Demon\'s Tunic','chest','false','magic',663,'cloth','c',0,600,69,0,284,0,0,'false','false','true','false','0-0;'),
(9063,'Shadow Item: Demon\'s Stockings','legs','false','magic',327,'cloth','c',0,600,43,0,177,0,0,'false','false','true','false','0-0;'),
(9064,'Shadow Item: Demon\'s Boots','feet','false','none',407,'leather','c',0,600,36,0,0,0,0,'false','false','true','false','0-0;'),
(9065,'Shadow Item: Demon\'s Gloves','gloves','false','none',203,'leather','c',0,600,36,0,0,0,0,'false','false','true','false','0-0;'),
(9066,'Shadow Item: Shining Circlet','head','false','none',200,'steel','c',0,600,54,0,0,0,0,'false','false','true','false','0-0;'),
(9067,'Shadow Item: Zubei\'s Breastplate','chest','false','heavy',2657,'mithril','b',0,600,157,0,0,0,0,'false','false','true','false','0-0;'),
(9068,'Shadow Item: Zubei\'s Gaiters','legs','false','heavy',1190,'mithril','b',0,600,98,0,0,0,0,'false','false','true','false','0-0;'),
(9069,'Shadow Item: Zubei\'s Helmet','head','false','none',197,'mithril','b',0,600,62,0,0,0,0,'false','false','true','false','0-0;'),
(9071,'Shadow Item: Zubei\'s Gauntlet','gloves','false','none',197,'mithril','b',0,600,41,0,0,0,0,'false','false','true','false','0-0;'),
(9072,'Shadow Item: Zubei\'s Boots','feet','false','none',393,'mithril','b',0,600,41,0,0,0,0,'false','false','true','false','0-0;'),
(9073,'Shadow Item: Zubei\'s Leather Shirt','chest','false','light',1443,'leather','b',0,600,117,0,0,0,0,'false','false','true','false','0-0;'),
(9074,'Shadow Item: Zubei\'s Leather Gaiters','legs','false','light',493,'leather','b',0,600,73,0,0,0,0,'false','false','true','false','0-0;'),
(9075,'Shadow Item: Zubei\'s Gauntlet','gloves','false','none',197,'mithril','b',0,600,41,0,0,0,0,'false','false','true','false','0-0;'),
(9076,'Shadow Item: Zubei\'s Boots','feet','false','none',393,'mithril','b',0,600,41,0,0,0,0,'false','false','true','false','0-0;'),
(9077,'Shadow Item: Tunic of Zubei','chest','false','magic',653,'leather','b',0,600,78,0,345,0,0,'false','false','true','false','0-0;'),
(9078,'Shadow Item: Stockings of Zubei','legs','false','magic',313,'leather','b',0,600,49,0,216,0,0,'false','false','true','false','0-0;'),
(9079,'Shadow Item: Zubei\'s Gauntlet','gloves','false','none',197,'mithril','b',0,600,41,0,0,0,0,'false','false','true','false','0-0;'),
(9080,'Shadow Item: Zubei\'s Boots','feet','false','none',393,'mithril','b',0,600,41,0,0,0,0,'false','false','true','false','0-0;'),
(9081,'Shadow Item: Dark Crystal Breastplate','chest','false','heavy',2567,'crystal','a',0,600,171,0,0,0,0,'false','false','true','false','0-0;'),
(9082,'Shadow Item: Dark Crystal Gaiters','legs','false','heavy',1107,'crystal','a',0,600,107,0,0,0,0,'false','false','true','false','0-0;'),
(9083,'Shadow Item: Dark Crystal Helmet','head','false','none',190,'crystal','a',0,600,69,0,0,0,0,'false','false','true','false','0-0;'),
(9085,'Shadow Item: Dark Crystal Gloves','gloves','false','none',193,'leather','a',0,600,46,0,0,0,0,'false','false','true','false','0-0;'),
(9086,'Shadow Item: Dark Crystal Boots','feet','false','none',370,'crystal','a',0,600,46,0,0,0,0,'false','false','true','false','0-0;'),
(9087,'Shadow Item: Dark Crystal Leather Armor','chest','false','light',1433,'leather','a',0,600,128,0,0,0,0,'false','false','true','false','0-0;'),
(9088,'Shadow Item: Dark Crystal Leggings','legs','false','light',493,'leather','a',0,600,80,0,0,0,0,'false','false','true','false','0-0;'),
(9089,'Shadow Item: Dark Crystal Gloves','gloves','false','none',193,'leather','a',0,600,46,0,0,0,0,'false','false','true','false','0-0;'),
(9090,'Shadow Item: Dark Crystal Boots','feet','false','none',370,'crystal','a',0,600,46,0,0,0,0,'false','false','true','false','0-0;'),
(9091,'Shadow Item: Dark Crystal Robe','fullarmor','false','magic',817,'leather','a',0,600,139,0,665,0,0,'false','false','true','false','0-0;'),
(9092,'Shadow Item: Dark Crystal Gloves','gloves','false','none',193,'leather','a',0,600,46,0,0,0,0,'false','false','true','false','0-0;'),
(9093,'Shadow Item: Dark Crystal Boots','feet','false','none',370,'crystal','a',0,600,46,0,0,0,0,'false','false','true','false','0-0;'),
(9094,'Shadow Item: Majestic Plate Armor','fullarmor','false','heavy',3067,'leather','a',0,600,293,0,0,0,0,'false','false','true','false','0-0;'),
(9095,'Shadow Item: Magestic Circlet','head','false','none',183,'leather','a',0,600,73,0,0,0,0,'false','false','true','false','0-0;'),
(9096,'Shadow Item: Magestic Gauntlet','gloves','false','none',180,'leather','a',0,600,49,0,0,0,0,'false','false','true','false','0-0;'),
(9097,'Shadow Item: Magestic Boots','feet','false','none',370,'blood_steel','a',0,600,49,0,0,0,0,'false','false','true','false','0-0;'),
(9098,'Shadow Item: Majestic Leather Armor','fullarmor','false','light',1783,'leather','a',0,600,220,0,0,0,0,'false','false','true','false','0-0;'),
(9099,'Shadow Item: Magestic Gauntlet','gloves','false','none',180,'leather','a',0,600,49,0,0,0,0,'false','false','true','false','0-0;'),
(9100,'Shadow Item: Magestic Boots','feet','false','none',370,'blood_steel','a',0,600,49,0,0,0,0,'false','false','true','false','0-0;'),
(9101,'Shadow Item: Magestic Robe','fullarmor','false','magic',777,'leather','a',0,600,147,0,718,0,0,'false','false','true','false','0-0;'),
(9102,'Shadow Item: Magestic Gauntlet','gloves','false','none',180,'leather','a',0,600,49,0,0,0,0,'false','false','true','false','0-0;'),
(9103,'Shadow Item: Magestic Boots','feet','false','none',370,'blood_steel','a',0,600,49,0,0,0,0,'false','false','true','false','0-0;'),
(9128,'Shadow Item: Mithril Gauntlet','gloves','false','none',200,'mithril','c',0,600,36,0,0,0,0,'false','false','true','false','0-0;'),
(9138,'Santa\'s Hat','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9145,'Little Angel Wings (Event)','hair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(9158,'Golden Circlet of Redemption','dhair','false','none',10,'steel','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9159,'Silver Circlet of Salvation','dhair','false','none',10,'steel','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9160,'Pig Wrangler\'s Cap','dhair','false','none',10,'steel','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9177,'Shadow Item - Teddy Bear Hat - Resurrection','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9178,'Shadow Item - Piggy Hat - Resurrection','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9179,'Shadow Item - Jester Hat - Resurrection','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9180,'Shadow Item - Wizard Hat - Resurrection','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9181,'Shadow Item - Dapper Cap - Resurrection','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9182,'Shadow Item - Romantic Chapeau - Resurrection','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9183,'Shadow Item - Iron Circlet - Resurrection','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9184,'Shadow Item - Teddy Bear Hat - Escape','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9185,'Shadow Item - Piggy Hat - Escape','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9186,'Shadow Item - Jester Hat - Escape','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9187,'Shadow Item - Wizard Hat - Escape','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9188,'Shadow Item - Dapper Cap - Escape','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9189,'Shadow Item - Romantic Chapeau - Escape','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9190,'Shadow Item - Iron Circlet - Escape','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9191,'Shadow Item - Teddy Bear Hat - Big Head','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9192,'Shadow Item - Piggy Hat - Big Head','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9193,'Shadow Item - Jester Hat - Big Head','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9194,'Shadow Item - Wizard Hat - Big Head','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9195,'Shadow Item - Dapper Cap - Big Head','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9196,'Shadow Item - Romantic Chapeau - Big Head','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9197,'Shadow Item - Iron Circlet - Big Head','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9198,'Shadow Item - Teddy Bear Hat - Firework','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9199,'Shadow Item - Piggy Hat - Firework','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9200,'Shadow Item - Jester Hat - Firework','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9201,'Shadow Item - Wizard Hat - Firework','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9202,'Shadow Item - Dapper Cap - Firework','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9203,'Shadow Item - Romantic Chapeau - Firework','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9204,'Shadow Item - Iron Circlet - Firework','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'false','false','true','false','0-0;'),
(9208,'Phantom Mask (Event)','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(9391,'Human Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9392,'Elven Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9393,'Dark Elven Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9394,'Orcish Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9395,'Dwarven Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9396,'Kamaelic Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9397,'Shield Master Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9398,'Bard Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9399,'Force Master Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9400,'Weapon Master Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9401,'Dagger Master Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9402,'Bow Master Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9403,'Wizard Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9404,'Summoner Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9405,'Healer Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9406,'Enchanter Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9407,'Weapon Master Circlet (Kamael only)','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9408,'Bow Master Circlet (Kamael only)','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9409,'Black Phantom Mask (Event)','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(9410,'Human Veteran\'s Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9411,'Elven Veteran\'s Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9412,'Dark Elven Veteran\'s Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9413,'Orcish Veteran\'s Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9414,'Dwarf Veteran\'s Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9415,'Kamaelic Veteran\'s Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(9416,'Dynasty Breast Plate','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(9417,'Dynasty Breast Plate - Shield Master','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(9418,'Dynasty Breast Plate - Weapon Master','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(9419,'Dynasty Breast Plate - Force Master','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(9420,'Dynasty Breast Plate - Bard','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(9421,'Dynasty Gaiter','legs','true','heavy',3210,'wood','s80',0,-1,141,0,0,0,0,'true','true','true','true','0-0;'),
(9422,'Dynasty Helmet','head','true','heavy',530,'wood','s80',0,-1,92,0,0,0,0,'true','true','true','true','0-0;'),
(9423,'Dynasty Gauntlet - Heavy Armor','gloves','true','heavy',520,'wood','s80',0,-1,61,0,0,0,0,'true','true','true','true','0-0;'),
(9424,'Dynasty Boots - Heavy Armor','feet','true','heavy',1090,'wood','s80',0,-1,61,0,0,0,0,'true','true','true','true','0-0;'),
(9425,'Dynasty Leather Armor','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(9426,'Dynasty Leather Armor - Dagger Master','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(9427,'Dynasty Leather Armor - Bow Master','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(9428,'Dynasty Leather Leggings','legs','true','light',1370,'wood','s80',0,-1,106,0,0,0,0,'true','true','true','true','0-0;'),
(9429,'Dynasty Leather Helmet','head','true','light',530,'wood','s80',0,-1,92,0,0,0,0,'true','true','true','true','0-0;'),
(9430,'Dynasty Leather Gloves - Light Armor','gloves','true','light',520,'wood','s80',0,-1,61,0,0,0,0,'true','true','true','true','0-0;'),
(9431,'Dynasty Leather Boots - Light Armor','feet','true','light',1090,'wood','s80',0,-1,61,0,0,0,0,'true','true','true','true','0-0;'),
(9432,'Dynasty Tunic','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(9433,'Dynasty Tunic - Healer','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(9434,'Dynasty Tunic - Enchanter','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(9435,'Dynasty Tunic - Summoner','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(9436,'Dynasty Tunic - Wizard','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(9437,'Dynasty Stockings','legs','true','magic',860,'wood','s80',0,-1,71,0,370,0,0,'true','true','true','true','0-0;'),
(9438,'Dynasty Circlet','head','true','magic',530,'wood','s80',0,-1,92,0,0,0,0,'true','true','true','true','0-0;'),
(9439,'Dynasty Gloves - Robe','gloves','true','magic',520,'wood','s80',0,-1,61,0,0,0,0,'true','true','true','true','0-0;'),
(9440,'Dynasty Shoes - Robe','feet','true','magic',1090,'wood','s80',0,-1,61,0,0,0,0,'true','true','true','true','0-0;'),
(9452,'Sealed Dynasty Earring','rear,lear','true','none',150,'wood','s80',0,-1,0,79,0,0,0,'true','true','true','true','0-0;'),
(9453,'Sealed Dynasty Necklace','neck','true','none',150,'wood','s80',0,-1,0,106,0,0,0,'true','true','true','true','0-0;'),
(9454,'Sealed Dynasty Ring','rfinger,lfinger','true','none',150,'wood','s80',0,-1,0,53,0,0,0,'true','true','true','true','0-0;'),
(9455,'Dynasty Earrings','rear,lear','true','none',150,'wood','s80',0,-1,0,90,35,0,0,'true','true','true','true','0-0;'),
(9456,'Dynasty Necklace','neck','true','none',150,'wood','s80',0,-1,0,120,46,0,0,'true','true','true','true','0-0;'),
(9457,'Dynasty Ring','rfinger,lfinger','true','none',150,'wood','s80',0,-1,0,60,23,0,0,'true','true','true','true','0-0;'),
(9458,'Dynasty Earrings - Stun Resistance','rear,lear','true','none',150,'wood','s80',0,-1,0,27,35,0,0,'true','true','true','true','0-0;'),
(9459,'Dynasty Necklace - Stun Resistance','neck','true','none',150,'wood','s80',0,-1,0,36,46,0,0,'true','true','true','true','0-0;'),
(9460,'Dynasty Ring - Stun Resistance','rfinger,lfinger','true','none',150,'wood','s80',0,-1,0,18,23,0,0,'true','true','true','true','0-0;'),
(9461,'Dynasty Earrings - Poison Resistance','rear,lear','true','none',150,'wood','s80',0,-1,0,27,35,0,0,'true','true','true','true','0-0;'),
(9462,'Dynasty Necklace  - Poison Resistance','neck','true','none',150,'wood','s80',0,-1,0,36,46,0,0,'true','true','true','true','0-0;'),
(9463,'Dynasty Ring - Poison Resistance','rfinger,lfinger','true','none',150,'wood','s80',0,-1,0,18,23,0,0,'true','true','true','true','0-0;'),
(9464,'Dynasty Earrings - Bleeding Resistance','rear,lear','true','none',150,'wood','s80',0,-1,0,27,35,0,0,'true','true','true','true','0-0;'),
(9465,'Dynasty Necklace  - Bleeding Resistance','neck','true','none',150,'wood','s80',0,-1,0,36,46,0,0,'true','true','true','true','0-0;'),
(9466,'Dynasty Ring - Bleeding Resistance','rfinger,lfinger','true','none',150,'wood','s80',0,-1,0,18,23,0,0,'true','true','true','true','0-0;'),
(9467,'Dynasty Earrings - Sleep Resistance','rear,lear','true','none',150,'wood','s80',0,-1,0,27,35,0,0,'true','true','true','true','0-0;'),
(9468,'Dynasty Necklace - Sleep Resistance','neck','true','none',150,'wood','s80',0,-1,0,36,46,0,0,'true','true','true','true','0-0;'),
(9469,'Dynasty Ring - Sleep Resistance','rfinger,lfinger','true','none',150,'wood','s80',0,-1,0,18,23,0,0,'true','true','true','true','0-0;'),
(9470,'Dynasty Earrings - Paralysis Resistance','rear,lear','true','none',150,'wood','s80',0,-1,0,27,35,0,0,'true','true','true','true','0-0;'),
(9471,'Dynasty Necklace - Paralysis Resistance','neck','true','none',150,'wood','s80',0,-1,0,36,46,0,0,'true','true','true','true','0-0;'),
(9472,'Dynasty Ring - Paralysis Resistance','rfinger,lfinger','true','none',150,'wood','s80',0,-1,0,18,23,0,0,'true','true','true','true','0-0;'),
(9473,'Dynasty Earrings - Hold Resistance','rear,lear','true','none',150,'wood','s80',0,-1,0,27,35,0,0,'true','true','true','true','0-0;'),
(9474,'Dynasty Necklace  - Hold Resistance','neck','true','none',150,'wood','s80',0,-1,0,36,46,0,0,'true','true','true','true','0-0;'),
(9475,'Dynasty Ring - Hold Resistance','rfinger,lfinger','true','none',150,'wood','s80',0,-1,0,18,23,0,0,'true','true','true','true','0-0;'),
(9476,'Dynasty Earrings - Fear Resistance','rear,lear','true','none',150,'wood','s80',0,-1,0,27,35,0,0,'true','true','true','true','0-0;'),
(9477,'Dynasty Necklace - Fear Resistance','neck','true','none',150,'wood','s80',0,-1,0,36,46,0,0,'true','true','true','true','0-0;'),
(9478,'Dynasty Ring - Fear Resistance','rfinger,lfinger','true','none',150,'wood','s80',0,-1,0,18,23,0,0,'true','true','true','true','0-0;'),
(9479,'Dynasty Earrings (not used) - Darkness Resistance','rear,lear','true','none',150,'wood','s80',0,-1,0,27,35,0,0,'true','true','true','true','0-0;'),
(9480,'Dynasty Necklace (not used) - Darkness Resistance','neck','true','none',150,'wood','s80',0,-1,0,36,46,0,0,'true','true','true','true','0-0;'),
(9481,'Dynasty Ring (not used) - Darkness Resistance','rfinger,lfinger','true','none',150,'wood','s80',0,-1,0,18,23,0,0,'true','true','true','true','0-0;'),
(9514,'Sealed Dynasty Breast Plate','chest','true','heavy',7570,'wood','s80',0,-1,214,0,0,0,0,'true','true','true','true','0-0;'),
(9515,'Sealed Dynasty Gaiter','legs','true','heavy',3210,'wood','s80',0,-1,134,0,0,0,0,'true','true','true','true','0-0;'),
(9516,'Sealed Dynasty Helmet','head','true','heavy',530,'wood','s80',0,-1,81,0,0,0,0,'true','true','true','true','0-0;'),
(9517,'Sealed Dynasty Gauntlets','gloves','true','heavy',520,'wood','s80',0,-1,53,0,0,0,0,'true','true','true','true','0-0;'),
(9518,'Sealed Dynasty Boots','feet','true','heavy',1090,'wood','s80',0,-1,53,0,0,0,0,'true','true','true','true','0-0;'),
(9519,'Sealed Dynasty Leather Armor','chest','true','light',4180,'wood','s80',0,-1,161,0,0,0,0,'true','true','true','true','0-0;'),
(9520,'Sealed Dynasty Leather Leggings','legs','true','light',1370,'wood','s80',0,-1,101,0,0,0,0,'true','true','true','true','0-0;'),
(9521,'Sealed Dynasty Leather Helmet','head','true','light',530,'wood','s80',0,-1,81,0,0,0,0,'true','true','true','true','0-0;'),
(9522,'Sealed Dynasty Leather Gloves','gloves','true','light',520,'wood','s80',0,-1,53,0,0,0,0,'true','true','true','true','0-0;'),
(9523,'Sealed Dynasty Leather Boots','feet','true','light',1090,'wood','s80',0,-1,53,0,0,0,0,'true','true','true','true','0-0;'),
(9524,'Sealed Dynasty Tunic','chest','true','magic',1780,'wood','s80',0,-1,107,0,592,0,0,'true','true','true','true','0-0;'),
(9525,'Sealed Dynasty Stockings','legs','true','magic',860,'wood','s80',0,-1,67,0,370,0,0,'true','true','true','true','0-0;'),
(9526,'Sealed Dynasty Circlet','head','true','magic',530,'wood','s80',0,-1,81,0,0,0,0,'true','true','true','true','0-0;'),
(9527,'Sealed Dynasty Gloves','gloves','true','magic',520,'wood','s80',0,-1,53,0,0,0,0,'true','true','true','true','0-0;'),
(9528,'Sealed Dynasty Shoes','feet','true','magic',1090,'wood','s80',0,-1,53,0,0,0,0,'true','true','true','true','0-0;'),
(9577,'Cotton Shirt','underwear','true','none',130,'wood','none',0,-1,6,0,0,1300,0,'true','true','true','true','0-0;'),
(9578,'Linen Shirt','underwear','true','none',130,'wood','d',0,-1,12,0,0,25000,39,'true','true','true','true','0-0;'),
(9579,'Silk Shirt','underwear','true','none',130,'wood','c',0,-1,17,0,0,80000,27,'true','true','true','true','0-0;'),
(9580,'Thin Leather Shirt','underwear','true','none',130,'wood','b',0,-1,21,0,0,260000,29,'true','true','true','true','0-0;'),
(9581,'Scale Shirt','underwear','true','none',130,'wood','a',0,-1,23,0,0,588000,39,'true','true','true','true','0-0;'),
(9582,'Mithril Shirt','underwear','true','none',130,'wood','s',0,-1,28,0,0,1800000,86,'true','true','true','true','0-0;'),
(9583,'Striped Cotton Shirt','underwear','true','none',130,'wood','none',0,-1,8,0,0,6100,0,'true','true','true','true','0-0;'),
(9584,'Striped Linen Shirt','underwear','true','none',130,'wood','d',0,-1,14,0,0,49000,75,'true','true','true','true','0-0;'),
(9585,'Striped Silk Shirt','underwear','true','none',130,'wood','c',0,-1,19,0,0,180000,60,'true','true','true','true','0-0;'),
(9586,'Thin Striped Leather Shirt','underwear','true','none',130,'wood','b',0,-1,22,0,0,400000,64,'true','true','true','true','0-0;'),
(9587,'Striped Scale Shirt','underwear','true','none',130,'wood','a',0,-1,26,0,0,880000,59,'true','true','true','true','0-0;'),
(9588,'Striped Mithril Shirt','underwear','true','none',130,'wood','s',0,-1,30,0,0,2540000,122,'true','true','true','true','0-0;'),
(9589,'Iron Bracelet','rbracelet','true','none',150,'wood','c',0,-1,0,0,0,216000,72,'true','true','true','true','0-0;'),
(9590,'Bronze Bracelet','rbracelet','true','none',150,'wood','b',0,-1,0,0,0,480000,53,'true','true','true','true','0-0;'),
(9591,'Steel Bracelet','rbracelet','true','none',150,'wood','a',0,-1,0,0,0,1140000,76,'true','true','true','true','0-0;'),
(9592,'Mithril Bracelet','rbracelet','true','none',150,'wood','s',0,-1,0,0,0,3560000,171,'true','true','true','true','0-0;'),
(9605,'Agathion Seal Bracelet - Rainbow Clan Hall','lbracelet','true','none',150,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','3267-1;3269-1;5414-1;'),
(9606,'Agathion Seal Bracelet - Wild Beast Reserve','lbracelet','true','none',150,'wood','none',0,-1,0,0,0,30000000,0,'false','false','true','false','3267-1;3270-1;5413-1;'),
(9607,'Agathion Seal Bracelet - Gludio','lbracelet','true','none',150,'wood','none',0,-1,0,0,0,30000000,0,'false','false','true','false','3267-1;3268-1;5415-1;'),
(9608,'Agathion Seal Bracelet - Dion','lbracelet','true','none',150,'wood','none',0,-1,0,0,0,30000000,0,'false','false','true','false','3267-1;3268-1;5415-1;'),
(9609,'Agathion Seal Bracelet - Giran','lbracelet','true','none',150,'wood','none',0,-1,0,0,0,30000000,0,'false','false','true','false','3267-1;3268-1;5415-1;'),
(9610,'Agathion Seal Bracelet - Oren','lbracelet','true','none',150,'wood','none',0,-1,0,0,0,30000000,0,'false','false','true','false','3267-1;3268-1;5415-1;'),
(9611,'Agathion Seal Bracelet - Aden','lbracelet','true','none',150,'wood','none',0,-1,0,0,0,30000000,0,'false','false','true','false','3267-1;3268-1;5415-1;'),
(9612,'Agathion Seal Bracelet - Innadril','lbracelet','true','none',150,'wood','none',0,-1,0,0,0,30000000,0,'false','false','true','false','3267-1;3268-1;5415-1;'),
(9613,'Agathion Seal Bracelet - Goddard','lbracelet','true','none',150,'wood','none',0,-1,0,0,0,30000000,0,'false','false','true','false','3267-1;3268-1;5415-1;'),
(9614,'Agathion Seal Bracelet - Rune','lbracelet','true','none',150,'wood','none',0,-1,0,0,0,30000000,0,'false','false','true','false','3267-1;3268-1;5415-1;'),
(9615,'Agathion Seal Bracelet - Schuttgart','lbracelet','true','none',150,'wood','none',0,-1,0,0,0,30000000,0,'false','false','true','false','3267-1;3268-1;5415-1;'),
(9662,'Great Wolf Scale Armor','greatwolf','true','pet',160,'wood','none',0,-1,112,14,0,2033416,0,'true','true','true','true','0-0;'),
(9663,'Great Wolf Bronze Armor','greatwolf','true','pet',160,'wood','none',0,-1,124,14,0,3921666,0,'true','true','true','true','0-0;'),
(9664,'Great Wolf Plate Armor','greatwolf','true','pet',160,'wood','none',0,-1,136,14,0,7719833,0,'true','true','true','true','0-0;'),
(9665,'Great Wolf Mithril Armor','greatwolf','true','pet',160,'wood','none',0,-1,148,14,0,13609916,0,'true','true','true','true','0-0;'),
(9666,'Great Wolf Oriharukon Armor','greatwolf','true','pet',160,'wood','none',0,-1,160,14,0,26255666,0,'true','true','true','true','0-0;'),
(9667,'Great Wolf Orichalcum Armor','greatwolf','true','pet',160,'wood','none',0,-1,171,14,0,52952250,0,'true','true','true','true','0-0;'),
(9669,'Native Helmet','head','true','none',70,'wood','none',0,-1,33,0,0,0,0,'true','true','true','true','0-0;'),
(9670,'Native Tunic','chest','true','none',4720,'wood','none',0,-1,53,0,0,0,0,'true','true','true','true','0-0;'),
(9671,'Native Pants','legs','true','none',1700,'wood','none',0,-1,29,0,0,0,0,'true','true','true','true','0-0;'),
(9677,'Ring of Wind Mastery','rfinger,lfinger','true','none',150,'wood','none',0,-1,0,36,0,0,0,'true','true','true','true','0-0;'),
(9820,'Shadow Item: Clan Oath Helm','head','false','none',210,'wood','d',0,300,37,0,0,0,0,'false','false','true','false','0-0;'),
(9821,'Shadow Item: Clan Oath Armor','fullarmor','false','none',3290,'wood','d',0,300,158,0,0,0,0,'false','false','true','false','0-0;'),
(9822,'Shadow Item: Clan Oath Gauntlets - Heavy Armor','gloves','false','none',210,'wood','d',0,300,24,0,0,0,0,'false','false','true','false','0-0;'),
(9823,'Shadow Item: Clan Oath Sabaton - Heavy Armor','feet','false','none',430,'wood','d',0,300,24,0,0,0,0,'false','false','true','false','0-0;'),
(9824,'Shadow Item: Clan Oath Brigandine','fullarmor','false','none',1800,'wood','d',0,300,119,0,0,0,0,'false','false','true','false','0-0;'),
(9825,'Shadow Item: Clan Oath Leather Gloves - Light Armor','gloves','false','none',210,'wood','d',0,300,24,0,0,0,0,'false','false','true','false','0-0;'),
(9826,'Shadow Item: Clan Oath Boots - Light Armor','feet','false','none',430,'wood','d',0,300,24,0,0,0,0,'false','false','true','false','0-0;'),
(9827,'Shadow Item: Clan Oath Aketon','fullarmor','false','none',820,'wood','d',0,300,79,0,239,0,0,'false','false','true','false','0-0;'),
(9828,'Shadow Item: Clan Oath Padded Gloves - Robe','gloves','false','none',210,'wood','d',0,300,24,0,0,0,0,'false','false','true','false','0-0;'),
(9829,'Shadow Item: Clan Oath Sandals - Robe','feet','false','none',430,'wood','d',0,300,24,0,0,0,0,'false','false','true','false','0-0;'),
(9830,'Improved Apella Helm','head','true','none',570,'wood','a',0,-1,73,0,0,2030000,163,'true','true','true','true','0-0;'),
(9831,'Improved Apella Plate Armor','fullarmor','true','none',9780,'wood','a',0,-1,293,0,0,0,704,'true','true','true','true','0-0;'),
(9832,'Improved Apella Gauntlet - Heavy Armor','gloves','true','none',580,'wood','a',0,-1,49,0,0,1360000,108,'true','true','true','true','0-0;'),
(9833,'Improved Apella Solleret - Heavy Armor','feet','true','none',1130,'wood','a',0,-1,49,0,0,1360000,108,'true','true','true','true','0-0;'),
(9834,'Improved Apella Brigandine','fullarmor','true','none',5400,'wood','a',0,-1,220,0,0,6600000,526,'true','true','true','true','0-0;'),
(9835,'Improved Apella Leather Gloves - Light Armor','gloves','true','none',580,'wood','a',0,-1,49,0,0,1360000,108,'true','true','true','true','0-0;'),
(9836,'Improved Apella Boots - Light Armor','feet','true','none',1130,'wood','a',0,-1,49,0,0,1360000,108,'true','true','true','true','0-0;'),
(9837,'Improved Apella Doublet','fullarmor','true','none',2450,'wood','a',0,-1,147,0,718,6600000,526,'true','true','true','true','0-0;'),
(9838,'Improved Apella Silk Gloves - Robe','gloves','true','none',580,'wood','a',0,-1,49,0,0,1360000,108,'true','true','true','true','0-0;'),
(9839,'Improved Apella Sandals - Robe','feet','true','none',1130,'wood','a',0,-1,49,0,0,1360000,108,'true','true','true','true','0-0;'),
(9883,'Teddy Bear Hat - Big Head','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','3265-1;'),
(9884,'Piggy Hat - Big Head','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','3265-1;'),
(9885,'Jester Hat - Big Head','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','3265-1;'),
(9886,'Wizard Hat - Big Head','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','3265-1;'),
(9887,'Dapper Cap - Big Head','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','3265-1;'),
(9888,'Romantic Chapeau - Big Head','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','3265-1;'),
(9889,'Iron Circlet - Big Head','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','3265-1;'),
(9890,'Teddy Bear Hat - Firework','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','3266-1;'),
(9891,'Piggy Hat - Firework','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','3266-1;'),
(9892,'Jester Hat - Firework','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','3266-1;'),
(9893,'Wizard Hat - Firework','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','3266-1;'),
(9894,'Dapper Cap - Firework','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','3266-1;'),
(9895,'Romantic Chapeau - Firework','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','3266-1;'),
(9896,'Iron Circlet - Firework','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','3266-1;'),
(9899,'Weight Loss Ring','rfinger,lfinger','true','none',150,'wood','none',0,-1,0,7,0,0,0,'true','true','true','true','3406-1;'),
(9900,'Quiet Footsteps Ring','rfinger,lfinger','true','none',150,'wood','none',0,-1,0,7,0,0,0,'true','true','true','true','0-0;'),
(9909,'Agathion Seal Bracelet','lbracelet','true','none',150,'wood','none',0,500,0,0,0,0,0,'true','true','true','true','0-0;'),
(9913,'Talisman_Test','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','0-0;'),
(9914,'Blue Talisman of Power','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3271-1;'),
(9915,'Blue Talisman of Wild Magic','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3277-1;'),
(9916,'Blue Talisman of Defense','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3272-1;'),
(9917,'Red Talisman of Minimum Clarity','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3281-1;'),
(9918,'Red Talisman of Maximum Clarity','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3282-1;'),
(9919,'Blue Talisman of Reflection','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3410-1;'),
(9920,'Blue Talisman of Invisibility','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3280-1;'),
(9921,'Blue Talisman - Shield Protection','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3274-1;'),
(9922,'Black Talisman - Mending','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3286-1;'),
(9923,'Black Talisman - Escape','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3289-1;'),
(9924,'Blue Talisman of Healing','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3283-1;'),
(9925,'Red Talisman of Recovery','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3273-1;'),
(9926,'Blue Talisman of Defense','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3285-1;'),
(9927,'Blue Talisman of Magic Defense','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3276-1;'),
(9928,'Red Talisman of Mental Regeneration','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3278-1;'),
(9929,'Blue Talisman of Protection','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3275-1;'),
(9930,'Blue Talisman of Evasion','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3321-1;'),
(9931,'Red Talisman of Meditation','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3279-1;'),
(9932,'Blue Talisman of Invincibility','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3284-1;'),
(9933,'Yellow Talisman of Power','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3293-1;'),
(9934,'Yellow Talisman of Violent Haste','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3301-1;'),
(9935,'Yellow Talisman of Arcane Defense','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3296-1;'),
(9936,'Yellow Talisman of Arcane Power','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3294-1;'),
(9937,'Yellow Talisman of Arcane Haste','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3302-1;'),
(9938,'Yellow Talisman of Accuracy','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3297-1;'),
(9939,'Yellow Talisman of Defense','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3295-1;'),
(9940,'Yellow Talisman of Alacrity','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3313-1;'),
(9941,'Yellow Talisman of Speed','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3300-1;'),
(9942,'Yellow Talisman of Critical Reduction','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3317-1;'),
(9943,'Yellow Talisman of Critical Power','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3299-1;'),
(9944,'Yellow Talisman of Critical Dodging','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3316-1;'),
(9945,'Yellow Talisman of Evasion','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3298-1;'),
(9946,'Yellow Talisman of Healing','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3312-1;'),
(9947,'Yellow Talisman of CP Regeneration','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3311-1;'),
(9948,'Yellow Talisman of Physical Regeneration','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3310-1;'),
(9949,'Yellow Talisman of Mental Regeneration','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3320-1;'),
(9950,'Grey Talisman of Weight Training','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3314-1;'),
(9951,'Grey Talisman of Mid-Grade Fishing','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3315-1;'),
(9952,'Orange Talisman - Hot Springs Recovery','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3332-1;'),
(9953,'Orange Talisman - Elixir of Life','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3333-1;'),
(9954,'Orange Talisman - Elixir of Mental Strength','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3334-1;'),
(9955,'Black Talisman of Vocalization','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3291-1;'),
(9956,'Black Talisman of Arcane Freedom','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3288-1;'),
(9957,'Black Talisman of Physical Freedom','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3287-1;'),
(9958,'Black Talisman of Rescue','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3290-1;'),
(9959,'Black Talisman of Free Speech','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3292-1;'),
(9960,'White Talisman of Bravery','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3306-1;'),
(9961,'White Talisman of Motion','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3307-1;'),
(9962,'White Talisman of Grounding','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3305-1;'),
(9963,'White Talisman of Attention','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3304-1;'),
(9964,'White Talisman of Bandages','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3303-1;'),
(9965,'White Talisman of Protection','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3309-1;'),
(9966,'White Talisman of Freedom','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3308-1;'),
(10018,'Agathion Seal Bracelet - Fortress','lbracelet','true','none',150,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(10019,'Ring Mail Breastplate','chest','false','none',8820,'wood','none',0,-1,77,0,0,0,0,'false','false','true','false','0-0;'),
(10020,'Iron Plate Gaiters','legs','false','none',3820,'wood','none',0,-1,48,0,0,0,0,'false','false','true','false','0-0;'),
(10021,'Puma Skin Shirt','chest','false','none',4700,'wood','none',0,-1,58,0,0,0,0,'false','false','true','false','0-0;'),
(10022,'Puma Skin Gaiters','legs','false','none',1600,'wood','none',0,-1,36,0,0,0,0,'false','false','true','false','0-0;'),
(10023,'Cursed Tunic','chest','false','none',2090,'wood','none',0,-1,39,0,106,0,0,'false','false','true','false','0-0;'),
(10024,'Cursed Stockings','legs','false','none',1020,'wood','none',0,-1,24,0,66,0,0,'false','false','true','false','0-0;'),
(10122,'Red Crescent Earring','rear,lear','false','none',150,'silver','d',0,-1,0,24,0,0,0,'false','false','true','false','0-0;'),
(10123,'Necklace of Devotion','neck','false','none',150,'silver','d',0,-1,0,32,0,0,0,'false','false','true','false','0-0;'),
(10124,'Ring of Devotion','rfinger,lfinger','false','none',150,'gold','d',0,-1,0,16,0,0,0,'false','false','true','false','0-0;'),
(10126,'Dynasty Leather Armor - Force Master','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(10127,'Dynasty Leather Armor - Weapon Master','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(10139,'Agathion Bracelet','lbracelet','true','none',150,'wood','none',0,500,0,0,0,0,0,'false','false','true','false','0-0;'),
(10140,'Blessed Ring of Escape','rfinger,lfinger','true','none',150,'wood','none',0,-1,0,49,0,0,0,'true','true','true','true','3408-1;'),
(10141,'Grey Talisman - Yeti Transform','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3335-1;'),
(10142,'Grey Talisman - Buffalo Transform','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3336-1;'),
(10158,'Grey Talisman of Upper Grade Fishing','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'true','true','true','true','3315-1;'),
(10168,'Dynasty Leather Armor - Enchanter','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(10169,'Enchanter Circlet (Kamael only)','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(10170,'Baylor\'s Earring','rear,lear','true','none',150,'gold','s80',0,-1,0,71,31,0,0,'true','true','true','true','0-0;'),
(10175,'Gobblin Circlet (Event)','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(10176,'White Half Mask','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(10177,'Black Half Mask','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(10207,'Enhanced Striped Scale Shirt','chest','true','none',130,'wood','a',0,-1,26,0,0,0,59,'true','true','true','true','0-0;'),
(10208,'Enhanced Striped Mithril Shirt','chest','true','none',130,'wood','s',0,-1,30,0,70,2540000,122,'true','true','true','true','0-0;'),
(10209,'Enhanced Steel Bracelet','rbracelet','true','none',150,'wood','a',0,-1,0,0,0,0,76,'true','true','true','true','0-0;'),
(10210,'Enhanced Mithril Bracelet','rbracelet','true','none',150,'wood','s',0,-1,0,0,120,3560000,170,'true','true','true','true','0-0;'),
(10211,'Blessed Ring of Resurrection','rfinger,lfinger','true','none',150,'wood','none',0,120,0,30,0,0,0,'true','true','true','true','3409-1;'),
(10214,'Dynasty Leather Armor - Summoner','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(10227,'Dynasty Platinum Plate','chest','true','heavy',7570,'wood','s80',0,-1,220,0,0,0,0,'true','true','true','true','0-0;'),
(10228,'Dynasty Platinum Plate - Shield Master','chest','true','heavy',7570,'wood','s80',0,-1,220,0,0,0,0,'true','true','true','true','0-0;'),
(10229,'Dynasty Platinum Plate - Weapon Master','chest','true','heavy',7570,'wood','s80',0,-1,220,0,0,0,0,'true','true','true','true','0-0;'),
(10230,'Dynasty Platinum Plate - Force Master','chest','true','heavy',7570,'wood','s80',0,-1,220,0,0,0,0,'true','true','true','true','0-0;'),
(10231,'Dynasty Platinum Plate - Bard','chest','true','heavy',7570,'wood','s80',0,-1,220,0,0,0,0,'true','true','true','true','0-0;'),
(10232,'Dynasty Jewel Leather Mail','chest','true','light',4180,'wood','s80',0,-1,166,0,0,0,0,'true','true','true','true','0-0;'),
(10233,'Dynasty Jewel Leather Mail - Dagger Master','chest','true','light',4180,'wood','s80',0,-1,166,0,0,0,0,'true','true','true','true','0-0;'),
(10234,'Dynasty Jewel Leather Mail - Bow Master','chest','true','light',4180,'wood','s80',0,-1,166,0,0,0,0,'true','true','true','true','0-0;'),
(10235,'Dynasty Silver Satin Tunic','chest','true','magic',1780,'wood','s80',0,-1,110,0,592,0,0,'true','true','true','true','0-0;'),
(10236,'Dynasty Silver Satin Tunic - Healer','chest','true','magic',1780,'wood','s80',0,-1,110,0,592,0,0,'true','true','true','true','0-0;'),
(10237,'Dynasty Silver Satin Tunic - Enchanter','chest','true','magic',1780,'wood','s80',0,-1,110,0,592,0,0,'true','true','true','true','0-0;'),
(10238,'Dynasty Silver Satin Tunic - Summoner','chest','true','magic',1780,'wood','s80',0,-1,110,0,592,0,0,'true','true','true','true','0-0;'),
(10239,'Dynasty Silver Satin Tunic - Human Wizard','chest','true','magic',1780,'wood','s80',0,-1,110,0,592,0,0,'true','true','true','true','0-0;'),
(10240,'Bird Nest','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(10241,'Purple Viking Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(10242,'Golden Viking Circlet','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(10243,'Panda Hat','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(10244,'White Sheep Hat','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(10245,'Black Sheep Hat','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(10246,'Frog Hat','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(10247,'Fish Hat','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(10248,'Straw Hat','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(10249,'Chicken Hat','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(10250,'Explorer Hat','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(10251,'Medieval Party Mask','hairall','true','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(10273,'Wolf Summoning Bracelet','lbracelet','true','none',150,'wood','none',0,120,0,0,0,0,0,'true','true','true','true','0-0;'),
(10314,'Beleth\'s Ring','rfinger,lfinger','true','none',150,'wood','s',0,-1,0,0,48,0,152,'true','true','true','true','3649-1;'),
(10315,'Shadow Item - Purple Viking Circlet','hairall','true','none',10,'wood','none',0,500,0,0,0,0,0,'true','true','true','true','0-0;'),
(10316,'Agathion Seal Bracelet - Little Angel - Firecracker','lbracelet','true','none',150,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','3423-1;3267-1;'),
(10317,'Agathion Seal Bracelet - Little Angel - Big Head','lbracelet','true','none',150,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','3423-1;3267-1;'),
(10318,'Agathion Seal Bracelet - Little Angel - Escape','lbracelet','true','none',150,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','3423-1;3267-1;'),
(10319,'Agathion Seal Bracelet - Little Angel - Resurrection','lbracelet','true','none',150,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','3423-1;3267-1;'),
(10320,'Agathion Seal Bracelet - Little Angel','lbracelet','true','none',150,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','3423-1;3267-1;'),
(10321,'Shadow Item - Golden Viking Circlet','hairall','true','none',10,'wood','none',0,500,0,0,0,0,0,'true','true','true','true','0-0;'),
(10322,'Agathion Seal Bracelet - Little Devil - Firecracker','lbracelet','true','none',150,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','3424-1;3267-1;'),
(10323,'Agathion Seal Bracelet - Little Devil - Big Head','lbracelet','true','none',150,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','3424-1;3267-1;'),
(10324,'Agathion Seal Bracelet - Little Devil - Escape','lbracelet','true','none',150,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','3424-1;3267-1;'),
(10325,'Agathion Seal Bracelet - Little Devil - Resurrection','lbracelet','true','none',150,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','3424-1;3267-1;'),
(10326,'Agathion Seal Bracelet - Little Devil','lbracelet','true','none',150,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','3424-1;3267-1;'),
(10416,'Blue Talisman - Explosion','talisman','true','none',150,'wood','none',0,65,0,0,0,0,0,'false','false','true','false','0-0;'),
(10417,'Blue Talisman - Magic Explosion','talisman','true','none',150,'wood','none',0,65,0,0,0,0,0,'false','false','true','false','0-0;'),
(10418,'White Talisman - Storm','talisman','true','none',150,'wood','none',0,65,0,0,0,0,0,'false','false','true','false','0-0;'),
(10419,'White Talisman - Darkness','talisman','true','none',150,'wood','none',0,65,0,0,0,0,0,'false','false','true','false','0-0;'),
(10420,'White Talisman - Water','talisman','true','none',150,'wood','none',0,65,0,0,0,0,0,'false','false','true','false','0-0;'),
(10421,'White Talisman - Fire','talisman','true','none',150,'wood','none',0,65,0,0,0,0,0,'false','false','true','false','0-0;'),
(10422,'White Talisman - Light','talisman','true','none',150,'wood','none',0,65,0,0,0,0,0,'false','false','true','false','0-0;'),
(10423,'Blue Talisman - Self-Destruction','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'false','false','true','false','0-0;'),
(10424,'Blue Talisman - Greater Healing','talisman','true','none',150,'wood','none',0,65,0,0,0,0,0,'false','false','true','false','0-0;'),
(10470,'Shadow Item - Red Crescent','rear,lear','true','none',150,'wood','none',0,180,0,0,0,0,0,'false','false','true','false','0-0;'),
(10471,'Shadow Item - Ring of Devotion','rfinger,lfinger','true','none',150,'wood','none',0,180,0,0,0,0,0,'false','false','true','false','0-0;'),
(10472,'Shadow Item - Necklace of Devotion','neck','true','none',150,'wood','none',0,180,0,0,0,0,0,'false','false','true','false','0-0;'),
(10487,'Dynasty Jeweled Leather Armor - Force Master','chest','true','none',4180,'wood','s80',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(10488,'Dynasty Jeweled Leather Armor - Weapon Master','chest','true','none',4180,'wood','s80',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(10489,'Dynasty Jeweled Leather Armor - Enchanter','chest','true','none',4180,'wood','s80',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(10490,'Dynasty Jeweled Leather Armor - Summoner','chest','true','none',4180,'wood','s80',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(10491,'Silk Shirt - HP','underwear','true','none',130,'wood','c',0,-1,0,0,0,80000,27,'true','true','true','true','3439-1;'),
(10492,'Silk Shirt - MP','underwear','true','none',130,'wood','c',0,-1,0,0,0,80000,27,'true','true','true','true','3440-1;'),
(10493,'Silk Shirt - CP','underwear','true','none',130,'wood','c',0,-1,0,0,0,80000,27,'true','true','true','true','3441-1;'),
(10494,'Thin Leather Shirt - HP','underwear','true','none',130,'wood','b',0,-1,0,0,0,260000,29,'true','true','true','true','3445-1;'),
(10495,'Thin Leather Shirt - MP','underwear','true','none',130,'wood','b',0,-1,0,0,0,260000,29,'true','true','true','true','3446-1;'),
(10496,'Thin Leather Shirt - CP','underwear','true','none',130,'wood','b',0,-1,0,0,0,260000,29,'true','true','true','true','3447-1;'),
(10497,'Scale Shirt - HP','underwear','true','none',130,'wood','a',0,-1,0,0,0,588000,39,'true','true','true','true','3451-1;'),
(10498,'Scale Shirt - MP','underwear','true','none',130,'wood','a',0,-1,0,0,0,588000,39,'true','true','true','true','3452-1;'),
(10499,'Scale Shirt - CP','underwear','true','none',130,'wood','a',0,-1,0,0,0,588000,39,'true','true','true','true','3453-1;'),
(10500,'Mithril Shirt - HP','underwear','true','none',130,'wood','s',0,-1,0,0,0,1800000,86,'true','true','true','true','3457-1;'),
(10501,'Mithril Shirt - MP','underwear','true','none',130,'wood','s',0,-1,0,0,0,1800000,86,'true','true','true','true','3458-1;'),
(10502,'Mithril Shirt - CP','underwear','true','none',130,'wood','s',0,-1,0,0,0,1800000,86,'true','true','true','true','3459-1;'),
(10503,'Striped Silk Shirt - HP','underwear','true','none',130,'wood','c',0,-1,0,0,0,180000,60,'true','true','true','true','3463-1;'),
(10504,'Striped Silk Shirt - MP','underwear','true','none',130,'wood','c',0,-1,0,0,0,180000,60,'true','true','true','true','3464-1;'),
(10505,'Striped Silk Shirt - CP','underwear','true','none',130,'wood','c',0,-1,0,0,0,180000,60,'true','true','true','true','3465-1;'),
(10506,'Thin Striped Leather Shirt - HP','underwear','true','none',130,'wood','b',0,-1,0,0,0,400000,44,'true','true','true','true','3469-1;'),
(10507,'Thin Striped Leather Shirt - MP','underwear','true','none',130,'wood','b',0,-1,0,0,0,400000,44,'true','true','true','true','3470-1;'),
(10508,'Thin Striped Leather Shirt - CP','underwear','true','none',130,'wood','b',0,-1,0,0,0,400000,44,'true','true','true','true','3471-1;'),
(10509,'Striped Scale Shirt - HP','underwear','true','none',130,'wood','a',0,-1,0,0,0,880000,59,'true','true','true','true','3475-1;'),
(10510,'Striped Scale Shirt - MP','underwear','true','none',130,'wood','a',0,-1,0,0,0,880000,59,'true','true','true','true','3476-1;'),
(10511,'Striped Scale Shirt - CP','underwear','true','none',130,'wood','a',0,-1,0,0,0,880000,59,'true','true','true','true','3477-1;'),
(10512,'Striped Mithril Shirt - HP','underwear','true','none',130,'wood','s',0,-1,0,0,0,2540000,122,'true','true','true','true','3481-1;'),
(10513,'Striped Mithril Shirt - MP','underwear','true','none',130,'wood','s',0,-1,0,0,0,2540000,122,'true','true','true','true','3482-1;'),
(10514,'Striped Mithril Shirt - CP','underwear','true','none',130,'wood','s',0,-1,0,0,0,2540000,122,'true','true','true','true','3483-1;'),
(10518,'Red Talisman - Life Force','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'false','false','true','false','0-0;'),
(10519,'White Talisman -  Earth','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'false','false','true','false','0-0;'),
(10533,'Blue Talisman - Attack Power','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'false','false','true','false','3487-1;'),
(10534,'Blue Talisman - Shield Defense','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'false','false','true','false','3488-1;'),
(10535,'Yellow Talisman - Defense Power','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'false','false','true','false','3490-1;'),
(10536,'Yellow Talisman - Magic Power','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'false','false','true','false','3489-1;'),
(10537,'Yellow Talisman - Evasion','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'false','false','true','false','3491-1;'),
(10538,'Yellow Talisman - Healing Power','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'false','false','true','false','3495-1;'),
(10539,'Yellow Talisman - CP Recovery Rate','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'false','false','true','false','3494-1;'),
(10540,'Yellow Talisman - HP Recovery Rate','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'false','false','true','false','3493-1;'),
(10541,'Yellow Talisman - Low Grade MP regeneration rate','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'false','false','true','false','3497-1;'),
(10542,'Red Talisman - HP/CP Recovery','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'false','false','true','false','3496-1;'),
(10543,'Yellow Talisman - Speed','talisman','true','none',150,'wood','none',0,60,0,0,0,0,0,'false','false','true','false','3492-1;'),
(10606,'Agathion Seal Bracelet - Rudolph','lbracelet','true','none',150,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','3425-1;3267-1;'),
(10613,'Bird Nest (Event)','hairall','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(10614,'White Wool Hat (Event)','hairall','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(10615,'Black Wool Hat (Event)','hairall','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(10616,'Straw Hat (Event)','hairall','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(10617,'Ant Hat  - Year 2008','hairall','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(10618,'Ol Mahum Hat  - Year 2008','hairall','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(10619,'Wolf Hat  - Year 2008','hairall','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(10620,'Shadow Item - Ant Hat - Blessed Scroll of Escape','hairall','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(10621,'Shadow Item - Ant Hat - Blessed Scroll of Resurrection','hairall','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(10622,'Shadow Item - Ant Hat - Firecracker','hairall','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(10623,'Shadow Item - Ant Hat - Big Head','hairall','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(10624,'Shadow Item - Ol Mahum Hat - Blessed Scroll of Escape','hairall','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(10625,'Shadow Item - Ol Mahum Hat - Blessed Scroll of Resurrection','hairall','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(10626,'Shadow Item - Ol Mahum Hat - Firecracker','hairall','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(10627,'Shadow Item - Ol Mahum Hat - Big Head','hairall','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(10628,'Shadow Item - Wolf Hat - Blessed Scroll of Escape','hairall','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(10629,'Shadow Item - Wolf Hat - Blessed Scroll of Resurrection','hairall','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(10630,'Shadow Item - Wolf Hat - Firecracker','hairall','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(10631,'Shadow Item - Wolf Hat - Big Head','hairall','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(10658,'Pet Accessory (not used) ','underwear','false','none',150,'wood','none',0,-1,0,7,0,0,0,'true','true','true','true','0-0;'),
(10659,'Agathion Summon Bracelet - Monkey','underwear','false','none',150,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(10660,'Agathion Summon Bracelet - Griffin','underwear','false','none',150,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(10793,'Armor of Nightmare - PvP','fullarmor','true','heavy',9580,'wood','a',0,-1,293,0,0,8800000,704,'true','true','true','true','0-0;'),
(10794,'Majestic Plate Armor - PvP','fullarmor','true','heavy',9200,'wood','a',0,-1,293,0,0,8800000,704,'true','true','true','true','0-0;'),
(10795,'Leather Armor of Nightmare - PvP','fullarmor','true','light',5300,'wood','a',0,-1,220,0,0,6600000,528,'true','true','true','true','0-0;'),
(10796,'Majestic Leather Mail - PvP','fullarmor','true','light',5350,'wood','a',0,-1,220,0,0,6600000,528,'true','true','true','true','0-0;'),
(10797,'Robe of Nightmare - PvP','fullarmor','true','magic',2300,'wood','a',0,-1,147,0,718,6600000,528,'true','true','true','true','0-0;'),
(10798,'Majestic Robe - PvP','fullarmor','true','magic',2330,'wood','a',0,-1,147,0,718,6600000,528,'true','true','true','true','0-0;'),
(10799,'Imperial Crusader Breastplate - PvP','chest','true','heavy',7620,'wood','s',0,-1,205,0,0,12780000,613,'true','true','true','true','0-0;'),
(10800,'Draconic Leather Armor - PvP','fullarmor','true','light',4950,'wood','s',0,-1,249,0,0,15580000,748,'true','true','true','true','0-0;'),
(10801,'Major Arcana Robe - PvP','fullarmor','true','magic',2300,'wood','s',0,-1,166,0,866,15580000,748,'true','true','true','true','0-0;'),
(10802,'Dynasty Breastplate - PvP','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(10803,'Dynasty Breastplate - PvP - Shield Master','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(10804,'Dynasty Breastplate - PvP - Weapon Master','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(10805,'Dynasty Breastplate - PvP - Force Master','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(10806,'Dynasty Breastplate - PvP - Bard','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(10807,'Dynasty Leather Armor - PvP','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(10808,'Dynasty Leather Armor - PvP - Dagger Master','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(10809,'Dynasty Leather Armor - PvP - Bow Master','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(10810,'Dynasty Tunic - PvP','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(10811,'Dynasty Tunic - PvP - Healer','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(10812,'Dynasty Tunic - PvP - Enchanter','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(10813,'Dynasty Tunic - PvP - Summoner','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(10814,'Dynasty Tunic - PvP - Wizard','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(10815,'Dynasty Leather Armor - PvP - Force Master','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(10816,'Dynasty Leather Armor - PvP - Weapon Master','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(10817,'Dynasty Leather Armor - PvP - Enchanter','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(10818,'Dynasty Leather Armor - PvP - Summoner','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(10819,'Dynasty Platinum Breastplate - PvP','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(10820,'Dynasty Platinum Breastplate - PvP - Shield Master','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(10821,'Dynasty Platinum Breastplate - PvP - Weapon Master','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(10822,'Dynasty Platinum Breastplate - PvP - Force Master','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(10823,'Dynasty Platinum Breastplate - PvP - Bard','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(10824,'Dynasty Jewel Leather Armor - PvP','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(10825,'Dynasty Jewel Leather Armor - PvP - Dagger Master','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(10826,'Dynasty Jewel Leather Armor - PvP - Bow Master','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(10827,'Dynasty Silver Satin Tunic - PvP','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(10828,'Dynasty Silver Satin Tunic - PvP - Healer','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(10829,'Dynasty Silver Satin Tunic - PvP - Enchanter','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(10830,'Dynasty Silver Satin Tunic - PvP - Summoner','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(10831,'Dynasty Silver Satin Tunic - PvP - Wizard','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(10832,'Dynasty Jewel Leather Armor - PvP - Force Master','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(10833,'Dynasty Jewel Leather Armor - PvP - Weapon Master','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(10834,'Dynasty Jewel Leather Armor - PvP - Enchanter','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(10835,'Dynasty Jewel Leather Armor - PvP - Summoner','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(11349,'Sealed Zubei\'s Gauntlet','gloves','true','none',590,'wood','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(11350,'Sealed Zubei\'s Boots','feet','true','none',1180,'wood','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(11351,'Sealed Avadon Gloves','gloves','true','none',590,'wood','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(11352,'Sealed Avadon Boots','feet','true','none',1170,'wood','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(11353,'Zubei\'s Leather Gaiters','legs','true','light',1480,'wood','b',0,-1,73,0,0,973000,100,'true','true','true','true','0-0;'),
(11354,'Zubei\'s Leather Shirt','chest','true','light',4330,'wood','b',0,-1,117,0,0,1560000,160,'true','true','true','true','0-0;'),
(11355,'Zubei\'s Gaiters','legs','true','heavy',3570,'wood','b',0,-1,98,0,0,1300000,133,'true','true','true','true','0-0;'),
(11356,'Zubei\'s Gauntlet - Heavy Armor Use','gloves','true','none',590,'wood','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(11357,'Zubei\'s Gauntlet - Light Armor Use','gloves','true','none',590,'wood','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(11358,'Zubei\'s Gauntlet - Robe Use','gloves','true','none',590,'wood','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(11359,'Zubei\'s Boots - Heavy Armor Use','feet','true','none',1180,'wood','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(11360,'Zubei\'s Boots - Light Armor Use','feet','true','none',1180,'wood','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(11361,'Zubei\'s Boots - Robe Use','feet','true','none',1180,'wood','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(11363,'Zubei\'s Helmet - Heavy Armor Use','head','true','none',590,'wood','b',0,-1,62,0,0,778000,80,'true','true','true','true','0-0;'),
(11364,'Zubei\'s Breastplate','chest','true','heavy',7970,'wood','b',0,-1,157,0,0,2080000,213,'true','true','true','true','0-0;'),
(11365,'Avadon Gloves - Heavy Armor Use','gloves','true','none',590,'wood','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(11366,'Avadon Gloves - Light Armor Use','gloves','true','none',590,'wood','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(11367,'Avadon Gloves - Robe Use','gloves','true','none',590,'wood','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(11368,'Avadon Leather Armor','fullarmor','true','light',5600,'wood','b',0,-1,191,0,0,2280000,259,'true','true','true','true','0-0;'),
(11369,'Avadon Robe','fullarmor','true','magic',2540,'wood','b',0,-1,127,0,561,2280000,259,'true','true','true','true','0-0;'),
(11370,'Avadon Boots - Heavy Armor Use','feet','true','none',1180,'wood','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(11371,'Avadon Boots - Light Armor Use','feet','true','none',1180,'wood','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(11372,'Avadon Boots - Robe Use','feet','true','none',1180,'wood','b',0,-1,41,0,0,519000,53,'true','true','true','true','0-0;'),
(11373,'Avadon Circlet - Heavy Armor Use','head','true','none',590,'wood','b',0,-1,62,0,0,778000,80,'true','true','true','true','0-0;'),
(11375,'Avadon Gaiters','legs','true','heavy',3520,'wood','b',0,-1,98,0,0,1300000,133,'true','true','true','true','0-0;'),
(11376,'Avadon Breastplate','chest','true','heavy',7920,'wood','b',0,-1,157,0,0,2080000,213,'true','true','true','true','0-0;'),
(11377,'Tunic of Zubei','chest','true','magic',1960,'wood','b',0,-1,78,0,345,1560000,160,'true','true','true','true','0-0;'),
(11378,'Stockings of Zubei','legs','true','magic',940,'wood','b',0,-1,49,0,216,973000,100,'true','true','true','true','0-0;'),
(11379,'Doom Gloves - Heavy Armor Use','gloves','true','none',580,'wood','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(11380,'Doom Gloves - Light Armor Use','gloves','true','none',580,'wood','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(11381,'Doom Gloves - Robe Use','gloves','true','none',580,'wood','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(11382,'Doom Boots - Heavy Armor Use','feet','true','none',1130,'wood','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(11383,'Doom Boots - Light Armor Use','feet','true','none',1130,'wood','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(11384,'Doom Boots - Robe Use','feet','true','none',1130,'wood','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(11386,'Doom Plate Armor','fullarmor','true','heavy',9980,'wood','b',0,-1,270,0,0,4710000,536,'true','true','true','true','0-0;'),
(11387,'Doom Helmet - Heavy Armor Use','head','true','none',580,'wood','b',0,-1,66,0,0,1210000,124,'true','true','true','true','0-0;'),
(11388,'Leather Armor of Doom','fullarmor','true','light',5500,'wood','b',0,-1,202,0,0,3530000,402,'true','true','true','true','0-0;'),
(11389,'Sealed Doom Gloves','gloves','true','none',580,'wood','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(11390,'Sealed Boots of Doom','feet','true','none',1130,'wood','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(11391,'Sealed Blue Wolf Boots','feet','true','none',1130,'wood','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(11392,'Sealed Blue Wolf Gloves','gloves','true','none',590,'wood','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(11393,'Tunic of Doom','chest','true','magic',1900,'wood','b',0,-1,83,0,377,2410000,248,'true','true','true','true','0-0;'),
(11394,'Blue Wolf Gaiters','legs','true','heavy',3370,'wood','b',0,-1,104,0,0,2010000,206,'true','true','true','true','0-0;'),
(11395,'Blue Wolf Leather Armor','fullarmor','true','light',5500,'wood','b',0,-1,202,0,0,3530000,402,'true','true','true','true','0-0;'),
(11396,'Blue Wolf Boots - Heavy Armor Use','feet','true','none',1130,'wood','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(11397,'Blue Wolf Boots - Light Armor Use','feet','true','none',1130,'wood','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(11398,'Blue Wolf Boots - Robe Use','feet','true','none',1130,'wood','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(11399,'Blue Wolf Gloves - Heavy Armor Use','gloves','true','none',590,'wood','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(11400,'Blue Wolf Gloves - Light Armor Use','gloves','true','none',590,'wood','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(11401,'Blue Wolf Gloves - Robe Use','gloves','true','none',590,'wood','b',0,-1,44,0,0,804000,83,'true','true','true','true','0-0;'),
(11402,'Blue Wolf Tunic','chest','true','magic',1920,'wood','b',0,-1,83,0,377,2410000,248,'true','true','true','true','0-0;'),
(11403,'Blue Wolf Helmet - Heavy Armor Use','head','true','none',580,'wood','b',0,-1,66,0,0,1210000,124,'true','true','true','true','0-0;'),
(11404,'Blue Wolf Stockings','legs','true','magic',920,'wood','b',0,-1,52,0,236,1510000,155,'true','true','true','true','0-0;'),
(11405,'Blue Wolf Breastplate','chest','true','heavy',7820,'wood','b',0,-1,166,0,0,3220000,330,'true','true','true','true','0-0;'),
(11406,'Stockings of Doom','legs','true','magic',910,'wood','b',0,-1,52,0,236,1160000,155,'true','true','true','true','0-0;'),
(11407,'Dark Crystal Gaiters','legs','true','heavy',3320,'wood','a',0,-1,107,0,0,2890000,178,'true','true','true','true','0-0;'),
(11408,'Dark Crystal Gloves - Heavy Armor Use','gloves','true','none',580,'wood','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(11409,'Dark Crystal Gloves - Light Armor Use','gloves','true','none',580,'wood','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(11410,'Dark Crystal Gloves - Robe Use','gloves','true','none',580,'wood','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(11411,'Dark Crystal Leather Armor','chest','true','light',4300,'wood','a',0,-1,128,0,0,3470000,214,'true','true','true','true','0-0;'),
(11412,'Dark Crystal Robe','fullarmor','true','magic',2450,'wood','a',0,-1,139,0,665,5080000,347,'true','true','true','true','0-0;'),
(11413,'Dark Crystal Boots - Heavy Armor Use','feet','true','none',1110,'wood','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(11414,'Dark Crystal Boots - Light Armor Use','feet','true','none',1110,'wood','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(11415,'Dark Crystal Boots - Robe Use','feet','true','none',1110,'wood','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(11417,'Dark Crystal Helmet - Heavy Armor Use','head','true','none',570,'wood','a',0,-1,69,0,0,1740000,107,'true','true','true','true','0-0;'),
(11418,'Dark Crystal Breastplate','chest','true','heavy',7700,'wood','a',0,-1,171,0,0,4630000,285,'true','true','true','true','0-0;'),
(11419,'Dark Crystal Leggings','legs','true','light',1480,'wood','a',0,-1,80,0,0,2170000,134,'true','true','true','true','0-0;'),
(11420,'Sealed Dark Crystal Gaiters','legs','true','heavy',3320,'wood','a',0,-1,107,0,0,2890000,178,'true','true','true','true','0-0;'),
(11421,'Sealed Dark Crystal Gloves','gloves','true','none',580,'wood','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(11422,'Sealed Dark Crystal Leather Armor','chest','true','light',4300,'wood','a',0,-1,128,0,0,3470000,214,'true','true','true','true','0-0;'),
(11423,'Sealed Dark Crystal Robe','fullarmor','true','magic',2450,'wood','a',0,-1,139,0,665,5080000,347,'true','true','true','true','0-0;'),
(11424,'Sealed Dark Crystal Boots','feet','true','none',1110,'wood','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(11426,'Sealed Dark Crystal Helmet - Heavy Armor Use','head','true','none',570,'wood','a',0,-1,69,0,0,1740000,107,'true','true','true','true','0-0;'),
(11427,'Sealed Dark Crystal breastplate','chest','true','heavy',7700,'wood','a',0,-1,171,0,0,4630000,285,'true','true','true','true','0-0;'),
(11428,'Sealed Dark Crystal Leggings','legs','true','light',1480,'wood','a',0,-1,80,0,0,2170000,134,'true','true','true','true','0-0;'),
(11429,'Sealed Tallum Gloves','gloves','true','none',580,'wood','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(11430,'Sealed Tallum Leather Armor','fullarmor','true','light',5400,'wood','a',0,-1,209,0,0,5080000,347,'true','true','true','true','0-0;'),
(11431,'Sealed Tallum Boots','feet','true','none',1130,'wood','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(11432,'Sealed Tallum Tunic','chest','true','magic',1860,'wood','a',0,-1,86,0,409,3470000,214,'true','true','true','true','0-0;'),
(11433,'Sealed Tallum Plate Armor','fullarmor','true','heavy',9780,'wood','a',0,-1,278,0,0,6770000,463,'true','true','true','true','0-0;'),
(11434,'Sealed Tallum Helmet - Heavy Armor Use','head','true','none',570,'wood','a',0,-1,69,0,0,1740000,107,'true','true','true','true','0-0;'),
(11435,'Sealed Tallum Stockings','legs','true','magic',920,'wood','a',0,-1,53,0,256,2170000,134,'true','true','true','true','0-0;'),
(11436,'Holy Spirit\'s Cloak','underwear','true','none',220,'wood','a',0,-1,18,0,0,0,0,'true','true','true','true','0-0;'),
(11437,'Tallum Gloves - Heavy Armor Use','gloves','true','none',580,'wood','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(11438,'Tallum Gloves - Light Armor Use','gloves','true','none',580,'wood','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(11439,'Tallum Gloves - Robe Use','gloves','true','none',580,'wood','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(11440,'Tallum Leather Armor','fullarmor','true','light',5400,'wood','a',0,-1,209,0,0,5080000,347,'true','true','true','true','0-0;'),
(11441,'Tallum Boots - Heavy Armor Use','feet','true','none',1130,'wood','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(11442,'Tallum Boots - Light Armor Use','feet','true','none',1130,'wood','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(11443,'Tallum Boots - Robe Use','feet','true','none',1130,'wood','a',0,-1,46,0,0,1160000,71,'true','true','true','true','0-0;'),
(11444,'Tallum Tunic','chest','true','magic',1860,'wood','a',0,-1,86,0,409,3470000,214,'true','true','true','true','0-0;'),
(11445,'Tallum Plate Armor','fullarmor','true','heavy',9780,'wood','a',0,-1,278,0,0,6770000,463,'true','true','true','true','0-0;'),
(11446,'Tallum Helmet - Heavy Armor Use','head','true','none',570,'wood','a',0,-1,69,0,0,1740000,107,'true','true','true','true','0-0;'),
(11447,'Tallum Stockings','legs','true','magic',920,'wood','a',0,-1,53,0,256,2170000,134,'true','true','true','true','0-0;'),
(11448,'Majestic Gauntlet - Heavy Armor Use','gloves','true','none',540,'wood','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(11449,'Majestic Gauntlet - Light Armor Use','gloves','true','none',540,'wood','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(11450,'Majestic Gauntlet - Robe Use','gloves','true','none',540,'wood','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(11451,'Majestic Leather Armor','fullarmor','true','light',5350,'wood','a',0,-1,220,0,0,7730000,528,'true','true','true','true','0-0;'),
(11452,'Majestic Robe','fullarmor','true','magic',2330,'wood','a',0,-1,147,0,718,7730000,528,'true','true','true','true','0-0;'),
(11453,'Majestic Boots - Heavy Armor Use','feet','true','none',1110,'wood','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(11454,'Majestic Boots - Light Armor Use','feet','true','none',1110,'wood','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(11455,'Majestic Boots - Robe Use','feet','true','none',1110,'wood','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(11456,'Majestic Circlet - Heavy Armor Use','head','true','none',550,'wood','a',0,-1,73,0,0,2640000,163,'true','true','true','true','0-0;'),
(11457,'Majestic Plate Armor','fullarmor','true','heavy',9200,'wood','a',0,-1,293,0,0,10300000,704,'true','true','true','true','0-0;'),
(11458,'Sealed Majestic Gauntlet','gloves','true','none',540,'wood','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(11459,'Sealed Majestic Leather Armor','fullarmor','true','light',5350,'wood','a',0,-1,220,0,0,7730000,528,'true','true','true','true','0-0;'),
(11460,'Sealed Majestic Robe','fullarmor','true','magic',2330,'wood','a',0,-1,147,0,718,7730000,528,'true','true','true','true','0-0;'),
(11461,'Sealed Majestic Boots','feet','true','none',1110,'wood','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(11462,'Sealed Majestic Circlet - Heavy Armor Use','head','true','none',550,'wood','a',0,-1,73,0,0,2640000,163,'true','true','true','true','0-0;'),
(11463,'Sealed Majestic Plate Armor','fullarmor','true','heavy',9200,'wood','a',0,-1,293,0,0,10300000,704,'true','true','true','true','0-0;'),
(11464,'Sealed Armor of Nightmare','fullarmor','true','heavy',9580,'wood','a',0,-1,293,0,0,10300000,704,'true','true','true','true','0-0;'),
(11465,'Sealed Gauntlet of Nightmare','gloves','true','none',550,'wood','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(11466,'Sealed Leather Armor of Nightmare','fullarmor','true','light',5300,'wood','a',0,-1,220,0,0,7730000,528,'true','true','true','true','0-0;'),
(11467,'Sealed Nightmare Robe','fullarmor','true','magic',2300,'wood','a',0,-1,147,0,718,7730000,528,'true','true','true','true','0-0;'),
(11468,'Sealed Boots of Nightmare','feet','true','none',1110,'wood','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(11470,'Sealed Helm of Nightmare','head','true','none',560,'wood','a',0,-1,73,0,0,2640000,163,'true','true','true','true','0-0;'),
(11471,'Armor of Nightmare','fullarmor','true','heavy',9580,'wood','a',0,-1,293,0,0,10300000,704,'true','true','true','true','0-0;'),
(11472,'Gauntlet of Nightmare - Heavy Armor Use','gloves','true','none',550,'wood','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(11473,'Gauntlet of Nightmare - Light Armor Use','gloves','true','none',550,'wood','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(11474,'Gauntlet of Nightmare - Robe Use','gloves','true','none',550,'wood','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(11475,'Nightmarish Leather Armor','fullarmor','true','light',5300,'wood','a',0,-1,220,0,0,7730000,528,'true','true','true','true','0-0;'),
(11476,'Nightmare Robe','fullarmor','true','magic',2300,'wood','a',0,-1,147,0,718,7730000,528,'true','true','true','true','0-0;'),
(11477,'Boots of Nightmare - Heavy Armor Use','feet','true','none',1110,'wood','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(11478,'Boots of Nightmare - Light Armor Use','feet','true','none',1110,'wood','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(11479,'Boots of Nightmare - Robe Use','feet','true','none',1110,'wood','a',0,-1,49,0,0,1760000,108,'true','true','true','true','0-0;'),
(11481,'Helm of Nightmare - Heavy Armor Use','head','true','none',560,'wood','a',0,-1,73,0,0,2640000,163,'true','true','true','true','0-0;'),
(11482,'Great Wolf Oriharukon Armor','chest','false','light',160,'wood','none',0,-1,160,14,0,0,0,'true','true','true','true','0-0;'),
(11483,'Draconic Leather Gloves','gloves','true','none',540,'wood','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(11484,'Draconic Leather Boots','feet','true','none',1110,'wood','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(11485,'Draconic Leather Armor','fullarmor','true','light',4950,'wood','s',0,-1,249,0,0,17400000,748,'true','true','true','true','0-0;'),
(11486,'Draconic Leather Helmet','head','true','none',550,'wood','s',0,-1,83,0,0,5370000,230,'true','true','true','true','0-0;'),
(11487,'Major Arcana Gloves','gloves','true','none',540,'wood','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(11488,'Major Arcana Robe','fullarmor','true','magic',2300,'wood','s',0,-1,166,0,866,17400000,748,'true','true','true','true','0-0;'),
(11489,'Major Arcana Boots','feet','true','none',1110,'wood','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(11490,'Major Arcana Circlet','head','true','none',550,'wood','s',0,-1,83,0,0,5370000,230,'true','true','true','true','0-0;'),
(11491,'Sealed Draconic Leather Gloves','gloves','true','none',540,'wood','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(11492,'Sealed Draconic Leather Boots','feet','true','none',1110,'wood','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(11493,'Sealed Draconic Leather Armor','fullarmor','true','light',4950,'wood','s',0,-1,236,0,0,17400000,748,'true','true','true','true','0-0;'),
(11494,'Sealed Draconic Leather Helmet','head','true','none',550,'wood','s',0,-1,83,0,0,5370000,230,'true','true','true','true','0-0;'),
(11495,'Sealed Major Arcana Gloves','gloves','true','none',540,'wood','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(11496,'Sealed Major Arcana Robe','fullarmor','true','magic',2300,'wood','s',0,-1,157,0,866,17400000,748,'true','true','true','true','0-0;'),
(11497,'Sealed Major Arcana Boots','feet','true','none',1110,'wood','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(11498,'Sealed Major Arcana Circlet','head','true','none',550,'wood','s',0,-1,83,0,0,5370000,230,'true','true','true','true','0-0;'),
(11499,'Sealed Imperial Crusader Gaiters','legs','true','heavy',3260,'wood','s',0,-1,121,0,0,8960000,383,'true','true','true','true','0-0;'),
(11500,'Sealed Imperial Crusader Gauntlet','gloves','true','none',540,'wood','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(11501,'Sealed Imperial Crusader Boots','feet','true','none',1110,'wood','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(11503,'Sealed Imperial Crusader Helmet','head','true','none',550,'wood','s',0,-1,83,0,0,5370000,230,'true','true','true','true','0-0;'),
(11504,'Sealed Imperial Crusader Breastplate','chest','true','heavy',7620,'wood','s',0,-1,193,0,0,14300000,613,'true','true','true','true','0-0;'),
(11505,'Imperial Crusader Gaiters','legs','true','heavy',3260,'wood','s',0,-1,128,0,0,8960000,383,'true','true','true','true','0-0;'),
(11506,'Imperial Crusader Gauntlet','gloves','true','none',540,'wood','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(11507,'Imperial Crusader Boots','feet','true','none',1110,'wood','s',0,-1,55,0,0,3580000,153,'true','true','true','true','0-0;'),
(11509,'Imperial Crusader Helmet','head','true','none',550,'wood','s',0,-1,83,0,0,5370000,230,'true','true','true','true','0-0;'),
(11510,'Imperial Crusader Breastplate','chest','true','heavy',7620,'wood','s',0,-1,205,0,0,14300000,613,'true','true','true','true','0-0;'),
(11511,'Great Wolf Orichalcum Armor','chest','false','light',160,'wood','none',0,-1,171,14,0,0,0,'true','true','true','true','0-0;'),
(11512,'Dynasty Gaiters','legs','true','heavy',3210,'wood','s80',0,-1,141,0,0,0,0,'true','true','true','true','0-0;'),
(11513,'Dynasty Gauntlet','gloves','true','none',520,'wood','s80',0,-1,61,0,0,0,0,'true','true','true','true','0-0;'),
(11514,'Dynasty Gloves','gloves','true','none',520,'wood','s80',0,-1,61,0,0,0,0,'true','true','true','true','0-0;'),
(11515,'Dynasty Leather Gloves','gloves','true','none',520,'wood','s80',0,-1,61,0,0,0,0,'true','true','true','true','0-0;'),
(11516,'Dynasty Leather Leggings','legs','true','light',1370,'wood','s80',0,-1,106,0,0,0,0,'true','true','true','true','0-0;'),
(11517,'Dynasty Leather Armor','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(11518,'Dynasty Leather Armor','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(11519,'Dynasty Leather Armor','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(11520,'Dynasty Leather Armor','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(11521,'Dynasty Leather Armor','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(11522,'Dynasty Leather Armor','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(11523,'Dynasty Leather Armor','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(11524,'Dynasty Leather Boots','feet','true','none',1090,'wood','s80',0,-1,61,0,0,0,0,'true','true','true','true','0-0;'),
(11525,'Dynasty Leather Helmet','head','true','none',530,'wood','s80',0,-1,92,0,0,0,0,'true','true','true','true','0-0;'),
(11526,'Dynasty Boots','feet','true','none',1090,'wood','s80',0,-1,61,0,0,0,0,'true','true','true','true','0-0;'),
(11527,'Dynasty Breastplate','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(11528,'Dynasty Breastplate','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(11529,'Dynasty Breastplate','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(11530,'Dynasty Breastplate','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(11531,'Dynasty Breastplate','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(11533,'Dynasty Shoes','feet','true','none',1090,'wood','s80',0,-1,61,0,0,0,0,'true','true','true','true','0-0;'),
(11534,'Dynasty Silver Satin Tunic','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(11535,'Dynasty Silver Satin Tunic','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(11536,'Dynasty Silver Satin Tunic','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(11537,'Dynasty Silver Satin Tunic','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(11538,'Dynasty Silver Satin Tunic','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(11539,'Dynasty Circlet','head','true','none',530,'wood','s80',0,-1,92,0,0,0,0,'true','true','true','true','0-0;'),
(11540,'Dynasty Jewel Leather Mail','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(11541,'Dynasty Jewel Leather Mail','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(11542,'Dynasty Jewel Leather Mail','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(11543,'Dynasty Jewel Leather Mail','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(11544,'Dynasty Jewel Leather Mail','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(11545,'Dynasty Jewel Leather Mail','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(11546,'Dynasty Jewel Leather Mail','chest','true','light',4180,'wood','s80',0,-1,170,0,0,0,0,'true','true','true','true','0-0;'),
(11547,'Dynasty Tunic','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(11548,'Dynasty Tunic','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(11549,'Dynasty Tunic','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(11550,'Dynasty Tunic','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(11551,'Dynasty Tunic','chest','true','magic',1780,'wood','s80',0,-1,113,0,592,0,0,'true','true','true','true','0-0;'),
(11552,'Dynasty Platinum Plate','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(11553,'Dynasty Platinum Plate','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(11554,'Dynasty Platinum Plate','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(11555,'Dynasty Platinum Plate','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(11556,'Dynasty Platinum Plate','chest','true','heavy',7570,'wood','s80',0,-1,226,0,0,0,0,'true','true','true','true','0-0;'),
(11557,'Dynasty Helmet - Heavy Armor Use','head','true','none',530,'wood','s80',0,-1,92,0,0,0,0,'true','true','true','true','0-0;'),
(11558,'Dynasty Stockings','legs','true','magic',860,'wood','s80',0,-1,71,0,370,0,0,'true','true','true','true','0-0;'),
(11559,'Sealed Dynasty Gaiters','legs','true','heavy',3210,'wood','s80',0,-1,134,0,0,0,0,'true','true','true','true','0-0;'),
(11560,'Sealed Dynasty Gauntlet','gloves','true','none',520,'wood','s80',0,-1,61,0,0,0,0,'true','true','true','true','0-0;'),
(11561,'Sealed Dynasty Gloves','gloves','true','none',520,'wood','s80',0,-1,61,0,0,0,0,'true','true','true','true','0-0;'),
(11562,'Sealed Dynasty Leather Gloves','gloves','true','none',520,'wood','s80',0,-1,61,0,0,0,0,'true','true','true','true','0-0;'),
(11563,'Sealed Dynasty Leather Leggings','legs','true','light',1370,'wood','s80',0,-1,100,0,0,0,0,'true','true','true','true','0-0;'),
(11564,'Sealed Dynasty Leather Armor','chest','true','light',4180,'wood','s80',0,-1,161,0,0,0,0,'true','true','true','true','0-0;'),
(11565,'Sealed Dynasty Leather Boots','feet','true','none',1090,'wood','s80',0,-1,61,0,0,0,0,'true','true','true','true','0-0;'),
(11566,'Sealed Dynasty Leather Helmet','head','true','none',530,'wood','s80',0,-1,92,0,0,0,0,'true','true','true','true','0-0;'),
(11567,'Sealed Dynasty Boots','feet','true','none',1090,'wood','s80',0,-1,61,0,0,0,0,'true','true','true','true','0-0;'),
(11568,'Sealed Dynasty Breastplate','chest','true','heavy',7570,'wood','s80',0,-1,214,0,0,0,0,'true','true','true','true','0-0;'),
(11570,'Sealed Dynasty Shoes','feet','true','none',1090,'wood','s80',0,-1,61,0,0,0,0,'true','true','true','true','0-0;'),
(11571,'Sealed Dynasty Circlet','head','true','none',530,'wood','s80',0,-1,92,0,0,0,0,'true','true','true','true','0-0;'),
(11572,'Sealed Dynasty Tunic','chest','true','magic',1780,'wood','s80',0,-1,107,0,592,0,0,'true','true','true','true','0-0;'),
(11573,'Sealed Dynasty Helmet','head','true','none',530,'wood','s80',0,-1,92,0,0,0,0,'true','true','true','true','0-0;'),
(11574,'Sealed Dynasty Stockings','legs','true','magic',860,'wood','s80',0,-1,67,0,370,0,0,'true','true','true','true','0-0;'),
(11575,'Adamantite Earring','rear,lear','true','none',150,'wood','b',0,-1,0,51,0,606000,62,'true','true','true','true','0-0;'),
(11576,'Adamantite Necklace','neck','true','none',150,'wood','b',0,-1,0,68,0,808000,83,'true','true','true','true','0-0;'),
(11577,'Adamantite Ring','rfinger,lfinger','true','none',150,'wood','b',0,-1,0,34,0,404000,41,'true','true','true','true','0-0;'),
(11578,'Earring of Black Ore','rear,lear','true','none',150,'wood','b',0,-1,0,54,0,924000,95,'true','true','true','true','0-0;'),
(11579,'Necklace of Black Ore','neck','true','none',150,'wood','b',0,-1,0,72,0,1230000,126,'true','true','true','true','0-0;'),
(11580,'Ring of Black Ore','rfinger,lfinger','true','none',150,'wood','b',0,-1,0,36,0,616000,63,'true','true','true','true','0-0;'),
(11581,'Sealed Phoenix Necklace','neck','true','none',150,'wood','a',0,-1,0,76,0,2600000,107,'true','true','true','true','0-0;'),
(11582,'Sealed Phoenix Ring','rfinger,lfinger','true','none',150,'wood','a',0,-1,0,38,0,1300000,54,'true','true','true','true','0-0;'),
(11583,'Sealed Phoenix Earring','rear,lear','true','none',150,'wood','a',0,-1,0,57,0,1950000,80,'true','true','true','true','0-0;'),
(11584,'Phoenix Necklace','neck','true','none',150,'wood','a',0,-1,0,80,26,2600000,107,'true','true','true','true','0-0;'),
(11585,'Phoenix Ring','rfinger,lfinger','true','none',150,'wood','a',0,-1,0,40,13,1300000,54,'true','true','true','true','0-0;'),
(11586,'Phoenix Earring','rear,lear','true','none',150,'wood','a',0,-1,0,60,20,1950000,80,'true','true','true','true','0-0;'),
(11587,'Majestic Necklace','neck','true','none',150,'wood','a',0,-1,0,85,33,3450000,160,'true','true','true','true','0-0;'),
(11588,'Majestic Ring','rfinger,lfinger','true','none',150,'wood','a',0,-1,0,42,17,1730000,80,'true','true','true','true','0-0;'),
(11589,'Majestic Earring','rear,lear','true','none',150,'wood','a',0,-1,0,63,25,2590000,120,'true','true','true','true','0-0;'),
(11590,'Sealed Majestic Necklace','neck','true','none',150,'wood','a',0,-1,0,80,0,3450000,160,'true','true','true','true','0-0;'),
(11591,'Sealed Majestic Ring','rfinger,lfinger','true','none',150,'wood','a',0,-1,0,40,0,1730000,80,'true','true','true','true','0-0;'),
(11592,'Sealed Majestic Earring','rear,lear','true','none',150,'wood','a',0,-1,0,60,0,2590000,120,'true','true','true','true','0-0;'),
(11593,'Sealed Tateossian Necklace','neck','true','none',150,'wood','s',0,-1,0,91,0,5920000,209,'true','true','true','true','0-0;'),
(11594,'Sealed Tateossian Ring','rfinger,lfinger','true','none',150,'wood','s',0,-1,0,46,0,2960000,105,'true','true','true','true','0-0;'),
(11595,'Sealed Tateossian Earring','rear,lear','true','none',150,'wood','s',0,-1,0,68,0,4440000,157,'true','true','true','true','0-0;'),
(11596,'Tateossian Necklace','neck','true','none',150,'wood','s',0,-1,0,95,42,5920000,209,'true','true','true','true','0-0;'),
(11597,'Tateossian Ring','rfinger,lfinger','true','none',150,'wood','s',0,-1,0,48,21,2960000,105,'true','true','true','true','0-0;'),
(11598,'Tateossian Earring','rear,lear','true','none',150,'wood','s',0,-1,0,71,31,4440000,157,'true','true','true','true','0-0;'),
(11599,'Dynasty Necklace','neck','true','none',150,'wood','s80',0,-1,0,120,46,0,0,'true','true','true','true','0-0;'),
(11600,'Dynasty Ring','rfinger,lfinger','true','none',150,'wood','s80',0,-1,0,60,23,0,0,'true','true','true','true','0-0;'),
(11601,'Dynasty Earring','rear,lear','true','none',150,'wood','s80',0,-1,0,90,35,0,0,'true','true','true','true','0-0;'),
(11602,'Sealed Dynasty Necklace','neck','true','none',150,'wood','s80',0,-1,0,106,0,0,0,'true','true','true','true','0-0;'),
(11603,'Sealed Dynasty Ring','rfinger,lfinger','true','none',150,'wood','s80',0,-1,0,53,0,0,0,'true','true','true','true','0-0;'),
(11604,'Sealed Dynasty Earring','rear,lear','true','none',150,'wood','s80',0,-1,0,79,0,0,0,'true','true','true','true','0-0;'),
(12006,'Common Item - Leather Boots','feet','true','none',433,'wood','d',0,-1,19,0,0,890,2,'true','true','true','true','0-0;'),
(12007,'Common Item - Crafted Leather Gloves','gloves','true','none',650,'wood','d',0,-1,19,0,0,890,2,'true','true','true','true','0-0;'),
(12008,'Common Item - Ring Mail Breastplate','chest','true','heavy',2940,'wood','d',0,-1,77,0,0,3560,6,'true','true','true','true','0-0;'),
(12009,'Common Item - Bone Helmet','head','true','none',213,'wood','d',0,-1,29,0,0,1340,2,'true','true','true','true','0-0;'),
(12010,'Common Item - Cursed Tunic','chest','true','magic',697,'wood','d',0,-1,39,0,106,2670,5,'true','true','true','true','0-0;'),
(12011,'Common Item - Cursed Stockings','legs','true','magic',340,'wood','d',0,-1,24,0,66,1670,3,'true','true','true','true','0-0;'),
(12012,'Common Item - Iron Plate Gaiters','legs','true','heavy',1273,'wood','d',0,-1,48,0,0,2230,4,'true','true','true','true','0-0;'),
(12014,'Common Item - Puma Skin Gaiters','legs','true','light',533,'wood','d',0,-1,36,0,0,1670,3,'true','true','true','true','0-0;'),
(12015,'Common Item - Puma Skin Shirt','chest','true','light',1567,'wood','d',0,-1,58,0,0,2670,5,'true','true','true','true','0-0;'),
(12016,'Common Item - Leather Gauntlet','gloves','true','none',213,'wood','d',0,-1,22,0,0,1350,2,'true','true','true','true','0-0;'),
(12017,'Common Item - Dark Stockings','legs','true','magic',333,'wood','d',0,-1,27,0,79,2520,5,'true','true','true','true','0-0;'),
(12018,'Common Item - Mystic\'s Tunic','chest','true','magic',677,'wood','d',0,-1,43,0,126,4040,7,'true','true','true','true','0-0;'),
(12019,'Common Item - Mystic\'s Stockings','legs','true','magic',330,'wood','d',0,-1,27,0,79,2520,5,'true','true','true','true','0-0;'),
(12020,'Common Item - Lion Skin Gaiters','legs','true','light',523,'wood','d',0,-1,41,0,0,2520,5,'true','true','true','true','0-0;'),
(12021,'Common Item - Lion Skin Shirt','chest','true','light',1527,'wood','d',0,-1,65,0,0,4040,7,'true','true','true','true','0-0;'),
(12022,'Common Item - White Tunic','chest','true','magic',680,'wood','d',0,-1,43,0,126,4040,7,'true','true','true','true','0-0;'),
(12023,'Common Item - Scale Gaiters','legs','true','heavy',1287,'wood','d',0,-1,54,0,0,3360,6,'true','true','true','true','0-0;'),
(12024,'Common Item - Scale Mail','chest','true','heavy',2907,'wood','d',0,-1,87,0,0,5380,10,'true','true','true','true','0-0;'),
(12026,'Common Item - Elven Tunic','chest','true','magic',693,'wood','d',0,-1,43,0,126,4040,7,'true','true','true','true','0-0;'),
(12027,'Common Item - Elven Stockings','legs','true','magic',337,'wood','d',0,-1,27,0,79,2520,5,'true','true','true','true','0-0;'),
(12028,'Common Item - Bronze Helmet','head','true','none',210,'wood','d',0,-1,33,0,0,2020,4,'true','true','true','true','0-0;'),
(12029,'Common Item - Blue Buckskin Boots','feet','true','none',433,'wood','d',0,-1,22,0,0,1350,2,'true','true','true','true','0-0;'),
(12030,'Common Item - Dwarven Scale Mail','chest','true','heavy',2847,'wood','d',0,-1,95,0,0,7160,13,'true','true','true','true','0-0;'),
(12031,'Common Item - Mithril Breastplate','chest','true','heavy',2890,'wood','d',0,-1,95,0,0,7160,13,'true','true','true','true','0-0;'),
(12032,'Common Item - Compound Scale Mail','chest','true','heavy',2873,'wood','d',0,-1,95,0,0,7160,13,'true','true','true','true','0-0;'),
(12033,'Common Item - Iron Boots','feet','true','none',427,'wood','d',0,-1,24,0,0,1960,4,'true','true','true','true','0-0;'),
(12034,'Common Item - Reinforced Leather Gaiters','legs','true','light',523,'wood','d',0,-1,46,0,0,3680,7,'true','true','true','true','0-0;'),
(12035,'Common Item - Reinforced Leather Boots','feet','true','none',427,'wood','d',0,-1,24,0,0,1960,4,'true','true','true','true','0-0;'),
(12036,'Common Item - Reinforced Leather Shirt','chest','true','light',1523,'wood','d',0,-1,73,0,0,5890,11,'true','true','true','true','0-0;'),
(12037,'Common Item - Reinforced Leather Gloves','gloves','true','none',213,'wood','d',0,-1,24,0,0,1960,4,'true','true','true','true','0-0;'),
(12038,'Common Item - Gauntlet','gloves','true','none',213,'wood','d',0,-1,24,0,0,1960,4,'true','true','true','true','0-0;'),
(12039,'Common Item - Dwarven Scale Gaiters','legs','true','heavy',1280,'wood','d',0,-1,61,0,0,4910,9,'true','true','true','true','0-0;'),
(12040,'Common Item - Linen Shirt','underwear','true','none',43,'wood','d',0,-1,12,0,0,0,0,'true','true','true','true','0-0;'),
(12041,'Common Item - Mithril Gaiters','legs','true','heavy',1277,'wood','d',0,-1,61,0,0,4910,9,'true','true','true','true','0-0;'),
(12042,'Common Item - Mithril Banded Gaiters','legs','true','light',527,'wood','d',0,-1,46,0,0,3680,7,'true','true','true','true','0-0;'),
(12043,'Common Item - Mithril Banded Mail','chest','true','light',1523,'wood','d',0,-1,73,0,0,5890,11,'true','true','true','true','0-0;'),
(12044,'Common Item - Blast Plate','chest','true','heavy',2807,'wood','d',0,-1,97,0,0,7860,14,'true','true','true','true','0-0;'),
(12045,'Common Item - Boots of Knowledge','feet','true','none',423,'wood','d',0,-1,24,0,0,1960,4,'true','true','true','true','0-0;'),
(12046,'Common Item - Gloves of Knowledge','gloves','true','none',213,'wood','d',0,-1,24,0,0,1960,4,'true','true','true','true','0-0;'),
(12047,'Common Item - Tunic of Knowledge','chest','true','magic',673,'wood','d',0,-1,49,0,147,5890,11,'true','true','true','true','0-0;'),
(12048,'Common Item - Stockings of Knowledge','legs','true','magic',333,'wood','d',0,-1,30,0,92,3680,7,'true','true','true','true','0-0;'),
(12049,'Common Item - Compound Scale Gaiters','legs','true','heavy',1257,'wood','d',0,-1,61,0,0,4910,9,'true','true','true','true','0-0;'),
(12050,'Common Item - Helmet','head','true','none',213,'wood','d',0,-1,37,0,0,2950,5,'true','true','true','true','0-0;'),
(12052,'Common Item - Manticore Skin Gaiters','legs','true','light',517,'wood','d',0,-1,48,0,0,5220,9,'true','true','true','true','0-0;'),
(12053,'Common Item - Manticore Skin Boots','feet','true','none',420,'wood','d',0,-1,27,0,0,2780,5,'true','true','true','true','0-0;'),
(12054,'Common Item - Manticore Skin Shirt','chest','true','light',1507,'wood','d',0,-1,77,0,0,8350,15,'true','true','true','true','0-0;'),
(12055,'Common Item - Manticore Skin Gloves','gloves','true','none',210,'wood','d',0,-1,27,0,0,2780,5,'true','true','true','true','0-0;'),
(12056,'Common Item - Mithril Scale Gaiters','legs','true','heavy',1290,'wood','d',0,-1,64,0,0,6960,13,'true','true','true','true','0-0;'),
(12057,'Common Item - Mithril Tunic','chest','true','magic',670,'wood','d',0,-1,52,0,169,8350,15,'true','true','true','true','0-0;'),
(12058,'Common Item - Mithril Stockings','legs','true','magic',327,'wood','d',0,-1,32,0,105,5220,9,'true','true','true','true','0-0;'),
(12059,'Common Item - Brigandine','chest','true','heavy',2773,'wood','d',0,-1,103,0,0,11100,20,'true','true','true','true','0-0;'),
(12060,'Common Item - Brigandine Gaiters','legs','true','heavy',1273,'wood','d',0,-1,64,0,0,6960,13,'true','true','true','true','0-0;'),
(12061,'Common Item - Brigandine Gauntlet','gloves','true','none',210,'wood','d',0,-1,27,0,0,2780,5,'true','true','true','true','0-0;'),
(12062,'Common Item - Brigandine Boots','feet','true','none',417,'wood','d',0,-1,27,0,0,2780,5,'true','true','true','true','0-0;'),
(12064,'Common Item - Brigandine Helmet','head','true','none',210,'wood','d',0,-1,41,0,0,4170,8,'true','true','true','true','0-0;'),
(12065,'Common Item - Elven Mithril Gloves','gloves','true','none',213,'wood','d',0,-1,27,0,0,2780,5,'true','true','true','true','0-0;'),
(12066,'Common Item - Elven Mithril Boots','feet','true','none',417,'wood','d',0,-1,27,0,0,2780,5,'true','true','true','true','0-0;'),
(12067,'Common Item - Striped Linen Shirt','underwear','true','none',43,'wood','d',0,-1,14,0,0,0,0,'true','true','true','true','0-0;'),
(12068,'Common Item - Rip Gauntlet','gloves','true','none',210,'wood','d',0,-1,27,0,0,2780,5,'true','true','true','true','0-0;'),
(12070,'Common Item - Boots of Power','feet','true','none',417,'wood','d',0,-1,27,0,0,2780,5,'true','true','true','true','0-0;'),
(12071,'Common Item - Assault Boots','feet','true','none',413,'wood','d',0,-1,29,0,0,3560,6,'true','true','true','true','0-0;'),
(12072,'Common Item - Mithril Gloves','gloves','true','none',210,'wood','d',0,-1,29,0,0,3560,6,'true','true','true','true','0-0;'),
(12074,'Common Item - Salamander Skin Mail','fullarmor','true','light',2033,'wood','d',0,-1,136,0,0,17300,31,'true','true','true','true','0-0;'),
(12075,'Common Item - Salamander Skin Boots','feet','true','none',410,'wood','d',0,-1,29,0,0,3560,6,'true','true','true','true','0-0;'),
(12076,'Common Item - Ogre Power Gauntlet','gloves','true','none',207,'wood','d',0,-1,29,0,0,3560,6,'true','true','true','true','0-0;'),
(12077,'Common Item - Plate Boots','feet','true','none',413,'wood','d',0,-1,29,0,0,3560,6,'true','true','true','true','0-0;'),
(12079,'Common Item - Plate Helmet','head','true','none',210,'wood','d',0,-1,44,0,0,5340,10,'true','true','true','true','0-0;'),
(12080,'Common Item - Plate Gaiters','legs','true','heavy',1257,'wood','d',0,-1,70,0,0,8890,16,'true','true','true','true','0-0;'),
(12081,'Common Item - Half Plate Armor','chest','true','heavy',2740,'wood','d',0,-1,111,0,0,14200,26,'true','true','true','true','0-0;'),
(12082,'Common Item - Sage\'s Worn Gloves','gloves','true','none',210,'wood','d',0,-1,29,0,0,3560,6,'true','true','true','true','0-0;'),
(12083,'Common Item - Sage\'s Rag','fullarmor','true','magic',160,'wood','d',0,-1,90,0,320,17300,31,'true','true','true','true','0-0;'),
(12084,'Common Item - Tempered Mithril Gaiters','legs','true','light',510,'wood','c',0,-1,56,0,0,8430,3,'true','true','true','true','0-0;'),
(12085,'Common Item - Tempered Mithril Boots','feet','true','none',410,'wood','c',0,-1,32,0,0,4500,2,'true','true','true','true','0-0;'),
(12086,'Common Item - Tempered Mithril Shirt','chest','true','light',1490,'wood','c',0,-1,90,0,0,13500,5,'true','true','true','true','0-0;'),
(12087,'Common Item - Reinforced Mithril Gloves','gloves','true','none',207,'wood','c',0,-1,32,0,0,4500,2,'true','true','true','true','0-0;'),
(12088,'Common Item - Dwarven Chain Boots','feet','true','none',403,'wood','c',0,-1,32,0,0,4500,2,'true','true','true','true','0-0;'),
(12089,'Common Item - Boots of Seal','feet','true','none',407,'wood','c',0,-1,32,0,0,4500,2,'true','true','true','true','0-0;'),
(12090,'Common Item - Chain Hood','head','true','none',207,'wood','c',0,-1,47,0,0,6750,3,'true','true','true','true','0-0;'),
(12092,'Common Item - Chain Gloves','gloves','true','none',207,'wood','c',0,-1,32,0,0,4500,2,'true','true','true','true','0-0;'),
(12093,'Common Item - Chain Boots','feet','true','none',407,'wood','c',0,-1,32,0,0,4500,2,'true','true','true','true','0-0;'),
(12094,'Common Item - Chain Gaiters','legs','true','heavy',1227,'wood','c',0,-1,75,0,0,11200,4,'true','true','true','true','0-0;'),
(12095,'Common Item - Chain Mail Shirt','chest','true','heavy',2707,'wood','c',0,-1,120,0,0,18000,7,'true','true','true','true','0-0;'),
(12097,'Common Item - Karmian Gloves','gloves','true','none',207,'wood','c',0,-1,32,0,0,4500,2,'true','true','true','true','0-0;'),
(12098,'Common Item - Karmian Boots','feet','true','none',410,'wood','c',0,-1,32,0,0,4500,2,'true','true','true','true','0-0;'),
(12099,'Common Item - Karmian Tunic','chest','true','magic',660,'wood','c',0,-1,60,0,225,13500,5,'true','true','true','true','0-0;'),
(12100,'Common Item - Karmian Stockings','legs','true','magic',323,'wood','c',0,-1,37,0,141,8430,3,'true','true','true','true','0-0;'),
(12101,'Common Item - Plate Leather Boots','feet','true','none',407,'wood','c',0,-1,32,0,0,4500,2,'true','true','true','true','0-0;'),
(12103,'Common Item - Plate Leather Gaiters','legs','true','light',520,'wood','c',0,-1,59,0,0,11200,4,'true','true','true','true','0-0;'),
(12104,'Common Item - Plate Leather Gloves','gloves','true','none',203,'wood','c',0,-1,33,0,0,4500,2,'true','true','true','true','0-0;'),
(12105,'Common Item - Plate Leather Armor','chest','true','light',1483,'wood','c',0,-1,94,0,0,18000,7,'true','true','true','true','0-0;'),
(12106,'Common Item - Great Helmet','head','true','none',203,'wood','c',0,-1,51,0,0,8420,3,'true','true','true','true','0-0;'),
(12108,'Common Item - Dwarven Chain Gloves','gloves','true','none',200,'wood','c',0,-1,34,0,0,5620,2,'true','true','true','true','0-0;'),
(12109,'Common Item - Dwarven Chain Gaiters','legs','true','heavy',1207,'wood','c',0,-1,80,0,0,14000,6,'true','true','true','true','0-0;'),
(12110,'Common Item - Dwarven Chain Mail Shirt','chest','true','heavy',2690,'wood','c',0,-1,129,0,0,22500,9,'true','true','true','true','0-0;'),
(12111,'Common Item - Rind Leather Gaiters','legs','true','light',517,'wood','c',0,-1,60,0,0,10500,4,'true','true','true','true','0-0;'),
(12112,'Common Item - Rind Leather Gloves','gloves','true','none',200,'wood','c',0,-1,34,0,0,5620,2,'true','true','true','true','0-0;'),
(12113,'Common Item - Rind Leather Armor','chest','true','light',1473,'wood','c',0,-1,97,0,0,16800,7,'true','true','true','true','0-0;'),
(12114,'Common Item - Rind Leather Boots','feet','true','none',407,'wood','c',0,-1,34,0,0,5620,2,'true','true','true','true','0-0;'),
(12115,'Common Item - Robe of Seal','fullarmor','true','magic',833,'wood','c',0,-1,105,0,413,27400,11,'true','true','true','true','0-0;'),
(12116,'Common Item - Gloves of Seal','gloves','true','none',207,'wood','c',0,-1,34,0,0,5620,2,'true','true','true','true','0-0;'),
(12117,'Common Item - Silk Shirt','underwear','true','none',43,'wood','c',0,-1,17,0,0,0,0,'true','true','true','true','0-0;'),
(12118,'Common Item - Crimson Boots','feet','true','none',403,'wood','c',0,-1,34,0,0,5620,2,'true','true','true','true','0-0;'),
(12119,'Common Item - Mithril Gauntlet','gloves','true','none',200,'wood','c',0,-1,36,0,0,10400,4,'true','true','true','true','0-0;'),
(12120,'Common Item - Shining Circlet','head','true','none',200,'wood','c',0,-1,54,0,0,15600,6,'true','true','true','true','0-0;'),
(12121,'Common Item - Demon\'s Boots','feet','true','none',407,'wood','c',0,-1,36,0,0,10400,4,'true','true','true','true','0-0;'),
(12122,'Common Item - Demon\'s Gloves','gloves','true','none',203,'wood','c',0,-1,36,0,0,10400,4,'true','true','true','true','0-0;'),
(12123,'Common Item - Demon\'s Tunic','chest','true','magic',663,'wood','c',0,-1,69,0,284,31200,12,'true','true','true','true','0-0;'),
(12124,'Common Item - Demon\'s Stockings','legs','true','magic',327,'wood','c',0,-1,43,0,177,19500,8,'true','true','true','true','0-0;'),
(12125,'Common Item - Composite Boots','feet','true','none',407,'wood','c',0,-1,36,0,0,10400,4,'true','true','true','true','0-0;'),
(12127,'Common Item - Composite Helmet','head','true','none',203,'wood','c',0,-1,54,0,0,15600,6,'true','true','true','true','0-0;'),
(12128,'Common Item - Composite Armor','fullarmor','true','heavy',3660,'wood','c',0,-1,224,0,0,67700,27,'true','true','true','true','0-0;'),
(12130,'Common Item - Theca Leather Gaiters','legs','true','light',510,'wood','c',0,-1,66,0,0,21000,8,'true','true','true','true','0-0;'),
(12131,'Common Item - Theca Leather Gloves','gloves','true','none',200,'wood','c',0,-1,37,0,0,11200,4,'true','true','true','true','0-0;'),
(12132,'Common Item - Theca Leather Boots','feet','true','none',403,'wood','c',0,-1,37,0,0,11200,4,'true','true','true','true','0-0;'),
(12133,'Common Item - Theca Leather Armor','chest','true','light',1457,'wood','c',0,-1,106,0,0,33600,13,'true','true','true','true','0-0;'),
(12134,'Common Item - Drake Leather Gloves','gloves','true','none',200,'wood','c',0,-1,39,0,0,16300,7,'true','true','true','true','0-0;'),
(12135,'Common Item - Drake Leather Armor','fullarmor','true','light',1933,'wood','c',0,-1,179,0,0,79500,32,'true','true','true','true','0-0;'),
(12136,'Common Item - Drake Leather Boots','feet','true','none',403,'wood','c',0,-1,39,0,0,16300,7,'true','true','true','true','0-0;'),
(12137,'Common Item - Divine Gloves','gloves','true','none',203,'wood','c',0,-1,39,0,0,16300,7,'true','true','true','true','0-0;'),
(12138,'Common Item - Divine Tunic','chest','true','magic',660,'wood','c',0,-1,74,0,314,48900,20,'true','true','true','true','0-0;'),
(12139,'Common Item - Divine Stockings','legs','true','magic',320,'wood','c',0,-1,46,0,196,30600,12,'true','true','true','true','0-0;'),
(12140,'Common Item - Stripe Silk Shirt','underwear','true','none',43,'wood','c',0,-1,19,0,0,0,0,'true','true','true','true','0-0;'),
(12141,'Common Item - Full Plate Gauntlet','gloves','true','none',200,'wood','c',0,-1,39,0,0,16300,7,'true','true','true','true','0-0;'),
(12142,'Common Item - Full Plate Boots','feet','true','none',400,'wood','c',0,-1,39,0,0,16300,7,'true','true','true','true','0-0;'),
(12144,'Common Item - Full Plate Armor','fullarmor','true','heavy',3493,'wood','c',0,-1,239,0,0,106000,42,'true','true','true','true','0-0;'),
(12145,'Common Item - Full Plate Helmet','head','true','none',200,'wood','c',0,-1,58,0,0,24500,10,'true','true','true','true','0-0;'),
(12146,'Common Item - Sealed Zubei\'s Gauntlet','gloves','true','none',197,'wood','b',0,-1,41,0,0,20900,3,'true','true','true','true','0-0;'),
(12147,'Common Item - Sealed Zubei\'s Boots','feet','true','none',393,'wood','b',0,-1,41,0,0,20900,3,'true','true','true','true','0-0;'),
(12148,'Common Item - Sealed Avadon Gloves','gloves','true','none',197,'wood','b',0,-1,41,0,0,20900,3,'true','true','true','true','0-0;'),
(12149,'Common Item - Sealed Avadon Boots','feet','true','none',390,'wood','b',0,-1,41,0,0,20900,3,'true','true','true','true','0-0;'),
(12150,'Common Item - Zubei\'s Leather Gaiters','legs','true','light',493,'wood','b',0,-1,73,0,0,39100,5,'true','true','true','true','0-0;'),
(12151,'Common Item - Zubei\'s Leather Shirt','chest','true','light',1443,'wood','b',0,-1,117,0,0,62600,8,'true','true','true','true','0-0;'),
(12152,'Common Item - Zubei\'s Gaiters','legs','true','heavy',1190,'wood','b',0,-1,98,0,0,52200,7,'true','true','true','true','0-0;'),
(12153,'Common Item - Zubei\'s Gauntlet','gloves','true','none',197,'wood','b',0,-1,41,0,0,20900,3,'true','true','true','true','0-0;'),
(12154,'Common Item - Zubei\'s Gauntlet','gloves','true','none',197,'wood','b',0,-1,41,0,0,20900,3,'true','true','true','true','0-0;'),
(12155,'Common Item - Zubei\'s Gauntlet','gloves','true','none',197,'wood','b',0,-1,41,0,0,20900,3,'true','true','true','true','0-0;'),
(12156,'Common Item - Zubei\'s Boots','feet','true','none',393,'wood','b',0,-1,41,0,0,20900,3,'true','true','true','true','0-0;'),
(12157,'Common Item - Zubei\'s Boots','feet','true','none',393,'wood','b',0,-1,41,0,0,20900,3,'true','true','true','true','0-0;'),
(12158,'Common Item - Zubei\'s Boots','feet','true','none',393,'wood','b',0,-1,41,0,0,20900,3,'true','true','true','true','0-0;'),
(12160,'Common Item - Zubei\'s Helmet','head','true','none',197,'wood','b',0,-1,62,0,0,31300,4,'true','true','true','true','0-0;'),
(12161,'Common Item - Zubei\'s Breastplate','chest','true','heavy',2657,'wood','b',0,-1,157,0,0,83500,11,'true','true','true','true','0-0;'),
(12162,'Common Item - Avadon Gloves','gloves','true','none',197,'wood','b',0,-1,41,0,0,20900,3,'true','true','true','true','0-0;'),
(12163,'Common Item - Avadon Gloves','gloves','true','none',197,'wood','b',0,-1,41,0,0,20900,3,'true','true','true','true','0-0;'),
(12164,'Common Item - Avadon Gloves','gloves','true','none',197,'wood','b',0,-1,41,0,0,20900,3,'true','true','true','true','0-0;'),
(12165,'Common Item - Avadon Leather Armor','fullarmor','true','light',1867,'wood','b',0,-1,191,0,0,102000,14,'true','true','true','true','0-0;'),
(12166,'Common Item - Avadon Robe','fullarmor','true','magic',847,'wood','b',0,-1,127,0,561,102000,14,'true','true','true','true','0-0;'),
(12167,'Common Item - Avadon Boots','feet','true','none',393,'wood','b',0,-1,41,0,0,20900,3,'true','true','true','true','0-0;'),
(12168,'Common Item - Avadon Boots','feet','true','none',393,'wood','b',0,-1,41,0,0,20900,3,'true','true','true','true','0-0;'),
(12169,'Common Item - Avadon Boots','feet','true','none',393,'wood','b',0,-1,41,0,0,20900,3,'true','true','true','true','0-0;'),
(12170,'Common Item - Avadon Circlet','head','true','none',197,'wood','b',0,-1,62,0,0,31300,4,'true','true','true','true','0-0;'),
(12172,'Common Item - Avadon Plate Gaiters','legs','true','heavy',1173,'wood','b',0,-1,98,0,0,52200,7,'true','true','true','true','0-0;'),
(12173,'Common Item - Avadon Breastplate','chest','true','heavy',2640,'wood','b',0,-1,157,0,0,83500,11,'true','true','true','true','0-0;'),
(12174,'Common Item - Thin Leather Shirt','underwear','true','none',43,'wood','b',0,-1,21,0,0,0,0,'true','true','true','true','0-0;'),
(12175,'Common Item - Tunic of Zubei','chest','true','magic',653,'wood','b',0,-1,78,0,345,62600,8,'true','true','true','true','0-0;'),
(12176,'Common Item - Stockings of Zubei','legs','true','magic',313,'wood','b',0,-1,49,0,216,39100,5,'true','true','true','true','0-0;'),
(12177,'Common Item - Doom Gloves','gloves','true','none',193,'wood','b',0,-1,44,0,0,37600,5,'true','true','true','true','0-0;'),
(12178,'Common Item - Doom Gloves','gloves','true','none',193,'wood','b',0,-1,44,0,0,37600,5,'true','true','true','true','0-0;'),
(12179,'Common Item - Doom Gloves','gloves','true','none',193,'wood','b',0,-1,44,0,0,37600,5,'true','true','true','true','0-0;'),
(12180,'Common Item - Doom Boots','feet','true','none',377,'wood','b',0,-1,44,0,0,37600,5,'true','true','true','true','0-0;'),
(12181,'Common Item - Doom Boots','feet','true','none',377,'wood','b',0,-1,44,0,0,37600,5,'true','true','true','true','0-0;'),
(12182,'Common Item - Doom Boots','feet','true','none',377,'wood','b',0,-1,44,0,0,37600,5,'true','true','true','true','0-0;'),
(12184,'Common Item - Doom Plate Armor','fullarmor','true','heavy',3327,'wood','b',0,-1,270,0,0,244000,33,'true','true','true','true','0-0;'),
(12185,'Common Item - Doom Helmet','head','true','none',193,'wood','b',0,-1,66,0,0,56300,8,'true','true','true','true','0-0;'),
(12186,'Common Item - Leather Armor of Doom','fullarmor','true','light',1833,'wood','b',0,-1,202,0,0,183000,24,'true','true','true','true','0-0;'),
(12187,'Common Item - Sealed Doom Gloves','gloves','true','none',193,'wood','b',0,-1,44,0,0,37600,5,'true','true','true','true','0-0;'),
(12188,'Common Item - Sealed Doom Boots','feet','true','none',377,'wood','b',0,-1,44,0,0,37600,5,'true','true','true','true','0-0;'),
(12189,'Common Item - Sealed Blue Wolf Boots','feet','true','none',377,'wood','b',0,-1,44,0,0,37600,5,'true','true','true','true','0-0;'),
(12190,'Common Item - Sealed Blue Wolf Gloves','gloves','true','none',197,'wood','b',0,-1,44,0,0,37600,5,'true','true','true','true','0-0;'),
(12191,'Common Item - Thin Stripe Leather Shirt','underwear','true','none',43,'wood','b',0,-1,22,0,0,0,0,'true','true','true','true','0-0;'),
(12192,'Common Item - Tunic of Doom','chest','true','magic',633,'wood','b',0,-1,83,0,377,112700,15,'true','true','true','true','0-0;'),
(12193,'Common Item - Blue Wolf Gaiters','legs','true','heavy',1123,'wood','b',0,-1,104,0,0,93900,13,'true','true','true','true','0-0;'),
(12194,'Common Item - Blue Wolf Leather Armor','fullarmor','true','light',1833,'wood','b',0,-1,202,0,0,183000,24,'true','true','true','true','0-0;'),
(12195,'Common Item - Blue Wolf Boots','feet','true','none',377,'wood','b',0,-1,44,0,0,37600,5,'true','true','true','true','0-0;'),
(12196,'Common Item - Blue Wolf Boots','feet','true','none',377,'wood','b',0,-1,44,0,0,37600,5,'true','true','true','true','0-0;'),
(12197,'Common Item - Blue Wolf Boots','feet','true','none',377,'wood','b',0,-1,44,0,0,37600,5,'true','true','true','true','0-0;'),
(12198,'Common Item - Blue Wolf Gloves','gloves','true','none',197,'wood','b',0,-1,44,0,0,37600,5,'true','true','true','true','0-0;'),
(12199,'Common Item - Blue Wolf Gloves','gloves','true','none',197,'wood','b',0,-1,44,0,0,37600,5,'true','true','true','true','0-0;'),
(12200,'Common Item - Blue Wolf Gloves','gloves','true','none',197,'wood','b',0,-1,44,0,0,37600,5,'true','true','true','true','0-0;'),
(12201,'Common Item - Blue Wolf Tunic','chest','true','magic',640,'wood','b',0,-1,83,0,377,112700,15,'true','true','true','true','0-0;'),
(12202,'Common Item - Blue Wolf Helmet','head','true','none',193,'wood','b',0,-1,66,0,0,56300,8,'true','true','true','true','0-0;'),
(12203,'Common Item - Blue Wolf Stockings','legs','true','magic',307,'wood','b',0,-1,52,0,236,70400,9,'true','true','true','true','0-0;'),
(12204,'Common Item - Blue Wolf Breastplate','chest','true','heavy',2607,'wood','b',0,-1,166,0,0,150200,20,'true','true','true','true','0-0;'),
(12205,'Common Item - Stockings of Doom','legs','true','magic',303,'wood','b',0,-1,52,0,236,70400,9,'true','true','true','true','0-0;'),
(12206,'Common Item - Dark Crystal Gaiters','legs','true','heavy',1107,'wood','a',0,-1,107,0,0,115000,9,'true','true','true','true','0-0;'),
(12207,'Common Item - Dark Crystal Gloves','gloves','true','none',193,'wood','a',0,-1,46,0,0,45900,4,'true','true','true','true','0-0;'),
(12208,'Common Item - Dark Crystal Gloves','gloves','true','none',193,'wood','a',0,-1,46,0,0,45900,4,'true','true','true','true','0-0;'),
(12209,'Common Item - Dark Crystal Gloves','gloves','true','none',193,'wood','a',0,-1,46,0,0,45900,4,'true','true','true','true','0-0;'),
(12210,'Common Item - Dark Crystal Leather Armor','chest','true','light',1433,'wood','a',0,-1,128,0,0,137700,11,'true','true','true','true','0-0;'),
(12211,'Common Item - Dark Crystal Robe','fullarmor','true','magic',817,'wood','a',0,-1,139,0,665,224000,18,'true','true','true','true','0-0;'),
(12212,'Common Item - Dark Crystal Boots','feet','true','none',370,'wood','a',0,-1,46,0,0,45900,4,'true','true','true','true','0-0;'),
(12213,'Common Item - Dark Crystal Boots','feet','true','none',370,'wood','a',0,-1,46,0,0,45900,4,'true','true','true','true','0-0;'),
(12214,'Common Item - Dark Crystal Boots','feet','true','none',370,'wood','a',0,-1,46,0,0,45900,4,'true','true','true','true','0-0;'),
(12216,'Common Item - Dark Crystal Helmet','head','true','none',190,'wood','a',0,-1,69,0,0,68800,6,'true','true','true','true','0-0;'),
(12217,'Common Item - Dark Crystal Breastplate','chest','true','heavy',2567,'wood','a',0,-1,171,0,0,183500,15,'true','true','true','true','0-0;'),
(12218,'Common Item - Dark Crystal Leggings','legs','true','light',493,'wood','a',0,-1,80,0,0,86000,7,'true','true','true','true','0-0;'),
(12219,'Common Item - Barbed Shirt','underwear','true','none',43,'wood','a',0,-1,23,0,0,0,0,'true','true','true','true','0-0;'),
(12220,'Common Item - Sealed Dark Crystal Gaiters','legs','true','heavy',1107,'wood','a',0,-1,107,0,0,115000,9,'true','true','true','true','0-0;'),
(12221,'Common Item - Sealed Dark Crystal Gloves','gloves','true','none',193,'wood','a',0,-1,46,0,0,45900,4,'true','true','true','true','0-0;'),
(12222,'Common Item - Sealed Dark Crystal Leather Armor','chest','true','light',1433,'wood','a',0,-1,128,0,0,137700,11,'true','true','true','true','0-0;'),
(12223,'Common Item - Sealed Dark Crystal Robe','fullarmor','true','magic',817,'wood','a',0,-1,139,0,665,224000,18,'true','true','true','true','0-0;'),
(12224,'Common Item - Sealed Dark Crystal Boots','feet','true','none',370,'wood','a',0,-1,46,0,0,45900,4,'true','true','true','true','0-0;'),
(12226,'Common Item - Sealed Dark Crystal Helmet','head','true','none',190,'wood','a',0,-1,69,0,0,68800,6,'true','true','true','true','0-0;'),
(12227,'Common Item - Sealed Dark Crystal Breastplate','chest','true','heavy',2567,'wood','a',0,-1,171,0,0,183500,15,'true','true','true','true','0-0;'),
(12228,'Common Item - Sealed Dark Crystal Leggings','legs','true','light',493,'wood','a',0,-1,80,0,0,86000,7,'true','true','true','true','0-0;'),
(12229,'Common Item - Sealed Tallum Gloves','gloves','true','none',193,'wood','a',0,-1,46,0,0,45900,4,'true','true','true','true','0-0;'),
(12230,'Common Item - Sealed Tallum Leather Armor','fullarmor','true','light',1800,'wood','a',0,-1,209,0,0,224000,18,'true','true','true','true','0-0;'),
(12231,'Common Item - Sealed Tallum Boots','feet','true','none',377,'wood','a',0,-1,46,0,0,45900,4,'true','true','true','true','0-0;'),
(12232,'Common Item - Sealed Tallum Tunic','chest','true','magic',620,'wood','a',0,-1,86,0,409,137700,11,'true','true','true','true','0-0;'),
(12233,'Common Item - Sealed Tallum Plate Armor','fullarmor','true','heavy',3260,'wood','a',0,-1,278,0,0,298000,24,'true','true','true','true','0-0;'),
(12234,'Common Item - Sealed Tallum Helmet','head','true','none',190,'wood','a',0,-1,69,0,0,68800,6,'true','true','true','true','0-0;'),
(12235,'Common Item - Sealed Tallum Stockings','legs','true','magic',307,'wood','a',0,-1,53,0,256,86000,7,'true','true','true','true','0-0;'),
(12236,'Common Item - Tallum Gloves','gloves','true','none',193,'wood','a',0,-1,46,0,0,45900,4,'true','true','true','true','0-0;'),
(12237,'Common Item - Tallum Gloves','gloves','true','none',193,'wood','a',0,-1,46,0,0,45900,4,'true','true','true','true','0-0;'),
(12238,'Common Item - Tallum Gloves','gloves','true','none',193,'wood','a',0,-1,46,0,0,45900,4,'true','true','true','true','0-0;'),
(12239,'Common Item - Tallum Leather Armor','fullarmor','true','light',1800,'wood','a',0,-1,209,0,0,224000,18,'true','true','true','true','0-0;'),
(12240,'Common Item - Tallum Boots','feet','true','none',377,'wood','a',0,-1,46,0,0,45900,4,'true','true','true','true','0-0;'),
(12241,'Common Item - Tallum Boots','feet','true','none',377,'wood','a',0,-1,46,0,0,45900,4,'true','true','true','true','0-0;'),
(12242,'Common Item - Tallum Boots','feet','true','none',377,'wood','a',0,-1,46,0,0,45900,4,'true','true','true','true','0-0;'),
(12243,'Common Item - Tallum Tunic','chest','true','magic',620,'wood','a',0,-1,86,0,409,137700,11,'true','true','true','true','0-0;'),
(12244,'Common Item - Tallum Plate Armor','fullarmor','true','heavy',3260,'wood','a',0,-1,278,0,0,298000,24,'true','true','true','true','0-0;'),
(12245,'Common Item - Tallum Helmet','head','true','none',190,'wood','a',0,-1,69,0,0,68800,6,'true','true','true','true','0-0;'),
(12246,'Common Item - Tallum Stockings','legs','true','magic',307,'wood','a',0,-1,53,0,256,86000,7,'true','true','true','true','0-0;'),
(12247,'Common Item - Majestic Gauntlet','gloves','true','none',180,'wood','a',0,-1,49,0,0,73500,6,'true','true','true','true','0-0;'),
(12248,'Common Item - Majestic Gauntlet','gloves','true','none',180,'wood','a',0,-1,49,0,0,73500,6,'true','true','true','true','0-0;'),
(12249,'Common Item - Majestic Gauntlet','gloves','true','none',180,'wood','a',0,-1,49,0,0,73500,6,'true','true','true','true','0-0;'),
(12250,'Common Item - Majestic Leather Armor','fullarmor','true','light',1783,'wood','a',0,-1,220,0,0,358000,29,'true','true','true','true','0-0;'),
(12251,'Common Item - Majestic Robe','fullarmor','true','magic',777,'wood','a',0,-1,147,0,718,358000,29,'true','true','true','true','0-0;'),
(12252,'Common Item - Majestic Boots','feet','true','none',370,'wood','a',0,-1,49,0,0,73500,6,'true','true','true','true','0-0;'),
(12253,'Common Item - Majestic Boots','feet','true','none',370,'wood','a',0,-1,49,0,0,73500,6,'true','true','true','true','0-0;'),
(12254,'Common Item - Majestic Boots','feet','true','none',370,'wood','a',0,-1,49,0,0,73500,6,'true','true','true','true','0-0;'),
(12255,'Common Item - Majestic Circlet','head','true','none',183,'wood','a',0,-1,73,0,0,110200,9,'true','true','true','true','0-0;'),
(12256,'Common Item - Majestic Plate Armor','fullarmor','true','heavy',3067,'wood','a',0,-1,293,0,0,477000,38,'true','true','true','true','0-0;'),
(12257,'Common Item - Sealed Majestic Gauntlet','gloves','true','none',180,'wood','a',0,-1,49,0,0,73500,6,'true','true','true','true','0-0;'),
(12258,'Common Item - Sealed Majestic Leather Armor','fullarmor','true','light',1783,'wood','a',0,-1,220,0,0,358000,29,'true','true','true','true','0-0;'),
(12259,'Common Item - Sealed Majestic Robe','fullarmor','true','magic',777,'wood','a',0,-1,147,0,718,358000,29,'true','true','true','true','0-0;'),
(12260,'Common Item - Sealed Majestic Boots','feet','true','none',370,'wood','a',0,-1,49,0,0,73500,6,'true','true','true','true','0-0;'),
(12261,'Common Item - Sealed Majestic Circlet','head','true','none',183,'wood','a',0,-1,73,0,0,110200,9,'true','true','true','true','0-0;'),
(12262,'Common Item - Sealed Majestic Plate Armor','fullarmor','true','heavy',3067,'wood','a',0,-1,293,0,0,477000,38,'true','true','true','true','0-0;'),
(12263,'Common Item - Sealed Armor of Nightmare','fullarmor','true','heavy',3193,'wood','a',0,-1,293,0,0,477000,38,'true','true','true','true','0-0;'),
(12264,'Common Item - Sealed Gauntlet of Nightmare','gloves','true','none',183,'wood','a',0,-1,49,0,0,73500,6,'true','true','true','true','0-0;'),
(12265,'Common Item - Sealed Leather Armor of Nightmare','fullarmor','true','light',1767,'wood','a',0,-1,220,0,0,358000,29,'true','true','true','true','0-0;'),
(12266,'Common Item - Sealed Nightmare Robe','fullarmor','true','magic',767,'wood','a',0,-1,147,0,718,358000,29,'true','true','true','true','0-0;'),
(12267,'Common Item - Sealed Boots of Nightmare','feet','true','none',370,'wood','a',0,-1,49,0,0,73500,6,'true','true','true','true','0-0;'),
(12269,'Common Item - Sealed Helm of Nightmare','head','true','none',187,'wood','a',0,-1,73,0,0,110200,9,'true','true','true','true','0-0;'),
(12270,'Common Item - Armor of Nightmare','fullarmor','true','heavy',3193,'wood','a',0,-1,293,0,0,477000,38,'true','true','true','true','0-0;'),
(12271,'Common Item - Gauntlet of Nightmare','gloves','true','none',183,'wood','a',0,-1,49,0,0,73500,6,'true','true','true','true','0-0;'),
(12272,'Common Item - Gauntlet of Nightmare','gloves','true','none',183,'wood','a',0,-1,49,0,0,73500,6,'true','true','true','true','0-0;'),
(12273,'Common Item - Gauntlet of Nightmare','gloves','true','none',183,'wood','a',0,-1,49,0,0,73500,6,'true','true','true','true','0-0;'),
(12274,'Common Item - Nightmarish Leather Armor','fullarmor','true','light',1767,'wood','a',0,-1,220,0,0,358000,29,'true','true','true','true','0-0;'),
(12275,'Common Item - Nightmare Robe','fullarmor','true','magic',767,'wood','a',0,-1,147,0,718,358000,29,'true','true','true','true','0-0;'),
(12276,'Common Item - Boots of Nightmare','feet','true','none',370,'wood','a',0,-1,49,0,0,73500,6,'true','true','true','true','0-0;'),
(12277,'Common Item - Boots of Nightmare','feet','true','none',370,'wood','a',0,-1,49,0,0,73500,6,'true','true','true','true','0-0;'),
(12278,'Common Item - Boots of Nightmare','feet','true','none',370,'wood','a',0,-1,49,0,0,73500,6,'true','true','true','true','0-0;'),
(12280,'Common Item - Helm of Nightmare','head','true','none',187,'wood','a',0,-1,73,0,0,110200,9,'true','true','true','true','0-0;'),
(12281,'Common Item - Stripe Barbed Shirt','underwear','true','none',43,'wood','a',0,-1,26,0,0,0,0,'true','true','true','true','0-0;'),
(12282,'Common Item - Draconic Leather Gloves','gloves','true','none',180,'wood','s',0,-1,55,0,0,0,0,'true','true','true','true','0-0;'),
(12283,'Common Item - Draconic Leather Boots','feet','true','none',370,'wood','s',0,-1,55,0,0,0,0,'true','true','true','true','0-0;'),
(12284,'Common Item - Draconic Leather Armor','fullarmor','true','light',1650,'wood','s',0,-1,249,0,0,0,0,'true','true','true','true','0-0;'),
(12285,'Common Item - Draconic Leather Helmet','head','true','none',183,'wood','s',0,-1,83,0,0,0,0,'true','true','true','true','0-0;'),
(12286,'Common Item - Major Arcana Gloves','gloves','true','none',180,'wood','s',0,-1,55,0,0,0,0,'true','true','true','true','0-0;'),
(12287,'Common Item - Major Arcana Robe','fullarmor','true','magic',767,'wood','s',0,-1,166,0,866,0,0,'true','true','true','true','0-0;'),
(12288,'Common Item - Major Arcana Boots','feet','true','none',370,'wood','s',0,-1,55,0,0,0,0,'true','true','true','true','0-0;'),
(12289,'Common Item - Major Arcana Circlet','head','true','none',183,'wood','s',0,-1,83,0,0,0,0,'true','true','true','true','0-0;'),
(12290,'Common Item - Mithril Shirt','underwear','true','none',43,'wood','s',0,-1,28,0,0,0,0,'true','true','true','true','0-0;'),
(12291,'Common Item - Sealed Draconic Leather Gloves','gloves','true','none',180,'wood','s',0,-1,55,0,0,0,0,'true','true','true','true','0-0;'),
(12292,'Common Item - Sealed Draconic Leather Boots','feet','true','none',370,'wood','s',0,-1,55,0,0,0,0,'true','true','true','true','0-0;'),
(12293,'Common Item - Sealed Draconic Leather Armor','fullarmor','true','light',1650,'wood','s',0,-1,236,0,0,0,0,'true','true','true','true','0-0;'),
(12294,'Common Item - Sealed Draconic Leather Helmet','head','true','none',183,'wood','s',0,-1,83,0,0,0,0,'true','true','true','true','0-0;'),
(12295,'Common Item - Sealed Major Arcana Gloves','gloves','true','none',180,'wood','s',0,-1,55,0,0,0,0,'true','true','true','true','0-0;'),
(12296,'Common Item - Sealed Major Arcana Robe','fullarmor','true','magic',767,'wood','s',0,-1,157,0,866,0,0,'true','true','true','true','0-0;'),
(12297,'Common Item - Sealed Major Arcana Boots','feet','true','none',370,'wood','s',0,-1,55,0,0,0,0,'true','true','true','true','0-0;'),
(12298,'Common Item - Sealed Major Arcana Circlet','head','true','none',183,'wood','s',0,-1,83,0,0,0,0,'true','true','true','true','0-0;'),
(12299,'Common Item - Sealed Imperial Crusader Gaiters','legs','true','heavy',1087,'wood','s',0,-1,121,0,0,0,0,'true','true','true','true','0-0;'),
(12300,'Common Item - Sealed Imperial Crusader Gauntlet','gloves','true','none',180,'wood','s',0,-1,55,0,0,0,0,'true','true','true','true','0-0;'),
(12301,'Common Item - Sealed Imperial Crusader Boots','feet','true','none',370,'wood','s',0,-1,55,0,0,0,0,'true','true','true','true','0-0;'),
(12303,'Common Item - Sealed Imperial Crusader Helmet','head','true','none',183,'wood','s',0,-1,83,0,0,0,0,'true','true','true','true','0-0;'),
(12304,'Common Item - Sealed Imperial Crusader Breastplate','chest','true','heavy',2540,'wood','s',0,-1,193,0,0,0,0,'true','true','true','true','0-0;'),
(12305,'Common Item - Imperial Crusader Gaiters','legs','true','heavy',1087,'wood','s',0,-1,128,0,0,0,0,'true','true','true','true','0-0;'),
(12306,'Common Item - Imperial Crusader Gauntlet','gloves','true','none',180,'wood','s',0,-1,55,0,0,0,0,'true','true','true','true','0-0;'),
(12307,'Common Item - Imperial Crusader Boots','feet','true','none',370,'wood','s',0,-1,55,0,0,0,0,'true','true','true','true','0-0;'),
(12309,'Common Item - Imperial Crusader Helmet','head','true','none',183,'wood','s',0,-1,83,0,0,0,0,'true','true','true','true','0-0;'),
(12310,'Common Item - Imperial Crusader Breastplate','chest','true','heavy',2540,'wood','s',0,-1,205,0,0,0,0,'true','true','true','true','0-0;'),
(12311,'Common Item - Red Crescent','rear,lear','true','none',50,'wood','d',0,-1,0,24,0,1150,2,'true','true','true','true','0-0;'),
(12312,'Common Item - Necklace of Devotion','neck','true','none',50,'wood','d',0,-1,0,32,0,1530,3,'true','true','true','true','0-0;'),
(12313,'Common Item - Ring of Devotion','rfinger,lfinger','true','none',50,'wood','d',0,-1,0,16,0,765,1,'true','true','true','true','0-0;'),
(12314,'Common Item - Enchanted Earring','rear,lear','true','none',50,'wood','d',0,-1,0,27,0,1720,3,'true','true','true','true','0-0;'),
(12315,'Common Item - Enchanted Necklace','neck','true','none',50,'wood','d',0,-1,0,36,0,2290,4,'true','true','true','true','0-0;'),
(12316,'Common Item - Enchanted Ring','rfinger,lfinger','true','none',50,'wood','d',0,-1,0,18,0,1150,2,'true','true','true','true','0-0;'),
(12317,'Common Item - Near Forest Necklace','neck','true','none',50,'wood','d',0,-1,0,40,0,3320,6,'true','true','true','true','0-0;'),
(12318,'Common Item - Tiger\'s Eye','rear,lear','true','none',50,'wood','d',0,-1,0,30,0,2490,5,'true','true','true','true','0-0;'),
(12319,'Common Item - Black Pearl Ring','rfinger,lfinger','true','none',50,'wood','d',0,-1,0,20,0,1660,3,'true','true','true','true','0-0;'),
(12320,'Common Item - Elven Necklace','neck','true','none',50,'wood','d',0,-1,0,45,0,4640,8,'true','true','true','true','0-0;'),
(12321,'Common Item - Elven Ring','rfinger,lfinger','true','none',50,'wood','d',0,-1,0,22,0,2320,4,'true','true','true','true','0-0;'),
(12322,'Common Item - Elven Earring','rear,lear','true','none',50,'wood','d',0,-1,0,34,0,3480,6,'true','true','true','true','0-0;'),
(12323,'Common Item - Mithril Ring','rfinger,lfinger','true','none',50,'wood','d',0,-1,0,24,0,2940,5,'true','true','true','true','0-0;'),
(12324,'Common Item - Necklace of Darkness','neck','true','none',50,'wood','d',0,-1,0,48,0,5880,11,'true','true','true','true','0-0;'),
(12325,'Common Item - Omen Beast\'s Eye','rear,lear','true','none',50,'wood','d',0,-1,0,36,0,4410,8,'true','true','true','true','0-0;'),
(12326,'Common Item - Moonstone Earring','rear,lear','true','none',50,'wood','c',0,-1,0,39,0,5520,2,'true','true','true','true','0-0;'),
(12327,'Common Item - Aquastone Necklace','neck','true','none',50,'wood','c',0,-1,0,52,0,7359,3,'true','true','true','true','0-0;'),
(12328,'Common Item - Aquastone Ring','rfinger,lfinger','true','none',50,'wood','c',0,-1,0,26,0,3679,1,'true','true','true','true','0-0;'),
(12329,'Common Item - Earring of Protection','rear,lear','true','none',50,'wood','c',0,-1,0,42,0,6819,3,'true','true','true','true','0-0;'),
(12330,'Common Item - Necklace of Protection','neck','true','none',50,'wood','c',0,-1,0,56,0,9090,4,'true','true','true','true','0-0;'),
(12331,'Common Item - Ring of Protection','rfinger,lfinger','true','none',50,'wood','c',0,-1,0,28,0,4550,2,'true','true','true','true','0-0;'),
(12332,'Common Item - Earring of Binding','rear,lear','true','none',50,'wood','c',0,-1,0,45,0,12499,5,'true','true','true','true','0-0;'),
(12333,'Common Item - Ring of Ages','rfinger,lfinger','true','none',50,'wood','c',0,-1,0,30,0,8330,3,'true','true','true','true','0-0;'),
(12334,'Common Item - Mermaid Teardrop','neck','true','none',50,'wood','c',0,-1,0,60,0,16700,7,'true','true','true','true','0-0;'),
(12335,'Common Item - Nassen\'s Earring','rear,lear','true','none',50,'wood','c',0,-1,0,48,0,19300,8,'true','true','true','true','0-0;'),
(12336,'Common Item - Necklace of Binding','neck','true','none',50,'wood','c',0,-1,0,64,0,25699,10,'true','true','true','true','0-0;'),
(12337,'Common Item - Ring of Binding','rfinger,lfinger','true','none',50,'wood','c',0,-1,0,32,0,12899,5,'true','true','true','true','0-0;'),
(12338,'Common Item - Adamantite Earring','rear,lear','true','none',50,'wood','b',0,-1,0,51,0,24350,3,'true','true','true','true','0-0;'),
(12339,'Common Item - Adamantite Necklace','neck','true','none',50,'wood','b',0,-1,0,68,0,32500,4,'true','true','true','true','0-0;'),
(12340,'Common Item - Adamantite Ring','rfinger,lfinger','true','none',50,'wood','b',0,-1,0,34,0,16200,2,'true','true','true','true','0-0;'),
(12341,'Common Item - Earring of Black Ore','rear,lear','true','none',50,'wood','b',0,-1,0,54,0,43100,6,'true','true','true','true','0-0;'),
(12342,'Common Item - Necklace of Black Ore','neck','true','none',50,'wood','b',0,-1,0,72,0,57500,7,'true','true','true','true','0-0;'),
(12343,'Common Item - Ring of Black Ore','rfinger,lfinger','true','none',50,'wood','b',0,-1,0,36,0,28800,4,'true','true','true','true','0-0;'),
(12344,'Common Item - Sealed Phoenix Necklace','neck','true','none',50,'wood','a',0,-1,0,76,0,69000,5,'true','true','true','true','0-0;'),
(12345,'Common Item - Sealed Phoenix Earring','rear,lear','true','none',50,'wood','a',0,-1,0,57,0,51800,4,'true','true','true','true','0-0;'),
(12346,'Common Item - Sealed Phoenix Ring','rfinger,lfinger','true','none',50,'wood','a',0,-1,0,38,0,34500,3,'true','true','true','true','0-0;'),
(12347,'Common Item - Phoenix Necklace','neck','true','none',50,'wood','a',0,-1,0,80,26,69000,5,'true','true','true','true','0-0;'),
(12348,'Common Item - Phoenix Ring','rfinger,lfinger','true','none',50,'wood','a',0,-1,0,40,13,34500,3,'true','true','true','true','0-0;'),
(12349,'Common Item - Phoenix Earring','rear,lear','true','none',50,'wood','a',0,-1,0,60,20,51800,4,'true','true','true','true','0-0;'),
(12350,'Common Item - Sealed Majestic Necklace','neck','true','none',50,'wood','a',0,-1,0,80,0,108300,9,'true','true','true','true','0-0;'),
(12351,'Common Item - Sealed Majestic Ring','rfinger,lfinger','true','none',50,'wood','a',0,-1,0,40,0,54200,4,'true','true','true','true','0-0;'),
(12352,'Common Item - Sealed Majestic Earring','rear,lear','true','none',50,'wood','a',0,-1,0,60,0,81300,7,'true','true','true','true','0-0;'),
(12353,'Common Item - Majestic Necklace','neck','true','none',50,'wood','a',0,-1,0,85,33,108300,9,'true','true','true','true','0-0;'),
(12354,'Common Item - Majestic Ring','rfinger,lfinger','true','none',50,'wood','a',0,-1,0,42,17,54200,4,'true','true','true','true','0-0;'),
(12355,'Common Item - Majestic Earring','rear,lear','true','none',50,'wood','a',0,-1,0,63,25,81300,7,'true','true','true','true','0-0;'),
(12356,'Common Item - Sealed Tateossian Necklace','neck','true','none',50,'wood','s',0,-1,0,91,0,0,0,'true','true','true','true','0-0;'),
(12357,'Common Item - Sealed Tateossian Ring','rfinger,lfinger','true','none',50,'wood','s',0,-1,0,46,0,0,0,'true','true','true','true','0-0;'),
(12358,'Common Item - Sealed Tateossian Earring','rear,lear','true','none',50,'wood','s',0,-1,0,68,0,0,0,'true','true','true','true','0-0;'),
(12359,'Common Item - Tateossian Necklace','neck','true','none',50,'wood','s',0,-1,0,95,42,0,0,'true','true','true','true','0-0;'),
(12360,'Common Item - Tateossian Ring','rfinger,lfinger','true','none',50,'wood','s',0,-1,0,48,21,0,0,'true','true','true','true','0-0;'),
(12361,'Common Item - Tateossian Earring','rear,lear','true','none',50,'wood','s',0,-1,0,71,31,0,0,'true','true','true','true','0-0;'),
(12372,'Monkey Hat','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(12373,'Pig Hat','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(12740,'Baby Pet Scale Armor','babypet','false','pet',160,'wood','none',0,-1,112,0,0,2033416,0,'true','true','true','true','0-0;'),
(12741,'Baby Pet Bronze Armor','babypet','false','pet',160,'wood','none',0,-1,124,0,0,3921666,0,'true','true','true','true','0-0;'),
(12742,'Baby Pet Plate Armor','babypet','false','pet',160,'wood','none',0,-1,136,0,0,7719833,0,'true','true','true','true','0-0;'),
(12743,'Baby Pet Mithril Armor','babypet','false','pet',160,'wood','none',0,-1,148,0,0,13609916,0,'true','true','true','true','0-0;'),
(12744,'Baby Pet Oriharukon Armor','babypet','false','pet',160,'wood','none',0,-1,160,0,0,26255666,0,'true','true','true','true','0-0;'),
(12745,'Baby Pet Orichalcum Armor','babypet','false','pet',160,'wood','none',0,-1,171,0,0,52952250,0,'true','true','true','true','0-0;'),
(12746,'Crystal Pendant','neck','false','pet',150,'wood','none',0,-1,0,22,0,4185,0,'true','true','true','true','0-0;'),
(12747,'Ruby Pendant','neck','false','pet',150,'wood','none',0,-1,0,30,0,21862,0,'true','true','true','true','0-0;'),
(12748,'Sapphire Pendant','neck','false','pet',150,'wood','none',0,-1,0,40,0,69221,0,'true','true','true','true','0-0;'),
(12749,'Diamond Pendant','neck','false','pet',150,'wood','none',0,-1,0,52,0,169809,0,'true','true','true','true','0-0;'),
(12750,'Enria Pendant','neck','false','pet',150,'wood','none',0,-1,0,66,0,501403,0,'true','true','true','true','0-0;'),
(12751,'Thons Pendant','neck','false','pet',150,'wood','none',0,-1,0,80,0,1795061,0,'true','true','true','true','0-0;'),
(12752,'Asofe Pendant','neck','false','pet',150,'wood','none',0,-1,0,94,0,5596065,0,'true','true','true','true','0-0;'),
(12766,'Gold Circlet','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(12767,'Silver Circlet','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(12779,'Agathion Seal Bracelet - Little Angel','underwear','false','none',150,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(12780,'Agathion Seal Bracelet - Little Devil','underwear','false','none',150,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(12781,'Ol Mahum Hat','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(12782,'Kat the Cat Hat - 30 day limited period','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(12783,'Feline Queen Hat - 30 day limited period','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(12784,'Ant Hat','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(12785,'Wolf Hat','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(12786,'Monster Eye Hat - 30 day limited period','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(12787,'Brown Bear Hat - 30 day limited period','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(12788,'Fungus Hat - 30 day limited period','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(12789,'Skull Hat - 30 day limited period','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(12790,'Ornithomimus Hat - 30 day limited period','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(12791,'Feline King Hat - 30 day limited period','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(12792,'Kai the Cat Hat - 30 day limited period','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(12815,'Red Talisman - Max CP','underwear','false','none',150,'wood','none',0,65,0,0,0,0,0,'true','true','true','true','0-0;'),
(12816,'Red Talisman - CP Regeneration','underwear','false','none',150,'wood','none',0,65,0,0,0,0,0,'true','true','true','true','0-0;'),
(12817,'Yellow Talisman - Increase Force','underwear','false','none',150,'wood','none',0,65,0,0,0,0,0,'true','true','true','true','0-0;'),
(12818,'Yellow Talisman - Damage Transition','underwear','false','none',150,'wood','none',0,65,0,0,0,0,0,'true','true','true','true','0-0;'),
(12835,'Shadow Item - Teddy Bear Hat','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'true','true','true','true','0-0;'),
(12836,'Shadow Item - Piggy Hat','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'true','true','true','true','0-0;'),
(12837,'Shadow Item - Jester Hat','dhair','false','none',10,'wood','none',0,300,0,0,0,0,0,'true','true','true','true','0-0;'),
(12838,'Fish Hat (Event)','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','false','true','0-0;'),
(12839,'Medieval Style Party Mask (Event)','dhair','false','none',10,'wood','none',0,-1,0,0,0,0,0,'false','false','true','false','0-0;'),
(12978,'Zubei\'s Helmet - Light Armor Use','head','true','none',590,'wood','b',0,-1,62,0,0,778000,80,'true','true','true','true','0-0;'),
(12979,'Zubei\'s Helmet - Robe Use','head','true','none',590,'wood','b',0,-1,62,0,0,778000,80,'true','true','true','true','0-0;'),
(12980,'Avadon Circlet - Light Armor Use','head','true','none',590,'wood','b',0,-1,62,0,0,778000,80,'true','true','true','true','0-0;'),
(12981,'Avadon Circlet - Robe Use','head','true','none',590,'wood','b',0,-1,62,0,0,778000,80,'true','true','true','true','0-0;'),
(12982,'Doom Helmet - Light Armor Use','head','true','none',580,'wood','b',0,-1,66,0,0,1210000,124,'true','true','true','true','0-0;'),
(12983,'Doom Helmet - Robe Use','head','true','none',580,'wood','b',0,-1,66,0,0,1210000,124,'true','true','true','true','0-0;'),
(12984,'Blue Wolf Helmet - Light Armor Use','head','true','none',580,'wood','b',0,-1,66,0,0,1210000,124,'true','true','true','true','0-0;'),
(12985,'Blue Wolf Helmet - Robe Use','head','true','none',580,'wood','b',0,-1,66,0,0,1210000,124,'true','true','true','true','0-0;'),
(12986,'Dark Crystal Helmet - Light Armor Use','head','true','none',570,'wood','a',0,-1,69,0,0,1740000,107,'true','true','true','true','0-0;'),
(12987,'Dark Crystal Helmet - Robe Use','head','true','none',570,'wood','a',0,-1,69,0,0,1740000,107,'true','true','true','true','0-0;'),
(12988,'Tallum Helmet - Light Armor Use','head','true','none',570,'wood','a',0,-1,69,0,0,1740000,107,'true','true','true','true','0-0;'),
(12989,'Tallum Helmet - Robe Use','head','true','none',570,'wood','a',0,-1,69,0,0,1740000,107,'true','true','true','true','0-0;'),
(12990,'Majestic Circlet - Light Armor Use','head','true','none',550,'wood','a',0,-1,73,0,0,2640000,163,'true','true','true','true','0-0;'),
(12991,'Majestic Circlet - Robe Use','head','true','none',550,'wood','a',0,-1,73,0,0,2640000,163,'true','true','true','true','0-0;'),
(12992,'Helm of Nightmare - Light Armor Use','head','true','none',560,'wood','a',0,-1,73,0,0,2640000,163,'true','true','true','true','0-0;'),
(12993,'Helm of Nightmare - Robe Use','head','true','none',560,'wood','a',0,-1,73,0,0,2640000,163,'true','true','true','true','0-0;'),
(12994,'Sealed Dark Crystal Helmet - Light Armor Use','head','true','none',570,'wood','a',0,-1,69,0,0,1740000,107,'true','true','true','true','0-0;'),
(12995,'Sealed Dark Crystal Helmet - Robe Use','head','true','none',570,'wood','a',0,-1,69,0,0,1740000,107,'true','true','true','true','0-0;'),
(12996,'Sealed Tallum Helmet - Light Armor Use','head','true','none',570,'wood','a',0,-1,69,0,0,1740000,107,'true','true','true','true','0-0;'),
(12997,'Sealed Tallum Helmet - Robe Use','head','true','none',570,'wood','a',0,-1,69,0,0,1740000,107,'true','true','true','true','0-0;'),
(12998,'Sealed Majestic Circlet - Light Armor Use','head','true','none',550,'wood','a',0,-1,73,0,0,2640000,163,'true','true','true','true','0-0;'),
(12999,'Sealed Majestic Circlet - Robe Use','head','true','none',550,'wood','a',0,-1,73,0,0,2640000,163,'true','true','true','true','0-0;'),
(13000,'Sealed Helm of Nightmare - Light Armor Use','head','true','none',560,'wood','a',0,-1,73,0,0,2640000,163,'true','true','true','true','0-0;'),
(13001,'Sealed Helm of Nightmare - Robe Use','head','true','none',560,'wood','a',0,-1,73,0,0,2640000,163,'true','true','true','true','0-0;');


INSERT INTO armor VALUES
(13022,'Light Purple-Maned Horse Mounting Bracelet - 7 day limited period','underwear','false','none',30, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13023,'Agathion of Love - 30-day limited period','underwear','false','none',30, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13024,'Sudden Agathion - 30-day limited period','underwear','false','none',30, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13025,'Shiny Agathion - 30-day limited period','underwear','false','none',30, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13026,'Sobbing Agathion - 30-day limited period','underwear','false','none',30, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13050,'Tigress exclusive armor','chest','false','light',160, 'wood','none',0,-1,49,49,0,0,0,'true','true','true','true','0-0;'),
(13058,'Silenos Hair Accessory','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13234,'Varka Karm (used by Varka Silenos)','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13235,'Ketra Karm (used by Ketra Orcs)','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13236,'AU Karm','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13237,'AR Karm','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13238,'AE Karm','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13239,'Kat the Cat Hat - 7-day Limited Period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13240,'Feline Queen Hat - 7-day Limited Period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13241,'Monster Eye Hat - 7-day Limited Period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13242,'Brown Bear Hat - 7-day Limited Period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13243,'Fungus Hat - 7-day Limited Period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13244,'Skull Hat - 7-day Limited Period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13245,'Ornithomimus Hat - 7-day Limited Period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13246,'Feline King Hat - 7-day Limited Period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13247,'Kai the Cat Hat - 7-day Limited Period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13254,'Agathion of Love - 7-day Limited Period','underwear','false','none',30, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13260,'Gran Kain\'s Squeaking Shoes - 10 hours limited period','feet','false','none',50, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13293,'Pailaka Earring','rear,lear','false','none',150, 'wood','d',0,-1,0,43,20,0,0,'true','true','true','true','0-0;'),
(13294,'Pailaka Ring','rfinger,lfinger','false','none',150, 'wood','d',0,-1,0,29,15,0,0,'true','true','true','true','0-0;'),
(13295,'Pailaka Bracelet','underwear','false','none',150, 'wood','b',0,-1,0,0,20,0,0,'true','true','true','true','0-0;'),
(13296,'Pailaka Shirt','chest','false','none',130, 'wood','a',0,-1,28,0,40,0,0,'true','true','true','true','0-0;'),
(13308,'Light Purple-Maned Horse Mounting Bracelet (Event) - 7-day Limited Period','underwear','false','none',30, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13309,'Agathion of Love (Event) - 30-day limited period','underwear','false','none',30, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13310,'Kat the Cat Hat (Event) - 30-day limited period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13311,'Feline Queen Hat (Event) - 30-day limited period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13312,'Monster Eye Hat (Event) - 30-day limited period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13313,'Brown Bear Hat (Event) - 30-day limited period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13314,'Fungus Hat (Event) - 30-day limited period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13315,'Skull Hat (Event) - 30-day limited period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13316,'Ornithomimus Hat (Event) - 30-day limited period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13317,'Feline King Hat (Event) - 30-day limited period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13318,'Kai the Cat Hat (Event) - 30-day limited period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13325,'Kat the Cat Hat (Event) - 7-day Limited Period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13326,'Feline Queen Hat (Event) - 7-day Limited Period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13327,'Monster Eye Hat (Event) - 7-day Limited Period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13328,'Brown Bear Hat (Event) - 7-day Limited Period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13329,'Fungus Hat (Event) - 7-day Limited Period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13330,'Skull Hat (Event) - 7-day Limited Period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13331,'Ornithomimus Hat (Event) - 7-day Limited Period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13332,'Feline King Hat (Event) - 7-day Limited Period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13333,'Kai the Cat Hat (Event) - 7-day Limited Period','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13340,'Agathion of Love (Event) - 7-day Limited Period','underwear','false','none',30, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13389,'Kratei Barbed Shirt - CP','chest','true','none',130, 'wood','a',0,-1,23,0,0,0,0,'true','true','true','true','0-0;'),
(13390,'Kratei Mithril Shirt - CP','chest','true','none',130, 'wood','s',0,-1,28,0,0,0,0,'true','true','true','true','0-0;'),
(13391,'Kratei Striped Barbed Shirt - CP','chest','true','none',130, 'wood','a',0,-1,26,0,0,0,0,'true','true','true','true','0-0;'),
(13392,'Kratei Striped Mithril Shirt - CP','underwear','true','none',130, 'wood','s',0,-1,30,0,0,0,0,'true','true','true','true','0-0;'),
(13393,'Shadow Item - Monkey Hat','dhair','false','none',10, 'wood','none',0,100,0,0,0,0,0,'true','true','true','true','0-0;'),
(13394,'Shadow Item - Pig Hat','dhair','false','none',10, 'wood','none',0,100,0,0,0,0,0,'true','true','true','true','0-0;'),
(13415,'Frog Hat','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13416,'Chicken Hat','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13429,'Teddy Bear Hat (Event)','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13430,'Piggy Hat (Event)','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(13431,'Jester Hat (Event)','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(20006,'Agathion Seal Bracelet - Majo','underwear','false','none',150, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(20007,'Agathion Seal Bracelet - Gold Majo','underwear','false','none',150, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(20008,'Agathion Seal Bracelet - Black Majo','underwear','false','none',150, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(20009,'Agathion Seal Bracelet - Majo - Big Head 30-day limited period','underwear','false','none',150, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(20010,'Agathion Seal Bracelet - Gold Majo - Resurrection 30-day limited period','underwear','false','none',150, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(20011,'Agathion Seal Bracelet - Black Majo - Escape 30-day limited period','underwear','false','none',150, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(20012,'Agathion Seal Bracelet - Plaipitak','underwear','false','none',150, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(20013,'Agathion Seal Bracelet - Plaipitak - Big Head 30-day limited period','underwear','false','none',150, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(20014,'Agathion Seal Bracelet - Plaipitak - Resurrection 30-day limited period','underwear','false','none',150, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(20015,'Agathion Seal Bracelet - Plaipitak - Escape 30-day limited period','underwear','false','none',150, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(20016,'Horn-Rimmed Glasses - Agility','face','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(20017,'Afro Hair','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(20018,'Afro Hair - Big Head, Firework','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(20019,'Afro Hair - Wind Walk','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(20020,'Uniform Hat','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(20021,'Assassin\'s Bamboo Hat','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(20022,'Ruthless Tribe Mask','face','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(20023,'Ribbon Hairband','face','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(20024,'Visor','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(20029,'Light Purple-Maned Horse Mounting Bracelet','underwear','false','none',30, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(20030,'Light Purple-Maned Horse Mounting Bracelet - 30 day limited period','underwear','false','none',30, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(20031,'Kat the Cat Hat','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;'),
(20032,'Skull Hat','dhair','false','none',10, 'wood','none',0,-1,0,0,0,0,0,'true','true','true','true','0-0;');
