/*
 * Decompiled with CFR 0.152.
 */
package org.python.parser.ast;

import java.io.DataOutputStream;
import java.io.IOException;
import org.python.parser.SimpleNode;
import org.python.parser.ast.VisitorIF;
import org.python.parser.ast.argumentsType;
import org.python.parser.ast.stmtType;

public class FunctionDef
extends stmtType {
    public String name;
    public argumentsType args;
    public stmtType[] body;

    public FunctionDef(String name, argumentsType args, stmtType[] body) {
        this.name = name;
        this.args = args;
        this.body = body;
    }

    public FunctionDef(String name, argumentsType args, stmtType[] body, SimpleNode parent) {
        this(name, args, body);
        this.beginLine = parent.beginLine;
        this.beginColumn = parent.beginColumn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("FunctionDef[");
        sb.append("name=");
        sb.append(this.dumpThis(this.name));
        sb.append(", ");
        sb.append("args=");
        sb.append(this.dumpThis(this.args));
        sb.append(", ");
        sb.append("body=");
        sb.append(this.dumpThis(this.body));
        sb.append("]");
        return sb.toString();
    }

    public void pickle(DataOutputStream ostream) throws IOException {
        this.pickleThis(5, ostream);
        this.pickleThis(this.name, ostream);
        this.pickleThis(this.args, ostream);
        this.pickleThis(this.body, ostream);
    }

    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitFunctionDef(this);
    }

    public void traverse(VisitorIF visitor) throws Exception {
        if (this.args != null) {
            this.args.accept(visitor);
        }
        if (this.body != null) {
            for (int i = 0; i < this.body.length; ++i) {
                if (this.body[i] == null) continue;
                this.body[i].accept(visitor);
            }
        }
    }
}

