/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;

public class TemplateAntTask
extends MatchingTask {
    protected File mappingFile;
    protected String python;
    protected File destdir;
    protected Path src;
    protected File scriptDir;
    protected boolean verbose = false;

    public void setMappingFile(String aMappingFile) {
        String amp = this.getProject().replaceProperties(aMappingFile);
        this.mappingFile = new File(amp);
    }

    public void setPython(String aPE) {
        this.python = aPE;
    }

    public void setDestdir(String in) {
        this.destdir = new File(this.getProject().replaceProperties(in));
    }

    public Path createSrc() {
        if (null == this.src) {
            this.src = new Path(this.getProject());
        }
        return this.src.createPath();
    }

    public void setSrcdir(Path srcDir) {
        if (null == this.src) {
            this.src = srcDir;
        } else {
            this.src.append(srcDir);
        }
    }

    public void setScriptdir(String in) {
        this.scriptDir = new File(this.getProject().replaceProperties(in));
    }

    public void setVerbose(String in) {
        this.verbose = new Boolean(this.getProject().replaceProperties(in));
    }

    /*
     * WARNING - void declaration
     */
    public void execute() {
        Map mapping;
        if (null == this.mappingFile) {
            throw new BuildException("no mappingFile specified");
        }
        if (!this.mappingFile.canRead()) {
            throw new BuildException("Can't read mappingFile: " + this.mappingFile);
        }
        if (null == this.python) {
            this.python = "python";
        }
        if (null == this.destdir) {
            throw new BuildException("no destdir specified");
        }
        if (!this.destdir.exists()) {
            throw new BuildException("destdir '" + this.destdir + "' doesn't exist");
        }
        try {
            mapping = this.fileToMap(this.mappingFile);
        }
        catch (IOException e) {
            throw new BuildException(e.toString(), (Throwable)e);
        }
        if (null == this.scriptDir) {
            throw new BuildException("no scriptdir specified");
        }
        if (!this.scriptDir.exists()) {
            throw new BuildException("scriptdir '" + this.scriptDir + "' doesn't exist");
        }
        File gexposeScript = new File(this.scriptDir.getAbsolutePath() + File.separator + "gexpose.py");
        File gderiveScript = new File(this.scriptDir.getAbsolutePath() + File.separator + "gderived.py");
        if (!gexposeScript.exists()) {
            throw new BuildException("no gexpose.py script found at: " + gexposeScript);
        }
        if (!gderiveScript.exists()) {
            throw new BuildException("no gderive.py script found at: " + gderiveScript);
        }
        String[] list = this.src.list();
        for (int i = 0; i < list.length; ++i) {
            File srcDir = this.getProject().resolveFile(list[i]);
            if (!srcDir.exists()) {
                throw new BuildException("srcDir '" + list[i] + "' does not exist");
            }
            DirectoryScanner ds = this.getDirectoryScanner(srcDir);
            String[] files = ds.getIncludedFiles();
            for (int j = 0; j < files.length; ++j) {
                void var14_15;
                String[] cmd;
                if (null == mapping.get(files[j])) {
                    if (!this.verbose) continue;
                    this.log("ignoring file (" + files[j] + ") with no mapping");
                    continue;
                }
                String fromFile = srcDir.getAbsolutePath() + File.separator + files[j];
                String mapFile = (String)mapping.get(files[j]);
                String mapFileName = mapFile.replace('.', File.separatorChar) + ".java";
                String toFile = this.destdir.getAbsolutePath() + File.separator + mapFileName;
                if (!new File(fromFile).exists()) {
                    throw new BuildException("source file '" + fromFile + "' does not exist");
                }
                if (!new File(toFile).exists()) {
                    throw new BuildException("destination file '" + toFile + "' (from class named " + mapFile + ") does not exist");
                }
                if (fromFile.endsWith(".expose")) {
                    cmd = new String[]{this.python, gexposeScript.getAbsolutePath(), fromFile, toFile};
                } else if (fromFile.endsWith(".derived")) {
                    cmd = new String[]{this.python, gderiveScript.getAbsolutePath(), fromFile, toFile};
                } else {
                    throw new BuildException("source file: '" + fromFile + "' has unknown extension; expected .derived or .expose");
                }
                Execute e = new Execute();
                e.setWorkingDirectory(this.scriptDir);
                e.setCommandline((String[])var14_15);
                if (this.verbose) {
                    String out = "";
                    for (int k = 0; k < e.getCommandline().length; ++k) {
                        out = out + e.getCommandline()[k] + " ";
                    }
                    this.log("executing: " + out);
                }
                try {
                    e.execute();
                    continue;
                }
                catch (IOException e2) {
                    throw new BuildException(e2.toString(), (Throwable)e2);
                }
            }
        }
    }

    protected Map fileToMap(File mapFile) throws IOException, BuildException {
        String line;
        HashMap<String, String> ret = new HashMap<String, String>();
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(mapFile)));
        while (null != (line = in.readLine())) {
            if (line.trim().startsWith("#") || 0 == line.trim().compareTo("")) continue;
            int idx = line.indexOf(":");
            if (-1 == idx) {
                throw new BuildException("invalid mapping syntax; no ':' on line: '" + line + "'");
            }
            String key = line.substring(0, idx);
            String val = line.substring(idx + 1, line.length());
            ret.put(key, val);
        }
        return ret;
    }
}

