/*
 * Decompiled with CFR 0.152.
 */
package javolution;

import java.io.PrintStream;
import javolution.JavolutionError;
import javolution.PerfContext;
import javolution.PerfStream;
import javolution.PerfText;
import javolution.PerfUtil;
import javolution.PerfXML;
import javolution.context.LogContext;
import javolution.text.Text;
import javolution.text.TextBuilder;

public class Javolution {
    public static final String VERSION = "4.2.6 (J2SE 1.5+) March 4 2007";
    private static PrintStream Out = System.out;
    static long _TimerOffset = 0L;
    private long _picoDuration = Long.MAX_VALUE;
    private static long _time;

    protected Javolution() {
    }

    public static void main(String[] stringArray) throws Exception {
        Out.println("Javolution - Java(TM) Solution for Real-Time and Embedded Systems");
        Out.println("Version 4.2.6 (J2SE 1.5+) March 4 2007 (http://javolution.org)");
        Out.println("");
        if (stringArray.length > 0) {
            if (stringArray[0].equals("version")) {
                return;
            }
            if (stringArray[0].equals("test")) {
                Javolution.testing();
                return;
            }
            if (stringArray[0].equals("perf")) {
                Javolution.benchmark();
                return;
            }
        }
        Out.println("Usage: java -jar javolution.jar [arg]");
        Out.println("where arg is one of:");
        Out.println("    version (to show version information only)");
        Out.println("    test    (to perform self-tests)");
        Out.println("    perf    (to run benchmark)");
    }

    private static void testing() throws Exception {
        Out.print("Testing...");
        Out.println("");
        Out.println("Success");
    }

    private static void benchmark() throws Exception {
        LogContext.setDefault(LogContext.STANDARD);
        Javolution.calibrate();
        Out.println("Run benchmark... (shortest execution times are displayed)");
        Out.println("");
        Thread.currentThread().setPriority(10);
        new PerfContext().run();
        new PerfText().run();
        new PerfStream().run();
        new PerfXML().run();
        new PerfUtil().run();
        Out.println("More performance analysis in future versions...");
    }

    private static void calibrate() {
        Javolution javolution = new Javolution();
        for (int i = 0; i < 1000; ++i) {
            javolution.startTime();
            javolution.keepBestTime(1);
        }
        _TimerOffset = javolution._picoDuration / 1000L;
    }

    public void println(Object object) {
        Out.println(object);
    }

    public void print(Object object) {
        Out.print(object);
    }

    public void startTime() {
        if (_time != 0L) {
            throw new Error("Timer not reset");
        }
        _time = Javolution.nanoTime();
    }

    public static void setOutputStream(PrintStream printStream) {
        Out = printStream;
    }

    public void keepBestTime(int n) {
        long l = Javolution.nanoTime() - _time - _TimerOffset;
        long l2 = l * 1000L / (long)n;
        if (l2 < this._picoDuration) {
            this._picoDuration = l2;
        }
        _time = 0L;
    }

    public String endTime() {
        long l;
        String string;
        if (this._picoDuration > 1000000000000L) {
            string = " s";
            l = 1000000000000L;
        } else if (this._picoDuration > 1000000000L) {
            string = " ms";
            l = 1000000000L;
        } else if (this._picoDuration > 1000000L) {
            string = " us";
            l = 1000000L;
        } else {
            string = " ns";
            l = 1000L;
        }
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(this._picoDuration / l);
        int n = 4 - textBuilder.length();
        textBuilder.append(".");
        int n2 = 0;
        int n3 = 10;
        while (n2 < n) {
            textBuilder.append(this._picoDuration * (long)n3 / l % 10L);
            ++n2;
            n3 *= 10;
        }
        this._picoDuration = Long.MAX_VALUE;
        return textBuilder.append(string).toString();
    }

    private static long nanoTime() {
        return System.nanoTime();
    }

    public static Class j2meGetClass(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                clazz = Class.forName(string, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                try {
                    clazz = Class.forName(string, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    // empty catch block
                }
            }
        }
        if (clazz == null) {
            throw new JavolutionError("Class " + string + " not found");
        }
        return clazz;
    }

    public static CharSequence j2meToCharSeq(Object object) {
        return object instanceof CharSequence ? (CharSequence)object : (object == null ? null : Text.valueOf((Object)((String)object)));
    }
}

