/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.JavolutionError;
import javolution.context.Context;
import javolution.context.LocalPools;
import javolution.context.PoolContext;
import javolution.context.RealtimeObject;

public class HeapContext
extends Context {
    private static RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

        protected Object create() {
            return new HeapContext();
        }
    };
    private final ThreadLocal _localPools = new ThreadLocal(){

        protected Object initialValue() {
            LocalPools localPools = new LocalPools(false);
            localPools._owner = Thread.currentThread();
            return localPools;
        }
    };
    private transient boolean _isInternal;

    public static HeapContext current() {
        for (Context context = Context.current(); context != null; context = context.getOuter()) {
            if (context instanceof HeapContext) {
                return (HeapContext)context;
            }
            if (!(context instanceof PoolContext)) continue;
            return null;
        }
        throw new JavolutionError("No heap context or pool context");
    }

    public static void enter() {
        HeapContext heapContext = (HeapContext)FACTORY.object();
        heapContext._isInternal = true;
        Context.enter(heapContext);
    }

    public static void exit() {
        HeapContext heapContext = (HeapContext)Context.current();
        if (!heapContext._isInternal) {
            throw new UnsupportedOperationException("The context to exit must be specified");
        }
        heapContext._isInternal = false;
        Context.exitNoCheck(heapContext);
        FACTORY.recycle(heapContext);
    }

    public void clear() {
        ((LocalPools)this._localPools.get()).clear();
    }

    protected void enterAction() {
        Context context = this.getOuter();
        context.getLocalPools().deactivatePools();
        this.getLocalPools().activatePools();
    }

    protected void exitAction() {
        this.getLocalPools().deactivatePools();
        Context context = this.getOuter();
        context.getLocalPools().activatePools();
    }

    final LocalPools getLocalPools() {
        return (LocalPools)this._localPools.get();
    }
}

