/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javax.realtime.MemoryArea;
import javolution.JavolutionError;
import javolution.context.ObjectFactory;
import javolution.context.ObjectPool;
import javolution.context.Realtime;
import javolution.text.Text;
import javolution.text.TextBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RealtimeObject
implements Realtime {
    private transient RealtimeObject _next;
    private transient Factory.Pool _pool;
    private transient RealtimeObject _previous;
    private transient int _preserved;

    protected RealtimeObject() {
    }

    public final boolean isLocal() {
        if (this._pool == null) {
            return false;
        }
        if (!this._pool.inUse()) {
            throw new JavolutionError("Reference to inner pool object detected");
        }
        if (!this._pool._isStack) {
            return false;
        }
        return this._pool.getUser() == Thread.currentThread();
    }

    public final String toString() {
        return this instanceof TextBuilder ? ((TextBuilder)this).stringValue() : this.toText().stringValue();
    }

    @Override
    public Text toText() {
        return Text.valueOf((Object)this.getClass().getName()).concat(Text.valueOf('@')).concat(Text.valueOf(System.identityHashCode(this), 16));
    }

    public final <T> T export() {
        this.move(Realtime.ObjectSpace.OUTER);
        return (T)this;
    }

    public final <T> T moveHeap() {
        this.move(Realtime.ObjectSpace.HEAP);
        return (T)this;
    }

    public final <T> T preserve() {
        this.move(Realtime.ObjectSpace.HOLD);
        return (T)this;
    }

    public final <T> T unpreserve() {
        this.move(Realtime.ObjectSpace.STACK);
        return (T)this;
    }

    @Override
    public boolean move(Realtime.ObjectSpace objectSpace) {
        if (this._pool == null) {
            return false;
        }
        if (!this._pool.inUse()) {
            throw new JavolutionError("Reference to inner pool object detected");
        }
        if (objectSpace == Realtime.ObjectSpace.OUTER) {
            if (!this._pool._isStack) {
                return false;
            }
            if (this._pool.getUser() == null) {
                return false;
            }
            if (this._pool.getUser() != Thread.currentThread()) {
                throw new JavolutionError("Cannot export objects from another thread stack");
            }
            Factory.Pool pool = (Factory.Pool)this._pool.getOuter();
            this.detach();
            Object object = pool.next();
            if (((RealtimeObject)object)._pool != null) {
                ((RealtimeObject)object).detach();
            }
            ((RealtimeObject)object).insertBefore(this._pool._activeTail);
            ((RealtimeObject)object)._pool = this._pool;
            this.insertBefore(pool._next);
            this._pool = pool;
            return true;
        }
        if (objectSpace == Realtime.ObjectSpace.HEAP) {
            if (!this._pool._isStack) {
                return false;
            }
            if (this._pool.getUser() != null && this._pool.getUser() != Thread.currentThread()) {
                throw new JavolutionError("Cannot move to the heap objects form another thread stack");
            }
            this.detach();
            this._pool._size--;
            this._pool = null;
            this._next = null;
            this._previous = null;
            return true;
        }
        if (objectSpace == Realtime.ObjectSpace.HOLD) {
            if (!this._pool._isStack) {
                return false;
            }
            if (this._pool.getUser() != null && this._pool.getUser() != Thread.currentThread()) {
                throw new JavolutionError("Cannot preserve objects from another thread stack");
            }
            if (this._preserved++ == 0) {
                this.detach();
                this.insertBefore(this._pool._holdTail);
                return true;
            }
            return false;
        }
        if (objectSpace == Realtime.ObjectSpace.STACK) {
            if (this._preserved != 0 && --this._preserved == 0) {
                this.detach();
                this.insertBefore(this._pool._next);
                this._pool._next = this;
                return true;
            }
            return false;
        }
        return true;
    }

    final void insertBefore(RealtimeObject realtimeObject) {
        this._previous = realtimeObject._previous;
        this._next = realtimeObject;
        this._next._previous = this;
        this._previous._next = this;
    }

    final void detach() {
        this._next._previous = this._previous;
        this._previous._next = this._next;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Factory<T extends RealtimeObject>
    extends ObjectFactory<T> {
        private Pool _cached = this.newHeapPool();

        protected Factory() {
        }

        @Override
        public final T object() {
            Pool pool = this._cached;
            return (T)(pool.getUser() == Thread.currentThread() ? pool.next() : this.currentPool().next());
        }

        @Override
        public final void recycle(T t) {
            Pool pool = ((RealtimeObject)t)._pool;
            if (pool == null) {
                this.currentPool().recycle(t);
            } else {
                pool.recycle(t);
            }
        }

        public final Pool currentPool() {
            Pool pool;
            this._cached = pool = (Pool)super.currentPool();
            return pool;
        }

        @Override
        protected Pool newStackPool() {
            return new Pool(true);
        }

        @Override
        protected Pool newHeapPool() {
            return new Pool(false);
        }

        private static final class Bound
        extends RealtimeObject {
            private Bound() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public final class Pool
        extends ObjectPool<T> {
            private RealtimeObject _next;
            private final boolean _isStack;
            private final MemoryArea _memoryArea;
            private int _size;
            private final RealtimeObject _activeHead;
            private final RealtimeObject _activeTail;
            private final RealtimeObject _holdHead;
            private final RealtimeObject _holdTail;
            private final Runnable _allocate = new Runnable(){

                public void run() {
                    RealtimeObject realtimeObject = (RealtimeObject)Factory.this.create();
                    Pool.this._size++;
                    realtimeObject.insertBefore(Pool.this._activeTail);
                    realtimeObject._pool = Pool.this;
                }
            };

            private Pool(boolean bl) {
                this._isStack = bl;
                this._memoryArea = MemoryArea.getMemoryArea(this);
                this._activeHead = new Bound();
                this._activeTail = new Bound();
                this._activeHead._next = this._activeTail;
                this._activeTail._previous = this._activeHead;
                this._holdHead = new Bound();
                this._holdTail = new Bound();
                this._holdHead._next = this._holdTail;
                this._holdTail._previous = this._holdHead;
                this._next = this._activeTail;
            }

            @Override
            public ObjectFactory getFactory() {
                return Factory.this;
            }

            @Override
            public int getSize() {
                return this._size;
            }

            @Override
            public void setSize(int n) {
                while (this._size < n) {
                    RealtimeObject realtimeObject = (RealtimeObject)Factory.this.create();
                    realtimeObject.insertBefore(this._next);
                    this._next = this._next._previous;
                    realtimeObject._pool = this;
                    ++this._size;
                }
            }

            @Override
            public T next() {
                RealtimeObject realtimeObject = this._next;
                this._next = realtimeObject._next;
                return this._next != null ? realtimeObject : this.allocate();
            }

            private T allocate() {
                this._next = this._activeTail;
                if (this._isStack) {
                    return this.stackAllocate();
                }
                if (this._size != 0) {
                    this.removeUse();
                }
                return (RealtimeObject)Factory.this.create();
            }

            private T stackAllocate() {
                this._memoryArea.executeInArea(this._allocate);
                return this._activeTail._previous;
            }

            private void removeUse() {
                RealtimeObject realtimeObject = this._activeHead._next;
                if (realtimeObject == this._activeTail) {
                    throw new JavolutionError("Empty pool with non-zero size");
                }
                realtimeObject.detach();
                realtimeObject._next = null;
                realtimeObject._previous = null;
                realtimeObject._pool = null;
                --this._size;
            }

            @Override
            public void recycle(T t) {
                Object t2;
                Pool pool;
                if (Factory.this.doCleanup()) {
                    Factory.this.cleanup(t);
                }
                if ((pool = ((RealtimeObject)(t2 = t))._pool) == this) {
                    ((RealtimeObject)t2).detach();
                    ((RealtimeObject)t2).insertBefore(this._next);
                    this._next = this._next._previous;
                    return;
                }
                if (pool == null) {
                    if (MemoryArea.getMemoryArea(t2) != this._memoryArea) {
                        return;
                    }
                    ((RealtimeObject)t2).insertBefore(this._next);
                    ((RealtimeObject)t2)._pool = this;
                    this._next = this._next._previous;
                    ++this._size;
                    return;
                }
                throw new IllegalArgumentException("Cannot recycle object belonging to a different context");
            }

            @Override
            protected void recycleAll() {
                RealtimeObject realtimeObject = this._activeHead._next;
                while (realtimeObject != this._next && Factory.this.doCleanup()) {
                    Factory.this.cleanup(realtimeObject);
                    realtimeObject = realtimeObject._next;
                }
                this._next = this._activeHead._next;
            }

            @Override
            protected void clearAll() {
                this._activeHead._next = this._activeTail;
                this._activeTail._previous = this._activeHead;
                this._holdHead._next = this._holdTail;
                this._holdTail._previous = this._holdHead;
            }

            public String toString() {
                String string = this._isStack ? "Stack Pool for " : "Heap Pool for ";
                return string + Factory.this.getClass() + " (Size: " + this._size + ")";
            }
        }
    }
}

