/**
 * [JOJO] ݖgpBQlpB얢mFB
 * Frintezza final battle
 *   http://www.l2jserver.com/forum/viewtopic.php?f=69&t=13999
 */

package com.l2jserver.gameserver.instancemanager;

import static com.l2jserver.gameserver.ai.CtrlIntention.AI_INTENTION_IDLE;
import static com.l2jserver.gameserver.ai.CtrlIntention.AI_INTENTION_ATTACK;

import java.util.concurrent.Future;
import java.util.logging.Logger;
import java.util.Collection;

import javolution.util.FastList;

import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2DecoyInstance;
import com.l2jserver.gameserver.model.actor.instance.L2GrandBossInstance;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.type.L2BossZone;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.Die;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.SpecialCamera;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;

/**
 * @author KKnD
 */
public class FrintezzaManagerFinalBattle
{
	private static Logger _log = Logger.getLogger(FrintezzaManagerFinalBattle.class.getName());
	private static FrintezzaManagerFinalBattle _instance;

	public final int ALIVE = 0;
	public final int FIGHTING = 1;
	public final int DEAD = 2;

	protected L2Npc weakScarlet;	//29046
	protected L2Npc strongScarlet;	//29047
	protected L2Npc frintezza;	//29045
	protected L2Npc portrait1;	//29050
	protected L2Npc portrait2;	//29051
	protected L2Npc portrait3;	//29050
	protected L2Npc portrait4;	//29051
	protected L2Npc dummy;	//29053
	protected L2Npc dummy1;	//29053
	protected L2Npc dummy2;	//29053
	protected L2Npc dummy3;	//29052
	protected L2Npc cube;	//29061
	protected L2BossZone _zone;
	protected boolean isMorphed = false;
	protected boolean isSecMorphed = false;
	protected L2Character _target;
	protected Future<?> _skillFrintezza;
	protected Future<?> _skillScarlet;
	protected Future<?> _retarget;
	protected Future<?> _clean;

	public static FrintezzaManagerFinalBattle getInstance()
	{
		if (_instance == null)
		{
			_log.info("Initializing FrintezzaManager TEST version");
			_instance = new FrintezzaManagerFinalBattle();
		}

		return _instance;
	}

	public FrintezzaManagerFinalBattle()
	{
		_zone = GrandBossManager.getInstance().getZone(174250, -86969, -5116);
		StatsSet set = GrandBossManager.getInstance().getStatsSet(29045);
		int status = GrandBossManager.getInstance().getBossStatus(29045);

		switch (status)
		{
		case DEAD:
			long time = set.getLong("respawn_time") - System.currentTimeMillis();
			if (time > 0)
				ThreadPoolManager.getInstance().scheduleGeneral(new spawntask(), time);
			else
				GrandBossManager.getInstance().setBossStatus(29045, ALIVE);
		}
	}

	// Starts final Battle
	public void startBattle()
	{
		frintezza = createNewSpawn(29045, 174240, -89805, -5022, 16048);	//tebT
		frintezza.setIsImmobilized(true);
		ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(1), 1000);
	}

	protected void doSecondMorph()
	{
		ThreadPoolManager.getInstance().scheduleGeneral(new secondMorph(1), 0);
	}

	protected void doThirdMorph()
	{
		ThreadPoolManager.getInstance().scheduleGeneral(new thirdMorph(1), 0);
	}

	protected void doScarletDie()
	{
		ThreadPoolManager.getInstance().scheduleGeneral(new scarletDie(1), 0);
	}

	protected L2Npc createNewSpawn(int templateId, int x, int y, int z, int heading)
	{
		L2Spawn tempSpawn = null;

		L2Npc npc;
		L2NpcTemplate template;

		try
		{
			template = NpcTable.getInstance().getTemplate(templateId);
			tempSpawn = new L2Spawn(template);

			tempSpawn.setLocx(x);
			tempSpawn.setLocy(y);
			tempSpawn.setLocz(z);
			tempSpawn.setHeading(heading);
			tempSpawn.setAmount(1);
			tempSpawn.stopRespawn();

			SpawnTable.getInstance().addNewSpawn(tempSpawn, false);

		}
		catch (Throwable t)
		{
			_log.warning(t.getMessage());
		}

		npc = tempSpawn.doSpawn();

		return npc;
	}

	private class secondMorph implements Runnable
	{
		private int _taskId = 0;

		public secondMorph(int taskId)
		{
			_taskId = taskId;
		}

		public void run()
		{
			switch (_taskId)
			{
			case 1:
				if (_retarget != null)
					_retarget.cancel(true);
				if (_skillScarlet != null)
					_skillScarlet.cancel(true);
				if (_skillFrintezza != null)
					_skillFrintezza.cancel(true);
				weakScarlet.setIsImmobilized(true);
				weakScarlet.setIsInvul(true);
				weakScarlet.abortAttack();
				weakScarlet.abortCast();
				weakScarlet.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
				((L2GrandBossInstance) weakScarlet).clearAggroList();
				((L2GrandBossInstance) weakScarlet).disableCoreAI(true);
				((L2GrandBossInstance) weakScarlet).setTarget(null);
				ThreadPoolManager.getInstance().scheduleGeneral(new secondMorph(2), 2000);
				break;
			case 2:
				L2Skill _skill = SkillTable.getInstance().getInfo(5017, 1);	//f[1 ϐgB
				weakScarlet.doCast(_skill);
				cast(weakScarlet, _skill);
				ThreadPoolManager.getInstance().scheduleGeneral(new secondMorph(3), 6000);
				break;
			case 3:
				weakScarlet.setIsImmobilized(false);
				weakScarlet.setRHandId(7903);
				npcupdate();
				weakScarlet.getStatus().setCurrentHp(weakScarlet.getStatus().getCurrentHp() * 1.15);
//-				weakScarlet.disableSkill(5017);	//f[1 ϐgB
//-				weakScarlet.enableSkill(5018);	//f[* @wB
				weakScarlet.setIsInvul(false);
				((L2GrandBossInstance) weakScarlet).disableCoreAI(false);
				L2Character s = getRandomTarget(weakScarlet);
				((L2GrandBossInstance) weakScarlet).addDamageHate(s, 0, 9999);
				weakScarlet.getAI().setIntention(AI_INTENTION_ATTACK, s);
				_retarget = ThreadPoolManager.getInstance().scheduleGeneral(new retarget(), 1000);
				_skillScarlet = ThreadPoolManager.getInstance().scheduleGeneral(new weakscarlet(), 1000);
				_skillFrintezza = ThreadPoolManager.getInstance().scheduleGeneral(new frinteza(), 1000);
				break;
			}
		}
	}

	private class thirdMorph implements Runnable
	{
		private int _taskId = 0;

		public thirdMorph(int taskId)
		{
			_taskId = taskId;
		}

		public void run()
		{
			switch (_taskId)
			{
			case 1:
				if (_retarget != null)
					_retarget.cancel(true);
				if (_skillScarlet != null)
					_skillScarlet.cancel(true);
				if (_skillFrintezza != null)
					_skillFrintezza.cancel(true);
				weakScarlet.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
				weakScarlet.abortAttack();
				weakScarlet.abortCast();
				frintezza.breakCast();
				L2Skill _skill = SkillTable.getInstance().getInfo(5007, 5);	//oF_X+LZtB
				cast(frintezza, _skill);
				((L2GrandBossInstance) weakScarlet).disableCoreAI(true);
				specialcamera(frintezza, 700, 120, 0, 0, 7000, 0, 0);
				ThreadPoolManager.getInstance().scheduleGeneral(new thirdMorph(22), 1000);
				break;
			case 22:
				specialcamera(frintezza, 100, 90, 0, 3000, 4100, 0, 0);
				ThreadPoolManager.getInstance().scheduleGeneral(new thirdMorph(23), 4000);
				break;
			case 23:
				specialcamera(frintezza, 100, 60, 0, 1000, 1100, 0, 0);
				ThreadPoolManager.getInstance().scheduleGeneral(new thirdMorph(24), 1000);
				break;
			case 24:
				specialcamera(frintezza, 1200, 90, 20, 7000, 7100, 0, 0);
				ThreadPoolManager.getInstance().scheduleGeneral(new thirdMorph(25), 7000);
				break;
			case 25:
				specialcamera(weakScarlet, 400, 260, 30, 0, 7000, 0, 0);
				weakScarlet.doDie(weakScarlet);
				ThreadPoolManager.getInstance().scheduleGeneral(new thirdMorph(2), 7000);
				break;
			case 2:
				strongScarlet = createNewSpawn(29047, weakScarlet.getX(), weakScarlet.getY(), weakScarlet.getZ(), weakScarlet.getHeading());	//XJ[bg @ nVR
			//	strongScarlet.getStatus().setCurrentHp(strongScarlet.getStatus().getCurrentHp() / 3);
				specialcamera(strongScarlet, 200, 260, 30, 0, 9000, 0, 0);
				weakScarlet.decayMe();
				weakScarlet.deleteMe();
				weakScarlet = null;
				strongScarlet.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
				strongScarlet.abortAttack();
				strongScarlet.abortCast();
				ThreadPoolManager.getInstance().scheduleGeneral(new thirdMorph(33), 1000);
				break;
			case 33:
				specialcamera(strongScarlet, 200, 270, -10, 2000, 9000, 0, 0);
				social(strongScarlet, 1);
				ThreadPoolManager.getInstance().scheduleGeneral(new thirdMorph(34), 2000);
				break;
			case 34:
				specialcamera(strongScarlet, 200, 230, 0, 0, 9000, 0, 0);
				ThreadPoolManager.getInstance().scheduleGeneral(new thirdMorph(35), 1000);
				break;
			case 35:
				specialcamera(strongScarlet, 200, 230, 0, 2000, 9000, 0, 20/**/);
				ThreadPoolManager.getInstance().scheduleGeneral(new thirdMorph(3), 2000);
				break;
			case 3:
				specialcamera(strongScarlet, 400, 250, 0, 2000, 4000, 0, 0);
				social(strongScarlet, 2);
				ThreadPoolManager.getInstance().scheduleGeneral(new thirdMorph(4), 4000);
				break;
			case 4:
				L2Character s = getRandomTarget(strongScarlet);
				((L2GrandBossInstance) strongScarlet).addDamageHate(s, 0, 9999);
				strongScarlet.getAI().setIntention(AI_INTENTION_ATTACK, s);
				_retarget = ThreadPoolManager.getInstance().scheduleGeneral(new retarget(), 1000);
				_skillScarlet = ThreadPoolManager.getInstance().scheduleGeneral(new strongscarlet(), 10000);
				_skillFrintezza = ThreadPoolManager.getInstance().scheduleGeneral(new frinteza(), 1000);
				break;
			}
		}
	}

	private class scarletDie implements Runnable
	{
		private int _taskId = 0;

		public scarletDie(int taskId)
		{
			_taskId = taskId;
		}

		public void run()
		{
			switch (_taskId)
			{
			case 1:
				if (_retarget != null)
					_retarget.cancel(true);
				if (_skillScarlet != null)
					_skillScarlet.cancel(true);
				if (_skillFrintezza != null)
					_skillFrintezza.cancel(true);
				specialcamera(strongScarlet, 500, 90, 80, 0, 10000, 0, 0);
				ThreadPoolManager.getInstance().scheduleGeneral(new scarletDie(2), 10000);
				break;
			case 2:
				specialcamera(frintezza, 100, 120, 10, 0, 12000, 0, 0);
				ThreadPoolManager.getInstance().scheduleGeneral(new scarletDie(22), 2000);
				break;
			case 22:
				specialcamera(frintezza, 100, 90, 30, 3000, 12000, 0, 0);
				frintezza.doDie(frintezza);
				_zone.broadcastPacket(new Die(frintezza));
				ThreadPoolManager.getInstance().scheduleGeneral(new scarletDie(3), 5000);
				break;
			case 3:
				cube = createNewSpawn(29061, 174226, -88035, -5115, 42682);	//e|[g L[u
				specialcamera(frintezza, 1000, 90, 30, 4000, 6000, 0, 0);
				GrandBossManager.getInstance().setBossStatus(29045, DEAD);
				StatsSet set = GrandBossManager.getInstance().getStatsSet(29045);
				set.set("respawn_time", System.currentTimeMillis() + 432000000); // respawn
				// 5
				// days??
				GrandBossManager.getInstance().setStatsSet(29045, set);
				ThreadPoolManager.getInstance().scheduleGeneral(new spawntask(), 432000000);
				if (_clean != null)
					_clean.cancel(true);
				ThreadPoolManager.getInstance().scheduleGeneral(new cleantask(), 900000);
				break;
			}
		}
	}

	private class frintezzaIntro implements Runnable
	{
		private int _taskId = 0;

		public frintezzaIntro(int taskId)
		{
			_taskId = taskId;
		}

		public void run()
		{
			switch (_taskId)
			{
			case 1:
				frintezza.setIsInvul(true);
				frintezza.abortAttack();
				frintezza.abortCast();
/**/			dummy3 = createNewSpawn(29052, 174232, -88023, -5115, 56847);	//JFVBep(910)
				dummy3.setIsImmobilized(true);
				specialcamera(dummy3, 30, -180, -20, 0, 4100, 0, 0);
				ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(2), 4000);
				break;
			case 2:
				specialcamera(dummy3, 800, 90, -90, 6000, 6100, 0, 0);
				ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(3), 5000);
				break;
			case 3:
				specialcamera(frintezza, 1500, 90, 10, 2000, 3000, 0, 0);
/**/			dummy3.deleteMe();
				ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(4), 2000);
				break;
			case 4:
				specialcamera(frintezza, 200, 90, -10, 3000, 4100, 0, 0);
				ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(5), 4000);
				break;
			case 5:
				specialcamera(frintezza, 100, 90, 25, 3000, 11000, 0, 0);
				ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(6), 4000);
				break;
			case 6:
				specialcamera(frintezza, 80, 70, -10, 0, 11000, 0, 0);
				social(frintezza, 1);
				portrait3 = createNewSpawn(29050, 172608, -88702, -4972, 64817);	//nV uX
				portrait4 = createNewSpawn(29051, 172634, -87165, -4972, 57730);	//nV uX
				dummy = createNewSpawn(29053, 174228, -88019, -5122, 57730);		//JF̃VbN(60)
				dummy.setIsImmobilized(true);
				dummy2 = createNewSpawn(29053, 175493, -88744, -5108, 45719);		//JFPۑ(60)
				dummy2.setIsImmobilized(true);
				ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(7), 7000);
				break;
			case 7:
				portrait1 = createNewSpawn(29050, 175833, -87165, -4972, 35048);	//nV uX
				portrait2 = createNewSpawn(29051, 175876, -88713, -4972, 28205);	//nV uX
				specialcamera(dummy2, 250, -55, 10, 0, 6000, 0, 0);
				ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(8), 1500);
				break;
			case 8:
				social(portrait1, 1);	//G悩яo
				social(portrait2, 1);	//G悩яo
				ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(9), 4000);
				break;
			case 9:
				specialcamera(frintezza, 200, 90, -10, 0, 10000, 0, 0);
				ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(99), 1000);
				break;
			case 99:
				specialcamera(frintezza, 100, 90, 25, 5000, 10000, 0, 0);
				social(frintezza, 3);
/**/			weakScarlet = createNewSpawn(29046, 174226, -88035, -5115, 42682);	//XJ[bg @ nVP()
				ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(10), 5000);
				break;
			case 10:
				specialcamera(frintezza, 10, 170, 40, 0, 10000, 0, 0);
				frintezza.enableAllSkills();
				L2Skill _skill = SkillTable.getInstance().getInfo(5006, 1);	//oF{tB
				cast(frintezza, _skill);
/**/			weakScarlet.deleteMe();
				ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(11), 5000);
				break;
			case 11:
				specialcamera(frintezza, 1100, 160, 30, 4000, 4100, 0, 0);
				dummy1 = createNewSpawn(29053, 173319, -88443, -3312, 48028);	//JF̃VbNp(60)
				dummy1.setIsImmobilized(true);
				ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(12), 4000);
				break;
			case 12:
				specialcamera(frintezza, 1600, 120, 30, 4000, 4100, 0, 0);
				ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(13), 4000);
				frintezza.setIsInvul(false);
				break;
			case 13:
				specialcamera(dummy1, 2100, 155, -45, 0, 6000, 0, 0);
				L2Skill _skil = SkillTable.getInstance().getInfo(5004, 1);	//̃VbN
				cast(dummy, _skil);
				frintezza.setIsInvul(false);
				ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(14), 5000);
				break;
			case 14:
				specialcamera(dummy, 500, 0, 30, 4000, 4300, 0, 0);
				ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(15), 200);
				break;
			case 15:
/**/			weakScarlet = createNewSpawn(29046, 174226, -88035, -5115, 42682);	//XJ[bg @ nVP
//-				weakScarlet.disableSkill(5017);	//f[1 ϐgB
//-				weakScarlet.disableSkill(5018);	//f[* @wB
				ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(16), 4000);
				break;
			case 16:
				specialcamera(weakScarlet, 200, -90, 20, 4000, 5000, 0, 0);
				ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(17), 5000);
				break;
			case 17:
				dummy.decayMe();
				dummy.deleteMe();
				dummy1.decayMe();
				dummy1.deleteMe();
				L2Character s = getRandomTarget(weakScarlet);
				((L2GrandBossInstance) weakScarlet).addDamageHate(s, 0, 9999);
				weakScarlet.getAI().setIntention(AI_INTENTION_ATTACK, s);
				_skillFrintezza = ThreadPoolManager.getInstance().scheduleGeneral(new frinteza(), 1000);
				_retarget = ThreadPoolManager.getInstance().scheduleGeneral(new retarget(), 40000);
				_skillScarlet = ThreadPoolManager.getInstance().scheduleGeneral(new weakscarlet(), 40000);
				_clean = ThreadPoolManager.getInstance().scheduleGeneral(new check_pc(), 300000);
				break;
			}
		}
	}

	protected void specialcamera(L2Npc target, int dist, int yaw, int pitch, int time, int duration, int turn, int rise)
	{
		if (target == null)
			return;

		for (L2Character pc : _zone.getCharactersInside().values())
		{
			if (pc instanceof L2PcInstance)
			{
				((L2PcInstance) pc).abortAttack();
				((L2PcInstance) pc).abortCast();
				((L2PcInstance) pc).setTarget(null);
				((L2PcInstance) pc).getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
				((L2PcInstance) pc).sendPacket(new SpecialCamera(target.getObjectId(), dist, yaw, pitch, time, duration, turn, rise, 1, 0));
			}
		}
	}

	protected void social(L2Npc target, int action)
	{
		if (target == null)
			return;

		_zone.broadcastPacket(new SocialAction(target.getObjectId(), action));
	}

	protected void cast(L2Npc npc, L2Skill skill)
	{
		if (npc == null)
			return;
		if (skill == null)
			return;

		_zone.broadcastPacket(new MagicSkillUse(npc, npc, skill.getDisplayId(), skill.getLevel(), skill.getHitTime(), skill.getReuseDelay()));
	}

	protected void npcupdate()
	{
		for (L2Character pc : _zone.getCharactersInside().values())
		{
			if (pc instanceof L2PcInstance)
			{
				((L2PcInstance) pc).sendPacket(new AbstractNpcInfo.NpcInfo(weakScarlet, pc));
			}
		}
	}

	protected L2Character getRandomTarget(L2Npc npc)
	{
		FastList<L2Character> result = new FastList<L2Character>();
		Collection<L2Object> objs = npc.getKnownList().getKnownObjects().values();
		{
			for (L2Object obj : objs)
			{
				if (obj instanceof L2Character)
				{
					if (!(GeoData.getInstance().canSeeTarget(((L2Character) obj).getX(), ((L2Character) obj).getY(), ((L2Character) obj).getZ(), npc.getX(), npc.getY(), npc.getZ())) || ((L2Character) obj).isGM())
						continue;
				}
				if (obj instanceof L2PcInstance || obj instanceof L2Summon || obj instanceof L2DecoyInstance)
				{
					if (Util.checkIfInRange(9000, npc, obj, true) && !((L2Character) obj).isDead())
						result.add((L2Character) obj);
				}
			}
		}
		if (result.size() != 0)
		{
			Object[] characters = result.toArray();
			return (L2Character) characters[Rnd.get(characters.length)];
		}
		return null;
	}

	protected L2Skill getRandomSkill(L2Npc npc)
	{
		L2Skill s = null;
		int skill;
		int lvl;
		if (npc == weakScarlet)
		{
			if (!isMorphed)
			{
				if (Rnd.get(100) < 10)
				{
					skill = 5016;	//XJ[bg̑
					lvl = 1;
				}
				else if (Rnd.get(100) < 10)
				{
					skill = 5016;	//XJ[bg̑
					lvl = 1;
				}
				else if (Rnd.get(100) < 10)
				{
					skill = 5015;	//f[* ˌB
					lvl = Rnd.get(1, 6);
				}
				else
				{
					skill = 5014;	//f[1 ʍUB
					lvl = 1;
				}
				s = SkillTable.getInstance().getInfo(skill, lvl);
			}
			else if (isMorphed)
			{
				if (Rnd.get(100) < 10)
				{
					skill = 5018;	//f[2 @wB
					lvl = 1;
				}
				else if (Rnd.get(100) < 10)
				{
					skill = 5016;	//XJ[bg̑
					lvl = 1;
				}
				else if (Rnd.get(100) < 10)
				{
					skill = 5015;	//f[* ˌB
					lvl = Rnd.get(1, 6);
				}
				else
				{
					skill = 5014;	//f[2 ʍUB
					lvl = 2;
				}
				s = SkillTable.getInstance().getInfo(skill, lvl);
			}
		}
		if (npc == strongScarlet)
		{
			if (Rnd.get(100) < 10)
			{
				skill = 5018;	//f[3 @wB
				lvl = 2;
			}
			else if (Rnd.get(100) < 10)
			{
				skill = 5019;	//f[3 ͈HPzB
				lvl = 1;
			}
			else if (Rnd.get(100) < 10)
			{
				skill = 5015;	//f[* ˌB
				lvl = Rnd.get(1, 6);
			}
			else if (Rnd.get(100) < 10)
			{
				skill = 5016;	//XJ[bg̑
				lvl = 1;
			}
			else
			{
				skill = 5014;	//f[3 ʍUB
				lvl = 3;
			}
			s = SkillTable.getInstance().getInfo(skill, lvl);
		}
		if (npc == frintezza)
		{
			if (Rnd.get(100) < 10)
			{
				skill = 5007;	//oFq[tB
				lvl = 1;
			}
			else if (Rnd.get(100) < 10)
			{
				skill = 5007;	//oFA_bV+ёĐtB
				lvl = 2;
			}
			else if (Rnd.get(100) < 10)
			{
				skill = 5007;	//oFU/xtB
				lvl = 3;
			}
			else if (Rnd.get(100) < 10)
			{
				skill = 5007;	//oFq[}tB
				lvl = 4;
			}
			else if (Rnd.get(100) < 10)
			{
				skill = 5007;	//oF_X+LZtB
				lvl = 5;
			}
			else
			{
				skill = 5006;	//oF{tB
				lvl = 1;
			}
			s = SkillTable.getInstance().getInfo(skill, lvl);
		}
		return s;
	}

	protected synchronized void callSkillAI(L2Npc npc)
	{
		L2Skill _skill = null;

		if (npc.isInvul() || npc.isCastingNow())
			return;

		if (_target == null || _target.isDead())
		{
			_target = getRandomTarget(npc);
			if (_target != null)
				_skill = getRandomSkill(npc);
		}

		L2Character target = _target;
		L2Skill skill = _skill;
		if (skill == null)
			skill = getRandomSkill(npc);
		if (target == null || target.isDead())
		{
			npc.setIsCastingNow(false);
			return;
		}

		if (Util.checkIfInRange(skill.getCastRange(), npc, target, true))
		{
			npc.getAI().setIntention(AI_INTENTION_IDLE);
			npc.setTarget(target);
			npc.setIsCastingNow(true);
			_target = null;
			_skill = null;
			npc.doCast(skill);
		}
		else
		{
			npc.setIsCastingNow(false);
		}
	}

	protected class weakscarlet implements Runnable
	{
		public void run()
		{
			callSkillAI(weakScarlet);
			_skillScarlet = ThreadPoolManager.getInstance().scheduleGeneral(this, 30000);
		}
	}

	protected class strongscarlet implements Runnable
	{
		public void run()
		{
			callSkillAI(strongScarlet);
			_skillScarlet = ThreadPoolManager.getInstance().scheduleGeneral(this, 30000);
		}
	}

	protected class frinteza implements Runnable
	{
		public void run()
		{
			L2Skill _skill = null;
			L2Skill skill = null;
			if (frintezza != null && !frintezza.isDead() && !frintezza.isCastingNow())
			{
				_skill = getRandomSkill(frintezza);
				if (_skill != null)
				{
					frintezza.doCast(_skill);
					if (_skill.getId() == 5007)	//t1`5
					{
						skill = SkillTable.getInstance().getInfo(5008, _skill.getLevel());	//tˍU
						if (skill != null)
						{
							if (weakScarlet != null && !weakScarlet.isDead())
								weakScarlet.doCast(skill);
							if (strongScarlet != null && !strongScarlet.isDead())
								strongScarlet.doCast(skill);
						}
					}
				}
			}
			_skillFrintezza = ThreadPoolManager.getInstance().scheduleGeneral(this, 5000);
		}
	}

	protected class retarget implements Runnable
	{
		public void run()
		{
			if (weakScarlet != null)
			{
				_target = getRandomTarget(weakScarlet);
				((L2GrandBossInstance) weakScarlet).addDamageHate(_target, 0, 9999);
				weakScarlet.getAI().setIntention(AI_INTENTION_ATTACK, _target);
			}
			if (strongScarlet != null)
			{
				_target = getRandomTarget(strongScarlet);
				((L2GrandBossInstance) strongScarlet).addDamageHate(_target, 0, 9999);
				strongScarlet.getAI().setIntention(AI_INTENTION_ATTACK, _target);
			}
			_retarget = ThreadPoolManager.getInstance().scheduleGeneral(this, 120000);
		}
	}

	protected class spawntask implements Runnable
	{
		public void run()
		{
			GrandBossManager.getInstance().setBossStatus(29045, ALIVE);
		}
	}

	public void statuscheck(int id)	//<<== GrandBossmanager
	{
		switch (id)
		{
		case 29046:
			if (weakScarlet.getCurrentHp() <= weakScarlet.getMaxHp() * 2 / 3 && !isMorphed)
			{
				isMorphed = true;
				doSecondMorph();
			}
			else if (weakScarlet.getCurrentHp() <= weakScarlet.getMaxHp() * 1 / 3 && isMorphed && !isSecMorphed)
			{
				isSecMorphed = true;
				doThirdMorph();
			}
			break;
		}
	}

	public void onKill(int id)	//<<== GrandBossmanager
	{
		switch (id)
		{
		case 29047:
			doScarletDie();
			break;
		}
	}

	protected class cleantask implements Runnable
	{
		public void run()
		{
			clean();
		}
	}

	public void clean()
	{
		_zone.oustAllPlayers();
		isMorphed = false;
		isSecMorphed = false;
		if (_skillFrintezza != null)
			_skillFrintezza.cancel(true);
		if (_skillScarlet != null)
			_skillScarlet.cancel(true);
		if (_retarget != null)
			_retarget.cancel(true);
		if (_clean != null)
			_clean.cancel(true);
		if (weakScarlet != null)
		{
			weakScarlet.decayMe();
			weakScarlet.deleteMe();
			weakScarlet = null;
		}
		if (strongScarlet != null)
		{
			strongScarlet.decayMe();
			strongScarlet.deleteMe();
			strongScarlet = null;
		}
		if (frintezza != null)
		{
			frintezza.decayMe();
			frintezza.deleteMe();
			frintezza = null;
		}
		if (portrait1 != null)
		{
			portrait1.decayMe();
			portrait1.deleteMe();
			portrait1 = null;
		}
		if (portrait2 != null)
		{
			portrait2.decayMe();
			portrait2.deleteMe();
			portrait2 = null;
		}
		if (portrait3 != null)
		{
			portrait3.decayMe();
			portrait3.deleteMe();
			portrait3 = null;
		}
		if (portrait4 != null)
		{
			portrait4.decayMe();
			portrait4.deleteMe();
			portrait4 = null;
		}
		if (dummy != null)
		{
			dummy.decayMe();
			dummy.deleteMe();
			dummy = null;
		}
		if (dummy1 != null)
		{
			dummy1.decayMe();
			dummy1.deleteMe();
			dummy1 = null;
		}
		if (dummy3 != null)
		{
			dummy3.decayMe();
			dummy3.deleteMe();
			dummy3 = null;
		}
		if (cube != null)
		{
			cube.decayMe();
			cube.deleteMe();
			cube = null;
		}
	}

	private class check_pc implements Runnable
	{
		public check_pc()
		{
		}

		public void run()
		{
			boolean d = false;

			for (L2Character cha : _zone.getCharactersInside().values())
			{
				if (cha instanceof L2PcInstance)
				{
					d = true;
				}
			}
			if (!d)
			{
				clean();
			}
			else
				_clean = ThreadPoolManager.getInstance().scheduleGeneral(new check_pc(), 300000);
		}
	}
}