/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.context.AllocatorContext;
import javolution.context.ConcurrentContext;
import javolution.context.ObjectFactory;
import javolution.xml.XMLSerializable;

public abstract class Context
implements XMLSerializable {
    public static final Context ROOT = new Root();
    private static final ThreadLocal CURRENT = new ThreadLocal(){

        protected Object initialValue() {
            return ROOT;
        }
    };
    private Thread _owner;
    private Context _outer;
    private ObjectFactory _factory;
    private AllocatorContext _allocator;

    protected Context() {
    }

    public static Context getCurrent() {
        return (Context)CURRENT.get();
    }

    public final Thread getOwner() {
        return this._owner;
    }

    public final Context getOuter() {
        return this._outer;
    }

    public String toString() {
        return "Instance of " + this.getClass().getName();
    }

    protected abstract void enterAction();

    protected abstract void exitAction();

    public static final <T extends Context> T enter(T t) {
        Context context;
        if (t._owner != null) {
            throw new IllegalStateException("Context is currently in use");
        }
        t._outer = context = Context.getCurrent();
        t._owner = Thread.currentThread();
        t._allocator = t instanceof AllocatorContext ? (AllocatorContext)t : context._allocator;
        CURRENT.set(t);
        t.enterAction();
        return t;
    }

    public static final <T extends Context> T enter(Class<T> clazz) {
        ObjectFactory<T> objectFactory = ObjectFactory.getInstance(clazz);
        Context context = (Context)objectFactory.object();
        context._factory = objectFactory;
        Context.enter(context);
        return (T)context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context exit() {
        Context context = Context.getCurrent();
        Context context2 = context._outer;
        if (context2 == null) {
            throw new IllegalStateException(Thread.currentThread() + " Cannot exit instance of " + context.getClass());
        }
        try {
            context.exitAction();
        }
        finally {
            CURRENT.set(context2);
            context._outer = null;
            context._owner = null;
            context._allocator = null;
            if (context._factory != null) {
                context._factory.recycle(context);
                context._factory = null;
            }
        }
        return context;
    }

    protected static void setCurrent(ConcurrentContext concurrentContext) {
        CURRENT.set(concurrentContext);
    }

    final AllocatorContext getAllocatorContext() {
        return this._allocator == null ? AllocatorContext.getDefault() : this._allocator;
    }

    public static final void exit(Context context) {
        Context.exit();
    }

    private static final class Root
    extends Context {
        private Root() {
        }

        @Override
        protected void enterAction() {
            throw new UnsupportedOperationException("Cannot enter the root context");
        }

        @Override
        protected void exitAction() {
            throw new UnsupportedOperationException("Cannot enter the root context");
        }
    }
}

