/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.realtime.MemoryArea;
import javolution.context.ObjectFactory;
import javolution.context.PersistentContext;
import javolution.lang.Reusable;
import javolution.util.FastCollection;
import javolution.util.FastComparator;

public class FastList<E>
extends FastCollection<E>
implements List<E>,
Reusable {
    private static final ObjectFactory FACTORY = new ObjectFactory(){

        public Object create() {
            return new FastList();
        }

        public void cleanup(Object object) {
            ((FastList)object).reset();
        }
    };
    private transient Node<E> _head = this.newNode();
    private transient Node<E> _tail = this.newNode();
    private transient FastComparator<? super E> _valueComparator = FastComparator.DEFAULT;
    private transient int _size;
    static volatile int ONE_VOLATILE = 1;
    private static final long serialVersionUID = 1L;

    public FastList() {
        this(4);
    }

    public FastList(String string) {
        this();
        new PersistentContext.Reference(string, this){

            @Override
            protected void notifyChange() {
                FastList.this.clear();
                FastList.this.addAll((FastList)this.get());
            }
        };
    }

    public FastList(int n) {
        ((Node)this._head)._next = (Node)this._tail;
        ((Node)this._tail)._previous = (Node)this._head;
        Node<E> node = this._tail;
        int n2 = 0;
        while (n2++ < n) {
            Node<E> node2 = this.newNode();
            ((Node)node2)._previous = (Node)node;
            ((Node)node)._next = (Node)node2;
            node = node2;
        }
    }

    public FastList(Collection<? extends E> collection) {
        this(collection.size());
        this.addAll(collection);
    }

    public static <E> FastList<E> newInstance() {
        return (FastList)FACTORY.object();
    }

    public static void recycle(FastList fastList) {
        FACTORY.recycle(fastList);
    }

    @Override
    public final boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public int hashCode() {
        FastComparator<E> fastComparator = this.getValueComparator();
        int n = 1;
        Node node = this._head;
        Node<E> node2 = this._tail;
        while ((node = node._next) != node2) {
            n = 31 * n + fastComparator.hashCodeOf(node._value);
        }
        return n;
    }

    @Override
    public final E get(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        return (E)((Node)this.nodeAt(n))._value;
    }

    @Override
    public final E set(int n, E e) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        Node<E> node = this.nodeAt(n);
        Object object = ((Node)node)._value;
        ((Node)node)._value = e;
        return (E)object;
    }

    @Override
    public final void add(int n, E e) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        this.addBefore(this.nodeAt(n), e);
    }

    @Override
    public final boolean addAll(int n, Collection<? extends E> collection) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        Node<E> node = this.nodeAt(n);
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addBefore(node, iterator.next());
        }
        return collection.size() != 0;
    }

    @Override
    public final E remove(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        Node<E> node = this.nodeAt(n);
        Object object = ((Node)node)._value;
        this.delete(node);
        return (E)object;
    }

    @Override
    public final int indexOf(Object object) {
        FastComparator<E> fastComparator = this.getValueComparator();
        int n = 0;
        Node node = this._head;
        Node<E> node2 = this._tail;
        while ((node = node._next) != node2) {
            if (fastComparator == FastComparator.DEFAULT ? FastList.defaultEquals(object, node._value) : fastComparator.areEqual(object, node._value)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(Object object) {
        FastComparator<E> fastComparator = this.getValueComparator();
        int n = this.size() - 1;
        Node node = this._tail;
        Node<E> node2 = this._head;
        while ((node = node._previous) != node2) {
            if (fastComparator == FastComparator.DEFAULT ? FastList.defaultEquals(object, node._value) : fastComparator.areEqual(object, node._value)) {
                return n;
            }
            --n;
        }
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return FastListIterator.valueOf(this, ((Node)this._head)._next, 0, this._size);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        return FastListIterator.valueOf(this, this.nodeAt(n), n, this._size);
    }

    @Override
    public final List<E> subList(int n, int n2) {
        if (n < 0 || n2 > this._size || n > n2) {
            throw new IndexOutOfBoundsException("fromIndex: " + n + ", toIndex: " + n2 + " for list of size: " + this._size);
        }
        return SubList.valueOf(this, ((Node)this.nodeAt(n))._previous, this.nodeAt(n2), n2 - n);
    }

    @Override
    public final E getFirst() {
        Node node = ((Node)this._head)._next;
        if (node == this._tail) {
            throw new NoSuchElementException();
        }
        return (E)node._value;
    }

    @Override
    public final E getLast() {
        Node node = ((Node)this._tail)._previous;
        if (node == this._head) {
            throw new NoSuchElementException();
        }
        return (E)node._value;
    }

    @Override
    public final void addFirst(E e) {
        this.addBefore(((Node)this._head)._next, e);
    }

    @Override
    public void addLast(E e) {
        if (((Node)this._tail)._next == null) {
            this.increaseCapacity();
        }
        ((Node)this._tail)._value = e;
        this._tail = ((Node)this._tail)._next;
        this._size += ONE_VOLATILE;
    }

    @Override
    public final E removeFirst() {
        Node node = ((Node)this._head)._next;
        if (node == this._tail) {
            throw new NoSuchElementException();
        }
        Object object = node._value;
        this.delete(node);
        return (E)object;
    }

    @Override
    public final E removeLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        this._size -= ONE_VOLATILE;
        Node node = ((Node)this._tail)._previous;
        Object object = node._value;
        this._tail = node;
        node._value = null;
        return (E)object;
    }

    public final void addBefore(Node<E> node, E e) {
        Node node2;
        Node node3;
        if (((Node)this._tail)._next == null) {
            this.increaseCapacity();
        }
        if ((node3 = (((Node)this._tail)._next = (node2 = ((Node)this._tail)._next)._next)) != null) {
            node3._previous = (Node)this._tail;
        }
        Node node4 = ((Node)node)._previous;
        node4._next = node2;
        ((Node)node)._previous = node2;
        node2._next = (Node)node;
        node2._previous = node4;
        node2._value = e;
        this._size += ONE_VOLATILE;
    }

    private final Node<E> nodeAt(int n) {
        Node node = this._head;
        int n2 = n;
        while (n2-- >= 0) {
            node = node._next;
        }
        return node;
    }

    @Override
    public final Node<E> head() {
        return this._head;
    }

    @Override
    public final Node<E> tail() {
        return this._tail;
    }

    @Override
    public final E valueOf(FastCollection.Record record) {
        return (E)((Node)record)._value;
    }

    @Override
    public final void delete(FastCollection.Record record) {
        Node node = (Node)record;
        this._size -= ONE_VOLATILE;
        node._value = null;
        node._previous._next = node._next;
        node._next._previous = node._previous;
        Node node2 = ((Node)this._tail)._next;
        node._previous = (Node)this._tail;
        node._next = node2;
        ((Node)this._tail)._next = node;
        if (node2 != null) {
            node2._previous = node;
        }
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final void clear() {
        this._size = ONE_VOLATILE - 1;
        Node node = this._head;
        Node<E> node2 = this._tail;
        while ((node = node._next) != node2) {
            node._value = null;
        }
        this._tail = ((Node)this._head)._next;
    }

    @Override
    public void reset() {
        this.clear();
        this._valueComparator = FastComparator.DEFAULT;
    }

    public FastList<E> setValueComparator(FastComparator<? super E> fastComparator) {
        this._valueComparator = fastComparator;
        return this;
    }

    @Override
    public FastComparator<? super E> getValueComparator() {
        return this._valueComparator;
    }

    @Override
    public List<E> unmodifiable() {
        return (List)super.unmodifiable();
    }

    protected Node<E> newNode() {
        return new Node();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        this._head = new Node();
        this._tail = new Node();
        ((Node)this._head)._next = (Node)this._tail;
        ((Node)this._tail)._previous = (Node)this._head;
        this.setValueComparator((FastComparator)objectInputStream.readObject());
        int n2 = n = objectInputStream.readInt();
        while (n2-- != 0) {
            this.addLast(objectInputStream.readObject());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.getValueComparator());
        objectOutputStream.writeInt(this._size);
        Node node = this._head;
        int n = this._size;
        while (n-- != 0) {
            node = node._next;
            objectOutputStream.writeObject(node._value);
        }
    }

    private void increaseCapacity() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            @Override
            public void run() {
                Node node = FastList.this.newNode();
                FastList.this._tail._next = node;
                node._previous = FastList.this._tail;
                Node node2 = FastList.this.newNode();
                node._next = node2;
                node2._previous = node;
                Node node3 = FastList.this.newNode();
                node2._next = node3;
                node3._previous = node2;
                Node node4 = FastList.this.newNode();
                node3._next = node4;
                node4._previous = node3;
            }
        });
    }

    private static boolean defaultEquals(Object object, Object object2) {
        return object == null ? object2 == null : object == object2 || object.equals(object2);
    }

    private static final class FastListIterator
    implements ListIterator {
        private static final ObjectFactory FACTORY = new ObjectFactory(){

            protected Object create() {
                return new FastListIterator();
            }

            protected void cleanup(Object object) {
                FastListIterator fastListIterator = (FastListIterator)object;
                fastListIterator._list = null;
                fastListIterator._currentNode = null;
                fastListIterator._nextNode = null;
            }
        };
        private FastList _list;
        private Node _nextNode;
        private Node _currentNode;
        private int _length;
        private int _nextIndex;

        private FastListIterator() {
        }

        public static FastListIterator valueOf(FastList fastList, Node node, int n, int n2) {
            FastListIterator fastListIterator = (FastListIterator)FACTORY.object();
            fastListIterator._list = fastList;
            fastListIterator._nextNode = node;
            fastListIterator._nextIndex = n;
            fastListIterator._length = n2;
            return fastListIterator;
        }

        @Override
        public boolean hasNext() {
            return this._nextIndex != this._length;
        }

        @Override
        public Object next() {
            if (this._nextIndex == this._length) {
                throw new NoSuchElementException();
            }
            ++this._nextIndex;
            this._currentNode = this._nextNode;
            this._nextNode = this._nextNode._next;
            return this._currentNode._value;
        }

        @Override
        public int nextIndex() {
            return this._nextIndex;
        }

        @Override
        public boolean hasPrevious() {
            return this._nextIndex != 0;
        }

        public Object previous() {
            if (this._nextIndex == 0) {
                throw new NoSuchElementException();
            }
            --this._nextIndex;
            this._currentNode = this._nextNode = this._nextNode._previous;
            return this._currentNode._value;
        }

        @Override
        public int previousIndex() {
            return this._nextIndex - 1;
        }

        public void add(Object object) {
            this._list.addBefore(this._nextNode, object);
            this._currentNode = null;
            ++this._length;
            ++this._nextIndex;
        }

        public void set(Object object) {
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            this._currentNode._value = object;
        }

        @Override
        public void remove() {
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            if (this._nextNode == this._currentNode) {
                this._nextNode = this._nextNode._next;
            } else {
                --this._nextIndex;
            }
            this._list.delete(this._currentNode);
            this._currentNode = null;
            --this._length;
        }
    }

    private static final class SubList
    extends FastCollection
    implements List,
    Serializable {
        private static final ObjectFactory FACTORY = new ObjectFactory(){

            protected Object create() {
                return new SubList();
            }

            protected void cleanup(Object object) {
                SubList subList = (SubList)object;
                subList._list = null;
                subList._head = null;
                subList._tail = null;
            }
        };
        private FastList _list;
        private Node _head;
        private Node _tail;
        private int _size;

        private SubList() {
        }

        public static SubList valueOf(FastList fastList, Node node, Node node2, int n) {
            SubList subList = (SubList)FACTORY.object();
            subList._list = fastList;
            subList._head = node;
            subList._tail = node2;
            subList._size = n;
            return subList;
        }

        @Override
        public int size() {
            return this._size;
        }

        @Override
        public FastCollection.Record head() {
            return this._head;
        }

        @Override
        public FastCollection.Record tail() {
            return this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return this._list.valueOf(record);
        }

        @Override
        public void delete(FastCollection.Record record) {
            this._list.delete(record);
        }

        public boolean addAll(int n, Collection collection) {
            if (n < 0 || n > this._size) {
                throw new IndexOutOfBoundsException("index: " + n);
            }
            Node node = this.nodeAt(n);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this._list.addBefore(node, iterator.next());
            }
            return collection.size() != 0;
        }

        public Object get(int n) {
            if (n < 0 || n >= this._size) {
                throw new IndexOutOfBoundsException("index: " + n);
            }
            return this.nodeAt(n)._value;
        }

        public Object set(int n, Object object) {
            if (n < 0 || n >= this._size) {
                throw new IndexOutOfBoundsException("index: " + n);
            }
            Node node = this.nodeAt(n);
            Object object2 = node._value;
            node._value = object;
            return object2;
        }

        public void add(int n, Object object) {
            if (n < 0 || n > this._size) {
                throw new IndexOutOfBoundsException("index: " + n);
            }
            this._list.addBefore(this.nodeAt(n), object);
        }

        public Object remove(int n) {
            if (n < 0 || n >= this._size) {
                throw new IndexOutOfBoundsException("index: " + n);
            }
            Node node = this.nodeAt(n);
            Object object = node._value;
            this._list.delete(node);
            return object;
        }

        @Override
        public int indexOf(Object object) {
            FastComparator fastComparator = this._list.getValueComparator();
            int n = 0;
            Node node = this._head;
            Node node2 = this._tail;
            while ((node = node._next) != node2) {
                if (fastComparator.areEqual(object, node._value)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            FastComparator fastComparator = this.getValueComparator();
            int n = this.size() - 1;
            Node node = this._tail;
            Node node2 = this._head;
            while ((node = node._previous) != node2) {
                if (fastComparator.areEqual(object, node._value)) {
                    return n;
                }
                --n;
            }
            return -1;
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int n) {
            if (n >= 0 && n <= this._size) {
                return FastListIterator.valueOf(this._list, this.nodeAt(n), n, this._size);
            }
            throw new IndexOutOfBoundsException("index: " + n + " for list of size: " + this._size);
        }

        public List subList(int n, int n2) {
            if (n < 0 || n2 > this._size || n > n2) {
                throw new IndexOutOfBoundsException("fromIndex: " + n + ", toIndex: " + n2 + " for list of size: " + this._size);
            }
            SubList subList = SubList.valueOf(this._list, this.nodeAt(n)._previous, this.nodeAt(n2), n2 - n);
            return subList;
        }

        private final Node nodeAt(int n) {
            if (n <= this._size >> 1) {
                Node node = this._head;
                int n2 = n;
                while (n2-- >= 0) {
                    node = node._next;
                }
                return node;
            }
            Node node = this._tail;
            int n3 = this._size - n;
            while (n3-- > 0) {
                node = node._previous;
            }
            return node;
        }
    }

    public static class Node<E>
    implements FastCollection.Record,
    Serializable {
        private Node<E> _next;
        private Node<E> _previous;
        private E _value;

        protected Node() {
        }

        public final E getValue() {
            return this._value;
        }

        @Override
        public final Node<E> getNext() {
            return this._next;
        }

        @Override
        public final Node<E> getPrevious() {
            return this._previous;
        }
    }
}

