<?php
    //========================================================================================================================
    /**
     * Webアプリケーションコンテナクラス
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    LabbitBox
     * @subpackage core
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      -
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    class Application{
        protected $_lbSession     = NULL;
        protected $_controller    = NULL;
        protected $_request;
        protected $_session;
        protected $_shared;
        protected $_params;   //起動パラメータ
         
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         * リクエスト/レスポンス/セッションの各オブジェクトを生成し
         *
         * @param string $project プロジェクトディレクトリ名(指定なしの場合はアプリケーションディレクトリ直下に配置)
         */
        //-------------------------------------------------------------------------------------------------------------------
        function __construct($confDir, $appDir, $docRoot = ''){
            //イニシャライズオブジェクト生成
            require_once(dirname(__FILE__).'/Init.php');
            $wInit  = new Init($confDir,            //設定ファイルディレクトリ
                               dirname(__FILE__),   //フレームワークディレクトリ
                               $appDir,             //プリケーションディレクトリ
                               $docRoot);           //ドキュメントルート
           
            //基本変数オブジェクト生成
            $this->_request = new Request();
            $this->_session = new Session();
            $this->_shared  = new Shared();
        
            //設定ファイルロード
            $wInit->loadConfig($this);              //アプリケーションオブジェクト
            
            //コントローラ前処理オブジェクト
            //CLIチェック
            $wPrefix    = (isset($_SERVER['argc']) ? 'cli' : 'sys');
            if ($wPrefix == 'cli'){
                argvToRequest();
            }else if(file_exists(BASE_APP.'/_precontroller.php')){
                require_once(BASE_APP.'/_precontroller.php');
                $wPrecontroller = new _precontroller($this);
                $this->_lbSession   = $wPrecontroller->lbSession();
            }

            //コントローラオブジェクト生成
            $type       = ($this->request()->isExist('type') ? $this->request('type') : $this->shared('SYSTEM_CONFIG')->value($wPrefix.'.type'));
            switch ($type){
                case 'ajax':
                case 'http':
                    require_once(BASE_LIB.'/AjaxRequest.php');
                    $this->_controller  = new AjaxRequest($this);
                    break;
                
                case 'ds':
                    require_once(BASE_LIB.'/DataCollector.php');
                    $this->_controller  = new DataCollector($this);
                    break;
                
                case 'rpc':
                    require_once(BASE_LIB.'/Router.php');
                    $this->_controller  = new Router($this);
                    break;
                
                case 'cli':
                    require_once(BASE_LIB.'/CLI.php');
                    $this->_controller  = new Cli($this);
                    break;
                
                case 'html':
                default:
                    require_once(BASE_LIB.'/Renderer.php');
                    if (isset($wPrecontroller) && $this->_lbSession->getTemplate){
                        $wTemplateName  = $this->_lbSession->getTemplate();
                    }
                    else{
                        $wTemplateName  = $this->shared('SYSTEM_CONFIG')->value('sys.base_template');
                    }
         
                    $wTemplatePath  = (TEMPLATE_DIR == '' ? PRJHOME : TEMPLATE_DIR);
                    $this->_controller  = new Renderer($this, $wTemplateName, $wTemplatePath);
                    break;
            }
        }
        
        function __destruct(){

        }

        public function lbSession(){
            return $this->_lbSession;
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * アプリケーション実行
         */    
        //-------------------------------------------------------------------------------------------------------------------
        public function run(){
            return $this->_controller->execute();
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * 起動パラメータ保存
         * @param string $key   起動パラメータ名称
         * @param string $value 起動パラメータ値
         */    
        //-------------------------------------------------------------------------------------------------------------------
        public function setParam($key, $value){
            $this->_params[$key]    = $value;
        }
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * 起動パラメータ取得
         * @param string $key   起動パラメータ名称
         * @return string   起動パラメータ値
         */    
        //-------------------------------------------------------------------------------------------------------------------
        public function param($key){
            return $this->_params[$key];
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * リクエスト変数($_REQUEST)ゲッタ
         *
         * @param string $agName リクエスト変数($_REQUEST)名 : 引数が空文字''の場合はオブジェクト自身を返す
         * @return variable 変数値または自オブジェクト
         * 
         */    
        //-------------------------------------------------------------------------------------------------------------------
        public function request($agName = ''){
            if ($agName == ''){
                return $this->_request;
            }
            elseif ($this->_request->isExist($agName)){
                return $this->_request->get($agName);
            }
            else{
                die(sprintf("Invalid Request variable Name : %s\n", $agName));
            }
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * セッション変数($_SESSION)ゲッタ
         *
         * @param string $agName セッション変数($_SESSION)名 : 引数が空文字''の場合はオブジェクト自身を返す
         * @return variable 変数値または自オブジェクト
         */    
        //-------------------------------------------------------------------------------------------------------------------
        public function session($agName = ''){
            if ($agName == ''){
                return $this->_session;
            }
            elseif ($this->_session->isExist($agName)){
                return $this->_session->get($agName);
            }
            else{
                die(sprintf("Invalid Session variable Name : %s\n", $agName));
            }
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * 共有変数ゲッタ
         *
         * @param string $agName 共有変数名 : 引数が空文字''の場合はオブジェクト自身を返す
         * @return variable 変数値または自オブジェクト
         */    
        //-------------------------------------------------------------------------------------------------------------------
        public function shared($agName = ''){
            if ($agName == ''){
                return $this->_shared;
            }
            elseif ($this->_shared->isExist($agName)){
                return $this->_shared->get($agName);
            }
            else{
                die(sprintf("Invalid Shared variable Name : %s\n", $agName));
            }
        }

        public function config($tagName){
            return $this->shared()->get('SYSTEM_CONFIG')->value($tagName);
        }

    }

?>
