<?php
    //========================================================================================================================
    /**
     * MVCビュークラス：クライアントビュー
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    LabbitBox
     * @subpackage core
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      2010/11/10
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(BASE_LIB.'/HtmlBasicView.php');

    class ClientView extends HtmlBasicView{
        protected $_jsEventList     = array();

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         * @param object    $application    アプリケーションオブジェクト
         * @param object    $templateName   テンプレート名   
         * @param string    $templateDir    テンプレート格納ディレクトリ
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($application, $templateName = '', $templateDir = ''){
            parent::__construct($application);
            $this->_className   = 'ClientView';

            $wTemplateDir   = ($templateDir == '' ? (TEMPLATE_DIR == '' ? PRJHOME : TEMPLATE_DIR) : $templateDir);
            $wTemplatePath  = $wTemplateDir.'/'.$templateName;
            $wMeta          = '<meta http-equiv="Content-Type" content="text/html; charset=utf-8">';
            $this->textTemplate($wMeta.file_get_contents($wTemplatePath));           
        }



        /**
         * テンプレート設定
         *
         * ClientView, EmbededViewは標準で部分HTMLを扱うため、文字化け防止のために自動でmetaを追加する。
         *
         * @author "minotaur"<minotaur@labbitbox.org>
         *
         * @param string $templateName テンプレート名(ファイル名)
         * @param string $templateDir  テンプレートディレクトリ(省略可)
         *
         * @return TRUE
         */
        public function setTemplate($templateName, $templateDir=''){
            $this->_doc->preserveWhiteSpace = false;
            $this->_doc->formatOutput       = true;
            if($templateName != ''){
                $wTemplateDir   = ($templateDir == '' ? (TEMPLATE_DIR == '' ? PRJHOME : TEMPLATE_DIR) : $templateDir);
                $wTemplatePath  = $wTemplateDir.'/'.$templateName;
                if (file_exists($wTemplatePath)){
                    $wMeta = '<meta http-equiv="Content-Type" content="text/html; charset=utf-8">';
                    $this->textTemplate($wMeta.file_get_contents($wTemplatePath));           
                }
                else{
                    $wMeta = '<meta http-equiv="Content-Type" content="text/html; charset=utf-8">';
                    $this->textTemplate($wMeta.'<div id="'.$templateName.'"></div>');
                }
            }else{
                $wMeta = '<meta http-equiv="Content-Type" content="text/html; charset=utf-8">';
                $this->textTemplate($wMeta);
            }
            return TRUE;
        }


        //-------------------------------------------------------------------------------------------------------------------
        /**
         * レスポンス文字列生成
         * 自DOMオブジェクトからHTML文字列に展開する
         *
         * @return string   HTML文字列
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function build(){
            parent::build();

            //Javascriptライブラリ・イベント定義
            if ($this->_eventManager->count() > 0){
                $this->addJsEvent($this->_eventManager->items());
            }

            return $this->_doc;
        }

        public function responseHeadItems(){ 
            //<head>部
            $wDynamicModify     = array();
            //-- 起動情報
            $wDynamicModify['LB_INFO']  = "['".implode("','", $this->_lbInfo)."']";           

            //-- イベント定義
            $wDynamicModify['EVENT']    = $this->_insertJsEvent();

             //-- CSS定義
            $wDynamicModify['CSSFILE']  = $this->_insertCssLink();   //CSSファイルインクルード定義
            $wDynamicModify['CSS']      = $this->_insertStyleCss();  //CSS定義
            
            //-- Javascript定義
            $wDynamicModify['JSFILE']   = $this->_insertJsInclude(); //Javascriptインクルード定義
            $wDynamicModify['JS']       = $this->_insertJsScript();  //Javascript関数定義追加

            //要素なしリスト削除
            foreach($wDynamicModify as $_key => $_list){
                if (count($_list) == 0){
                    unset($wDynamicModify[$_key]);
                }
            }
        
            return $wDynamicModify;
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * CSSファイルインクルード定義→DOM追加
         * addCssLink()で追加した定義をドキュメントに追加する
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function _insertMeta(){
            return $this->_metaList;
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * CSSファイルインクルード定義→DOM追加
         * addCssLink()で追加した定義をドキュメントに追加する
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function _insertCssLink(){
            return $this->_cssPathList;
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * CSS定義→DOM追加
         * addStyleCss()で追加した定義をドキュメントに追加する
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function _insertStyleCss(){
            return $this->_styleList;
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * Javascript外部ファイル定義→DOM追加
         * addJsFile()で追加した定義をドキュメントに追加する
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function _insertJsInclude(){
            return $this->_jsFileList;
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * ページロード時実行スクリプト→DOM追加
         * addLoadJs()で追加した定義をドキュメントに追加する
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function _insertLoadJs(){
  
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * Javascript関数定義→DOM追加
         * addJsFunction()で追加した定義をドキュメントに追加する
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function _insertJsScript(){
            //存在チェック
            if (count($this->_jsFunctionList) + count($this->_jsScriptList) == 0){
                return array();
            }
            
            //関数定義展開:addJsFunction()で追加した定義
            $wJsList    = array();
            foreach ($this->_jsFunctionList as $_function => $_code){
                $wDefinition    = array();
                $wDefinition[]  = "function ".$_function."(".$_code[0]."){";
                $wDefinition[]  = implode($this->config('sys.delimiterForJs'), $_code[1]);
                $wDefinition[]  = "}";
                $wJsList[]      = implode($this->config('sys.delimiterForJs'), $wDefinition);
            }
    
            //スクリプト定義展開:addJsScript()で追加した定義
            foreach ($this->_jsScriptList as $_script){
                $wJsList[]      = implode($this->config('sys.delimiterForJs'), $_script);
            }

            return $wJsList;
        }

        private function addJsEvent($event){
            $wkEvent   = (is_array($event) ? $event : array($event));
            $this->_jsEventList[]  = $wkEvent;
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * Javascript外部ファイル定義→DOM追加
         * addJsFile()で追加した定義をドキュメントに追加する
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function _insertJsEvent(){
            return $this->_jsEventList;
        }

    }

?>
