<?php
    //========================================================================================================================
    /**
     * MVCクラス：コントローラー（通常HTML用）
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    LabbitBox
     * @subpackage core
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      2010/2/26
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    class Controller {
        protected $_app     = NULL;     //アプリケーションオブジェクト(親オブジェクト)
        protected $_model   = NULL;
        protected $_view    = NULL;

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         * @param object    $application    アプリケーションオブジェクト
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($application){
            //アプリケーションオブジェクト保存
            $this->_app         = $application;

            //CLIチェック
            $wPrefix    = (isset($_SERVER['argc']) ? 'cli' : 'sys');
            
            //起動パラメータ取得
            $wkRQ               = $this->_app->request();
            $this->_app->setParam('action', ($wkRQ->isExist('action') ? $wkRQ->get('action') : $this->config($wPrefix.'.action')));
            $this->_app->setParam('method', ($wkRQ->isExist('method') ? $wkRQ->get('method') : $this->config($wPrefix.'.method')));
            $this->_app->setParam('type',   ($wkRQ->isExist('type')   ? $wkRQ->get('type')   : $this->config($wPrefix.'.type')));

            //----------------------------------------------------------------------------------------------------------------
            //モデルオブジェクト生成
            $wkModelClassName   = $this->_app->param('action').'_M';
            $wkModelFilePath    = PRJHOME.'/'.$wkModelClassName.'.php';
            if (file_exists($wkModelFilePath)){
                require_once($wkModelFilePath);
                $this->_model   = new $wkModelClassName($this->_app);
            }
        }
        
        function __destruct(){

        }
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * システム設定情報取得
         * @param string    $tagName    設定タグ名
         * @param string    $elementID  エントリーID
         * @return string   config設定値
         */
        //-------------------------------------------------------------------------------------------------------------------
        protected function config($tagName){
            return $this->_app->shared('SYSTEM_CONFIG')->value($tagName);
        }

        protected function configByID($elementID){
            return $this->_app->shared('SYSTEM_CONFIG')->valueByID($elementID);
        }
        
        protected function session($entryID = ''){
            return $this->_app->session($entryID);
        }    
       
        protected function request($entryID = ''){
            return $this->_app->request($entryID);
        }    
       
        protected function shared($entryID = ''){
            return $this->_app->shared($entryID);
        }    
     
    }

?>
