<?php
/**
 * DatabaseDriver abstruction class
 *
 * Database class presents abstract handling for any type of RDBMS or data collection(php array, xml, csv ....)
 *
 * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
 * http://www.gnu.org/licenses/gpl-3.0.txt.
 *
 * @package    LabbitBox
 * @subpackage DB
 * @copyright  2010 LabbitBox Development Team.
 * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
 * @author     minotaur <minotaur@labbitbox.org>
 * @version    v0.1
 * @since      -
 * @link       http://labbitbox.org/
 * @see        http://labbitbox.org/
 * @todo       sync to DB_Driver_firebird.php
 */
class DB_Driver{

    protected $_db;


    /**
     * constructor
     *
     * @param DB $parent
     */
    public function __construct($parent){
        $this->_db = $parent;
        $this->_db->loadSql(dirname(__FILE__).'/../xml/DB_Driver_'.$this->_db->type().'.sql.xml');
    }


    public function __destruct(){}
    public function connect($agServer, $agPort, $agDatabasePath, $agUserName, $agPassword, $agCharacterSet=NULL){}
    public function disconnect($connection){}
    public function startTransaction($connection){}
    public function commit($transaction=NULL){}
    public function rollback($transaction=NULL){}
    public function checkpoint($transaction=NULL){}
    public function query($transaction, $sql){}
    public function fetch($nativeDataset){}
    public function getInfo($nativeDataset){}

}
?>
