<?php
/**
 * Dataset
 *
 * Database class presents abstract handling for any type of RDBMS or data collection(php array, xml, csv ....)
 *
 * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
 * http://www.gnu.org/licenses/gpl-3.0.txt.
 *
 * @package    LabbitBox
 * @subpackage DB
 * @copyright  2010 LabbitBox Development Team.
 * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
 * @author     minotaur <minotaur@labbitbox.org>
 * @version    v0.1
 * @since      -
 * @link       http://labbitbox.org/
 * @see        http://labbitbox.org/
 */
class Dataset{

    protected $_db;            // parent DB class object
    protected $_transactionId; // using transaction id
    protected $_nativeDataset; // as results of query
    protected $_cursor = 0;
    protected $_records;



    /**
     * constructor of Dataset
     *
     * @param Database $db            親DBクラスオブジェクト
     * @param mixed    $query         SQL-id、或いはSQL文などの問い合わせ
     * @param mixed    $params        パラメータ
     * @param boolean  $autoValidation TRUE:自動バリデーション, FALSE: 手動バリデーション
     * @param int      $trinsactionId TransactionId at Database(it is not native transaction id, default 0)
     */
    public function __construct($db, $query=NULL, $params=NULL, $autoValidation=TRUE, $transactionId=NULL){
	    $this->_db = $db;
        $this->_transactionId = $transactionId;
        if($query!==NULL) $this->bind($query, $params, $autoValidation);
    }



    /**
     * destructor
     */
    public function __destruct(){ /* Not implemeted yet */ }

	/**
	 * bind result of query to dataset
	 *
	 * @param string  $query
     * @param mixed   $params         パラメータ
     * @param boolean $autoValidation TRUE:自動バリデーション, FALSE: 手動バリデーション
	 *
	 * @return boolean TRUE
	 */
    public function bind($query, $params=NULL, $autoValidation=TRUE){
        $this->_nativeDataset = $this->_db->query($query, $params, $autoValidation, $this->_transactionId);
    }



    /**
     * 全レコード取得[仮実装]
     *
     * 実際にはオブジェクト形式での取り扱いが標準になるかもしれないので、今のところは直接getAllAsArray()を呼び出す方法を推奨する。
     *
     * @return NamedArray $xxxx[0]['FieldName']形式の連想配列
     */
    public    function getAll(){
        return $this->getAllAsArray();
    }



	/**
	 * get all data as array
	 *
	 * @return mixed NamedArray
	 */
    public    function getAllAsArray(){
        if($this->_nativeDataset){
            $array = array();
            while( ($rec = $this->_db->fetch($this->_nativeDataset)) !== FALSE){
                $array[] = $rec;
            }
            $this->_db->freeResult($this->_nativeDataset);
            return $array;
        }else{
            return array();
        }
    }


    /**
     * fetch
     *
     * @return Mixed DataArray
     */
    public function fetch(){
        return $rec = $this->_db->fetch($this->_nativeDataset);
    }



	/**
	 * get all data as csv
	 *
	 * not support quoted string yet.
	 *
	 * @return mixed string array per line
	 */
    public    function getAllAsCsv($quote='"', $separate=','){
		$data = $this->getAllAsArray();
		foreach($data as $record){
            $fmRecord = NULL;
            foreach($record as $field){
                if(is_int($field)){
                    $fmRecord[] = $field;
                }else{
                    $fmRecord[] = $quote.trim($field).$quote;
                }
            }
			$csv[] = implode($separate, $fmRecord);
		}
		return implode("\n", $csv);
	}



    public    function getAllAsXml(){ /* Not implemeted yet */ }



	/**
	 * get all data as csv
	 *
	 * not support quoted string yet.
	 *
	 * @return mixed string array per line
	 */
    public    function getAllAsJson(){
		return json_encode($this->getAllAsArray());
	}



    public    function insert(){ /* Not implemeted yet */ }
    public    function first(){ /* Not implemeted yet */ }
    public    function get(){ /* Not implemeted yet */ }
    public    function last(){ /* Not implemeted yet */ }

    public    function post(){ /* Not implemeted yet */ }
    public    function cancel(){ /* Not implemeted yet */ }

    public    function commit(){ /* Not implemeted yet */ }
    public    function rollback(){ /* Not implemeted yet */ }
    public    function checkpoint(){ /* Not implemeted yet */ }

    public function getRecordInfo(){
        return $this->_db->_getRecordInfo($this->_nativeDataset);
    }
}
?>
