<?php
    //========================================================================================================================
    /**
     * ExtJS用データストアクラス
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    LabbitBox
     * @subpackage core
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      2010/2/26
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    class Datastore {
        private $_storeId;              //データストアID
        private $_dsInfo    = array();  //データストア情報連想配列
        private $_dsData    = array();  //データストア用データ
        private $_fieldList = array();  //フィールド情報リスト

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         *
         * @param object    $agApplication  アプリケーションオブジェクト(WebApplicationなど)
         * @param string    $agStoreId      データストアID
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($agApplication, $agStoreId){
            $this->_app     = $agApplication;   //アプリケーション
            $this->_storeId = $agStoreId;       //ストアID
            
            //デフォルト値セット
            $this->_dsInfo  = array(
                'root'          => 'root',
                'url'           => '',
                'totalProperty' => 'totalProperty'
            );
        }

        //---------------------------------------------------------------------------------------------
        /**
         * データストア用合計項目名称セット
         * @param integer   $agTotalId  合計項目名称
         */
        //---------------------------------------------------------------------------------------------
        public function setTotalProperty($agTotalId){
            $this->_dsInfo['totalProperty'] = $agTotalId;
        }

        //---------------------------------------------------------------------------------------------
        /**
         * データストア用ルートノードIDセット
         * @param string    $agRootId   ルートノードID
         */
        //---------------------------------------------------------------------------------------------
        public function setRootId($agRootId){
            $this->_dsInfo['root']          = $agRootId;
        }

        //---------------------------------------------------------------------------------------------
        /**
         * データストア用レコード数カウントセット
         * @param integer   $agCount    レコード数
         */
        //---------------------------------------------------------------------------------------------
        public function setDsCount($agCount){
            $this->_dsInfo['totalProperty']     = $agCount;
        }

        //---------------------------------------------------------------------------------------------
        /**
         * データストア用情報追加
         * @param integer   $agInfoName     情報項目名称
         * @param string    $agValue        値
         */
        //---------------------------------------------------------------------------------------------
        public function addInfo($agInfoName, $agValue){
            $this->_dsInfo[$agInfoName]     = $agValue;
        }

        //---------------------------------------------------------------------------------------------
        /**
         * データストア用レコード追加
         * @param integer   $agRecord   レコードイメージの連想配列
         */
        //---------------------------------------------------------------------------------------------
        public function addRecord($agDataName, $agRecord){
            $this->_dsData[$agDataName][]   = $agRecord;
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * データストア(JSON)レスポンス文字列取得
         *
         * @param boolean   $agOutput   出力要否：trueを指定した場合はレスポンスを出力する
         * @return string   レスポンスJSON文字列
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function getJsonDs($agOutput = false){
            $wkJson         = array_merge($this->_dsData, $this->_dsInfo);
            file_put_contents('/tmp/test.txt', json_encode($wkJson));
         
            if ($agOutput){
                print json_encode($wkJson);
            }
            else{
                return json_encode($wkJson);
            }
        }

        //---------------------------------------------------------------------------------------------
        /**
         * データストア用フィールド情報セット
         * @param string    $agName     フィールド名
         * @param string    $agType     フィールド型名
         */
        //---------------------------------------------------------------------------------------------
        public function addField($agName, $agType){
            $this->_fieldList[$agName]  = $agType;
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         *
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function getJsonDsDefinition(){
            $wkClassID  = ucfirst($this->_storeId);
            $wkDs   = array();
            $wkDs[] = sprintf("%s = Ext.extend(Ext.data.JsonStore, {", $wkClassID);
            $wkDs[] = sprintf("  constructor: function(cfg) {");
            $wkDs[] = sprintf("    cfg = cfg || {};");
            $wkDs[] = sprintf("      %s.superclass.constructor.call(this, Ext.apply({", $wkClassID);
            $wkDs[] = sprintf("       storeId: '%s',", $this->_storeId);
            foreach ($this->_dsInfo as $_name => $_value){
                $wkDs[] = sprintf("       %s: '%s',", $_name, $_value);
            }
            
            $wkDs[] = sprintf("       fields: [");
            $wkFields       = array();
            foreach ($this->_fieldList as $_name => $_type){
                $wkFields[] = sprintf("       {name:'%s',type:'%s'}", $_name, $_type);
            }
            $wkDs[] = sprintf("        %s", implode(",\n", $wkFields));
            $wkDs[] = sprintf("      ]");
            $wkDs[] = sprintf("    }, cfg)");
            $wkDs[] = sprintf("  }");
            $wkDs[] = sprintf("});");
            $wkDs[] = sprintf("new %s();", $wkClassID);

            return implode("\n", $wkDs);
        }

    }

?>
