<?php
    //========================================================================================================================
    /**
     * MVC埋め込み用モデルクラス
     *
     * EmbededViewクラスと組み合わせて使用することが想定されている
     * 対応するEmbededModelクラスを継承したクラスファイルが存在する場合に、
     * 該当のビューのコンストラクタで自動で生成される
     * 実装例：［HtmlViewまたはAjaxView:V100］ー［ビュー:S100］ー［ビュー:S110］ー［ビュー:S111］
     * 　上記の例では、S100,S110,S111全てのコンストラクタで自動的に生成される
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    LabbitBox
     * @subpackage core
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      2010/2/26
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(BASE_LIB.'/Model.php');
    class EmbededModel extends Model{
        protected $_app;          //アプリケーションオブジェクト
        protected $_mode;         //実行モード REGION/AJAX(使用は任意:使用しなければ通常のモデルと同一動作)
        protected $_extendParams; //拡張パラメータ(データ構造は実装仕様に従う)
        public    $data;          //生成後データ領域(データ構造は実装仕様に従う)

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         *
         * @param object    $agApplication  アプリケーションオブジェクト(WebApplicationなど)
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($application, $mode = '', $extendParams){
            $this->_app          = $application; //アプリケーション
            $this->_mode         = $mode;        //実行モード
            $this->_extendParams = $extendParams;
        }
         
    }

?>
