<?php
    //========================================================================================================================
    /**
     * MVCビュークラス：HTMLビュー
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    LabbitBox
     * @subpackage core
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      2010/2/26
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(BASE_LIB.'/View.php');

    abstract class HtmlBasicView extends View{
        protected $_eventManager;   //イベントマネージャー
        
        //変数リスト
        protected $_lbInfo          = array();
        protected $_cssPathList     = array();
        protected $_styleList       = array();
        protected $_jsFileList      = array();
        protected $_jsFunctionList  = array();
        protected $_jsScriptList    = array();
        protected $_jsEventList     = array();
        protected $_loadJsList      = array();
        protected $_metaList        = array();
        protected $_timerList       = array();
        protected $_ajaxTimerList   = array();

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         * @param object    $application    アプリケーションオブジェクト
         * @param string    $templateName   テンプレート名
         * @param string    $templateDir    テンプレート格納ディレクトリ
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($application, $templateName = '', $templateDir = ''){
            parent::__construct($application, $templateName, $templateDir);
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * レスポンス文字列生成
         * 自DOMオブジェクトからHTML文字列に展開する
         *
         * @return string   HTML文字列
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function build(){
            parent::build();

            //起動情報定義
            $this->_lbInfo[] = $_SERVER['PHP_SELF'];
            $this->_lbInfo[] = ($this->request()->isExist('action') ? $this->request('action') : $this->config('sys.action'));
            $this->_lbInfo[] = ($this->request()->isExist('method') ? $this->request('method') : $this->config('sys.method'));
            $this->_lbInfo[] = ($this->request()->isExist('type') ? $this->request('type') : $this->config('sys.type'));
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * meta定義追加
         * <head>にmeta定義を追加する
         *
         * @param string    $key    キー(連想配列の場合は値は不要)
         * @param array     $value  値
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function addMeta($key, $value = NULL){
            $wMeta = (is_array($key) ? $key : array($key => $value));
            $this->_metaList    = array_merge($this->_metaList, $wMeta);
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * CSSファイルインクルード定義追加
         * <head>に外部CSSファイルへのリンクタグを追加する
         *
         * @param string    $agCSSName      CSS名(.cssは付けない)
         * @param string    $agCSSDir       CSSパス:省略時は'css'
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function addCssLink($agCSSName, $agCSSDir = 'css'){
            $cssFilePath = $agCSSDir.'/'.$agCSSName.'.css';
            if (file_exists($cssFilePath)){
                $this->_cssPathList[]   = $cssFilePath.'?update='.filemtime($cssFilePath);
            }
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * CSS定義追加
         * <head>にstyleのクラス定義を追加する
         *
         * @param string    $agEntryName    クラス名
         * @param array     $agStyleList    スタイルの連想配列
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function addStyleCss($entryName, $styles){
//print_r($this->_styleList);
            if (!array_key_exists($entryName, $this->_styleList)){
                $this->_styleList[$entryName]   = array();
            }
            $this->_styleList[$entryName]       = array_merge($this->_styleList[$entryName], $styles);
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * CSS定義追加
         * <head>にstyleのクラス定義を追加する
         *
         * @param string    $agClassName    クラス名
         * @param array     $styleList      スタイルの連想配列
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function addStyleCssList($styleCssList){
            foreach ($styleCssList as $_entryName => $_styles){
                $this->addStyleCss($_entryName, $_styles);
            }
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * Javascriptインクルード定義追加
         * <head>に外部Javascriptファイルのインクルードタグを追加する
         *
         * @param string    $agJsFilePath   外部Javascriptファイルパス
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function addJsInclude($agJsFilePath){
            if (!in_array($agJsFilePath, $this->_jsFileList)){
                if (file_exists($agJsFilePath)){
                    $this->_jsFileList[]    = $agJsFilePath.'?update='.filemtime($agJsFilePath);
                }
            }
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * ページロード時実行スクリプト定義追加
         * <head>に外部Javascriptファイルのインクルードタグを追加する
         *
         * @param string    $function 関数名
         * @param string    $args     引数群(引数イメージを文字列で：例(引数3個の場合)'a, b, c')
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function addLoadJsFunction($function, $args = ''){
            $this->_loadJsList[]    = $function.'('.$args.');';
        }

        public function addLoadJs($script){
            $this->_loadJsList[]    = $script;
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * Javascript関数定義追加
         * <head>にJavascript関数を直接記述
         *
         * @param string    $function   関数名
         * @param string    $args       引数群(引数イメージを文字列で：例(引数3個の場合)"10, 'abc', 5")
         * @param string    $script     関数の実行コード
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function addJsFunction($function, $args, $script){
            $wkScript   = (is_array($script) ? $script : array($script));
            $this->_jsFunctionList[$function] = array($args, $wkScript);
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * Javascript定義追加
         * <head>にJavascript関数を直接記述
         *
         * @param array     $script     スクリプトの実行コード
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function addJsScript($script){
            $wkJs   = (is_array($script) ? $script : array($script));
            $this->_jsScriptList[]  = $wkJs;
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * Javascriptタイマー定義追加
         * <head>にタイマーリストを記述
         *
         * @param string    $aTimerID   タイマー名
         * @param string    $aFunction  タイマーハンドラ名
         * @param integer   $aInterval  タイマーイベント間隔(sec)
         * @param string    $aSW        起動時タイマー起動ON/OFF
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function addTimer($aTimerID, $aInterval, $aFunction, $aParams = '', $aSW = 'ON'){
            require_once(BASE_LIB.'/EventManager.php');

            $wTimer = new Timer($aTimerID, 'U', $aInterval, $aFunction, array(), $aParams, $aSW);
            $this->eventManager()->addTimerEvent($wTimer);
        }

        /*
         * @param string    $aTimer         タイマー名
         * @param string    $aInterval      タイマーイベント発生間隔
         * @param array     $aTargets       Ajax送信対象エレメントの配列
         * @param array     $aHandler       イベントハンドラの連想配列（イベントポイント => イベントハンドラ）
         * @param array     $aServerParams  Ajax起動パラメータの連想配列(ex.'method' => 'onTimer')
         * @param string    $aSW            起動時タイマー起動ON/OFF
         */
        public function addAjaxTimer($aTimerID, $aInterval, $aHandler = array(), $aTargets = array(), $aExecParams = array(), $aSW = 'ON'){
            require_once(BASE_LIB.'/EventManager.php');

            $wTimer = new Timer($aTimerID, 'A', $aInterval, $aHandler, $aTargets, $aExecParams, $aSW);
            $this->eventManager()->addTimerEvent($wTimer);
        }

    }

?>
