<?php
    //========================================================================================================================
    /**
     * MVCビュークラス：HTMLビュー
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    LabbitBox
     * @subpackage core
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      2010/2/26
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(BASE_LIB.'/HtmlBasicView.php');

    class HtmlView extends HtmlBasicView{
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         * @param object    $application    アプリケーションオブジェクト
         * @param string    $templateName   テンプレート名
         * @param string    $templateDir    テンプレート格納ディレクトリ
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($application, $templateName = '', $templateDir = ''){
            parent::__construct($application, $templateName, $templateDir);
            $this->_className   = 'HtmlView';
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * レスポンス文字列生成
         * 自DOMオブジェクトからHTML文字列に展開する
         *
         * @return string   HTML文字列
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function build(){
            parent::build();

            //Javascriptライブラリ・イベント定義
            if ($this->_eventManager->count() + $this->_eventManager->timerCount() > 0){
                if ($this->_eventManager->count() > 0) $this->addJsScript($this->_eventManager->script());
                if ($this->_eventManager->timerCount() > 0) $this->addJsScript($this->_eventManager->timerScript());
                
                $this->addLoadJsFunction('labbitbox.setInfo', "['".implode("','", $this->_lbInfo)."']");
                $this->addLoadJsFunction('labbitbox.load');
                
                if ($this->_eventManager->count() > 0) $this->addLoadJsFunction('labbitbox.eventInitialize');
                if ($this->_eventManager->timerCount() > 0) $this->addLoadJsFunction('labbitbox.timerInitialize');
            }
            $this->addJsScript("var LB_ITEM_COUNT = '".AJAX_ITEM_COUNT."';");

            //<head>部追加
            //-- Meta定義
            $this->_insertMeta();        //meta定義

            //-- CSS定義
            $this->_insertCssLink();     //CSSファイルインクルード定義
            $this->_insertStyleCss();    //CSS定義
            
            //-- Javascript定義
            $this->_insertJsInclude();   //Javascriptインクルード定義
            $this->_insertJsScript();    //Javascript関数定義追加
            $this->_insertLoadJs();      //ページロード時実行スクリプト

            return $this->_doc;
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * CSSファイルインクルード定義→DOM追加
         * addCssLink()で追加した定義をドキュメントに追加する
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function _insertMeta(){
            foreach ($this->_metaList as $_key => $_value){
                $wMeta      = $this->_doc->createElement('meta');
                $wMeta->setAttribute($_key, $_value);
                $wHeadNode  = $this->_doc->getElementsByTagName('head')->item(0);
                $wHeadNode->appendChild($wMeta);
            }
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * CSSファイルインクルード定義→DOM追加
         * addCssLink()で追加した定義をドキュメントに追加する
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function _insertCssLink(){
            foreach ($this->_cssPathList as $_path){
                $wkCss  = $this->_doc->createElement('link');
                $wkCss->setAttribute('href', $_path);
                $wkCss->setAttribute('rel', 'stylesheet');
                $wkCss->setAttribute('type', 'text/css');
                $wkHeadNode = $this->_doc->getElementsByTagName('head')->item(0);
                $wkHeadNode->appendChild($wkCss);
            }
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * CSS定義→DOM追加
         * addStyleCss()で追加した定義をドキュメントに追加する
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function _insertStyleCss(){
            //定義ノード生成
            $wkStyle    = $this->_doc->createElement('style');
            $wkStyle->setAttribute('type', 'text/css');
            
            //スタイル定義文字列編集
            $wkDefinition   = '';
            foreach ($this->_styleList as $_className => $_style){
                $wkDefinition   = '';
                foreach ($_style as $_name => $_value){
                    $wkDefinition   .= $_name.':'.$_value.';';
                }
                $wkTextNode = $this->_doc->createTextNode("\n".$_className.'{'.$wkDefinition.'}');
                $wkStyle->appendChild($wkTextNode);
            }
            
            //定義ノードをheadタグに追加
            $wkHeadNode = $this->_doc->getElementsByTagName('head')->item(0);
            $wkHeadNode->appendChild($wkStyle);
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * Javascript外部ファイル定義→DOM追加
         * addJsFile()で追加した定義をドキュメントに追加する
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function _insertJsInclude(){
            if (count($this->_jsFileList) > 0){
                foreach ($this->_jsFileList as $_path){
                    $wkJs  = $this->_doc->createElement('script');
                    $wkJs->setAttribute('src', $_path);
                    $wkHeadNode = $this->_doc->getElementsByTagName('head')->item(0);
                    $wkHeadNode->appendChild($wkJs);
                }
            }
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * ページロード時実行スクリプト→DOM追加
         * addLoadJs/addLoadJsFunction()で追加した定義をドキュメントに追加する
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function _insertLoadJs(){
            //存在チェック
            if (count($this->_loadJsList) == 0){
                return;
            }
            
            //定義ノード生成
            $wkLoadJs   = $this->_doc->createElement('script');
            $wkLoadJs->setAttribute('language', 'JavaScript');
            $wkDefinition   = array();
            $wkDefinition[] = "";
            $wkDefinition[] = 'Event.observe(document, "dom:loaded", function(){';
            
            //ページロード時実行スクリプト/関数
            foreach ($this->_loadJsList as $_function){
                $wkDefinition[] = $_function;
            }
            
            //テキストノード生成
            $wkDefinition[] = "}, true);";
            $wkDefinition[] = "";
            $wkTextNode = $this->_doc->createTextNode(implode($this->config('sys.delimiterForJs'), $wkDefinition));
            $wkLoadJs->appendChild($wkTextNode);
            
            //定義ノードをheadタグに追加
            $wkHeadNode = $this->_doc->getElementsByTagName('head')->item(0);
            $wkHeadNode->appendChild($wkLoadJs);
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * Javascript関数定義→DOM追加
         * addJsFunction()で追加した定義をドキュメントに追加する
         */
        //-------------------------------------------------------------------------------------------------------------------
        private function _insertJsScript(){
            //存在チェック
            if (count($this->_jsFunctionList) + count($this->_jsScriptList) == 0){
                return;
            }
            
            //定義ノード生成
            $wkLoadJs   = $this->_doc->createElement('script');
            $wkLoadJs->setAttribute('language', 'JavaScript');
            $wkDefinition   = array();
            $wkDefinition[] = "";

            //関数定義展開:addJsFunction()で追加した定義
            foreach ($this->_jsFunctionList as $_function => $_code){
                $wkDefinition[] = "function ".$_function."(".$_code[0]."){";
                $wkDefinition[] = implode($this->config('sys.delimiterForJs'), $_code[1]);
                $wkDefinition[] = "}";
            }
            
            //スクリプト定義展開:addJsScript()で追加した定義
            foreach ($this->_jsScriptList as $_script){
                //スクリプト編集
                $wkDefinition[] = implode($this->config('sys.delimiterForJs'), $_script);
            }

            //テキストノード生成
            $wkDefinition[] = "";
            $wkTextNode = $this->_doc->createTextNode(implode($this->config('sys.delimiterForJs'), $wkDefinition));
            $wkLoadJs->appendChild($wkTextNode);
            
            //定義ノードをheadタグに追加
            $wkHeadNode = $this->_doc->getElementsByTagName('head')->item(0);
            $wkHeadNode->appendChild($wkLoadJs);
        }

    }

?>
