<?php
    //========================================================================================================================
    /**
     * 初期化クラス
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    LabbitBox
     * @subpackage core
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      -
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    class Init {
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         * @param string    $confDir        設定ファイル格納ディレクトリ
         * @param string    $libDir         フレームワークディレクトリ
         * @param string    $appDir         プリケーションディレクトリ
         * @param string    $docRoot        ドキュメントルート
         * @param string    $projectName    アプリケーション名(プロジェクト名)：指定した場合サブディレクトリ名になる
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($confDir, $libDir, $appDir, $docRoot = '', $projectName = ''){
            //------------------------------------------------------------------------------------------------------------------
            // セッションスタート
            //------------------------------------------------------------------------------------------------------------------
            session_start();
            
            //------------------------------------------------------------------------------------------------------------------
            // ディレクトリ定数定義
            //------------------------------------------------------------------------------------------------------------------
            define('BASE_CONF', $confDir);  //設定ファイルディレクトリ
            define('BASE_LIB',  $libDir);   //フレームワークディレクトリ
            define('BASE_APP',  $appDir);   //プリケーションディレクトリ
            define('DOC_ROOT',  ($docRoot == '' ? $_SERVER['DOCUMENT_ROOT'] : $docRoot));   //ドキュメントルート
            
            $projectDir     = ($projectName == '' ? '' : '/'.$projectName);
            define('PRJHOME', BASE_APP.$projectDir);    //アプリケーションディレクトリ
            
            //------------------------------------------------------------------------------------------------------------------
            // 基本ライブラリ展開
            //------------------------------------------------------------------------------------------------------------------
            require_once(BASE_LIB.'/sysvar.php');
            require_once(BASE_LIB.'/common.php');       //共通ライブラリ
            require_once(BASE_LIB.'/develop.php');      //開発時デバッグ用関数群            
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * 設定ファイルロード
         * @param object    $application    アプリケーションオブジェクト
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function loadConfig($application){
            //システム設定オブジェクト
            require_once(BASE_LIB.'/Config.php');
            $wConfig    = new Config(BASE_CONF);
 
            $application->shared()->add('SYSTEM_CONFIG', $wConfig);
            
            //------------------------------------------------------------------------------------------------------------------
            // PHP設定
            //------------------------------------------------------------------------------------------------------------------
            date_default_timezone_set('Asia/Tokyo');
            foreach($wConfig->getElementsByTagName('ini_set') as $_elementID => $_value){
                ini_set($_elementID, $_value);
            }
          
            //------------------------------------------------------------------------------------------------------------------
            // define定数定義
            //------------------------------------------------------------------------------------------------------------------
            foreach($wConfig->getElementsByTagName('const') as $_ID => $_value){
                 define($_ID, $_value);
            }
          
            //------------------------------------------------------------------------------------------------------------------
            // 設定ファイル定義済みディレクトリ定数定義
            //------------------------------------------------------------------------------------------------------------------
            foreach($wConfig->getElementsByTagName('directory') as $_elementID => $_value){
                 define($_elementID, $_value);
            }
       
        }
    }
        
?>
