<?php
    //========================================================================================================================
    /**
     * LabbitBoxセッション管理クラス
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    LabbitBox
     * @subpackage core
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      2010/2/26
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    class LbSession {
        protected $_app             = NULL;     //アプリケーションオブジェクト
        protected $_active          = FALSE;    //LabbitBoxセッション起動済みフラグ

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         * @param object    $application    アプリケーションオブジェクト
         * @return boolean  セッション変数LB_SESSIONの有無のBoolean値
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($application){
            $this->_app         = $application;
            if ($this->_app->session()->isExist('LB_SESSION')){
                $this->_active  = TRUE;
            }
            else{
                $this->_app->session()->add('LB_SESSION', array());
                $this->add('SCRIPT_NAME', $_SERVER['SCRIPT_NAME']);
                $this->_active  = FALSE;
            }    
        }

        public function active(){
            return $this->_active;
        }

        public function reset(){
            if ($this->_app->session()->isExist('LB_SESSION')){
                $this->_app->session()->remove('LB_SESSION');
            }
        }

        public function add($key, $value){
            $wkLbData   = $this->_app->session()->get('LB_SESSION');
            $wkLbData[$key] = $value;
            $this->_app->session()->set('LB_SESSION', $wkLbData);
        }

        public function set($key, $value){
            $this->add($key, $value);
        }

        public function get($key){
            if ($this->_app->session()->isExist('LB_SESSION')){
                if ($this->_app->session()->isArrayExist('LB_SESSION', $key)){
                    return $this->_app->session()->getArrayValue('LB_SESSION', $key);
                }
            }
            return FALSE;
        }

        public function setTemplate($templatePath){
            $this->add('TEMPLATE', $templatePath);
        }

        public function getTemplate(){
            return $this->get('TEMPLATE');
        }

        /**
         * 起動時割込(切替)処理
         * precontroller内で処理の切替えが必要なときに呼び出され
         * 現在の起動パラメータを保存し、切替先の起動パラメータをリクエスト変数にセットする
         */
        public function interrupt($action, $method, $type, $params = array()){
            //呼び出しパラメータの保存
            foreach ($this->_app->request() as $_key => $_value){
                $this->add($_key, $_value);
            } 
            $this->add('url', $this->get('SCRIPT_NAME'));
            $this->add('action', $this->_app->config('sys.action'));
            $this->add('method', $this->_app->config('sys.method'));
            $this->add('type', $this->_app->config('sys.type'));
zx('int:'.implode(':', $this->_app->session()->get('LB_SESSION')));
            //切り替え先起動パラメータセット
            foreach ($params as $_key => $_value){
                $this->_app->request()->add($_key, $_value);
            } 
            $this->_app->request()->set('action', $action);
            $this->_app->request()->set('method', $method); 
            $this->_app->request()->set('type', $type);    
        
            $this->_app->shared()->get('SYSTEM_CONFIG')->loadActionXml($action);
        }

        /**
         * 割込(切替)前処理へ復帰
         * アプリケーションで割込処理終了(認証等で条件が満たされたとき)に
         * 割込前の処理に戻るために起動パラメータを復帰する
         */
        public function callback($ajaxView){
            $cExecParams    = array('url', 'action', 'method', 'type');

            $wExecParams    = array();
            foreach ($cExecParams as $_exKey){
                $wValue     = $this->get($_exKey);
                $wExecParams[$_exKey]    = ($wValue === FALSE ? '' : $wValue);
            }
zx('cb:'.implode(':', $wExecParams));

            $wParams    = array();
            foreach ($this->_app->session()->get('LB_SESSION') as $_key => $_value){
                if (!in_array($_key, $cExecParams)){
                    $wParams[$_key]     = $_value;
                }
            }

            $ajaxView->redirect($wExecParams['url'], $wExecParams['action'], $wExecParams['method'], $wExecParams['type'], $wParams);

        }
    }

?>
