<?php
    //========================================================================================================================
    /**
     * MVCモデルクラス
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    LabbitBox
     * @subpackage core
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      2010/2/26
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    class Model {
        protected $_app;        //アプリケーションオブジェクト

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         *
         * @param object    $agApplication  アプリケーションオブジェクト(WebApplicationなど)
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($application){
            $this->_app     = $application;   //アプリケーション
        }
         
        //---------------------------------------------------------------------------------------------
        /**
         * 未定義関数コール時処理
         */
        //---------------------------------------------------------------------------------------------
        public function __call($name, $params){

        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * システム設定情報取得
         * @param string    $tagName    設定タグ名
         * @param string    $elementID  エントリーID
         * @return string   config設定値
         */
        //-------------------------------------------------------------------------------------------------------------------
        protected function config($tagName){
            return $this->_app->shared('SYSTEM_CONFIG')->value($tagName);
        }

        protected function configByID($elementID){
            return $this->_app->shared('SYSTEM_CONFIG')->valueByID($elementID);
        }

        protected function session($entryID = ''){
            return $this->_app->session($entryID);
        }    
       
        protected function request($entryID = ''){
            return $this->_app->request($entryID);
        }    
       
        protected function shared($entryID = ''){
            return $this->_app->shared($entryID);
        }    

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * システム設定情報取得
         *
         * @param boolean   $agOutput   出力要否：trueを指定した場合はレスポンスを出力する
         * @return string   レスポンスJSON文字列
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function response($output = false){

        }

    }

?>
