<?php
    //========================================================================================================================
    /**
     * DOMエレメント更新クラス
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    LabbitBox
     * @subpackage core
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      2010/8/26
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(BASE_LIB.'/HtmlElement.php');
    class ModifyElement extends HtmlElement{
        private $_parent;
        private $_doc;
        private $_element;
        private $_originalList  = array();

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         *
         * @param object    $parent         親オブジェクト
         * @param string    $elementID      エレメントID
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($parent, $elementID){
            $this->id           = $elementID;
            $this->_elementID   = $elementID;
            $this->_parent      = $parent;
            $this->_doc         = $parent->doc();
            $this->_element     = $parent->getElementById($elementID, $this->_doc);
            $parent->addModifyElement($this);
            
            //初期状態属性保存
            if ($this->_element !== NULL){
            //if ($this->_element->hasAttribute($this->_element)){
                foreach ($this->_element->attributes as $_attr){
                    $this->_originalList[$_attr->nodeName]  = $_attr->textContent;
                }
            //}
            }
        }
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * エレメント変更実行
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function modify(){
            $cExList    = array('selected', 'checked');
            
            //イベント登録
            foreach ($this->_eventList as $_event){
                $this->_parent->getTopRegion()->eventManager()->addEvent($_event);
            }
        
            //スタイル文字列編集
            $wkStyleText    = '';
            foreach ($this->_styleList as $_styleName => $_styleValue){
                $wkStyleText    .= $_styleName.':'.$_styleValue.';';
            }
            if ($wkStyleText != ''){
                $this->_attrList['style']   = $wkStyleText;
            }
        
            //追加属性挿入
            $wkAttrList = array_merge($this->_originalList, $this->_attrList);
            foreach($wkAttrList as $_name => $_value){
                //checked や selected などで値に FALSE が入っている場合は値を追加しない
                if (in_array($_name, $cExList)){
                    if ($_value === false){
                        if ($this->_element->hasAttribute($_name)){
                            $this->_element->removeAttribute($_name);
                        }
                    }
                    else{
                        $this->_element->setAttribute($_name, $_name);    
                    }
                    continue;
                }
            
                //値セット
                switch ($_name){
                    //テキストノード
                    case 'TEXT_NODE':
                        //従属するテキストノードが存在する場合は削除する
                        foreach ($this->_element->childNodes as $_childNode){
                            if ($_childNode->nodeType == XML_TEXT_NODE){
                                $this->_element->removeChild($_childNode);
                            }
                        }
                        $wkTextNode = $this->_doc->createTextNode($_value);
                        $this->_element->appendChild($wkTextNode);
                        break;

                    default:
                        $this->_element->setAttribute($_name, $_value);
                }
            }
        }
    }

?>
