<?php
//========================================================================================================================
/**
 * 生テキストエレメント更新クラス
 *
 * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
 * http://www.gnu.org/licenses/gpl-3.0.txt.
 *
 * @package    LabbitBox
 * @subpackage core
 * @copyright  2010 LabbitBox Development Team.
 * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
 * @author     neobaba <neobaba@labbitbox.org>
 * @version    v0.1
 * @since      2011/04/20
 * @link       http://labbitbox.org/
 * @see        http://labbitbox.org/
 */
//========================================================================================================================
require_once(BASE_LIB.'/HtmlElement.php');
class ModifyHtmlText{
    protected $_parent;
    protected $_elementID;
    protected $_htmlText;

    /**
     * コンストラクタ/デストラクタ
     *
     * @param object    $parent         親オブジェクト
     * @param string    $elementID      エレメントID
     * @param string    $htmlText       HTMLテキスト
     */
    public function __construct($parent, $elementID, $htmlText){
        $this->_parent    = $parent;
        $this->_elementID = $elementID;
        $this->_htmlText  = $htmlText;
        $this->_replace();
        $parent->replaceKeyword($this->_elementID, $this->_elementID, $this);
    }



    /**
     * Regionのキーワードリスト展開で自動的に呼び出されるメソッド
     * 
     * @return string HtmlText
     */
    public function draw(){
        return $this->_htmlText;
    }



    /**
     * 置き換え機能拡張用メソッド
     */
    protected function _replace(){
        // 必要に応じて派生クラスで追加実装してください
    }


}

      ?>
