<?php
    //========================================================================================================================
    /**
     * プレコントローラ
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    LabbitBox
     * @subpackage core
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      -
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(BASE_LIB.'/LbSession.php');

    class Precontroller {
        protected $_app = NULL;
        protected $_lbSession = NULL;
        protected $_templatePath    = '';       //使用テンプレートパス(htmlの時のみ有効）
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         *
         * @param object    $application  アプリケーションオブジェクト
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($application){
            $this->_app         = $application;
            $this->_lbSession   = new LbSession($application);

            //起動済状態
            if ($this->_lbSession->active() === TRUE){
                $this->sessionActive($this->_lbSession);    //サブクラスで実装
            }
            //未起動状態：ログイン表示
            else{
                $this->sessionInactive($this->_lbSession);  //サブクラスで実装
            }
       }

        //---------------------------------------------------------------------------------------------
        /**
         * 未定義関数コール時処理
         */
        //---------------------------------------------------------------------------------------------
        public function __call($name, $params){

        }

        //---------------------------------------------------------------------------------------------
        /**
         * Labbitboxセッションオブジェクト取得
         */
        //---------------------------------------------------------------------------------------------
        public function lbSession(){
            return $this->_lbSession;
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * システム設定情報取得
         * @param string    $tagName    設定タグ名
         * @param string    $elementID  エントリーID
         * @return string   config設定値
         */
        //-------------------------------------------------------------------------------------------------------------------
        protected function config($tagName){
            return $this->_app->shared('SYSTEM_CONFIG')->value($tagName);
        }

        protected function configByID($elementID){
            return $this->_app->shared('SYSTEM_CONFIG')->valueByID($elementID);
        }

        protected function session($entryID = ''){
            return $this->_app->session($entryID);
        }    
       
        protected function request($entryID = ''){
            return $this->_app->request($entryID);
        }    
       
        protected function shared($entryID = ''){
            return $this->_app->shared($entryID);
        }    
 


    }

?>
