<?php
    //========================================================================================================================
    /**
     * MVCクラス：コントローラー（HTML画面表示用）
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    LabbitBox
     * @subpackage core
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      2010/2/26
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(BASE_LIB.'/Controller.php');

    class Renderer extends Controller {
        private $_templateName  = '';
        private $_templatePath  = '';

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         * @param object    $application    アプリケーションオブジェクト
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function __construct($application, $templateName, $templatePath){
            parent::__construct($application);
            $this->_templateName    = $templateName;
            $this->_templatePath    = $templatePath;

            //----------------------------------------------------------------------------------------------------------------
            //ビューオブジェクト生成
            $wkViewClassName    = $this->_app->param('action').'_V';
            $wkViewFilePath     = PRJHOME.'/'.$wkViewClassName.'.php';

            if (file_exists($wkViewFilePath)){
                require_once($wkViewFilePath);
                $this->_view    = new $wkViewClassName($this->_app);
            }
        }
    
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * MVC実行
         */
        //-------------------------------------------------------------------------------------------------------------------
        public function execute(){
            //モデル
            if ($this->_model != NULL){
                $wkFunction     = $this->_app->param('method');
                $this->_model->$wkFunction($this->_app);
            }
            
            //ビュー
            if ($this->_view != NULL){
                if ($this->_templateName !== ''){
                    $this->_view->setTemplate($this->_templateName, $this->_templatePath);
                }
                $wkFunction     = $this->_app->param('method');
                $this->_view->$wkFunction($this->_app);
                print $this->_view->response(FALSE);
            }
        }
    
    }

?>
