<?php
    //========================================================================================================================
    /**
     * MVCクラス：コントローラー（ExtDirect用）
     *
     * リクエスト変数($_REQUEST)のラッパークラス
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    LabbitBox
     * @subpackage core
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      2010/2/26
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(BASE_LIB.'/Controller.php');

    class Router extends Controller {

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         * @param object    $application    アプリケーションオブジェクト
         */
        //-------------------------------------------------------------------------------------------------------------------
        function __construct($application){
            parent::__construct($application);

            //----------------------------------------------------------------------------------------------------------------
            //ビューオブジェクト生成
            $wkViewClassName    = $this->_app->param('action').'_R';
            $wkViewFilePath     = PRJHOME.'/'.$wkViewClassName.'.php';
            if (file_exists($wkViewFilePath)){
                require_once($wkViewFilePath);
                $this->_view    = new $wkViewClassName($this->_app);
            }
        }

        //-------------------------------------------------------------------------------------------------------------------
        /**
         * MVC実行
         */
        //-------------------------------------------------------------------------------------------------------------------
        function execute(){
            //モデル
            if ($this->_model != NULL){
                $wkFunction     = $this->_method;
                $this->_model->$wkFunction($this->_app);
            }
            
            //ビュー
            if ($this->_view != NULL){
                $wkFunction     = $this->_method;
                $this->_view->$wkFunction($this->_app);
                $this->_view->response();
            }
        }
    
    }

?>
