<?php

    //========================================================================================================================
	/**
     * 共通ルーチン
	 *
	 * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
	 * http://www.gnu.org/licenses/gpl-3.0.txt.
	 *
	 * @package    LabbitBox
	 * @subpackage core
	 * @copyright  2010 LabbitBox Development Team.
	 * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org> and minotaur <minotaur@labbitbox.org
	 * @since      -
	 * @link       http://labbitbox.org/
	 * @see        http://labbitbox.org/
	 */
    //========================================================================================================================
    function argvToRequest(){
        foreach ($_SERVER['argv'] as $idx => $value) {
            switch ($idx) {
                case 0:
                    $_REQUEST['ExecutedFileName'] = $value;
                    break;
                    
                case 1:
                    $_REQUEST['action']    = $value;
                    break;

                case 2:
                    $_REQUEST['method']    = $value;
                    break;

                default:
                    $wkParams              = explode('=', $value);
                    $wkKey                 = $wkParams[0];
                    $_REQUEST[$wkKey]      = $wkParams[1];
                    break;
            }
        }
    }

    //-------------------------------------------------------------------------------------------------------------------
    /**
     * メッセージ取得
     * @param string    $key    エントリータグ名
     * @return string   メッセージ文字列
     */
    //-------------------------------------------------------------------------------------------------------------------
    function message($className, $key){            
        //メッセージ
        $wMsgXml    = dirname(__FILE__).'/xml/message.xml';
        $wMsgDom    = new DOMDocument('1.0', 'utf-8');
        if (!file_exists($wMsgXml)){
            $wMsgXml    = dirname(__FILE__).'/xml/message.ja.xml';
            if (!file_exists($wMsgXml)){
                die('File not exist "'.$wMsgXml.'"');
            }
        }
        $wMsgDom->preserveWhiteSpace = false;
        $wMsgDom->load($wMsgXml);
        $wXPath     = new DOMXPath($wMsgDom); 

        $wKey   = '/message/'.$className.'/'.$key.'/text()';
        $wNode  = $wXPath->query($wKey)->item(0);
        if ($wNode != NULL){
            return $wNode->nodeValue;
        }

        ec('No entry "'.$wKey.'" in message');
        ec('[Degug Trace]');
        var_dump(debug_backtrace());
        debug_print_backtrace();
        die;
    }

    function dc(){
        ec('[Class Name:'.get_class().']');
    }

    /**
     * デバッグログファイル出力
     * dfc()は既存ファイルを削除してから出力 / df()は追加書き込み
     * @param string    $text       デバッグ出力する文字列
     * @param string    $fileName   出力ファイル名(デフォルト:debug.html)
     * @param string    $dir        出力ディレクトリ(デフォルト:/tmp)
     * @param boolean   $wrap       html改行タグ(<BR>)付加の要否否(デフォルト:TRUE)
     * @param boolean   $append     追加書き込み要否(デフォルト:TRUE)
     * @param boolean   $timeStamp  各行へのタイムスタンプ(m/d H:i:s)付加の要否否(デフォルト:TRUE)
     */
    function zxc($text, $fileName = NULL, $dir = NULL, $wrap = TRUE, $append = FALSE, $timeStamp = TRUE){
        df($text, $fileName, $dir, $wrap, $append, $timeStamp);
    }
    
    function dfc($text, $fileName = NULL, $dir = NULL, $wrap = TRUE, $append = FALSE, $timeStamp = TRUE){
        df($text, $fileName, $dir, $wrap, $append, $timeStamp);
    }

    function zx($text, $fileName = NULL, $dir = NULL, $wrap = TRUE, $append = TRUE, $timeStamp = TRUE){
        df($text, $fileName, $dir, $wrap, $append, $timeStamp);
    }

    function df($text, $fileName = NULL, $dir = NULL, $wrap = TRUE, $append = TRUE, $timeStamp = TRUE){
        $wDir       = ($dir == NULL ? '/tmp' : $dir);
        $wFileName  = ($fileName == NULL ? 'debug.html' : $fileName);
        $wWrap      = ($wrap ? '<br>' : '');
        $text       = ($timeStamp ? date('m/d H:i:s').' ' : '').$text;
        if ($append){
            file_put_contents($wDir.'/'.$wFileName, $text.$wWrap, FILE_APPEND);
        }
        else{
            file_put_contents($wDir.'/'.$wFileName, $text.$wWrap);
        }
    }
    
    //-------------------------------------------------------------------------------------------------------------------
    /**
     * テンプレートファイル展開
     *
     * @param string    $srcFile        テンプレートファイルフルパス
     * @param array     $tagList        展開タグ文字列リスト（埋め込みタグ => 展開文字列）の連想配列
     * @param string    $returnMode     'STRING':文字列/'FILE':ファイル出力/'ARRAY':配列
     * @param string    $option         $returnMode='STRING'の場合は行の区切り文字列
     *                                  $returnMode='FILE'の場合は出力ファイルフルパス
     * @return array    展開イメージ（$returnModeにより出力形式は異なる）
     */
    //-------------------------------------------------------------------------------------------------------------------
    function spreadFileByTag($srcFile, $tagList, $returnMode = 'STRING', $option = ''){
        $wkResultList   = array();
        $wkSrcFile      = file($srcFile);
        return spreadArrayByTag($wkSrcFile, $tagList, $returnMode, $option);
    }
    
    //-------------------------------------------------------------------------------------------------------------------
    /**
     * テンプレート配列展開
     *
     * @param string    $src            テンプレート展開元配列
     * @param array     $tagList        展開タグ文字列リスト（埋め込みタグ => 展開文字列）の連想配列
     * @param string    $returnMode     'STRING':文字列/'FILE':ファイル出力/'ARRAY':配列
     * @param string    $option         $returnMode='STRING'の場合は行の区切り文字列
     *                                  $returnMode='FILE'の場合は出力ファイルフルパス
     * @return array    展開イメージ（$returnModeにより出力形式は異なる）
     */
    //-------------------------------------------------------------------------------------------------------------------
    function spreadArrayByTag($src, $tagList, $returnMode = 'STRING', $option = ''){
        foreach ($src as $rec) {
            if(!empty($tagList)){ //2009.09.01M.I.if条件追加
                foreach ($tagList as $tag => $text) {
                    $rec  = str_replace(TPL_START.$tag.TPL_END, $text, $rec);
                }
            }
            $wkResultList[]    = $rec;
        }

        //結果出力
        switch ($returnMode) {
            case 'STRING':
                return implode($option, $wkResultList);
                break;
            case 'FILE':
                if ($wp = fopen($option, 'w')){
                    fwrite($wp, implode('', $wkResultList));
                    fclose($wp);
                }
                break;
            case 'ARRAY':
                return $wkResultList;
                break;
        }
    }

    //-----------------------------------------------------------------------------------------
    /**
     * パラメータリスト作成
     * 与えられた連想配列からパラメータ文字列を生成する
     *
     * @param array     $paramList      パラメータリスト連想配列
     * @param string    $operator       パラメータ名と値を連結する演算子
     * @param string    $connect        パラメータ同士を連結する文字列
     * @param string    $quote          値を囲む引用符
     * @param string    $prefix         全体の先頭に付加する文字列
     * @param string    $suffix         全体の最後に付加する文字列
     */
    //-----------------------------------------------------------------------------------------
    function getParamList($paramList, $operator = '=', $connect = ' ', $quote = '"', $prefix = '', $suffix = ''){
        if (is_array($paramList) && count($paramList) > 0){
            $wkParams        = array();
            foreach ($paramList as $key => $value) {
                $wkParams[]    = $key.$operator.$quote.$value.$quote;
            }
            return $prefix.implode($connect, $wkParams).$suffix;
        }
        else{
            return '';
        }
    }

    //--------------------------------------------------------------------------------------------------------------
    /**
     * データソース(連想配列)→XML変換：各レコード個別
     * 
     * @param array     $array      変換対象連想配列 array('レコード名' => array('フィールド名'=>値, 'フィールド名'=>値, ～～～))
     * @param string    $recName    レコード要素名
     * @param string    $rootName   ルート要素名
     * @return string   XML出力イメージ
     */
    //--------------------------------------------------------------------------------------------------------------
    function arrayToXML($array, $rootName = 'root'){
        $wkXML        = array();
        $wkXML[]    = '<'.$rootName.'>';
        foreach ($array as $recName => $rec) {
            $wkXML[]    = '<'.$recName.'>';
            foreach ($rec as $field => $value) {
                $wkXML[]    = '<'.$field.'>'.$value.'</'.$field.'>';
            }
            $wkXML[]    = '</'.$recName.'>';
        }
        $wkXML[]    = '</'.$rootName.'>';
        return '<?xml version="1.0" encoding="utf-8"?>'."\n".implode("\n", $wkXML);
    }

    //--------------------------------------------------------------------------------------------------------------
    /**
     * データソース(連想配列)→XML変換：全レコード同一フォーマット(DBレコードイメージをXMLに変換する場合など)
     * 
     * @param array     $array      変換対象連想配列 array('レコード名' => array('フィールド名'=>値, 'フィールド名'=>値, ～～～))
     * @param string    $recName    レコード要素名
     * @param string    $rootName   ルート要素名
     * @return string   XML出力イメージ
     */
    //--------------------------------------------------------------------------------------------------------------
    function arrayListToXML($array, $recName = 'rec', $rootName = 'root'){
        $wkXML        = array();
        $wkXML[]    = '<'.$rootName.'>';
        foreach ($array as $rec) {
            $wkXML[]    = '<'.$recName.'>';
            foreach ($rec as $field => $value) {
                $wkXML[]    = '<'.$field.'>'.$value.'</'.$field.'>';
            }
            $wkXML[]    = '</'.$recName.'>';
        }
        $wkXML[]    = '</'.$rootName.'>';
        return '<?xml version="1.0" encoding="utf-8"?>'."\n".implode("\n", $wkXML);
    }

    //--------------------------------------------------------------------------------------------------------------
    /**
     * データソース(連想配列)→XML変換：全レコード同一フォーマット(DBレコードイメージをXMLに変換する場合など)
     * 
     * @param array     $array      変換対象連想配列 array('レコード名' => array('フィールド名'=>値, 'フィールド名'=>値, ～～～))
     * @param string    $recName    レコード要素名
     * @param string    $rootName   ルート要素名
     * @return string   XML出力イメージ
     */
    //--------------------------------------------------------------------------------------------------------------
    function arrayGroupToXML($arrayGroup, $recName = 'rec', $rootName = 'root'){
        $wkXML        = array();
        $wkXML[]    = '<'.$rootName.'>';
        foreach ($arrayGroup as $_groupName => $_array) {
            $wkXML[]    = '<'.$_groupName.'>';
            foreach ($_array as $rec) {
                $wkXML[]    = '<'.$recName.'>';
                foreach ($rec as $field => $value) {
                    $wkXML[]    = '<'.$field.'>'.$value.'</'.$field.'>';
                }
                $wkXML[]    = '</'.$recName.'>';
            }
            $wkXML[]    = '</'.$_groupName.'>';
        }
        $wkXML[]    = '</'.$rootName.'>';
        return '<?xml version="1.0" encoding="utf-8"?>'."\n".implode("\n", $wkXML);
    }

    function structToXML($data, $valueListName = 'valueList', $recName = 'rec', $rootName = 'root'){
        $wXML       = array();
        $wXML[]     = '<'.$rootName.'>';

        $wValueList     = array();
        $wDatasetList   = array();
        foreach ($data as $_key => $_value){
            if (!is_array($_value)){
                $wValueList[$_key]      = $_value;
            }
            else{
                $wDatasetList[$_key]    = $_value;
            }
        }
        
        //属性(非配列)項目編集
        $wXML[] = '<'.$valueListName.'>';
        foreach ($wValueList as $_key => $_value){
            $wXML[] = '<'.$_key.'>'.$_value.'</'.$_key.'>';
        }
        $wXML[] = '</'.$valueListName.'>';

        //レコード(配列)項目編集 
        foreach ($wDatasetList as $_datasetName => $_dataset) {
            $wXML[]     = '<'.$_datasetName.'>';
            foreach ($_dataset as $_rec) {
                $wXML[]     = '<'.$recName.'>';
                foreach ($_rec as $_field => $_value) {
                    $wXML[] = '<'.$_field.'>'.$_value.'</'.$_field.'>';
                }
                $wXML[]    = '</'.$recName.'>';
            }
            $wXML[]     = '</'.$_datasetName.'>';
        }

        $wXML[]    = '</'.$rootName.'>';
        return '<?xml version="1.0" encoding="utf-8"?>'."\n".implode("\n", $wXML);
    }

    //-----------------------------------------------------------------------------------------
    /**
     * 連想配列→JSON変換
     * 
     * @param array $array  対象データ（フィールド名=>値 の連想配列）
     * @return string       JSON文字列
     */
    //-----------------------------------------------------------------------------------------
    function arrayToJSON($array){
        $wkJSON    = '{';
        foreach ($array as $field => $value) {
            $wkJSON    .= ($wkJSON == '{' ? '' : ',')."\n";
            $wkJSON    .= dblQuoted($field).':'.dblQuoted(str_replace("\r\n", "\\r\\n", $value));
        }
        $wkJSON    .= '}';

        return $wkJSON;
    }

    //-----------------------------------------------------------------------------------------
    /**
     * ユニーク値発行（伝票No.等に使用）
     * 与えられた文字列に対する32桁のユニークなIDを返す
     * 
     * @return string   ユニークID
     */
    //-----------------------------------------------------------------------------------------
    function getUniqueID(){
        return md5(uniqid(microtime()));
    }

    //-----------------------------------------------------------------------------------------
    /**
     * キャラクタセット変換
     * UTF-8 → ShiftJIS
     * 
     * @param string    $string     対象文字列
     * @return string   変換後文字列
     */   
    //-----------------------------------------------------------------------------------------
    function utf8ToSjis($string){
        return mb_convert_encoding($string, 'SJIS-WIN', 'UTF-8');
    }

    //-----------------------------------------------------------------------------------------
    /**
     * キャラクタセット変換
     * ShiftJIS → UTF-8
     * 
     * @param string    $string     対象文字列
     * @return string   変換後文字列
     */   
    //-----------------------------------------------------------------------------------------
    function sjisToUtf8($string){
        return mb_convert_encoding($string, 'UTF-8', 'SJIS-WIN');
    }

    //-----------------------------------------------------------------------------------------
    /**
     * クォーテーション付加
     * 与えられた文字列の前後にクォーテーションを付加する
     * 
     * @param string    $str        対象文字列
     * @param string    $quoteStr   囲む文字列
     * @return string   クオート処理された文字列
     */    
    //-----------------------------------------------------------------------------------------
    function quoted($str, $quateStr = "'"){
        return $quateStr.$str.$quateStr;
    }

    //-----------------------------------------------------------------------------------------
    /**
     * ダブルクォーテーション付加
     * 与えられた文字列の前後にダブルクォーテーションを付加する
     * 
     * @param string    $str        対象文字列
     * @return string   ダブルクオート処理された文字列
     */
    //-----------------------------------------------------------------------------------------
    function dblQuoted($str){
        return quoted($str, '"');
    }
    


    /**
     * AutoValidation for DB string
     *
     * @param string $rawString
     *
     * @return string double ' to ''
     */
    function dbStr($rawString){
        return str_replace("'", "''", $rawString);
    }




    /**
     * AutoValidation for DB number
     *
     * @param numeric $rawNumber
     *
     * @return numeric *1
     */
    function dbNum($rawNumber){
        return ( $rawNumber == $rawNumber*1 ? $rawNumber*1 : 0 );
    }




    //-----------------------------------------------------------------------------------------
    /**
     * キャメルケース変換
     * 与えられた文字列をキャメルケースに変換する
     * 
     * @param string    $str        対象文字列
     * @param boolean   $ucFirst    先頭文字を大文字にするか否か
     * @param string    $delmiter   区切り文字列
     * @return string   変換後文字列
     */
    //-----------------------------------------------------------------------------------------
    function toCamelCase($str, $ucFirst = FALSE, $delimiter = '_'){
        $wkList    = explode($delimiter, $str);
        foreach ($wkList as $index => $word) {
            if (($index == 0) && ($ucFirst == FALSE)){
                $wkList[$index] = strtolower($word);    
            }
            else{
                $wkList[$index] = ucfirst(strtolower($word));
            }
        }
        
        return implode('', $wkList);
    }

    //-----------------------------------------------------------------------------------------
    /**
     * ディレクトリ削除
     * 指定されたディレクトリの内容をディレクトリを含めて全て削除する
     * 
     * @param string    $agDir   削除ディレクトリ
     */
    //-----------------------------------------------------------------------------------------
    function removeDirectory($agDir) {
        if ($wkDirHandle = opendir("$agDir")) {
            while (($wkItem = readdir($wkDirHandle)) != FALSE) {
                if ($wkItem != "." && $wkItem != "..") {
                    if (is_dir($agDir.'/'.$wkItem)){
                        removeDirectory($agDir.'/'.$wkItem);
                    } 
                    else{
                        unlink($agDir.'/'.$wkItem);
                    }
                }
            }
            closedir($wkDirHandle);
            rmdir($agDir);
        }
    }



    /**
     * 配列トリム
     *
     * @param array $src
     *
     * @return array トリム済み配列
     */
    function trim_r($src){
        foreach($src as $key=>$val){
            if(is_array($val)){
                $dest[trim($key)] = trim_r($val);
            }else{
                $dest[trim($key)] = trim($val);
            }
        }
        return $dest;
    }



    
?>
