<?php

    //========================================================================================================================
    /**
     *    開発用共通ライブラリ
     *
     *  【開発時用】
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    LabbitBox
     * @subpackage core
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      2009/1/1
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================

    //------------------------------------------------------------------------------------------------------------------------
    /**
     * 〔開発時用〕セッション変数表示
     -------------------------------------------------------------------------------------------------------------------*/
    function displaySession(){
        displayArray($_SESSION);
    }

    //------------------------------------------------------------------------------------------------------------------------
    /**
     * 〔開発時用〕配列表示
     * 与えられた配列をブラウザ上に表示する
     * @param    array    $arrayData        対象配列
     * @param    boolean    $subArray        配列の階層構造も表示
     */
    //------------------------------------------------------------------------------------------------------------------------
    function displayArray($arrayData, $feed = "<br />", $subArray = true){
        foreach ($arrayData as $key => $value){
            print $key."\t=>".$value.$feed;

            //配列の階層構造も表示
            if ($subArray){
                if (is_array($value)){
                    displayArray($value, true);
                }
            }
        }
    }

    //------------------------------------------------------------------------------------------------------------------------
    /**
     * 〔開発時用〕echo
     * 与えられた文字列をブラウザ上に表示する
     * @param    string    $str     表示文字列
     * @param    string    $prefix  表示文字列に付加される識別文字列　識別文字列:表示文字列　と表示される
     */
    //------------------------------------------------------------------------------------------------------------------------
    function ec($str, $prefix = ""){
        echo ($prefix != '' ? $prefix.' : ' : '').$str.'<br>';
    }

    function pf($str, $prefix = ""){
        echo ($prefix != '' ? $prefix.' : ' : '').$str."\n";
    }


    //------------------------------------------------------------------------------------------------------------------------
    /**
     * 〔開発時用〕デバッグログ出力
     * 与えられた文字列をデバッグログファイルに出力する
     * @param   string  $logStr     出力文字列
     * @param   string  $timestamp  各ログ行にタイムスタンプを出力するか否か('YES'/'NO')
     * @param   string  $add        ログファイルに追加出力('s')するか上書き出力('w')するか否か
     * @param   string  $path       ログファイルパス
     */
    //------------------------------------------------------------------------------------------------------------------------
    function dlog($logStr, $add = 'a', $timestamp = 'NO', $path = ''){
        if (DEBUG_MODE == 'ON'){
            $wkPath    = ($path != '' ? $path : DEBUG_ROOT);

            if ($wp = fopen($wkPath, $add)){
                fwrite($wp, ($timestamp == 'YES' ? '['.date('Y/m/d H:i:s').']' : '').$logStr.DEBUG_FEED);
            }
        }
    }


?>
