<?php
    //========================================================================================================================
    /**
     * リクエストクラス
     *
     * リクエスト変数($_REQUEST)のラッパークラス
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    LabbitBox
     * @subpackage core
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      2010/2/26
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    class Request extends BasicVariable {
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         */
        //-------------------------------------------------------------------------------------------------------------------
        function __construct(){
            parent::__construct($_REQUEST);
        }
    }

    //========================================================================================================================
    /**
     * セッションクラス
     *
     * セッション変数($_SESSION)のラッパークラス
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    LabbitBox
     * @subpackage core
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      2010/2/26
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    class Session extends BasicVariable {
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         */
        //-------------------------------------------------------------------------------------------------------------------
        function __construct(){
            parent::__construct($_SESSION);
        }
    }

    //========================================================================================================================
    /**
     * ハンドリング変数クラス
     *
     * MVC間受渡用変数のクラス
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    LabbitBox
     * @subpackage core
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      2010/2/26
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    class Shared extends BasicVariable {
        private $_Share  = array();
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         */
        //-------------------------------------------------------------------------------------------------------------------
        function __construct(){
            parent::__construct($this->_Shared);
        }
    }
    
    //========================================================================================================================
    /**
     * 基本変数クラス
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    LabbitBox
     * @subpackage core
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      2010/2/26
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    class BasicVariable {
        private $_variableList  = NULL;
        
        //-------------------------------------------------------------------------------------------------------------------
        /**
         * コンストラクタ/デストラクタ
         * 
         * @param *array $variable 変数ポインタ
         */
        //-------------------------------------------------------------------------------------------------------------------
        function __construct(&$variable){
            $this->_variableList        = &$variable;
        }
        
        //---------------------------------------------------------------------------------------------
        /**
         * 変数値セット/追加
         * 
         * @param string $key 変数名
         * @param string $data 変数値
         */    
        //---------------------------------------------------------------------------------------------
        function add($key, $data){
           $this->_variableList[$key] = $data;
        }

        function set($key, $data){
           $this->_variableList[$key] = $data;
        }
        
        //---------------------------------------------------------------------------------------------
        /**
         * 変数値取得
         * 
         * @param string $key 変数名
         * @return string 変数値
         */    
        //---------------------------------------------------------------------------------------------
        function get($key){
            return ($this->isExist($key) ? $this->_variableList[$key] : '');
        }
        
        //---------------------------------------------------------------------------------------------
        /**
         * 変数値削除
         * 
         * @param string $key 変数名
         */    
        //---------------------------------------------------------------------------------------------
        function remove($key){
            unset($this->_variableList[$key]);
        }

        //---------------------------------------------------------------------------------------------
        /**
         * 変数配列取得
         * 
         * @return 変数
         */    
        //---------------------------------------------------------------------------------------------
        function toArray(){
            return $this->_variableList;
        }

        //---------------------------------------------------------------------------------------------
        /**
         * 変数存在チェック
         * 
         * @param string    $key     変数名
         * @return boolean  指定された変数名の変数が存在した場合はTRUE
         */    
        //---------------------------------------------------------------------------------------------
        function isExist($key){
            return array_key_exists($key, $this->_variableList);
        }

        //---------------------------------------------------------------------------------------------
        /**
         * 変数存在チェックと値或いはデフォルト値の取得
         * 
         * @param  string $key     変数名
         * @param  mixed  $default デフォルト値
         * @return mixed  キーに対応する変数値があれば変数値、なければ指定されたデフォルト値
         */    
        //---------------------------------------------------------------------------------------------
        function valueDef($key, $default){
            if($this->isExist($key)){
                return $this->_variableList[$key];
            }else{
                return $default;
            }
        }

        //---------------------------------------------------------------------------------------------
        /**
         * 配列変数存在チェック
         * 
         * @param string    $key      変数名
         * @param string    $arrayKey 配列インデックス
         * @return boolean  配列で格納された変数内に指定されたキーが存在した場合はTRUE
         */    
        //---------------------------------------------------------------------------------------------
        function isArrayExist($key, $arrayKey){
            if (!is_array($this->_variableList[$key])){
                return false;
            }
            return array_key_exists($arrayKey, $this->_variableList[$key]);
        }

        //---------------------------------------------------------------------------------------------
        /**
         * 配列変数値取得
         * 指定された変数が配列でない場合はNULLを戻す
         * 
         * @param string    $key      変数名
         * @param string    $arrayKey 配列インデックス
         * @return string   配列で格納された変数内の指定されたキーの値(存在しない場合はFALSE)
         */
        //---------------------------------------------------------------------------------------------
        function getArrayValue($key, $arrayKey){
            if (is_array($this->_variableList[$key])){
                if (array_key_exists($arrayKey, $this->_variableList[$key])){
                    return $this->_variableList[$key][$arrayKey];
                }
                ec('No entry "'.$key.'" in '.$key);
                ec('[Degug Trace]');
                var_dump(debug_backtrace());
                debug_print_backtrace();
                die;
            }
            else{
                return NULL;
            }
        }

    }
?>
