//---------------------------------------------------------------------------------------------------------------------
/**
 * ExtJS用ライブラリ
 *
 * @package  NeoFW3.0
 * @author   Neo Co.,Ltd. : Tsuyoshi Baba
 * @since    2010/2/26
*/ 
//---------------------------------------------------------------------------------------------------------------------
var rg = [{}];          //ExtJS用リージョンオブジェクトリスト
var renderList = [{}];  //レンダリング済みリージョンリスト

//---------------------------------------------------------------------------------------------------------------------
/**
 * リージョンオブジェクト追加
 *
 * @param string    agResionName    リージョンオブジェクト名
 */ 
//---------------------------------------------------------------------------------------------------------------------
function addRegion(agResionName, agTargetElement){
    eval("rg['" + agResionName + "'] = new " + agResionName + "();");
    
    //初期表示あり
    if (agTargetElement != undefined){
        renderRegion(agResionName, agTargetElement);
    }
}

//---------------------------------------------------------------------------------------------------------------------
/**
 * リージョンオブジェクト取得
 *
 * @param string    agResionName    リージョンオブジェクト名
 * @return object   リージョンオブジェクト
 */ 
//---------------------------------------------------------------------------------------------------------------------
function getRegion(agResionName){
    return rg[agResionName];
}

//---------------------------------------------------------------------------------------------------------------------
/**
 * リージョンレンダリング
 * 生成済みのリージョンオブジェクト(配列rgに格納)をレンダリングする
 *
 * @param string    agResionName    リージョンオブジェクト名
 * @param string    agTargetElement レンダリング対象コンテナ
 */ 
//---------------------------------------------------------------------------------------------------------------------
function renderRegion(agResionName, agTargetElement){
    if (agResionName in renderList){
        showRegion(agResionName);
    }
    else{
        renderList[agResionName]    = agTargetElement;
        getRegion(agResionName).render(Ext.get(agTargetElement));
    }
}

//---------------------------------------------------------------------------------------------------------------------
/**
 * リージョン表示
 *
 * @param string    agResionName    リージョンオブジェクト名
 */ 
//---------------------------------------------------------------------------------------------------------------------
function showRegion(agResionName){
    getRegion(agResionName).show();
}

//---------------------------------------------------------------------------------------------------------------------
/**
 * リージョン非表示
 *
 * @param string    agResionName    リージョンオブジェクト名
 */ 
//---------------------------------------------------------------------------------------------------------------------
function hideRegion(agResionName){
    getRegion(agResionName).hide();
}

