//=====================================================================================================================
/**
 * htmlGrid用Javascript
 */ 
//=====================================================================================================================
var _fixedColCount = $H({});    //固定列数
var _columnList = $H({});       //列情報リスト      
var _valueType = $H({
    INPUT:$H({
        text:'getTextValue',
        password:'getTextValue',
        hidden:'getTextValue',
        checkbox:'getCheckedValue',
        radio:'getChecedValue',
        button:'getDummy'
    }),
    A:$H({'':'getDummy'}),
    DIV:$H({'':'getDivValue'}),
    SPAN:$H({'':'getDivValue'}),
    P:$H({'':'getDivValue'}),
    SELECT:$H({
        'select-one':'getSelectValue',
        'select-multiple':'getSelectValue'
    }),
    TEXTAREA:$H({'':'getDiv'})
});

/**
 * 初期設定
 */ 
function initGrid(gridID, fixedColCount, columns){
    _fixedColCount[gridID]      = fixedColCount;
    _columnList[gridID]         = eval(columns);
 
    syncScrollBar(gridID);
}

/**
 * スクロール同期設定
 */
function syncScrollBar(gridID){
    var gridDiv     = gridID + '_GRID';
    var headDiv     = gridID + '_HEAD';
    var fixedCol    = gridID + '_FIXED';
    if ($(headDiv) || $(fixedCol)){
        $(gridDiv).onscroll    = function(){
            //横スクロールバー
            if ($(headDiv)){
                $(headDiv).scrollLeft   = $(gridDiv).scrollLeft;
            }
            
            //縦スクロールバー
            if ($(fixedCol)){
                $(fixedCol).scrollTop   = $(gridDiv).scrollTop;
            }
        }
    }
}

/**
 * イベント情報取得
 * [戻り値のオブジェクト要素]
 * gridID:      大枠divタグのエレメントID
 * elementID    イベント発生エレメントID
 * colID        イベント発生列ID
 * zone         HEAD/GRID ヘッダ部/データ部
 * colType      FIXED/FLEX 固定列部/可動部
 * rowIndex     イベント発生行インデックス
 * rowData      行データハッシュオブジェクト
 */ 
function eventInfo(e){
    var info    = $H({});

    //グリッドID取得
    var element     = e.srcElement || e.target;
    var gridID      = getGridID(element);
    info['gridID']      = gridID;
    info['elementID']   = element.id;
    
    //対象位置・行情報
    _columnList[info.gridID].each(function(column, index){
        if (element.id == (gridID + '_FIXED_HEAD_' + column['dataIndex'])){
            info['zone']        = 'HEAD';
            info['colType']     = 'FIXED';
            info['rowIndex']    = -1;
            info['colID']       = column['dataIndex'];
        }
        else if (element.id == (gridID + '_HEAD_' + column['dataIndex'])){
            info['zone']        = 'HEAD';
            info['colType']     = 'FLEX';
            info['rowIndex']    = -1;
            info['colID']       = column['dataIndex'];
        }
        else{
            rowIndex    = Number(element.id.replace(gridID + '_FIXED_' + column['dataIndex'] + '_', ''));
            if (!isNaN(rowIndex)){
                info['zone']        = 'GRID';
                info['colType']     = 'FIXED';
                info['rowIndex']    = rowIndex;
                info['colID']       = column['dataIndex'];
            }
            else{
                rowIndex    = Number(element.id.replace(gridID + '_' + column['dataIndex'] + '_', ''));
                if (!isNaN(rowIndex)){
                    info['zone']        = 'GRID';
                    info['colType']     = 'FLEX';
                    info['rowIndex']    = rowIndex;
                    info['colID']       = column['dataIndex'];
                }
            }
        }
    });
    
    //行データ
    if (info['zone'] == 'GRID'){
        info['rowData']     = rowData(gridID, info['rowIndex']);
    }  
    
    return(info);
}

/**
 * 行データ取得
 */ 
function rowData(gridID, rowIndex){
    var colValues   = $H({});
    _columnList[gridID].each(function(column, index){
        if (index < _fixedColCount[gridID]){
            elementID   = gridID + '_FIXED_' + column['dataIndex'] + '_' + rowIndex;
        }
        else{
            elementID   = gridID + '_' + column['dataIndex'] + '_' + rowIndex;
        }
        colValues.set([column['dataIndex']], getCellValue(elementID));
        //alert(elementID + ':' + column['dataIndex'] + ':' + colValues[column['dataIndex']]);
    });
    return(colValues);
}

/**
 * グリッドID取得
 */ 
function getGridID(element){
    var domTree = $(element.id).ancestors();
    
    for(var i=0; i < domTree.length; i++ ){
        var id = domTree[i].id;
        if ($(id).getAttribute('value') == '__GRID_BASE_DIV'){
            return id;
        }
    }	
}
    
/**
 * エレメント値取得
 */
function getCellValue(elementID){
    var tag     = $(elementID).tagName;
    var type    = ($(elementID).type ? $(elementID).type : '');
    var func    = _valueType.get(tag).get(type);
    //alert(elementID + '->' + func + '>>' + typeof window[func] + ':' + tag + ':' + type);
    if (typeof window[func] == 'function'){
        a = eval(func)(elementID);
        //alert('a:' + a);
        return a;
    }
}

//DIV:innerHTML
function getDivValue(elementID){
    if (typeof $(elementID).innerHTML.trim == 'function'){
        return $(elementID).innerHTML.trim();
    }
    else{
        return $(elementID).innerHTML.replace(/(^\s+)|(\s+$)/g, "");
    }
}

//SELECT:select
function getSelectValue(elementID){
    var _selectedValue;
    _selectedValue  = null;
    $A($(elementID).childElements()).each(function(_option){
        if (_option.selected){
            _selectedValue = _option.value;
        }
    });
    return _selectedValue;
}

//INPUT:checkbox
//INPUT:radio
function getCheckedValue(elementID){
    return $(elementID).checked;
}

//INPUT:text
//INPUT:password
//INPUT:hidden
function getTextValue(elementID){
    return $(elementID).value;
}

//未対応エレメント
function getDummy(elementID){
    return $(elementID).value;
}
    
/**
 * レスポンス値加工
 * レスポンスに'rowIndex'を含む場合、エレメント名_{rowIndex}の値をレスポンスオブジェクトに追加する
 */
function prepareAjaxByRowData(e, serverMethod){
    var ele = e.srcElement || e.target;
    var wInfo    = eventInfo(e);

    //サーバーサイドのメソッド名をセット
    labbitbox.setAjaxServerMethod(serverMethod);

    //グリッドID・行インデックスをセット
    labbitbox.addAjaxParam('gridID', getGridID(ele));
    labbitbox.addAjaxParam('rowIndex', wInfo.rowIndex);
    labbitbox.addAjaxParam('sender', ele.id);
    labbitbox.addAjaxParam('colID', wInfo.colID);
    labbitbox.addAjaxParam('zone', wInfo.zone);
    labbitbox.addAjaxParam('colType', wInfo.colType);

    //Ajaxのリクエストパラメータにイベント発生行の列データをセット
    if (wInfo.rowData !== undefined){
        wInfo.rowData.each(function(_cell){
            //alert(_cell.key + '-' + _cell.value);
            setAjaxParam(_cell.key, _cell.value);
        });
    }
}

function setAjaxHandler(point, handleValue){
    labbitbox.addAjaxHandler(point, handleValue);
}

function setAjaxParam(name, value){
    labbitbox.addAjaxParam(name, value);
}
    
/**
 * レスポンス値加工
 * レスポンスに'gridID'と'rowIndex'を含む場合、エレメント名_{rowIndex}の値をレスポンスオブジェクトに追加する
 * @param hash レスポンス文字列
 */
function responseCellValue(response){
    if ((wGridID = response.get('gridID')) &&
        (wIndex = response.get('rowIndex'))){
        response.each(function(_res){
            if (!$(wGridID + '_FIXED_' + _res.key + '_0')){
                wID = wGridID + '_' + _res.key + '_' + wIndex;
            }
            else{
                wID = wGridID + '_FIXED_' + _res.key + '_' + wIndex;
            }

            if ($(wID)){
                response.set(wID, _res.value);
            }
        });
    }

    return true;
}

