//---------------------------------------------------------------------------------------------------------------------
/**
 *
 * @package  LabbitBox1.0
 * @author   neobaba
 * @since    2010/9/4
*/ 
//---------------------------------------------------------------------------------------------------------------------
var LBInfo;
var Labbitbox = Class.create({
    //コンストラクタ
    initialize: function(){
        _this = this;
        _this.ajaxParam = $H({});
        _this.handlerList = $H({});
        _this.functionType = $H({
            INPUT:$H({
                text:'displayTextValue',
                password:'displayTextValue',
                hidden:'displayTextValue',
                checkbox:'displayCheckbox',
                radio:'displayRadio',
                button:'displayVoid'
            }),
            DIV:$H({'':'displayDiv'}),
            BUTTON:$H({'':'displayDiv'}),
            SPAN:$H({'':'displayDiv'}),
            P:$H({'':'displayDiv'}),
            SELECT:$H({
                'select-one':'displaySelect',
                'select-multiple':'displaySelect'
            }),
            TEXTAREA:$H({
                '':'displayTextarea',
                textarea:'displayTextarea'
            })
        });
    },
        
    //起動時処理
    load: function(){
        _this.url       = '';
        _this.path      = _this.getInfo('path');
        _this.action    = _this.getInfo('action');
        _this.method    = _this.getInfo('method');
        _this.type      = _this.getInfo('type');
        _this.groupList = $H({});
    },

    //起動時イベント登録処理
    eventInitialize: function(){
        $H(LBEvents).each(function(element){
            _this.observeEventList(element.key);
        }); 
    },

    timerInitialize: function(){
        $H(LBTimers).each(function(timer){
            _this.observeTimer(timer.key);
        });    
    },

    observeEventList: function(elementID){
        wElement  = $H(LBEvents).get(elementID);
        $H(wElement).each(function(event){
            //イベント登録
            switch (event.value[0]){
                //Ajax用
                case 'A':
                    _this.eventObserve(elementID, event.key, _this.prepareAjax);
                    break;

                //Grid(Ajax)用
                case 'G':
                    _this.eventObserve(elementID, event.key, _this.prepareGridAjax);
                    break;

                //Http用
                case 'H':
                    _this.eventObserve(elementID, event.key, _this.sendHttp);
                    break;

                //グループイベント用
                case 'GU':
                case 'GA':  //2011/1/23:使用禁止
                    _this.observeGroupEvent(event.value[0], event, document.getElementsByTagName("body").item(0).childNodes);
                    break;
                        
                //汎用
                case 'U':
                    //登録ハンドラあり
                    if (event.value[2][event.key]){
                        _this.eventObserve(elementID, event.key, eval(event.value[2][event.key]));
                    }
                    //それ以外：省略時ハンドラ(エレメントID_イベント識別子)を実行
                    else{
                        _this.eventObserve(elementID, event.key, eval(elementID + '_' + event.key));
                     }
                    break;
            }
        }); 
    },

    observeGroupEvent: function(mode, event, nodeList){
        $A(nodeList).each(function(_node){
            if (_node.childNodes.length > 0){
                _this.observeGroupEvent(mode, event, _node.childNodes);
            }

            else if (_node.id != undefined){
                wPrefix     = event.value[5][0] + (event.value[5][0] != '' ? '_' : '');
                wSuffix     = (event.value[5][1] != '' ? '_' : '') + event.value[5][1];
                if (_node.id.substr(0, wPrefix.length) == wPrefix &&
                    _node.id.substr(_node.id.length - wSuffix.length, wSuffix.length) == wSuffix){
                    switch (mode){
                        case 'GU':
                            //登録ハンドラあり
                            if (event.value[2][event.key]){
                                _this.eventObserve(_node.id, event.key, eval(event.value[2][event.key]));
                            }
                            //それ以外：省略時ハンドラ(エレメントID_イベント識別子)を実行
                            else{
                                _this.eventObserve(_node.id, event.key, eval(event.value[5][0] + '__' + event.value[5][1] + '_' + event.key));
                            }
                            break;
                        //2011/1/23:使用禁止
                        case 'GA':
                            _this.groupList.set(_node.id, _node.id.substr(wPrefix.length, _node.id.length - wPrefix.length - wSuffix.length));
                            _this.eventObserve(_node.id, event.key, _this.prepareAjax);
                            break;
                    }
                }
            }
        });
    },

    //個別イベント登録
    eventObserve: function(elementID, event, handler){
        Event.observe(elementID, event, function(e){handler(e, elementID);});
    },
    
    //タイマーイベント登録・起動
    observeTimer: function(timerID){
        var wTimer  = $H(LBTimers).get(timerID);
        //汎用タイマーイベント
        if (wTimer[0] == 'U'){
            _this.timerStart(timerID, wTimer[1], 'function(){' + wTimer[3] + '(' + wTimer[5] + ');}', wTimer[2]);
        }
        //Ajaxタイマーイベント
        else{
            //イベントハンドラ/起動情報セット
            _this.timerStart(timerID, wTimer[1], 'function(){_this.prepareAjaxTimer(aTimerID);}', wTimer[2]);
        }
    },
    
    timerStart: function(aTimerID, aInterval, afunction, aSW){
        eval(aTimerID + ' = new PeriodicalExecuter(' + afunction + ', ' + aInterval + ');');
        if (aSW == 'OFF'){
            (eval(aTimerID)).stop();
        }
    },
    
    timerSW: function(aTimerID, aSW){
        if (aSW == 'ON'){
            (eval(aTimerID)).registerCallback();
        }
        else if (aSW == 'OFF'){
            (eval(aTimerID)).stop();
        }
    },
    
    //Ajaxリクエストパラメータクリア
    resetAjaxParam: function(){
        _this.ajaxParam = $H({});
    },

    //Ajaxリクエストパラメータセット
    addAjaxParam: function(key, value){
        _this.ajaxParam.set(key, value);
    },

    //独立Ajaxリクエスト準備処理
    setAjaxServerAction: function(serverAction){
        _this.action    = serverAction;
    },

    setAjaxServerMethod: function(serverMethod){
        _this.method    = serverMethod;
    },

    setAjaxServerType: function(serverMethod){
        _this.type      = serverType;
    },

    //イベントハンドラ追加
    //handlerList = debugRequest/debugResponse/receiveResponse/afterResponse
    addAjaxHandler: function(point, name){
        _this.handlerList.set(point, name);
    },
    
    //イベント発生エレメント取得
    eventElement: function(e){
        return e.srcElement || e.target;
    },

    eventElementID: function(e){
        wElement    = _this.eventElement(e);
        if ((wElementID = _this.groupList.get(wElement.id)) == undefined){
            wElementID  = wElement.id;
        }
        return wElementID;

    },
     
    //Ajaxリクエスト準備処理
    prepareAjax: function(e, rootID){
        _this.resetAjaxParam();
        //_this.srcID     = _this.eventElementID(e);
        _this.srcID     = rootID;
        _this.eventType = e.type;

        //イベントハンドラ/起動情報セット
        _this.setEventInfo(e, ['Handler', 'ExecParam']);
        
        //送信エレメントセット前イベントポイント
        if (funcName = _this.existHandler('beforeParamSet')){
            if (!eval(funcName)(e)){
                return;
            }
        }
        
        //送信エレメントセット
        _this.setEventInfo(e, ['SendElement']);

        //リクエスト実行
        if(_this.ajaxCancel != true){
            _this.ajaxRequest();
        }
    },
     
    //タイマーAjaxリクエスト準備処理
    prepareAjaxTimer: function(timerID){
        _this.resetAjaxParam();
        _this.srcID         = timerID;
        _this.handlerList   = $H({});

        _this.setInfo_Handler_timer(timerID);       //イベントハンドラセット
        _this.setInfo_ExecParam_timer(timerID);     //サーバー起動情報保存
        _this.setInfo_SendElement_Timer(timerID);   //Ajaxリクエスト時送信エレメントセット

        //送信エレメントセット前イベントポイント
        if (funcName = _this.existHandler('beforeParamSet')){
            if (!eval(funcName)(e)){
                return;
            }
        }

        //リクエスト実行
        if(_this.ajaxCancel != true){
            _this.ajaxRequest();
        }
    },
     
    //Grid(Ajax)リクエスト準備処理
    prepareGridAjax: function(e){
        var wInfo       = eventInfo(e);
        _this.srcID     = wInfo.gridID;
        _this.eventType = e.type;

        //イベントハンドラ/起動情報セット
        _this.setEventInfo(e, ['Handler', 'ExecParam']);

        //対象グリッド列判定
        wGridColumn = $H(LBEvents).get(_this.srcID)[_this.eventType][4];
        if (wGridColumn.length > 0){
            var wFlag   = false;
            for (var i = 0; i < wGridColumn.length; i++){
                if (wGridColumn[i] == wInfo.colID){
                    wFlag   = true;
                    break;
                }
            }
            if (!wFlag) return;
        }
        
        //送信エレメントセット前イベントポイント
        if (funcName = _this.existHandler('beforeParamSet')){
            if (!eval(funcName)(e)){
                return;
            }
        }
 
        //送信エレメントセット
        _this.setEventInfo(e, ['SendElement']);
        prepareAjaxByRowData(e, _this.method);

        //リクエスト実行
        if(_this.ajaxCancel != true){
            _this.ajaxRequest();
        }
    },

    //リクエスト実行
    ajaxRequest: function(){
        //既定パラメータ
        _this.addAjaxParam('action', _this.action);
        _this.addAjaxParam('method', _this.method);
        _this.addAjaxParam('type', 'ajax');
        uniqueTime  = new Date();
        _this.addAjaxParam('timestamp', uniqueTime.toLocaleTimeString());
 
        //リクエスト実行前イベントポイント
        if (funcName = _this.existHandler('beforeRequest')){
            if (!eval(funcName)(_this.ajaxParam)){
                return;
            }
        }

        //Ajax通信開始
        postParam   = _this.ajaxParam.toQueryString();

        //デバッグ処理
        if (_this.handlerList.get('debugRequest')){
            alert("[DebugRequest]  " + postParam);
        }

        //Ajaxリクエスト実行
        var ajax = new Ajax.Request(
            _this.path,
            {
                method:        'post',
                asynchronous:   true,
                parameters:     postParam,
                onSuccess:      function(obj){
                    _this.response(obj.responseText);
                },
                onFailure:      function(){
                    alert('Request Failed');
                    //$(elementID).innerHTML = '失敗しました';
                }
            }
        );

        //パラメータクリア
        _this.ajaxParam = $H({});
    },

    //---------------------------------------------------------------------------------------------------------------------
    /**
     * INPUT:TEXT 値更新
     */ 
    //---------------------------------------------------------------------------------------------------------------------
    response: function(response){
        //デバッグ用アラート
        if (_this.handlerList.get('debugResponse')){
            alert("[DebugResponse]  " + response);
        }
        
        //レスポンス展開
        eval("res = $H(" + response + ");");
        var wElements       = res.get('LB_elements');
        var wContents       = res.get('LB_contents');
        var wStyle          = res.get('LB_style');
        var wAttribute      = res.get('LB_attribute');
        var wClientProc     = res.get('LB_clientProc');
        var wModifyHeadTag  = res.get('LB_modifyHeadTag');
        var wHElements      = _this.itemToHash(wElements);
        var wHContents      = _this.itemToHash(wContents);
        var wHStyle         = _this.itemToHash(wStyle);
        var wHAttribute     = _this.itemToHash(wAttribute);
        var wHClientProc    = _this.itemToHash(wClientProc);
        var wHModifyHeadTag = _this.itemToHash(wModifyHeadTag);

        //レスポンス受信時イベントポイント
        if (funcName = _this.existHandler('receiveResponse')){
            if (!eval(funcName)(wHContents)){
                return;
            }
        }
        
        //値表示
        if (_this.count(wContents) > 0){
            wHContents.each(function(_res){
                if ($(_res.key)){
                    _this.displayValue(_res.key, _res.value);

                    //イベント再定義
                    _this.observeEventList(_res.key);
                    if (wLbType = $(_res.key).getAttribute('lb_type')){
                        switch(wLbType){
                            case 'HTML_GRID':
                                syncScrollBar(_res.key);
                                break;
                        }
                    }
                }
            });
        }

        //エレメント追加
        if (_this.count(wElements) > 0){
            wHElements.each(function(_info){
                var ele = new Element(_info.value[0]);
                ele.setAttribute('id', _info.key);
                if (_info.value[1] !== ''){
                    ele.setAttribute('value', _info.value[1]);
                }

                if (_this.count(wAttribute) > 0){
                    var wEleAttr    = wHAttribute.get(_info.key);
                    if (wEleAttr != undefined){
                        for (var _attr in wEleAttr){
                            ele.setAttribute(_attr, wEleAttr[_attr]);
                        }
                    }
                }

                if (_info.value[2] == 'body'){
                    var wContainer  = document.getElementsByTagName('body')[0];
                }
                else{
                    var wContainer  = $(_info.value[2]);
                }
                wContainer.appendChild(ele);
            });
        }

        //スタイル更新
        if (_this.count(wStyle) > 0){
            wHStyle.each(function(_info){
                $(_info.key).setStyle(_info.value);
            });
        }

        //属性更新
        if (_this.count(wAttribute) > 0){
            wHAttribute.each(function(_info){
                if (_this.count(wElements) > 0){
                    if (wHElements.get(_info.key) != undefined){
                        return;
                    }
                }
                
                for(var _key in _info.value){
                    $(_info.key).setAttribute(_key, _info.value[_key]);
                }
            });
        }

        //headタグ内スタイル・Script定義更新
        if (_this.count(wModifyHeadTag) > 0){
            _this.modifyHeadTag(wModifyHeadTag);
        }

        //クライアント側処理
        if (_this.count(wClientProc) > 0){
            (function(){
		        var f = arguments.callee;
		        setTimeout(function(){
			        if (document.getElementsByTagName('*'))
                        _this.CBClientProc(wHClientProc);
			        else 
                        f();
	            }, 100);
	        })();
        }

        //レスポンス後イベントポイント
        if (funcName = _this.existHandler('afterResponse')){
            if (!eval(funcName)(wHContents)){
                return;
            }
        }
    },
    
    startTimer: function(aTimerName, afunction, aInterval){
        eval(aTimerName + ' = new PeriodicalExecuter(' + afunction + ', ' + aInterval + ');');
    },

    //クライアント側コールバックルーチン
    CBClientProc: function(clientProc){
        clientProc.each(function(_proc){
            eval(_proc.value);
        });
    },

    //Object要素数カウント
    count: function(item){
        return $H(item).get(LB_ITEM_COUNT);
    },

    //レスポンスアイテム群ハッシュ取得
    itemToHash: function(item){
        wItem   = $H({});
        for (var _key in item){
            if (_key != LB_ITEM_COUNT){
                wItem.set(_key, item[_key]);
            }
        }
        return wItem;
    },

    //ハッシュ内容表示(開発テスト用
    displayHash: function(hash){
        hash.each(function(_data){
            alert(_data.key + ':' + _data.value);
        });
    },
        
    //ハンドラ有無チェック
    existHandler: function(handlerID){
        //任意イベントハンドラ(ビューのonAjax〜メソッドで指定)
        if (_this.handlerList.get(handlerID)){
            //return eval(_this.handlerList.get(handlerID));
            return _this.handlerList.get(handlerID);
        }
        //既定イベントハンドラ
        else{
            funcName    = _this.method + '_' + handlerID;
            if (typeof window[funcName] == 'function'){
                //return window[funcName];
                return funcName;
            }
        }
        return false;
    },
    
    //--------------------------------------------------------------
    //エレメント表示値セット
    displayValue: function(elementID, value){
        var tag     = $(elementID).tagName;
        var type    = ($(elementID).type ? $(elementID).type : '');
        var func    = _this.functionType.get(tag).get(type);
        //alert(elementID + '(' + (typeof value) + '):' + tag + ':' + type + '=' + func + '=' + value);
        
        //コンポーネント別処理
        if (wLbType = $(elementID).getAttribute('LB_type')){
            switch(wLbType){
                case 'HTML_GRID':
                    _this.replaceElement(elementID, value);
                    break;
            }
        }
        //汎用処理
        else{
            if ((typeof value !== 'object') || ((typeof value === 'object') && value[0] !== '##LABBITBOX##')){
                eval('_this.' + func)(elementID, value);
            }
            else{
                eval((eval('_this.' + value[1]) ? '_this.' : '') + value[1])(elementID, value);
            }
        }
    },

    //INPUT:TEXT/HIDDEN
    displayTextValue: function(elementID, value){
        $(elementID).value  = value;
    },

    //INPUT:CHECHBOX
    displayCheckbox: function(elementID, value){
        $(elementID).checked    = value;
    },

    //INPUT:RADIO
    displayRadio: function(elementID, value){
        $(elementID).checked    = value;
    },

    //DIV:innerHTML
    displayDiv: function(elementID, value){
        Element.update(elementID, value);
    },

    //TEXTAREA
    displayTextarea: function(elementID, value){
        $(elementID).value = value;
    },
    
    //SELECT:select
    displaySelect: function(elementID, value){
        var selectedList    = $H([]);
        
        // 注意：非効率だが複数選択の場合の配列と
        //       文字列の区別が面倒なので、
        //       とりあえず両方走らせておく。
        //       後日、判別を実装しないと
        //       偶然一致で複数選択が発生する可能性あり。

        //単一選択
        selectedList[value]         = true;

        //複数選択
        if (value[0]){
            for (var i in value){
                selectedList[value[i]]  = true;
            }
        }
        
        $A($(elementID).childElements()).each(function(_option){
            _option.selected    = selectedList[_option.value];
        });
    },

    //表示更新なし:buttonなど
    displayVoid: function(elementID, value){
        Element.update(elementID, value);
    },

    //エレメント置換:HtmlGridなど
    replaceElement: function(elementID, value){
        $(elementID).replace(value);
    },
    
    //拡張タグ編集処理
    //SELECT:select アイテム置換
    replaceSelect: function(elementID, value){
        //optionタグ個別置換処理(元のoptionタグ群は上書きされ削除される)
        if (value[2]['options']){
            var i = 0;
            for (var _value in value[2]['options']){
                var optionTag    = new Element('option', {id:elementID + i, value:value[2]['options'][_value]});
                optionTag.appendChild(document.createTextNode(_value));
                if (i++ == 0){
                    Element.update(elementID, value);
                }
                else{
                    $(elementID).insert(optionTag);
                }
            }
            _this.displaySelect(elementID, value[2]['selected']);
        }
    },

    //headタグ部動的更新
    modifyHeadTag: function(modifyList){
        //動的追加要素クリア
        wLbID   = modifyList['CONFIG']['LB_ID'];
        var wHeadChildren   = $(document.getElementsByTagName('head')[0]).childElements();
        wHeadChildren.each(function(_item){
            if (_item.getAttribute('lb_id') == wLbID){
                _item.remove();
            }
        });        

        //CSS/Script定義
        _this.dynamicModify(wLbID, modifyList['DATA']);
    },

    //動的更新処理
    dynamicModify: function(lbID, modifyList){
       $H(modifyList).each(function(_modify){
           switch(_modify.key){
                case 'CSS':
                    var wStyle = new Element('style', {'type':'text/css', 'LB_id':lbID});
                    var wCss = '';
                    $H(_modify.value).each(function(_css){
                        var wItems  = '';
                        $H(_css.value).each(function(_item){
                            wItems  = wItems + _item.key + ':' + _item.value + ';';
                        });
                        wCss    = wCss + _css.key + '{' + wItems + '}';
                    });
                    if (!wStyle.styleSheet){
                        wStyle.appendChild(document.createTextNode(wCss));
                    }
                    else{
                        wStyle.styleSheet.cssText = wCss;
                    }
                    document.getElementsByTagName('head')[0].appendChild(wStyle);
                    break;

                case 'CSSFILE':
                    for (var i = 0; i < _modify.value.length; i++){
                        var wStyle = new Element('link', {'rel':'stylesheet', 'type':'text/css', 'href':_modify.value[i], 'LB_id':lbID});
                        document.getElementsByTagName('head')[0].appendChild(wStyle);
                    }
                    break;
 
                case 'JS':
                    var wScript = new Element('script', {'language': 'JavaScript', 'LB_id':lbID});
                    var wJs = '';
                    for (var i = 0; i < _modify.value.length; i++){
                        wJs = wJs + _modify.value[i];
                    }
                    wScript.text = wJs;
                    document.getElementsByTagName('head')[0].appendChild(wScript);
                    break;

                case 'JSFILE':
                    for (var i = 0; i < _modify.value.length; i++){
                        var wScript = new Element('script', {'src': _modify.value[i], 'LB_id':lbID});
                        document.getElementsByTagName('head')[0].appendChild(wScript);
                    }
                    break;

                case 'EVENT':
                    eval('var wEvents = ' + _modify.value);
                    for (var _el in wEvents){
                        if (!LBEvents[_el]) LBEvents[_el] = {};
                        for (var _ev in wEvents[_el]){
                            LBEvents[_el][_ev]  = wEvents[_el][_ev];
                        }
                    }

	                (function(){
		                var f = arguments.callee;
		                setTimeout(function(){
			                if (document.evaluate) _this.CBEventObserve(wEvents);
                            else if (document.getElementsByTagName('*'))  _this.CBEventObserve(wEvents);
			                else f();
	                	}, 500);
	                })();

                    break;

                case 'LB_INFO':
                    eval('var wLBInfo = ' + _modify.value + ';');
                    _this.setInfo(wLBInfo);
                    break;
            }
        });
    },

    //コールバックルーチン：イベント登録
    CBEventObserve: function(events){
        $H(events).each(function(element){
             _this.observeEventList(element.key);
        });
    },

    //起動情報アクセサ
    setInfo: function(infoList){
        LBInfo  = infoList;
    },

    getInfo: function(entryID){
        var cList = {'path':0, 'action':1, 'method':2, 'type':3};
        return LBInfo[cList[entryID]];
    },

    //---------------------------------------------------------------------------------------------
    //イベント情報セット
    setEventInfo: function(e, setList){
        for (var i = 0; i < setList.length; i++){
            eval('_this.setInfo_' + setList[i] + '(e);');
        }
    },

    //送信エレメントセット
    //-- イベント用
    setInfo_SendElement: function(e){
        _this.addAjaxParam('sender', _this.srcID);
        if ($H(LBEvents).get(_this.srcID) == undefined) return;
        wSendElement    = $H(LBEvents).get(_this.srcID)[_this.eventType][1];
        _this.setInfo_SendElement_sub(e, wSendElement);
    },

    //-- タイマー用
    setInfo_SendElement_Timer: function(){
        _this.addAjaxParam('sender', _this.srcID);
        if ($H(LBTimers).get(_this.srcID) == undefined) return;
        wSendElement    = $H(LBTimers).get(_this.srcID)[4];
        _this.setInfo_SendElement_sub(null, wSendElement);
    },

    //-- 共通処理
    setInfo_SendElement_sub: function(e, aSendElement){ 
        if (_this.count(aSendElement) > 0){
            var wHSendElement   = _this.itemToHash(aSendElement);
            _this.ajaxCancel = false; // 対象属性チェックフラグ (*で属性がないものはtrueになる)
            wHSendElement.each(function(elementID){
                tmpElementID = elementID.value;
                if(tmpElementID.indexOf(".") == -1){
                    // ドットを含まない従来型の表現 $F(xxxx) で評価
                    _this.addAjaxParam(tmpElementID, $F(tmpElementID));
                }else{
                    // ドットを含む表現の処理
                    detailed = tmpElementID.split(".");
                    tId    = detailed[0];
                    tAttribute = detailed[1];
                    if(tmpElementID.indexOf("*") == -1){
                        if(tAttribute == 'innerHTML'){
                            value    = eval("$('"+tId+"').innerHTML");
                        }else if(tAttribute == 'value'){
                            value    = eval("$('"+tId+"').value");
                        }else if(tAttribute == 'checked'){
                            value    = eval("$('"+tId+"').checked");
                        }else if(tAttribute == 'selected'){
                            value    = eval("$('"+tId+"').selected");
                        }else{
                            value    = eval("$('"+tId+"').getAttribute('"+tAttribute+"')");
                        }
                        _this.addAjaxParam(tmpElementID, value);
                    }else{
                        // *を含むID無指定・属性指定型の表現 (例: *.id )
                        tId = Event.element(e);
                        tId = tId.id;
                        if(eval("$('"+tId+"').hasAttribute('"+tAttribute+"')")){
                            // 属性がある場合
                            if(tAttribute == 'innerHTML'){
                                value    = eval("$('"+tId+"').innerHTML");
                            }else if(tAttribute == 'value'){
                                value    = eval("$('"+tId+"').value");
                            }else if(tAttribute == 'checked'){
                                value    = eval("$('"+tId+"').checked");
                            }else if(tAttribute == 'selected'){
                                value    = eval("$('"+tId+"').selected");
                            }else{
                                value    = eval("$('"+tId+"').getAttribute('"+tAttribute+"')");
                            }
                            _this.addAjaxParam(tmpElementID, value);
                        }else{
                            if(tAttribute == 'checked'){
                                value    = eval("$('"+tId+"').checked");
                            }else if(tAttribute == 'selected'){
                                value    = eval("$('"+tId+"').selected");
                            }else{
                                // 属性がない場合
                                _this.ajaxCancel = true;
                            }
                            _this.addAjaxParam(tmpElementID, value);
                        }
                    }
                }
            });
        }
    },

    //--------------------------------
    //イベントハンドラセット
    //-- イベント用
    setInfo_Handler: function(e){
        _this.handlerList   = $H({});
        if ($H(LBEvents).get(_this.srcID) == undefined) return;        
        wHandler    = $H(LBEvents).get(_this.srcID)[_this.eventType][2];
        if (_this.count(wHandler) > 0){
            _this.handlerList   = _this.itemToHash(wHandler);
        }
    },

    //-- タイマー用
    setInfo_Handler_timer: function(aTimerID){
        _this.handlerList   = $H({});
        wHandler    = $H(LBTimers).get(aTimerID)[3];        
        if (_this.count(wHandler) > 0){
            _this.handlerList   = _this.itemToHash(wHandler);
        }
    },

    //--------------------------------
    //サーバー起動情報保存
    //-- イベント用
    setInfo_ExecParam: function(e){
        _this.execParam = $H({});
        if ($H(LBEvents).get(_this.srcID) == undefined) return;
        wExecParam      = $H(LBEvents).get(_this.srcID)[_this.eventType][3];
        if (_this.count(wExecParam) > 0){
            _this.execParam = _this.itemToHash(wExecParam);
        }
        _this.setInfo_ExecParam_sub();
    },

    //-- タイマー用
    setInfo_ExecParam_timer: function(aTimerID){
        _this.execParam = $H({});
        wExecParams = $H(LBTimers).get(aTimerID)[5];        
        if (_this.count(wExecParams) > 0){
            _this.execParam     = _this.itemToHash(wExecParams);
        }
        _this.setInfo_ExecParam_sub();
    },

    //-- 共通処理
    setInfo_ExecParam_sub: function(){
        //サーバーサイドメソッド準備
        var wMethodFlag = false;
        _this.execParam.each(function(_ep){
             switch(_ep.key){
                case 'url':
                    _this.url       = _ep.value;
                    break;
                case 'path':
                    _this.path      = _ep.value;
                    break;
                case 'action':
                    _this.action    = _ep.value;
                    break;
                case 'method':
                    _this.method    = _ep.value;
                    wMethodFlag = true;
                    break;
                case 'type':
                    _this.type      = _ep.value;
                    break;
                default:
                    _this.addAjaxParam(_ep.key, _ep.value);
            }
        });

        if (!wMethodFlag){
            _this.method    = _this.srcID + '_' + _this.eventType;
        }
    },

    //---------------------------------------------------------------------------------------------
    //Utility
    sendHttp: function(e){
        _this.srcID     = _this.eventElementID(e);
        _this.eventType = e.type;

        _this.setEventInfo(e, ['SendElement', 'Handler', 'ExecParam']);
 
        //リクエスト実行前イベントポイント
        if (funcName = _this.existHandler('beforeRequest')){
            if (!eval(funcName)(_this.ajaxParam)){
                return;
            }
        }

        //URI編集
        if (_this.url != ''){
            var wUrl    = _this.url;
        }
        else{
            _this.addAjaxParam('action', _this.action);
            _this.addAjaxParam('method', _this.method);
            _this.addAjaxParam('type', _this.type);
            uniqueTime  = new Date();
            _this.addAjaxParam('timestamp', uniqueTime.toLocaleTimeString());

            var wUrl    = _this.path + '?' + _this.ajaxParam.toQueryString();
        }

        //デバッグ処理
        if (_this.handlerList.get('debugRequest')){
            alert("[DebugRequest]  " + wUrl);
        }

        location.href = wUrl;
    },

    //
    dummy: function(){}
});

var labbitbox = new Labbitbox();
