//---------------------------------------------------------------------------------------------------------------------
/**
 * サウンド再生用Javascriptライブラリ(HTML5対応ブラウザのみ)
 * 【使用方法】
 * playSound(['FilePath1', FilePath2', ・・・,'FilePathxx']);
 * 引数に音声ファイルのパスを配列で渡すと順次再生する
 * 対応音声ファイル：mp3 / wav
 * setSoundDirectory()関数でデフォルトディレクトリを指定可能
 *
 * @package  LabbitBox1.0
 * @author   neobaba
 * @since    2010/9/4
*/ 
//---------------------------------------------------------------------------------------------------------------------
var _audio      = null;
var _currentIdx = 0;
var _soundExt   = '';
var _soundList;
var _soundDir   = '';

function setSoundDirectory(dir){
    _soundDir   = dir;
}

function playSound(soundList){
    _soundList  = soundList;

    var wAudioTagSupport = !!(document.createElement('audio').canPlayType);
    if (!wAudioTagSupport){
        //alert('HTML5 audio not supported');
        return;
    }

    _audio  = new Audio("");
    if (_audio.canPlayType){
        var wCanPlayMp3 = ("" != _audio.canPlayType("audio/mpeg"));
        var wCanPlayWav = ("" != _audio.canPlayType("audio/wav"));
        if (wCanPlayMp3){
            _soundExt   = "mp3";
        }
        else if (wCanPlayWav){
            _soundExt   = "wav";
        }
        else{
            //alert("not support both mp3 and wav");
        }
    }
    else{
        alert("not exist canPlayType");
    }
    
    _currentIdx = 0;
    _play();
    (function(){
        var f = arguments.callee;
        setTimeout(function(){
            if (_audio.ended){
                if (_play()){
                    f();
                }
            }
            else 
                f();
        }, 100);
    })();

}

function _play(){
    if (_currentIdx >= _soundList.length){
        return false;
    }
    else{
        var wSoundDir   = (_soundDir === '' ? '' : _soundDir + '/');
        _audio.src  = wSoundDir + _soundList[_currentIdx] + '.' + _soundExt;
        _audio.load();
        _audio.play();
        _currentIdx++;
        return true;
    }
}
