<?php
require_once(BASE_LIB.'/EmbededView.php');
/**
 * AccountRegistration Interface as HtmlParts
 *
 * @package     LabbitBox
 * @subpackage  LB_Auth
 * @author      minotaur <minotaur@labbitbox.org>
 * @since       2011/08/24
 */
class LB_Auth_AccReg_E extends EmbededView {

    public function main(){
        if(file_exists(TEMPLATE_DIR.'/LB_Auth_AccReg.tpl.html')){
            $templateDir  = TEMPLATE_DIR;
        }else{
            $templateDir  = dirname(__FILE__);
        }
        $templateFile = 'LB_Auth_AccReg.tpl.html';
        $this->setTemplate($templateFile, $templateDir);

        require_once(BASE_LIB.'/ModifyElement.php');
        // Captcha設定
        $captcha = new EmbededView($this, $this->_app, 'LB_Auth_CAPTCHA.tpl.html', 'REGION', dirname(__FILE__));//$templateDir);
        $captcha->main();
        $this->replaceRegion($captcha, 'accreg_divCaptcha');

        // イベント設定
        $btnEntry = new ModifyElement($this, 'accreg_btnEntry');
        $params   = NULL;
        $params[] = 'accregAccId';
        $params[] = 'accregAccIdChk';
        $params[] = 'accregScreenName';
        $params[] = 'accregPwd';
        $params[] = 'accregPwdChk';
        $params[] = 'cap_text';
        $ev = $btnEntry->onAjaxClick($params);
        $ev->execParam('action', 'LB_Auth_AccReg');
        $ev->execParam('method', 'entryAccount');
        //$ev->handler('beforeParamSet', 'checkEntryData');
    }



    public function crt(){
        require_once(BASE_LIB.'/ModifyElement.php');

        if(file_exists(TEMPLATE_DIR.'/LB_Auth_AccCrt.tpl.html')){
            $templateDir  = TEMPLATE_DIR;
        }else{
            $templateDir  = dirname(__FILE__);
        }
        $templateFile = 'LB_Auth_AccCrt.tpl.html';
        $this->setTemplate($templateFile, $templateDir);
    }



    /**
     * Request for LoginURL
     */
    public function rqu(){
        if(file_exists(TEMPLATE_DIR.'/LB_Auth_ReqLoginUrl.tpl.html')){
            $templateDir  = TEMPLATE_DIR;
        }else{
            $templateDir  = dirname(__FILE__);
        }
        $templateFile = 'LB_Auth_ReqLoginUrl.tpl.html';
        $this->setTemplate($templateFile, $templateDir);

        require_once(BASE_LIB.'/ModifyElement.php');
        // Captcha設定
        $captcha = new EmbededView($this, $this->_app, 'LB_Auth_CAPTCHA.tpl.html', 'REGION', dirname(__FILE__));//$templateDir);
        $captcha->main();
        $this->replaceRegion($captcha, 'accreg_divCaptcha');

        // イベント設定
        $btnEntry = new ModifyElement($this, 'accreg_btnEntry');
        $params   = NULL;
        $params[] = 'accregAccId';
        $params[] = 'accregAccIdChk';
        $params[] = 'cap_text';
        $ev = $btnEntry->onAjaxClick($params);
        $ev->execParam('action', 'LB_Auth_AccReg');
        $ev->execParam('method', 'requestLoginUrl');
        //$ev->handler('beforeParamSet', 'checkEntryData');
    }




    /**
     * Certification for AccountRegistration
     */
    public function crt2(){
        require_once(BASE_LIB.'/ModifyElement.php');

        if(file_exists(TEMPLATE_DIR.'/LB_Auth_AccCrt.tpl.html')){
            $templateDir  = TEMPLATE_DIR;
        }else{
            $templateDir  = dirname(__FILE__);
        }
        $templateFile = 'LB_Auth_AccCrt.tpl.html';
        $this->setTemplate($templateFile, $templateDir);
    }

}

?>
