<?php
require_once(BASE_LIB.'/Model.php');
/**
 * AccountRegistration Interface as HtmlParts
 *
 * @package     LabbitBox
 * @subpackage  LB_Auth
 * @author      minotaur <minotaur@labbitbox.org>
 * @since       2011/08/26
 */
class LB_Auth_AccReg_M extends Model {

    public function entryAccount(){

        // CAPTCHA判定
        require_once(BASE_APP.'/../LabbitBox/plugin/securimage/securimage.php');
        $si = new securimage();

        // 認証OKの場合
        if ($si->check($this->request('cap_text')) === TRUE){
            // データベースオブジェクト生成(トランザクションがあるので共用DBではなく生成する)
            $db = new DB($this->configById('DB'));

            // SQL読込
            $db->loadSql(dirname(__FILE__).'/LB_Auth_AccReg.sql.xml');

            // SALT、パスワード生成
            $salt          = $this->_app->getRandomKey(2);
            $pwd      = hash('sha256', trim($this->request('accregPwd')).$salt);

            // その他設定
            $accId         = trim($this->request('accregAccId'));
            $wkExecTime      = strftime('%Y/%m/%d %H:%M:%S');

            // トランザクション取得
            $wkTrn = $db->startTransaction();
            try{
                // アカウントキー取得
                $dataset = $db->dataset('LB_AUTH_AccReg_SELECT_LB_AUTH_ACC_NO')->getAll();
                $accNo   = $dataset[0]['ACC_NO'];

                // アカウント登録[LB_AUTH_ACC] =================================
                $prmV                       = array();
                $prmV[':ACC_NO']            = $accNo;
                $prmV[':ACC_ID']            = $accId;
                $prmV[':SCREEN_NAME']       = trim($this->request('accregScreenName'));
                $prmV[':SALT']              = $salt;
                $prmV[':PWD']               = $pwd;
                // SQL実行
                $db->query('LB_AUTH_AccReg_INSERT_LB_AUTH_ACC', $prmV, TRUE, $wkTrn);

                // Commit
                $db->commit($wkTrn);
                $this->_app->shared()->add('ErrMessage', '1');
                // メール送信
                $this->sendEntryMail($accNo, $accId, trim($this->request('accregScreenName')));
            }
            catch(FBException $e){
                // Rollback
                $db->rollback($wkTrn);
                $this->_app->shared()->add('ErrMessage', '2');
            }
        }
        // 認証NGの場合
        else{
            $this->_app->shared()->add('ErrMessage', '3');
        }
    }


    /**
     * sendEntryMail [初期メール送信処理]
     */
    public function sendEntryMail($accNo, $accId, $screenName){

        require_once(BASE_LIB.'/EMail.php');

        // データベースオブジェクト生成(トランザクションがあるので共用DBではなく生成する)
        $db = new DB($this->configById('DB'));

        // SQL読込
        $db->loadSql(dirname(__FILE__).'/LB_Auth_AccReg.sql.xml');

        // URL取得
        $wkRandomKey  = hash('md5', $this->_app->getRandomKey(4));

        // トランザクション取得
        $wkTrn = $db->startTransaction();
        try{
            // ログインパラメータファイル登録 -------------------
            $wkArrayL                    = array();
            $wkArrayL[':ACC_NO']         = $accNo;
            $wkArrayL[':PRM_KEYWORD']    = $wkRandomKey;
            $wkArrayL[':VALID_TIME']     = strftime('%Y/%m/%d %H:%M:%S', time()+($this->config('app.LB_Auth..max_cd_term')*60*60));
            $wkArrayL[':CREATE_USER']    = $accNo;

            // SQL実行
            $db->query('LB_AUTH_AccReg_INSERT_LB_AUTH_OTP', $wkArrayL, TRUE, $wkTrn);

            // Commit
            $db->commit($wkTrn);
            $this->_app->shared()->add('ErrMessage', '1');
        }
        catch(FBException $e){
            // Rollback
            $db->rollbackTransaction($wkTrn);
          //$this->_app->shared()->add('ErrMessage', $e->getMessage());
            $this->_app->shared()->add('ErrMessage', '2');
            $e->terminate();
        }

        // メール送信
        $to     = $accId;
        $from   = $this->config('app.LB_Auth.mail_from');
        $cc     = $this->config('app.LB_Auth.mail_cc');
        $bcc    = $this->config('app.LB_Auth.mail_bcc');
        $return = $this->config('app.LB_Auth.mail_return');
        $ttl    = $this->config('app.LB_Auth.mail_subject');
        $mail = new EMail('', $from, $ttl, $cc, $bcc, $return);
        $mail->addMailHeader('toAddr', $to);

        // 本文をテンプレートから作成する場合
        if(file_exists(TEMPLATE_DIR.'/LB_Auth_AccReg.mail.tpl.txt')){
            $templateDir = TEMPLATE_DIR;
        }else{
            $templateDir = dirname(__FILE__);
        }
        $url                = "http://".$_SERVER[SERVER_NAME]."/acc.php?method=crt&u=$accNo&cd=$wkRandomKey\n";
        $prm                = NULL;
        $prm['SCREEN_NAME'] = $screenName;
        $prm['ACC_ID']      = $accId;
        $prm['URL']         = $url;

        $mail->sendFromTemplate($templateDir.'/LB_Auth_AccReg.mail.tpl.txt', $prm);

    }



    /**
     * send mail that includes login url for forgotten password
     */
    function requestLoginUrl(){
    }

}
?>
