<?php

    //========================================================================================================================
    /**
     * MVCクラス：コントローラー（Ajaxリクエスト用）
     *
     * リクエスト変数($_REQUEST)のラッパークラス
     *
     * LICENSE: This source file is subject to GNU GENERAL PUBLIC LICENSE Version 3
     * http://www.gnu.org/licenses/gpl-3.0.txt.
     *
     * @package    LabbitBox
     * @subpackage LB_Auth
     * @copyright  2010 LabbitBox Development Team.
     * @license    GPL v3 http://www.gnu.org/licenses/gpl-3.0.txt
     * @author     neobaba <neobaba@labbitbox.org>
     * @version    v0.1
     * @since      2010/8/26
     * @link       http://labbitbox.org/
     * @see        http://labbitbox.org/
     */
    //========================================================================================================================
    require_once(BASE_LIB.'/AjaxRequest.php');

    class LB_Auth_AjaxRequest extends AjaxRequest{

        function __construct($application){
            parent::__construct($application);

            //モデル
            $wkModelClassName               = $this->_app->param('action').'_M';
            $wkModelFilePath                = PRJHOME.'/'.$wkModelClassName.'.php';

            $wkLB_Auth_ModelClassName       = $this->_app->param('action').'_M';
            $wkLB_Auth_ModelFilePath        = dirname(__FILE__).'/'.$wkModelClassName.'.php';

            $wkLB_Auth_CustomModelClassName = $this->_app->param('action').'_Customized_M';
            $wkLB_Auth_CustomModelFilePath  = PRJHOME.'/'.$wkModelClassName.'.php';

            if(strpos($this->_app->param('action'), 'LB_Auth')===FALSE){
                if(file_exists($wkModelFilePath)){
                    require_once($wkModelFilePath);
                    $this->_model   = new $wkModelClassName($this->_app);
                }
            }else{
                if(file_exists($wkLB_Auth_CustomModelFilePath) ){
                    require_once($wkLB_Auth_CustomModelFilePath);
                    $this->_model   = new $wkLB_Auth_CustomModelClassName($this->_app);
                }else{
                    if(file_exists($wkLB_Auth_ModelFilePath)){
                        require_once($wkLB_Auth_ModelFilePath);
                        $this->_model   = new $wkLB_Auth_ModelClassName($this->_app);
                    }
                }
            }

            // ビューオブジェクト生成
            $wkViewClassName               = $this->_app->param('action').'_A';
            $wkViewFilePath                = PRJHOME.'/'.$wkViewClassName.'.php';

            $wkLB_Auth_ViewClassName       = $this->_app->param('action').'_A';
            $wkLB_Auth_ViewFilePath        = dirname(__FILE__).'/'.$wkViewClassName.'.php';

            $wkLB_Auth_CustomViewClassName = $this->_app->param('action').'_Customized_A';
            $wkLB_Auth_CustomViewFilePath  = PRJHOME.'/'.$wkViewClassName.'.php';

            if(strpos($this->_app->param('action'), 'LB_Auth')===FALSE){
                if(file_exists($wkViewFilePath)){
                    require_once($wkViewFilePath);
                    $this->_view   = new $wkViewClassName($this->_app);
                }
            }else{
                if(file_exists($wkLB_Auth_CustomViewFilePath) ){
                    require_once($wkLB_Auth_CustomViewFilePath);
                    $this->_view   = new $wkLB_Auth_CustomViewClassName($this->_app);
                }else{
                    if(file_exists($wkLB_Auth_ViewFilePath)){
                        require_once($wkLB_Auth_ViewFilePath);
                        $this->_view   = new $wkLB_Auth_ViewClassName($this->_app);
                    }
                }
            }
        }
    }

?>
